#
# This file was generated using xslt from its XML file
#
# Copyright 2008, Associated Universities Inc., Washington DC
#
import sys
import os
from casac import *
import string
import time
from casa_stack_manip import stack_frame_find
import gc
import numpy
from odict import odict
from task_widefield import widefield
from taskinit import casalog
from taskinit import xmlpath
class widefield_pg_:
    __name__ = "widefield"

    def __init__(self) :
       self.__bases__ = (widefield_pg_,)
       self.__doc__ = self.__call__.__doc__


    def __call__(self, vis=None,imagename=None,outlierfile=None,field=None,spw=None,selectdata=None,timerange=None,uvrange=None,antenna=None,scan=None,mode=None,niter=None,gain=None,threshold=None,psfmode=None,ftmachine=None,facets=None,wprojplanes=None,multiscale=None,negcomponent=None,interactive=None,mask=None,nchan=None,start=None,width=None,imsize=None,cell=None,phasecenter=None,restfreq=None,stokes=None,weighting=None,robust=None,npixels=None,noise=None,cyclefactor=None,cyclespeedup=None,npercycle=None,uvtaper=None,outertaper=None,innertaper=None,restoringbeam=None,calready=None,):

        myf=stack_frame_find( )
        myf['__last_task'] = 'widefield'
        myf['taskname'] = 'widefield'
        ###
        myf['update_params'](func=myf['taskname'],printtext=False)
        ###
        ###
        #Handle globals or user over-ride of arguments
        #
	function_signature_defaults=dict(zip(self.__call__.func_code.co_varnames,self.__call__.func_defaults))
	useLocalDefaults = False

        for item in function_signature_defaults.iteritems():
                key,val = item
                keyVal = eval(key)
                if (keyVal == None):
                        #user hasn't set it - use global/default
                        pass
                else:
                        #user has set it - use over-ride
			if (key != 'self') :
			   useLocalDefaults = True
                        #myf[key]=keyVal

	myparams = {}
	if useLocalDefaults :
	   for item in function_signature_defaults.iteritems():
	       key,val = item
	       keyVal = eval(key)
	       exec('myparams[key] = keyVal')
	       if (keyVal == None):
	           exec('myparams[key] = '+ key + ' = self.itsdefault(key)')
		   keyVal = eval(key)
		   if(type(keyVal) == dict) :
                      if len(keyVal) > 0 :
		         exec('myparams[key] = ' + key + ' = keyVal[len(keyVal)-1][\'value\']')
		      else :
		         exec('myparams[key] = ' + key + ' = {}')

	else :
            uselessvariable = None 
            myparams['vis'] = vis = myf['vis']
            myparams['imagename'] = imagename = myf['imagename']
            myparams['outlierfile'] = outlierfile = myf['outlierfile']
            myparams['field'] = field = myf['field']
            myparams['spw'] = spw = myf['spw']
            myparams['selectdata'] = selectdata = myf['selectdata']
            myparams['timerange'] = timerange = myf['timerange']
            myparams['uvrange'] = uvrange = myf['uvrange']
            myparams['antenna'] = antenna = myf['antenna']
            myparams['scan'] = scan = myf['scan']
            myparams['mode'] = mode = myf['mode']
            myparams['niter'] = niter = myf['niter']
            myparams['gain'] = gain = myf['gain']
            myparams['threshold'] = threshold = myf['threshold']
            myparams['psfmode'] = psfmode = myf['psfmode']
            myparams['ftmachine'] = ftmachine = myf['ftmachine']
            myparams['facets'] = facets = myf['facets']
            myparams['wprojplanes'] = wprojplanes = myf['wprojplanes']
            myparams['multiscale'] = multiscale = myf['multiscale']
            myparams['negcomponent'] = negcomponent = myf['negcomponent']
            myparams['interactive'] = interactive = myf['interactive']
            myparams['mask'] = mask = myf['mask']
            myparams['nchan'] = nchan = myf['nchan']
            myparams['start'] = start = myf['start']
            myparams['width'] = width = myf['width']
            myparams['imsize'] = imsize = myf['imsize']
            myparams['cell'] = cell = myf['cell']
            myparams['phasecenter'] = phasecenter = myf['phasecenter']
            myparams['restfreq'] = restfreq = myf['restfreq']
            myparams['stokes'] = stokes = myf['stokes']
            myparams['weighting'] = weighting = myf['weighting']
            myparams['robust'] = robust = myf['robust']
            myparams['npixels'] = npixels = myf['npixels']
            myparams['noise'] = noise = myf['noise']
            myparams['cyclefactor'] = cyclefactor = myf['cyclefactor']
            myparams['cyclespeedup'] = cyclespeedup = myf['cyclespeedup']
            myparams['npercycle'] = npercycle = myf['npercycle']
            myparams['uvtaper'] = uvtaper = myf['uvtaper']
            myparams['outertaper'] = outertaper = myf['outertaper']
            myparams['innertaper'] = innertaper = myf['innertaper']
            myparams['restoringbeam'] = restoringbeam = myf['restoringbeam']
            myparams['calready'] = calready = myf['calready']

        if type(vis)==str: vis=[vis]
        if type(multiscale)==int: multiscale=[multiscale]
        if type(imsize)==int: imsize=[imsize]
        if type(cell)==float: cell=[cell]
        if type(outertaper)==str: outertaper=[outertaper]
        if type(innertaper)==str: innertaper=[innertaper]
        if type(restoringbeam)==str: restoringbeam=[restoringbeam]

	result = None

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['vis'] = vis
        mytmp['imagename'] = imagename
        mytmp['outlierfile'] = outlierfile
        mytmp['field'] = field
        mytmp['spw'] = spw
        mytmp['selectdata'] = selectdata
        mytmp['timerange'] = timerange
        mytmp['uvrange'] = uvrange
        mytmp['antenna'] = antenna
        mytmp['scan'] = scan
        mytmp['mode'] = mode
        mytmp['niter'] = niter
        mytmp['gain'] = gain
        mytmp['threshold'] = threshold
        mytmp['psfmode'] = psfmode
        mytmp['ftmachine'] = ftmachine
        mytmp['facets'] = facets
        mytmp['wprojplanes'] = wprojplanes
        mytmp['multiscale'] = multiscale
        mytmp['negcomponent'] = negcomponent
        mytmp['interactive'] = interactive
        mytmp['mask'] = mask
        mytmp['nchan'] = nchan
        mytmp['start'] = start
        mytmp['width'] = width
        mytmp['imsize'] = imsize
        if type(cell) == str :
           mytmp['cell'] = casac.quanta().quantity(cell)
        else :
           mytmp['cell'] = cell
        mytmp['phasecenter'] = phasecenter
        mytmp['restfreq'] = restfreq
        mytmp['stokes'] = stokes
        mytmp['weighting'] = weighting
        mytmp['robust'] = robust
        mytmp['npixels'] = npixels
        mytmp['noise'] = noise
        mytmp['cyclefactor'] = cyclefactor
        mytmp['cyclespeedup'] = cyclespeedup
        mytmp['npercycle'] = npercycle
        mytmp['uvtaper'] = uvtaper
        mytmp['outertaper'] = outertaper
        mytmp['innertaper'] = innertaper
        mytmp['restoringbeam'] = restoringbeam
        mytmp['calready'] = calready
	pathname='file://' + xmlpath( ) + '/'
	trec = casac.utils().torecord(pathname+'widefield.xml')

        casalog.origin('widefield')
        if not trec.has_key('widefield') or not casac.utils().verify(mytmp, trec['widefield']) :
	    return False


	try :
          casalog.post('')
          casalog.post('##########################################')
          casalog.post('##### Begin Task: widefield           #####')
          casalog.post('')
          result = widefield(vis, imagename, outlierfile, field, spw, selectdata, timerange, uvrange, antenna, scan, mode, niter, gain, threshold, psfmode, ftmachine, facets, wprojplanes, multiscale, negcomponent, interactive, mask, nchan, start, width, imsize, cell, phasecenter, restfreq, stokes, weighting, robust, npixels, noise, cyclefactor, cyclespeedup, npercycle, uvtaper, outertaper, innertaper, restoringbeam, calready)
          casalog.post('')
          casalog.post('##### End Task: widefield           #####')
          casalog.post('##########################################')


# saveinputs for individule engine has no use
# saveinputs should alos be removed from casa_in_py.py
#
#
#          saveinputs = myf['saveinputs']
#          saveinputs('widefield', 'widefield.last', myparams)
#
#
	except Exception, instance:
	  if(myf.has_key('__rethrow_casa_exceptions') and myf['__rethrow_casa_exceptions']) :
	     raise
	  else:
	     tname = 'widefield'
	     casalog.post('An error occurred running task %s: %s' % (tname,instance), 'ERROR')
	     pass

        gc.collect()
        return result
#
#
##
#    def paramgui(self, useGlobals=True):
#        """
#        Opens a parameter GUI for this task.  If useGlobals is true, then any relevant global parameter settings are used.
#        """
#        import paramgui
#
#        myf = stack_frame_find( )
#
#        if useGlobals:
#            paramgui.setGlobals(myf)
#        else:
#            paramgui.setGlobals({})
#
#        paramgui.runTask('widefield', myf['_ip'])
#        paramgui.setGlobals({})
#
#
#
#
    def defaults(self, param=None):
        myf=stack_frame_find( )
        a = odict()
        a['vis']  = ['']
        a['imagename']  = '', 
        a['outlierfile']  = ''
        a['field']  = ''
        a['spw']  = ''
        a['selectdata']  = False
        a['mode']  = 'mfs'
        a['niter']  = 500
        a['gain']  = 0.1
        a['threshold']  = '0.0Jy'
        a['psfmode']  = 'clark'
        a['ftmachine']  = ''
        a['multiscale']  = []
        a['interactive']  = False
        a['mask']  = []
        a['imsize']  = [256, 256]
        a['cell']  = ['1.0arcsec', '1.0arcsec']
        a['phasecenter']  = ''
        a['restfreq']  = ''
        a['stokes']  = 'I'
        a['weighting']  = 'natural'
        a['cyclefactor']  = 1.5
        a['cyclespeedup']  = -1
        a['uvtaper']  = False
        a['restoringbeam']  = ['']
        a['calready']  = False

        a['selectdata'] = {
                    0:{'value':False}, 
                    1:odict([{'value':True}, {'timerange':''}, {'uvrange':''}, {'antenna':''}, {'scan':''}])}
        a['multiscale'] = {
                    0:odict([{'notvalue':[]}, {'negcomponent':-1}])}
        a['mode'] = {
                    0:{'value':'mfs'}, 
                    1:odict([{'value':'channel'}, {'nchan':-11}, {'start':0}, {'width':1}]), 
                    2:odict([{'value':'velocity'}, {'nchan':1}, {'start':'0.0km/s'}, {'width':'1km/s'}]), 
                    3:odict([{'value':'frequency'}, {'nchan':1}, {'start':'1.4GHz'}, {'width':'10kHz'}])}
        a['weighting'] = {
                    0:{'value':'natural'}, 
                    1:{'value':'uniform'}, 
                    2:odict([{'value':'briggs'}, {'robust':0.0}, {'npixels':0}]), 
                    3:odict([{'value':'briggsabs'}, {'robust':0.0}, {'noise':'1.0Jy'}, {'npixels':0}]), 
                    4:odict([{'value':'superuniform'}, {'npixels':0}])}
        a['uvtaper'] = {
                    0:{'value':False}, 
                    1:odict([{'value':True}, {'outertaper':[]}, {'innertaper':[]}])}
        a['interactive'] = {
                    0:{'value':False}, 
                    1:odict([{'value':True}, {'npercycle':100}])}
        a['ftmachine'] = {
                    0:odict([{'value':'wproject'}, {'wprojplanes':256}, {'facets':1}]), 
                    1:odict([{'value':'ft'}, {'facets':1}])}

### This function sets the default values but also will return the list of
### parameters or the default value of a given parameter
        if(param == None):
                myf['__set_default_parameters'](a)
        elif(param == 'paramkeys'):
                return a.keys()
        else:
	        if(a.has_key(param)):
		   #if(type(a[param]) == dict) :
		   #   return a[param][len(a[param])-1]['value']
	   	   #else :
		      return a[param]


#
#
    def check_params(self, param=None, value=None):
      myf=stack_frame_find( )

#      print 'param:', param, 'value:', value
      try :
         if str(type(value)) != "<type 'instance'>" :
            value0 = value
            value = myf['cu'].expandparam(param, value)
            matchtype = False
            if(type(value) == numpy.ndarray):
               if(type(value) == type(value0)):
                  myf[param] = value.tolist()
               else:
                  #print 'value:', value, 'value0:', value0
                  #print 'type(value):', type(value), 'type(value0):', type(value0)
                  myf[param] = value0
                  if type(value0) != list :
                     matchtype = True
            else :
               myf[param] = value
            value = myf['cu'].verifyparam({param:value})
            if matchtype:
               value = False
      except Exception, instance:
         #ignore the exception and just return it unchecked
         myf[param] = value
      return value

#
#
    def itsdefault(self, paramname) :
        a = {}
        a['vis']  = ['']
        a['imagename']  = '', 
        a['outlierfile']  = ''
        a['field']  = ''
        a['spw']  = ''
        a['selectdata']  = False
        a['timerange']  = ''
        a['uvrange']  = ''
        a['antenna']  = ''
        a['scan']  = ''
        a['mode']  = 'mfs'
        a['niter']  = 500
        a['gain']  = 0.1
        a['threshold']  = '0.0Jy'
        a['psfmode']  = 'clark'
        a['ftmachine']  = ''
        a['facets']  = 3
        a['wprojplanes']  = 64
        a['multiscale']  = []
        a['negcomponent']  = 0
        a['interactive']  = False
        a['mask']  = []
        a['nchan']  = 1
        a['start']  = 0
        a['width']  = 1
        a['imsize']  = [256, 256]
        a['cell']  = ['1.0arcsec', '1.0arcsec']
        a['phasecenter']  = ''
        a['restfreq']  = ''
        a['stokes']  = 'I'
        a['weighting']  = 'natural'
        a['robust']  = 0.0
        a['npixels']  = 0
        a['noise']  = '1.0Jy'
        a['cyclefactor']  = 1.5
        a['cyclespeedup']  = -1
        a['npercycle']  = 100
        a['uvtaper']  = False
        a['outertaper']  = ['']
        a['innertaper']  = ['1.0']
        a['restoringbeam']  = ['']
        a['calready']  = False

        if a.has_key(paramname) :
	      return a[paramname]
widefield_pg = widefield_pg_()
