#
# This file was generated using xslt from its XML file
#
# Copyright 2014, Associated Universities Inc., Washington DC
#
import sys
import os
#from casac import *
import casac
import string
import time
import inspect
import gc
import numpy
from casa_stack_manip import stack_frame_find
from odict import odict
from types import * 
from task_widefield import widefield
class widefield_cli_:
    __name__ = "widefield"
    rkey = None
    i_am_a_casapy_task = None
    # The existence of the i_am_a_casapy_task attribute allows help()
    # (and other) to treat casapy tasks as a special case.

    def __init__(self) :
       self.__bases__ = (widefield_cli_,)
       self.__doc__ = self.__call__.__doc__

       self.parameters={'vis':None, 'imagename':None, 'outlierfile':None, 'field':None, 'spw':None, 'selectdata':None, 'timerange':None, 'uvrange':None, 'antenna':None, 'scan':None, 'mode':None, 'niter':None, 'gain':None, 'threshold':None, 'psfmode':None, 'ftmachine':None, 'facets':None, 'wprojplanes':None, 'multiscale':None, 'negcomponent':None, 'interactive':None, 'mask':None, 'nchan':None, 'start':None, 'width':None, 'imsize':None, 'cell':None, 'phasecenter':None, 'restfreq':None, 'stokes':None, 'weighting':None, 'robust':None, 'npixels':None, 'noise':None, 'cyclefactor':None, 'cyclespeedup':None, 'npercycle':None, 'uvtaper':None, 'outertaper':None, 'innertaper':None, 'restoringbeam':None, 'calready':None, }


    def result(self, key=None):
	    #### and add any that have completed...
	    return None


    def __call__(self, vis=None, imagename=None, outlierfile=None, field=None, spw=None, selectdata=None, timerange=None, uvrange=None, antenna=None, scan=None, mode=None, niter=None, gain=None, threshold=None, psfmode=None, ftmachine=None, facets=None, wprojplanes=None, multiscale=None, negcomponent=None, interactive=None, mask=None, nchan=None, start=None, width=None, imsize=None, cell=None, phasecenter=None, restfreq=None, stokes=None, weighting=None, robust=None, npixels=None, noise=None, cyclefactor=None, cyclespeedup=None, npercycle=None, uvtaper=None, outertaper=None, innertaper=None, restoringbeam=None, calready=None, ):

        """Wide-field imaging and deconvolution with selected algorithm

	Detailed Description: 

This is the main wide-field imaging/deconvolution task.  It
uses the wprojection method for a large field of view, can
make many facets, and can include outlier fields.  Several
deconvolution algorithms are supported.  Interactive cleaning
is also supported
  
	Arguments :
		vis:	name of input visibility file
		   Default Value: 

		imagename:	Pre-name of output images
		   Default Value:  

		outlierfile:	Text file with image names, sizes, centers
		   Default Value: 

		field:	Field Name
		   Default Value: 

		spw:	Spectral windows:channels: \'\' is all 
		   Default Value: 

		selectdata:	Other data selection parameters
		   Default Value: False

		timerange:	Range of time to select from data
		   Default Value: 

		uvrange:	Select data within uvrange 
		   Default Value: 

		antenna:	Select data based on antenna/baseline
		   Default Value: 

		scan:	scan number range
		   Default Value: 

		mode:	Type of selection (mfs, channel, velocity, frequency)
		   Default Value: mfs
		   Allowed Values:
				mfs
				channel
				velocity
				frequency

		niter:	Maximum number of iterations
		   Default Value: 500

		gain:	Loop gain for cleaning
		   Default Value: 0.1

		threshold:	Flux level to stop cleaning.  Must include units
		   Default Value: 0.0Jy

		psfmode:	Algorithm to use (clark, hogbom) 
		   Default Value: clark
		   Allowed Values:
				clark
				hogbom

		ftmachine:	Gridding method for the image (wproject, ft)
		   Default Value: 
		   Allowed Values:
				ft
				wproject

		facets:	Number of facets along each axis in main image only
		   Default Value: 3

		wprojplanes:	Number of planes to use in wprojection convolutiuon function
		   Default Value: 64

		multiscale:	set deconvolution scales (pixels), default: multiscale=[]
		   Default Value: 
	
      

		negcomponent:	Stop cleaning if the largest scale finds this number of neg components
		   Default Value: 0

		interactive:	use interactive clean (with GUI viewer)
		   Default Value: False

		mask:	cleanbox(es), mask image(s), and/or region(s) 
		   Default Value: 

		nchan:	Number of channels (planes) in output image
		   Default Value: 1

		start:	First channel in input to use
		   Default Value: 0

		width:	Number of input channels to average
		   Default Value: 1

		imsize:	Image size in pixels (nx,ny), single value okay
		   Default Value: 
    256256
	    

		cell:	The image cell size in arcseconds [x,y], single value okay. 
		   Default Value: 1.01.0

		phasecenter:	Field Identififier or direction of the image phase center
		   Default Value: 

		restfreq:	rest frequency to assign to image (see help)
		   Default Value: 

		stokes:	Stokes params to image (I,IV,QU,IQUV,RR,LL,XX,YY,RRLL,XXYY)
		   Default Value: I
		   Allowed Values:
				I
				IV
				QU
				IQUV
				RR
				LL
				RRLL
				XX
				YY
				XXYY

		weighting:	Weighting to apply to visibilities
		   Default Value: natural
		   Allowed Values:
				natural
				uniform
				briggs
				briggsabs
				radial
				superuniform

		robust:	Briggs robustness parameter
		   Default Value: 0.0
		   Allowed Values:
				-2.0
				2.0

		npixels:	number of pixels to determine cell size for superuniform or briggs weighting
		   Default Value: 0

		noise:	noise parameter for briggs abs mode weighting
		   Default Value: 1.0Jy

		cyclefactor:	Threshold for minor/major cycles (see pdoc)
		   Default Value: 1.5

		cyclespeedup:	Cycle threshold doubles in this number of iterations
		   Default Value: -1

		npercycle:	Number of iterations before interactive masking prompt
		   Default Value: 100

		uvtaper:	Apply additional uv tapering of  visibilities.
		   Default Value: False

		outertaper:	uv-taper on outer baselines in uv-plane
		   Default Value: 
	      
	    

		innertaper:	uv-taper in center of uv-plane
		   Default Value: 1.0

		restoringbeam:	Output Gaussian restoring beam for CLEAN image
		   Default Value: 

		calready:	Create scratch columns and store model visibilities so that selfcal can be run after clean
		   Default Value: False

	Returns: void

	Example :


        Wide-field imaging and deconvolution with selected algorithm:

        This is the main wide-field imaging/deconvolution task.  It
        uses the wprojection method for a large field of view, can
        make many facets, and can include outlier fields.  Several
        deconvolution algorithms are supported.  Interactive cleaning
        is also supported.

	For making large images (>2000 on a size), see hints at the
        end of the descriptions.  For making images larger than about
        5000x5000, the available memory must be larger than 2 Gbytes. For such 
        images therefore  a computer with a 64-bit operating system may be
        needed.


        Keyword arguments:
        vis -- Name of all input visibility files
                default: none; example: vis='ngc5921.ms'
                example: vis=['data01.ms', 'data02.ms']
        imagename -- Pre-name of output images:
                default: none; example: imagename='n5921'
                if outlier fields are included, then
                   imagename=['n5921', 'outlier1', outlier2']
                   and the first imagename is the wide-field image
                output images names are: n5921.clean, n5921.residual,
                n5921.model, n5921.interactive.mask
        mode -- Type of selection
                default: 'mfs'; example: mode='channel';
                Options: 'mfs', channel, velocity, frequency'
        alg -- Algorithm to use
                default: 'clark';
                Options: 'clark', 'hogbom','multiscale','entropy'
                    Strongly advise 'clark'.  multiscale and entropy
                    well-tested.
        imsize -- Image pixel size (x,y)
                default = [256,256]; example: imsize=[500,500], or imsize=500
                example for multiple fields: imsize=[(1000, 1000), (100, 100)]
        cell -- Cell size (x,y)
                default=['1arcsec,'1arcsec']
                example: cell=['0.5arcsec,'0.5arcsec'], or cell='0.5arcsec'
        phasecenter -- direction position or the field for the image center
                A list of the above is needed for multiple-fields
                default: '' -->field='0' as center; example: phasecenter='6'
                   phasecenter='J2000 19h30m00 -40d00m00'
                   phasecenter=['J2000 19h30m00 -40d00m00', 'J2000 19h57m00 40d00m00']
                      for wide-field, plus one outlier field.
        stokes -- Stokes parameters to image
                default='I'; example: stokes='IQUV';
                Options: 'I','IV','IQU','IQUV'
        niter -- Number iterations, set to zero for no CLEANing
                default: 500; example: niter=500
        gain -- Loop gain for CLEANing
                default: 0.1; example: gain=0.1
        threshold -- Flux level at which to stop CLEANing (units=mJy)
                default: 0.0; example: threshold=0.0
        mask -- Name(s) of mask image(s) used for CLEANing
                default: ''  example: mask='orion.mask'
                Number of mask fields must equal number of imaged fields
        cleanbox -- List of [blc-x,blc-y,trc-x,trc-y] values
                default: []; example: cleanbox=[110,110,150,145]
                Note: This can also be a filename with clean values:
                fieldindex blc-x blc-y trc-x trc-y
                cleanbox = 'interactive' is very useful.
        --- Data Selection
        nchan -- Number of channels to select
                default: 1; example: nchan=45
        start -- Start channel, 0-relative
                default=0; example: start=5
                if mode='frequency' then a frequency value e.g start='1.4GHz'
        width -- Channel width (value > 1 indicates channel averaging)
                default=1; example: width=5
                if mode='frequency' then a frequency value e.g  width='10kHz'
        step -- Step in channel number
                default=1; example: step=2
        field -- Select field using field id(s) or field name(s).
                  [run listobs to obtain the list id's or names]
               default: ''=all fields
               If field string is a non-negative integer, it is assumed a field index
                 otherwise, it is assumed a field name
               field='0~2'; field ids 0,1,2
               field='0,4,5~7'; field ids 0,4,5,6,7
               field='3C286,3C295'; field named 3C286 adn 3C295
               field = '3,4C*'; field id 3, all names starting with 4C
               example for multiple ms in vis parameter:
               field=['0~2', '1,2']
        spw -- Select spectral window/channels
               default: ''=all spectral windows and channels
               spw='0~2,4'; spectral windows 0,1,2,4 (all channels)
               spw='<2';  spectral windows less than 2 (i.e. 0,1)
               spw='0:5~61'; spw 0, channels 5 to 61
               spw='0,10,3:3~45'; spw 0,10 all channels, spw 3, channels 3 to 45.
               spw='0~2:2~6'; spw 0,1,2 with channels 2 through 6 in each.
               spw='0:0~10;15~60'; spectral window 0 with channels 0-10,15-60
               spw='0:0~10,1:20~30,2:1;2;3'; spw 0, channels 0-10,
                        spw 1, channels 20-30, and spw 2, channels, 1,2 and 3
               For multiple ms in vis parameter:
               spw=['0,10,3:3~45', '<2']
        timerange -- Select time range subset of data (not implemented yet)
            default='' meaning no time selection
            example: timerange='YYYY/MM/DD/HH:MM:SS.sss'
            timerange='< YYYY/MM/DD/HH:MM:SS.sss'
            timerange='> YYYY/MM/DD/HH:MM:SS.sss'
            timerange='ddd/HH:MM:SS.sss'
            timerange='< ddd/HH:MM:SS.sss'
            timerange='> ddd/HH:MM:SS.sss'
        restfreq -- Specify rest frequency to use for image
            default='' (i.e., try to use the restfreq specified in the visibility data)

        --- Weighting
        weighting -- Weighting to apply to visibilities
                default='natural'; example: weighting='uniform';
                Options: 'natural','uniform','briggs','briggsabs','radial', 'superuniform'
        robust -- 'briggs' and 'brigssabs' robustness parameter
                default=0.0; example: robust=0.5;
                Options: -2.0 to 2.0; -2 (uniform)/+2 (natural)
        npixels -- number of pixels to determine uv-cell size for weight calculation
                 -- Used with superuniform or briggs weighting schemes
                  example: npixels=3

        --- widefield controls
        ftmachine -- Gridding method for the image;
                ft (standard interferometric gridding).
                wproject (wprojection algorithm for gridding)
                default: wproject
        wprojplanes -- Number w-projection planes to use for gridding
                default: 256
                example: wprojplanes=64
		   Good value = BMAX(klambda) * Map width(arcmin)^2 / 600
        facets   -- Number of facets along one axis on central image
                image is divided in facets x facets rectangles.
                default: 1
                example: facets=3 makes 3x3 images to cover the field
		if ftmachine = 'ft', only faceting is used
                if ftmachine = 'wproject', both wplanes and faceting  
                         can be used  (see below).

        cyclefactor -- Change the threshold at which the deconvolution cycle will
                stop and degrid and subtract from the visibilities. For bad PSFs,
                reconcile often (cyclefactor=4 or 5); For good PSFs, use
                cyclefactor 1.5 to 2.0.
                default: 2.5; example: cyclefactor=4, but decreases speed considerably.
                <cycle threshold = cyclefactor * max sidelobe * max residual>
        cyclespeedup -- Cycle threshold doubles in this number of iterations
                default: -1; example: cyclespeedup=500

        --- MEM parameters (Experimental, not well-tested)
        sigma -- Target image sigma
                default: '0.001Jy'; example: sigma='0.1Jy'
        targetflux -- Target flux for final image
                default: '1.0Jy'; example: targetflux='200Jy'
        constrainflux -- Constrain image to match target flux;
                otherwise, targetflux is used to initialize model only.
                default: False; example: constrainflux=True
        prior -- Name of MEM prior images
                default: ['']; example: prior='source_mem.image'

        --- Multi-scale parameters (Experimental, not well-tested)
        negcomponent -- Stop component search when the largest scale has found this
                number of negative components; -1 means continue component search
                even if the largest component is negative.
                default: 2; example: negcomponent=-1
        scales -- Used for alg='multiscale'; set a number of scales or a vector
                default: [0,3,10]; example: scales=[0.0,3.0,10.0, 30]
        --  interactive masking
        npercycle -- when cleanbox is set to 'interactive',
           this is the number of iterations between each clean to update mask
           interactively. However, this number can be adjusted during execution.

	uvtaper -- Apply additional uv tapering of the visibilities.
               default: uvtaper=False; example: uvtaper=True
                  uvtaper=True expandable parameters
                     outertaper -- uv-taper on outer baselines in uv-plane
                           [bmaj, bmin, bpa] taper Gaussian scale in uv or
                            angular units. NOTE: uv taper in (klambda) is  
                            roughly on-sky FWHM(arcsec/200)
                         default: outertaper=[]; no outer taper applied
                            example: outertaper=['5klambda']  circular taper
                                FWHM=5 kilo-lambda
                                outertaper=['5klambda','3klambda','45.0deg']
                                outertaper=['10arcsec'] on-sky FWHM 10"
                                outertaper=['300.0'] default units are meters
                                   in aperture plane
                     innertaper -- uv-taper in center of uv-plane
                             NOT YET IMPLEMENTED

        restoringbeam -- Output Gaussian restoring beam for CLEAN image
                [bmaj, bmin, bpa] elliptical Gaussian restoring beam
                default units are in arc-seconds for bmaj,bmin, degrees
                for bpa default: restoringbeam=[]; Use PSF calculated
                from dirty beam.
                example: restoringbeam=['10arcsec'] circular Gaussian
                       FWHM 10" example:
                       restoringbeam=['10.0','5.0','45.0deg'] 10"x5"
                       at 45 degrees

	calready -- if True will create scratch columns if they are 
                not there. And after clean completes the predicted model 
                visibility is from the clean components are
                written to the ms.        

        async --  Run asynchronously
                default = False; do not run asychronously

 ======================================================================

                      HINTS ON RUNNING WIDEFIELD

      1.  Decide if the images will be specified directly in the  
          inputs or with an outlier file.  For more than a few fields,
          an outlier file more convenient.

         Direct Method:

            cell = ['1.0arcsec', '1.0arcsec']
            imagename = ['M1_0','M1_1','M1_2]
            imsize = [[1024,1024],[128,128],[128,128]]
            phasecenter = ['J2000 13h27m20.98 43d26m28.0', 
                      'J2000 13h30m52.159 43d23m08.02', 'J2000 13h24m08.16 43d09m48.0']

          Text file method  (in outlier.txt)

            imagename = 'M1'
            outlierfile = 'outlier.txt'
               [phasecenter, imsize ignored]

            Contents of outlier.txt
            C   0   1024 1024   13 27 20.98     43 26 28.0
            C   1    128  128   13 30 52.158    43 23 08.00
            C   2    128  128   13 24 08.163    43 09 48.00

         In both cases the following images will be made:
             M1_0.image, M1_1.image, M1_2.image     cleaned images
             M1.0.model, M1_1.model, M1_2.model     model images
             M1.0.residual, M1_1.residual, M1_2.residual     residual images

       2.  Wprojection:  It is fastest to use wprojection without faceting.
             ftmachine = 'wproject'
             wprojplane = NN

           The value of NN should be chosen as small as possible to reduce
           execution time.  The algorithm
               NN = BMAX(klambda) * imagewidth (arcmin)^2 / 600, with a minimum
                    of 16, should be adequate.

       3.  Depending on the memory of the computer, a limit of about
       5000x5000 may occur for example if a computer has 2Gbyte of
       RAM. Also a 32-bit computer has a maximum limit of 2Gbyte
       memory usable per process, irrespective of how much physical
       RAM is present. Hence it is recommended to move to a 64-bit
       computer with more than 2 GByte of RAM for >5000x5000 images
           

       4. For data with extremely large 'w' values, i.e low frequency,
       long baseline and very widefield image, the wprojection
       convolution can be very large and either not fit in memory or
       slow for processing.  In these cases you should consider using
       both ftmachine='wproject' and facets=xx where is 3.

  
        """
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
	#casac = self.__globals__['casac']
	casalog = self.__globals__['casalog']
	casa = self.__globals__['casa']
	#casalog = casac.casac.logsink()
        self.__globals__['__last_task'] = 'widefield'
        self.__globals__['taskname'] = 'widefield'
        ###
        self.__globals__['update_params'](func=self.__globals__['taskname'],printtext=False,ipython_globals=self.__globals__)
        ###
        ###
        #Handle globals or user over-ride of arguments
        #
        if type(self.__call__.func_defaults) is NoneType:
            function_signature_defaults={}
	else:
	    function_signature_defaults=dict(zip(self.__call__.func_code.co_varnames[1:],self.__call__.func_defaults))
	useLocalDefaults = False

        for item in function_signature_defaults.iteritems():
                key,val = item
                keyVal = eval(key)
                if (keyVal == None):
                        #user hasn't set it - use global/default
                        pass
                else:
                        #user has set it - use over-ride
			if (key != 'self') :
			   useLocalDefaults = True

	myparams = {}
	if useLocalDefaults :
	   for item in function_signature_defaults.iteritems():
	       key,val = item
	       keyVal = eval(key)
	       exec('myparams[key] = keyVal')
	       self.parameters[key] = keyVal
	       if (keyVal == None):
	           exec('myparams[key] = '+ key + ' = self.itsdefault(key)')
		   keyVal = eval(key)
		   if(type(keyVal) == dict) :
                      if len(keyVal) > 0 :
		         exec('myparams[key] = ' + key + ' = keyVal[len(keyVal)-1][\'value\']')
		      else :
		         exec('myparams[key] = ' + key + ' = {}')
	 
        else :
            print ''

            myparams['vis'] = vis = self.parameters['vis']
            myparams['imagename'] = imagename = self.parameters['imagename']
            myparams['outlierfile'] = outlierfile = self.parameters['outlierfile']
            myparams['field'] = field = self.parameters['field']
            myparams['spw'] = spw = self.parameters['spw']
            myparams['selectdata'] = selectdata = self.parameters['selectdata']
            myparams['timerange'] = timerange = self.parameters['timerange']
            myparams['uvrange'] = uvrange = self.parameters['uvrange']
            myparams['antenna'] = antenna = self.parameters['antenna']
            myparams['scan'] = scan = self.parameters['scan']
            myparams['mode'] = mode = self.parameters['mode']
            myparams['niter'] = niter = self.parameters['niter']
            myparams['gain'] = gain = self.parameters['gain']
            myparams['threshold'] = threshold = self.parameters['threshold']
            myparams['psfmode'] = psfmode = self.parameters['psfmode']
            myparams['ftmachine'] = ftmachine = self.parameters['ftmachine']
            myparams['facets'] = facets = self.parameters['facets']
            myparams['wprojplanes'] = wprojplanes = self.parameters['wprojplanes']
            myparams['multiscale'] = multiscale = self.parameters['multiscale']
            myparams['negcomponent'] = negcomponent = self.parameters['negcomponent']
            myparams['interactive'] = interactive = self.parameters['interactive']
            myparams['mask'] = mask = self.parameters['mask']
            myparams['nchan'] = nchan = self.parameters['nchan']
            myparams['start'] = start = self.parameters['start']
            myparams['width'] = width = self.parameters['width']
            myparams['imsize'] = imsize = self.parameters['imsize']
            myparams['cell'] = cell = self.parameters['cell']
            myparams['phasecenter'] = phasecenter = self.parameters['phasecenter']
            myparams['restfreq'] = restfreq = self.parameters['restfreq']
            myparams['stokes'] = stokes = self.parameters['stokes']
            myparams['weighting'] = weighting = self.parameters['weighting']
            myparams['robust'] = robust = self.parameters['robust']
            myparams['npixels'] = npixels = self.parameters['npixels']
            myparams['noise'] = noise = self.parameters['noise']
            myparams['cyclefactor'] = cyclefactor = self.parameters['cyclefactor']
            myparams['cyclespeedup'] = cyclespeedup = self.parameters['cyclespeedup']
            myparams['npercycle'] = npercycle = self.parameters['npercycle']
            myparams['uvtaper'] = uvtaper = self.parameters['uvtaper']
            myparams['outertaper'] = outertaper = self.parameters['outertaper']
            myparams['innertaper'] = innertaper = self.parameters['innertaper']
            myparams['restoringbeam'] = restoringbeam = self.parameters['restoringbeam']
            myparams['calready'] = calready = self.parameters['calready']

        if type(vis)==str: vis=[vis]
        if type(multiscale)==int: multiscale=[multiscale]
        if type(imsize)==int: imsize=[imsize]
        if type(cell)==float: cell=[cell]
        if type(outertaper)==str: outertaper=[outertaper]
        if type(innertaper)==str: innertaper=[innertaper]
        if type(restoringbeam)==str: restoringbeam=[restoringbeam]

	result = None

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['vis'] = vis
        mytmp['imagename'] = imagename
        mytmp['outlierfile'] = outlierfile
        mytmp['field'] = field
        mytmp['spw'] = spw
        mytmp['selectdata'] = selectdata
        mytmp['timerange'] = timerange
        mytmp['uvrange'] = uvrange
        mytmp['antenna'] = antenna
        mytmp['scan'] = scan
        mytmp['mode'] = mode
        mytmp['niter'] = niter
        mytmp['gain'] = gain
        mytmp['threshold'] = threshold
        mytmp['psfmode'] = psfmode
        mytmp['ftmachine'] = ftmachine
        mytmp['facets'] = facets
        mytmp['wprojplanes'] = wprojplanes
        mytmp['multiscale'] = multiscale
        mytmp['negcomponent'] = negcomponent
        mytmp['interactive'] = interactive
        mytmp['mask'] = mask
        mytmp['nchan'] = nchan
        mytmp['start'] = start
        mytmp['width'] = width
        mytmp['imsize'] = imsize
        if type(cell) == str :
           mytmp['cell'] = casac.casac.qa.quantity(cell)
        else :
           mytmp['cell'] = cell
        mytmp['phasecenter'] = phasecenter
        mytmp['restfreq'] = restfreq
        mytmp['stokes'] = stokes
        mytmp['weighting'] = weighting
        mytmp['robust'] = robust
        mytmp['npixels'] = npixels
        mytmp['noise'] = noise
        mytmp['cyclefactor'] = cyclefactor
        mytmp['cyclespeedup'] = cyclespeedup
        mytmp['npercycle'] = npercycle
        mytmp['uvtaper'] = uvtaper
        mytmp['outertaper'] = outertaper
        mytmp['innertaper'] = innertaper
        mytmp['restoringbeam'] = restoringbeam
        mytmp['calready'] = calready
	pathname='file://' + casa['dirs']['xml'] + '/'
	trec = casac.casac.utils().torecord(pathname+'widefield.xml')

        casalog.origin('widefield')
	try :
          #if not trec.has_key('widefield') or not casac.casac.utils().verify(mytmp, trec['widefield']) :
	    #return False

          casac.casac.utils().verify(mytmp, trec['widefield'], True)
          scriptstr=['']
          saveinputs = self.__globals__['saveinputs']
          if type(self.__call__.func_defaults) is NoneType:
              saveinputs=''
          else:
              saveinputs('widefield', 'widefield.last', myparams, self.__globals__,scriptstr=scriptstr)
          tname = 'widefield'
          spaces = ' '*(18-len(tname))
          casalog.post('\n##########################################'+
                       '\n##### Begin Task: ' + tname + spaces + ' #####')
          if type(self.__call__.func_defaults) is NoneType:
              casalog.post(scriptstr[0]+'\n', 'INFO')
          else :
              casalog.post(scriptstr[1][1:]+'\n', 'INFO')
          result = widefield(vis, imagename, outlierfile, field, spw, selectdata, timerange, uvrange, antenna, scan, mode, niter, gain, threshold, psfmode, ftmachine, facets, wprojplanes, multiscale, negcomponent, interactive, mask, nchan, start, width, imsize, cell, phasecenter, restfreq, stokes, weighting, robust, npixels, noise, cyclefactor, cyclespeedup, npercycle, uvtaper, outertaper, innertaper, restoringbeam, calready)
          casalog.post('##### End Task: ' + tname + '  ' + spaces + ' #####'+
                       '\n##########################################')

	except Exception, instance:
          if(self.__globals__.has_key('__rethrow_casa_exceptions') and self.__globals__['__rethrow_casa_exceptions']) :
             raise
          else :
             #print '**** Error **** ',instance
	     tname = 'widefield'
             casalog.post('An error occurred running task '+tname+'.', 'ERROR')
             pass

        gc.collect()
        return result
#
#
#
    def paramgui(self, useGlobals=True, ipython_globals=None):
        """
        Opens a parameter GUI for this task.  If useGlobals is true, then any relevant global parameter settings are used.
        """
        import paramgui
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )

        if useGlobals:
	    if ipython_globals == None:
                myf=self.__globals__
            else:
                myf=ipython_globals

            paramgui.setGlobals(myf)
        else:
            paramgui.setGlobals({})

        paramgui.runTask('widefield', myf['_ip'])
        paramgui.setGlobals({})

#
#
#
    def defaults(self, param=None, ipython_globals=None, paramvalue=None, subparam=None):
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
        if ipython_globals == None:
            myf=self.__globals__
        else:
            myf=ipython_globals

        a = odict()
        a['vis']  = ['']
        a['imagename']  = '', 
        a['outlierfile']  = ''
        a['field']  = ''
        a['spw']  = ''
        a['selectdata']  = False
        a['mode']  = 'mfs'
        a['niter']  = 500
        a['gain']  = 0.1
        a['threshold']  = '0.0Jy'
        a['psfmode']  = 'clark'
        a['ftmachine']  = ''
        a['multiscale']  = []
        a['interactive']  = False
        a['mask']  = []
        a['imsize']  = [256, 256]
        a['cell']  = ['1.0arcsec', '1.0arcsec']
        a['phasecenter']  = ''
        a['restfreq']  = ''
        a['stokes']  = 'I'
        a['weighting']  = 'natural'
        a['cyclefactor']  = 1.5
        a['cyclespeedup']  = -1
        a['uvtaper']  = False
        a['restoringbeam']  = ['']
        a['calready']  = False

        a['selectdata'] = {
                    0:{'value':False}, 
                    1:odict([{'value':True}, {'timerange':''}, {'uvrange':''}, {'antenna':''}, {'scan':''}])}
        a['multiscale'] = {
                    0:odict([{'notvalue':[]}, {'negcomponent':-1}])}
        a['mode'] = {
                    0:{'value':'mfs'}, 
                    1:odict([{'value':'channel'}, {'nchan':-11}, {'start':0}, {'width':1}]), 
                    2:odict([{'value':'velocity'}, {'nchan':1}, {'start':'0.0km/s'}, {'width':'1km/s'}]), 
                    3:odict([{'value':'frequency'}, {'nchan':1}, {'start':'1.4GHz'}, {'width':'10kHz'}])}
        a['weighting'] = {
                    0:{'value':'natural'}, 
                    1:{'value':'uniform'}, 
                    2:odict([{'value':'briggs'}, {'robust':0.0}, {'npixels':0}]), 
                    3:odict([{'value':'briggsabs'}, {'robust':0.0}, {'noise':'1.0Jy'}, {'npixels':0}]), 
                    4:odict([{'value':'superuniform'}, {'npixels':0}])}
        a['uvtaper'] = {
                    0:{'value':False}, 
                    1:odict([{'value':True}, {'outertaper':[]}, {'innertaper':[]}])}
        a['interactive'] = {
                    0:{'value':False}, 
                    1:odict([{'value':True}, {'npercycle':100}])}
        a['ftmachine'] = {
                    0:odict([{'value':'wproject'}, {'wprojplanes':256}, {'facets':1}]), 
                    1:odict([{'value':'ft'}, {'facets':1}])}

### This function sets the default values but also will return the list of
### parameters or the default value of a given parameter
        if(param == None):
                myf['__set_default_parameters'](a)
        elif(param == 'paramkeys'):
                return a.keys()
        else:
            if(paramvalue==None and subparam==None):
               if(a.has_key(param)):
                  return a[param]
               else:
                  return self.itsdefault(param)
            else:
               retval=a[param]
               if(type(a[param])==dict):
                  for k in range(len(a[param])):
                     valornotval='value'
                     if(a[param][k].has_key('notvalue')):
                        valornotval='notvalue'
                     if((a[param][k][valornotval])==paramvalue):
                        retval=a[param][k].copy()
                        retval.pop(valornotval)
                        if(subparam != None):
                           if(retval.has_key(subparam)):
                              retval=retval[subparam]
                           else:
                              retval=self.itsdefault(subparam)
		     else:
                        retval=self.itsdefault(subparam)
               return retval


#
#
    def check_params(self, param=None, value=None, ipython_globals=None):
      if ipython_globals == None:
          myf=self.__globals__
      else:
          myf=ipython_globals
#      print 'param:', param, 'value:', value
      try :
         if str(type(value)) != "<type 'instance'>" :
            value0 = value
            value = myf['cu'].expandparam(param, value)
            matchtype = False
            if(type(value) == numpy.ndarray):
               if(type(value) == type(value0)):
                  myf[param] = value.tolist()
               else:
                  #print 'value:', value, 'value0:', value0
                  #print 'type(value):', type(value), 'type(value0):', type(value0)
                  myf[param] = value0
                  if type(value0) != list :
                     matchtype = True
            else :
               myf[param] = value
            value = myf['cu'].verifyparam({param:value})
            if matchtype:
               value = False
      except Exception, instance:
         #ignore the exception and just return it unchecked
         myf[param] = value
      return value
#
#
    def description(self, key='widefield', subkey=None):
        desc={'widefield': 'Wide-field imaging and deconvolution with selected algorithm',
               'vis': 'name of input visibility file',
               'imagename': 'Pre-name of output images',
               'outlierfile': 'Text file with image names, sizes, centers',
               'field': 'Field Name',
               'spw': 'Spectral windows:channels: \'\' is all ',
               'selectdata': 'Other data selection parameters',
               'timerange': 'Range of time to select from data',
               'uvrange': 'Select data within uvrange ',
               'antenna': 'Select data based on antenna/baseline',
               'scan': 'scan number range',
               'mode': 'Type of selection (mfs, channel, velocity, frequency)',
               'niter': 'Maximum number of iterations',
               'gain': 'Loop gain for cleaning',
               'threshold': 'Flux level to stop cleaning.  Must include units',
               'psfmode': 'Algorithm to use (clark, hogbom) ',
               'ftmachine': 'Gridding method for the image (wproject, ft)',
               'facets': 'Number of facets along each axis in main image only',
               'wprojplanes': 'Number of planes to use in wprojection convolutiuon function',
               'multiscale': 'set deconvolution scales (pixels), default: multiscale=[]',
               'negcomponent': 'Stop cleaning if the largest scale finds this number of neg components',
               'interactive': 'use interactive clean (with GUI viewer)',
               'mask': 'cleanbox(es), mask image(s), and/or region(s) ',
               'nchan': 'Number of channels (planes) in output image',
               'start': 'First channel in input to use',
               'width': 'Number of input channels to average',
               'imsize': 'Image size in pixels (nx,ny), single value okay',
               'cell': 'The image cell size in arcseconds [x,y], single value okay. ',
               'phasecenter': 'Field Identififier or direction of the image phase center',
               'restfreq': 'rest frequency to assign to image (see help)',
               'stokes': 'Stokes params to image (I,IV,QU,IQUV,RR,LL,XX,YY,RRLL,XXYY)',
               'weighting': 'Weighting to apply to visibilities',
               'robust': 'Briggs robustness parameter',
               'npixels': 'number of pixels to determine cell size for superuniform or briggs weighting',
               'noise': 'noise parameter for briggs abs mode weighting',
               'cyclefactor': 'Threshold for minor/major cycles (see pdoc)',
               'cyclespeedup': 'Cycle threshold doubles in this number of iterations',
               'npercycle': 'Number of iterations before interactive masking prompt',
               'uvtaper': 'Apply additional uv tapering of  visibilities.',
               'outertaper': 'uv-taper on outer baselines in uv-plane',
               'innertaper': 'uv-taper in center of uv-plane',
               'restoringbeam': 'Output Gaussian restoring beam for CLEAN image',
               'calready': 'Create scratch columns and store model visibilities so that selfcal can be run after clean',

              }

#
# Set subfields defaults if needed
#
        if(subkey == 'channel'):
          desc['start'] = 'first channel in image relative to data channels'
        if(subkey == 'velocity'):
          desc['start'] = 'Velocity of first image channel: e.g \'0.0km/s\''
        if(subkey == 'velocity'):
          desc['width'] = 'image channel width in velocity units: e.g \'-1.0km/s\''
        if(subkey == 'frequency'):
          desc['start'] = 'Frequency of first image channel: e.q. \'1.4GHz\''
        if(subkey == 'frequency'):
          desc['width'] = 'Image channel width in frequency units: e.g \'10kHz\''
        if(subkey == 'briggs'):
          desc['npixels'] = 'number of pixels to determine uv-cell size 0=> field of view'
        if(subkey == 'briggsabs'):
          desc['npixels'] = 'number of pixels to determine uv-cell size 0=> field of view'
        if(subkey == 'superuniform'):
          desc['npixels'] = 'number of pixels to determine uv-cell size 0=> +/-3pixels'

        if(desc.has_key(key)) :
           return desc[key]

    def itsdefault(self, paramname) :
        a = {}
        a['vis']  = ['']
        a['imagename']  = '', 
        a['outlierfile']  = ''
        a['field']  = ''
        a['spw']  = ''
        a['selectdata']  = False
        a['timerange']  = ''
        a['uvrange']  = ''
        a['antenna']  = ''
        a['scan']  = ''
        a['mode']  = 'mfs'
        a['niter']  = 500
        a['gain']  = 0.1
        a['threshold']  = '0.0Jy'
        a['psfmode']  = 'clark'
        a['ftmachine']  = ''
        a['facets']  = 3
        a['wprojplanes']  = 64
        a['multiscale']  = []
        a['negcomponent']  = 0
        a['interactive']  = False
        a['mask']  = []
        a['nchan']  = 1
        a['start']  = 0
        a['width']  = 1
        a['imsize']  = [256, 256]
        a['cell']  = ['1.0arcsec', '1.0arcsec']
        a['phasecenter']  = ''
        a['restfreq']  = ''
        a['stokes']  = 'I'
        a['weighting']  = 'natural'
        a['robust']  = 0.0
        a['npixels']  = 0
        a['noise']  = '1.0Jy'
        a['cyclefactor']  = 1.5
        a['cyclespeedup']  = -1
        a['npercycle']  = 100
        a['uvtaper']  = False
        a['outertaper']  = ['']
        a['innertaper']  = ['1.0']
        a['restoringbeam']  = ['']
        a['calready']  = False

        #a = sys._getframe(len(inspect.stack())-1).f_globals

        if self.parameters['selectdata']  == True:
            a['timerange'] = ''
            a['uvrange'] = ''
            a['antenna'] = ''
            a['scan'] = ''

        if self.parameters['multiscale']  != []:
            a['negcomponent'] = -1

        if self.parameters['mode']  == 'channel':
            a['nchan'] = -11
            a['start'] = 0
            a['width'] = 1

        if self.parameters['mode']  == 'velocity':
            a['nchan'] = 1
            a['start'] = '0.0km/s'
            a['width'] = '1km/s'

        if self.parameters['mode']  == 'frequency':
            a['nchan'] = 1
            a['start'] = '1.4GHz'
            a['width'] = '10kHz'

        if self.parameters['weighting']  == 'briggs':
            a['robust'] = 0.0
            a['npixels'] = 0

        if self.parameters['weighting']  == 'briggsabs':
            a['robust'] = 0.0
            a['noise'] = '1.0Jy'
            a['npixels'] = 0

        if self.parameters['weighting']  == 'superuniform':
            a['npixels'] = 0

        if self.parameters['uvtaper']  == True:
            a['outertaper'] = []
            a['innertaper'] = []

        if self.parameters['interactive']  == True:
            a['npercycle'] = 100

        if self.parameters['ftmachine']  == 'wproject':
            a['wprojplanes'] = 256
            a['facets'] = 1

        if self.parameters['ftmachine']  == 'ft':
            a['facets'] = 1

        if a.has_key(paramname) :
	      return a[paramname]
widefield_cli = widefield_cli_()
