#
# This file was generated using xslt from its XML file
#
# Copyright 2014, Associated Universities Inc., Washington DC
#
import sys
import os
#from casac import *
import casac
import string
import time
import inspect
import gc
import numpy
from casa_stack_manip import stack_frame_find
from odict import odict
from types import * 
from task_vishead import vishead
class vishead_cli_:
    __name__ = "vishead"
    rkey = None
    i_am_a_casapy_task = None
    # The existence of the i_am_a_casapy_task attribute allows help()
    # (and other) to treat casapy tasks as a special case.

    def __init__(self) :
       self.__bases__ = (vishead_cli_,)
       self.__doc__ = self.__call__.__doc__

       self.parameters={'vis':None, 'mode':None, 'listitems':None, 'hdkey':None, 'hdindex':None, 'hdvalue':None, }


    def result(self, key=None):
	    #### and add any that have completed...
	    return None


    def __call__(self, vis=None, mode=None, listitems=None, hdkey=None, hdindex=None, hdvalue=None, ):

        """List, summary, get, and put metadata in a measurement set

	Detailed Description: 
List, summary, get, and put "header" information in a measurement set.
	Arguments :
		vis:	Name of input visibility file
		   Default Value: 

		mode:	options: list, summary, get, put
		   Default Value: summary
		   Allowed Values:
				list
				summary
				get
				put
				

		listitems:	items to list ([] for all)
		   Default Value: 
		   telescope
		   observer
		   project
		   field
		   freq_group_name
		   spw_name
		   schedule
		   schedule_type
		   release_date
		 

		hdkey:	keyword to get/put
		   Default Value: 

		hdindex:	keyword index to get/put, counting from zero. ''==>all
		   Default Value: 

		hdvalue:	value of hdkey
		   Default Value: 


	Example :


        This task allows the user to manipulate some meta-data parameters in a
        measurement set.  The mode='list' shows those keywords that are
        presently implemented, with their values.  The contents associated
        with the keywords can be obtained (get) and changed (put).

        The modes that are available are:

           list    --- List all keywords that are recognized, and list the
                       value(s) for each.  Only these keywords can be obtained
                       (get) or changed (put) 
           summary --- Equivalent to running taskname='listobs'; verbose=F
           get     --- Get the specified keyword value(s) from the ms
           put     --- Put the specified keyword value(s) into the ms

        Parameters currently implemented are (June 1, 2009):

           cal_grp              
           field                 Field names
           fld_code              Field Observing codes
           freq_group_name       
           log                   
           observer              Observer name
           project               Project name
           ptcs                  Phase tracking centers for each field
           release_date          
           schedule
           schedule_type
           spw_name              Spectral parameters?
           source_name           Source Names (=Field Names?)
           telescope             Telescope Name

        Keyword arguments:

        vis  --- Name of input visibility file
                  default: none, example: vis='my.ms'

        mode --- Mode of operation for vishead
                  default = 'list'; example: mode='get'

        hdkey--- keyword to get or put from the ms (used in get/put mode only)
                  ex: hdkey='telescope'

        hdindex--- index (counting from 0) if keyword is an array (used in get/put
                  mode only)
                  ex: hdindex='2'; hdindex=''->put/get full array; 

        hdvalue   --- value to be put in the MS (used in put mode only)
                  ex: hdvalue=array(['MyTelescope'])




        Examples:

           To transfer the parameters to useful python items requires some care.

           taskname = 'vishead'
           default() 
           vis = '3C84C.ms'
           mode = 'get'
                      
           to get a field name (string),
              hdkey = 'field'; hdindex = '2'; hdvalue=vishead(); 
                       print hdvalue[0] = the name for field='2'                    
                
           to get an phase center (number)
              hdkey = 'ptcs'; hdindex = '1'; hdvalue = vishead();
                       hdvalue[0][0] gives the ra, hdvalue[0][1] gives the dec in field '1'


           taskname = 'vishead'
           default() 
           vis = '3C84C.ms'
           mode = 'put'

          To change a string,

              hdkey = 'field'; hdindex = '2'; hdvalue = 'junk'; vishead()
                   field='2' is renamed 'junk'

          To change a number, (egs. ra of field=1 to 0.5 radian)
              is too complicated to figure out!
             


        """
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
	#casac = self.__globals__['casac']
	casalog = self.__globals__['casalog']
	casa = self.__globals__['casa']
	#casalog = casac.casac.logsink()
        self.__globals__['__last_task'] = 'vishead'
        self.__globals__['taskname'] = 'vishead'
        ###
        self.__globals__['update_params'](func=self.__globals__['taskname'],printtext=False,ipython_globals=self.__globals__)
        ###
        ###
        #Handle globals or user over-ride of arguments
        #
        if type(self.__call__.func_defaults) is NoneType:
            function_signature_defaults={}
	else:
	    function_signature_defaults=dict(zip(self.__call__.func_code.co_varnames[1:],self.__call__.func_defaults))
	useLocalDefaults = False

        for item in function_signature_defaults.iteritems():
                key,val = item
                keyVal = eval(key)
                if (keyVal == None):
                        #user hasn't set it - use global/default
                        pass
                else:
                        #user has set it - use over-ride
			if (key != 'self') :
			   useLocalDefaults = True

	myparams = {}
	if useLocalDefaults :
	   for item in function_signature_defaults.iteritems():
	       key,val = item
	       keyVal = eval(key)
	       exec('myparams[key] = keyVal')
	       self.parameters[key] = keyVal
	       if (keyVal == None):
	           exec('myparams[key] = '+ key + ' = self.itsdefault(key)')
		   keyVal = eval(key)
		   if(type(keyVal) == dict) :
                      if len(keyVal) > 0 :
		         exec('myparams[key] = ' + key + ' = keyVal[len(keyVal)-1][\'value\']')
		      else :
		         exec('myparams[key] = ' + key + ' = {}')
	 
        else :
            print ''

            myparams['vis'] = vis = self.parameters['vis']
            myparams['mode'] = mode = self.parameters['mode']
            myparams['listitems'] = listitems = self.parameters['listitems']
            myparams['hdkey'] = hdkey = self.parameters['hdkey']
            myparams['hdindex'] = hdindex = self.parameters['hdindex']
            myparams['hdvalue'] = hdvalue = self.parameters['hdvalue']

        if type(listitems)==str: listitems=[listitems]

	result = None

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['vis'] = vis
        mytmp['mode'] = mode
        mytmp['listitems'] = listitems
        mytmp['hdkey'] = hdkey
        mytmp['hdindex'] = hdindex
        mytmp['hdvalue'] = hdvalue
	pathname='file://' + casa['dirs']['xml'] + '/'
	trec = casac.casac.utils().torecord(pathname+'vishead.xml')

        casalog.origin('vishead')
	try :
          #if not trec.has_key('vishead') or not casac.casac.utils().verify(mytmp, trec['vishead']) :
	    #return False

          casac.casac.utils().verify(mytmp, trec['vishead'], True)
          scriptstr=['']
          saveinputs = self.__globals__['saveinputs']
          if type(self.__call__.func_defaults) is NoneType:
              saveinputs=''
          else:
              saveinputs('vishead', 'vishead.last', myparams, self.__globals__,scriptstr=scriptstr)
          tname = 'vishead'
          spaces = ' '*(18-len(tname))
          casalog.post('\n##########################################'+
                       '\n##### Begin Task: ' + tname + spaces + ' #####')
          if type(self.__call__.func_defaults) is NoneType:
              casalog.post(scriptstr[0]+'\n', 'INFO')
          else :
              casalog.post(scriptstr[1][1:]+'\n', 'INFO')
          result = vishead(vis, mode, listitems, hdkey, hdindex, hdvalue)
          casalog.post('##### End Task: ' + tname + '  ' + spaces + ' #####'+
                       '\n##########################################')

	except Exception, instance:
          if(self.__globals__.has_key('__rethrow_casa_exceptions') and self.__globals__['__rethrow_casa_exceptions']) :
             raise
          else :
             #print '**** Error **** ',instance
	     tname = 'vishead'
             casalog.post('An error occurred running task '+tname+'.', 'ERROR')
             pass

        gc.collect()
        return result
#
#
#
    def paramgui(self, useGlobals=True, ipython_globals=None):
        """
        Opens a parameter GUI for this task.  If useGlobals is true, then any relevant global parameter settings are used.
        """
        import paramgui
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )

        if useGlobals:
	    if ipython_globals == None:
                myf=self.__globals__
            else:
                myf=ipython_globals

            paramgui.setGlobals(myf)
        else:
            paramgui.setGlobals({})

        paramgui.runTask('vishead', myf['_ip'])
        paramgui.setGlobals({})

#
#
#
    def defaults(self, param=None, ipython_globals=None, paramvalue=None, subparam=None):
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
        if ipython_globals == None:
            myf=self.__globals__
        else:
            myf=ipython_globals

        a = odict()
        a['vis']  = ''
        a['mode']  = 'summary'

        a['mode'] = {
                    0:odict([{'value':'list'}, {'listitems':['telescope', 'observer', 'project', 'field', 'freq_group_name', 'spw_name', 'schedule', 'schedule_type', 'release_date']}]), 
                    1:{'value':'summary'}, 
                    2:odict([{'value':'get'}, {'hdkey':''}, {'hdindex':''}]), 
                    3:odict([{'value':'put'}, {'hdkey':''}, {'hdindex':''}, {'hdvalue':''}])}

### This function sets the default values but also will return the list of
### parameters or the default value of a given parameter
        if(param == None):
                myf['__set_default_parameters'](a)
        elif(param == 'paramkeys'):
                return a.keys()
        else:
            if(paramvalue==None and subparam==None):
               if(a.has_key(param)):
                  return a[param]
               else:
                  return self.itsdefault(param)
            else:
               retval=a[param]
               if(type(a[param])==dict):
                  for k in range(len(a[param])):
                     valornotval='value'
                     if(a[param][k].has_key('notvalue')):
                        valornotval='notvalue'
                     if((a[param][k][valornotval])==paramvalue):
                        retval=a[param][k].copy()
                        retval.pop(valornotval)
                        if(subparam != None):
                           if(retval.has_key(subparam)):
                              retval=retval[subparam]
                           else:
                              retval=self.itsdefault(subparam)
		     else:
                        retval=self.itsdefault(subparam)
               return retval


#
#
    def check_params(self, param=None, value=None, ipython_globals=None):
      if ipython_globals == None:
          myf=self.__globals__
      else:
          myf=ipython_globals
#      print 'param:', param, 'value:', value
      try :
         if str(type(value)) != "<type 'instance'>" :
            value0 = value
            value = myf['cu'].expandparam(param, value)
            matchtype = False
            if(type(value) == numpy.ndarray):
               if(type(value) == type(value0)):
                  myf[param] = value.tolist()
               else:
                  #print 'value:', value, 'value0:', value0
                  #print 'type(value):', type(value), 'type(value0):', type(value0)
                  myf[param] = value0
                  if type(value0) != list :
                     matchtype = True
            else :
               myf[param] = value
            value = myf['cu'].verifyparam({param:value})
            if matchtype:
               value = False
      except Exception, instance:
         #ignore the exception and just return it unchecked
         myf[param] = value
      return value
#
#
    def description(self, key='vishead', subkey=None):
        desc={'vishead': 'List, summary, get, and put metadata in a measurement set',
               'vis': 'Name of input visibility file',
               'mode': 'options: list, summary, get, put',
               'listitems': 'items to list ([] for all)',
               'hdkey': 'keyword to get/put',
               'hdindex': 'keyword index to get/put, counting from zero. ''==>all',
               'hdvalue': 'value of hdkey',

              }

#
# Set subfields defaults if needed
#

        if(desc.has_key(key)) :
           return desc[key]

    def itsdefault(self, paramname) :
        a = {}
        a['vis']  = ''
        a['mode']  = 'summary'
        a['listitems']  = ['telescope', 'observer', 'project', 'field', 'freq_group_name', 'spw_name', 'schedule', 'schedule_type', 'release_date']
        a['hdkey']  = ''
        a['hdindex']  = ''
        a['hdvalue']  = ''

        #a = sys._getframe(len(inspect.stack())-1).f_globals

        if self.parameters['mode']  == 'list':
            a['listitems'] = ['telescope', 'observer', 'project', 'field', 'freq_group_name', 'spw_name', 'schedule', 'schedule_type', 'release_date']

        if self.parameters['mode']  == 'get':
            a['hdkey'] = ''
            a['hdindex'] = ''

        if self.parameters['mode']  == 'put':
            a['hdkey'] = ''
            a['hdindex'] = ''
            a['hdvalue'] = ''

        if a.has_key(paramname) :
	      return a[paramname]
vishead_cli = vishead_cli_()
