#
# This file was generated using xslt from its XML file
#
# Copyright 2009, Associated Universities Inc., Washington DC
#
import sys
import os
from  casac import *
import string
from taskinit import casalog
from taskinit import xmlpath
#from taskmanager import tm
import task_vishead
def vishead(vis='', mode='summary', listitems=['telescope', 'observer', 'project', 'field', 'freq_group_name', 'spw_name', 'schedule', 'schedule_type', 'release_date'], hdkey='', hdindex='', hdvalue=''):

        """List, summary, get, and put metadata in a measurement set

        This task allows the user to manipulate some meta-data parameters in a
        measurement set.  The mode='list' shows those keywords that are
        presently implemented, with their values.  The contents associated
        with the keywords can be obtained (get) and changed (put).

        The modes that are available are:

           list    --- List all keywords that are recognized, and list the
                       value(s) for each.  Only these keywords can be obtained
                       (get) or changed (put) 
           summary --- Equivalent to running taskname='listobs'; verbose=F
           get     --- Get the specified keyword value(s) from the ms
           put     --- Put the specified keyword value(s) into the ms

        Parameters currently implemented are (June 1, 2009):

           cal_grp              
           field                 Field names
           fld_code              Field Observing codes
           freq_group_name       
           log                   
           observer              Observer name
           project               Project name
           ptcs                  Phase tracking centers for each field
           release_date          
           schedule
           schedule_type
           spw_name              Spectral parameters?
           source_name           Source Names (=Field Names?)
           telescope             Telescope Name

        Keyword arguments:

        vis  --- Name of input visibility file
                  default: none, example: vis='my.ms'

        mode --- Mode of operation for vishead
                  default = 'list'; example: mode='get'

        hdkey--- keyword to get or put from the ms (used in get/put mode only)
                  ex: hdkey='telescope'

        hdindex--- index (counting from 0) if keyword is an array (used in get/put
                  mode only)
                  ex: hdindex='2'; hdindex=''->put/get full array; 

        hdvalue   --- value to be put in the MS (used in put mode only)
                  ex: hdvalue=array(['MyTelescope'])




        Examples:

           To transfer the parameters to useful python items requires some care.

           taskname = 'vishead'
           default() 
           vis = '3C84C.ms'
           mode = 'get'
                      
           to get a field name (string),
              hdkey = 'field'; hdindex = '2'; hdvalue=vishead(); 
                       print hdvalue[0] = the name for field='2'                    
                
           to get an phase center (number)
              hdkey = 'ptcs'; hdindex = '1'; hdvalue = vishead();
                       hdvalue[0][0] gives the ra, hdvalue[0][1] gives the dec in field '1'


           taskname = 'vishead'
           default() 
           vis = '3C84C.ms'
           mode = 'put'

          To change a string,

              hdkey = 'field'; hdindex = '2'; hdvalue = 'junk'; vishead()
                   field='2' is renamed 'junk'

          To change a number, (egs. ra of field=1 to 0.5 radian)
              is too complicated to figure out!
             


        """
        if type(listitems)==str: listitems=[listitems]

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['vis'] = vis
        mytmp['mode'] = mode
        mytmp['listitems'] = listitems
        mytmp['hdkey'] = hdkey
        mytmp['hdindex'] = hdindex
        mytmp['hdvalue'] = hdvalue
	pathname='file://' + xmlpath( ) + '/'
	trec = casac.utils().torecord(pathname+'vishead.xml')

        casalog.origin('vishead')
        if trec.has_key('vishead') and casac.utils().verify(mytmp, trec['vishead']) :
	    result = task_vishead.vishead(vis, mode, listitems, hdkey, hdindex, hdvalue)

	else :
	  result = False
        return result
