from odict import odict
mytasks = odict()
tasksum = odict()
taskcat = odict()
taskvis = odict()
tasksum['accor'] = 'Normalize visibilities based on auto-correlations'
taskcat['accor'] = 'calibration'
taskvis['accor'] = ''
tasksum['accum'] = 'Accumulate incremental calibration solutions into a calibration table'
taskcat['accum'] = 'calibration'
taskvis['accum'] = ''
tasksum['applycal'] = 'Apply calibrations solutions(s) to data'
taskcat['applycal'] = 'calibration'
taskvis['applycal'] = ''
tasksum['asdmsummary'] = 'Summarized description of an ASDM dataset.'
taskcat['asdmsummary'] = 'information'
taskvis['asdmsummary'] = 'experimental'
tasksum['autoclean'] = 'CLEAN an image with automatically-chosen clean regions.'
taskcat['autoclean'] = 'imaging'
taskvis['autoclean'] = 'hidden'
tasksum['bandpass'] = 'Calculates a bandpass calibration solution'
taskcat['bandpass'] = 'calibration'
taskvis['bandpass'] = ''
tasksum['blcal'] = 'Calculate a baseline-based calibration solution (gain or bandpass)'
taskcat['blcal'] = 'calibration'
taskvis['blcal'] = ''
tasksum['boxit'] = 'Box regions in image above given threshold value.'
taskcat['boxit'] = 'imaging'
taskvis['boxit'] = 'experimental'
tasksum['browsetable'] = 'Browse a table (MS, calibration table, image)'
taskcat['browsetable'] = 'utility'
taskvis['browsetable'] = ''
tasksum['calstat'] = 'Displays statistical information on a calibration table'
taskcat['calstat'] = 'calibration'
taskvis['calstat'] = ''
tasksum['caltabconvert'] = 'Convert old-style caltables into new-style caltables.'
taskcat['caltabconvert'] = 'utility'
taskvis['caltabconvert'] = ''
tasksum['clean'] = 'Invert and deconvolve images with selected algorithm'
taskcat['clean'] = 'imaging'
taskvis['clean'] = ''
tasksum['clearcal'] = 'Re-initializes the calibration for a visibility data set'
taskcat['clearcal'] = 'calibration'
taskvis['clearcal'] = ''
tasksum['clearplot'] = 'Clear the matplotlib plotter and all layers'
taskcat['clearplot'] = 'utility, visualization'
taskvis['clearplot'] = ''
tasksum['clearstat'] = 'Clear all autolock locks'
taskcat['clearstat'] = 'utility'
taskvis['clearstat'] = ''
tasksum['concat'] = 'Concatenate several visibility data sets.'
taskcat['concat'] = 'utility, manipulation'
taskvis['concat'] = ''
tasksum['conjugatevis'] = 'Change the sign of the phases in all visibility columns.'
taskcat['conjugatevis'] = 'utility, manipulation'
taskvis['conjugatevis'] = ''
tasksum['csvclean'] = 'This task does an invert of the visibilities and deconvolve in the image plane.'
taskcat['csvclean'] = 'utilities, imaging'
taskvis['csvclean'] = 'experimental'
tasksum['cvel'] = 'regrid an MS to a new spectral window / channel structure or frame'
taskcat['cvel'] = 'manipulation'
taskvis['cvel'] = ''
tasksum['cvel2'] = 'Regrid an MS or MMS to a new spectral window, channel structure or frame'
taskcat['cvel2'] = 'manipulation'
taskvis['cvel2'] = 'experimental'
tasksum['deconvolve'] = 'Image based deconvolver'
taskcat['deconvolve'] = 'imaging'
taskvis['deconvolve'] = ''
tasksum['delmod'] = 'Deletes model representations in the MS'
taskcat['delmod'] = 'calibration'
taskvis['delmod'] = ''
tasksum['exportasdm'] = 'Convert a CASA visibility file (MS) into an ALMA or EVLA Science Data Model'
taskcat['exportasdm'] = 'import/export'
taskvis['exportasdm'] = ''
tasksum['exportfits'] = 'Convert a CASA image to a FITS file'
taskcat['exportfits'] = 'import/export'
taskvis['exportfits'] = ''
tasksum['exportuvfits'] = 'Convert a CASA visibility data set to a UVFITS file:'
taskcat['exportuvfits'] = 'import/export'
taskvis['exportuvfits'] = ''
tasksum['feather'] = 'Combine two images using their Fourier transforms'
taskcat['feather'] = 'imaging'
taskvis['feather'] = ''
tasksum['fixplanets'] = 'Changes FIELD and SOURCE table entries based on user-provided direction or POINTING table, optionally fixes the UVW coordinates'
taskcat['fixplanets'] = 'editing, maninpulation, calibration'
taskvis['fixplanets'] = ''
tasksum['fixvis'] = 'Recalculates (u, v, w) and/or changes Phase Center '
taskcat['fixvis'] = 'editing, manipulation'
taskvis['fixvis'] = ''
tasksum['flagcmd'] = 'Flagging task based on batches of flag-commands'
taskcat['flagcmd'] = 'data editing'
taskvis['flagcmd'] = ''
tasksum['flagdata'] = 'All-purpose flagging task based on data-selections and flagging modes/algorithms.'
taskcat['flagdata'] = 'editing'
taskvis['flagdata'] = ''
tasksum['flagmanager'] = 'Enable list, save, restore, delete and rename flag version files.'
taskcat['flagmanager'] = 'editing'
taskvis['flagmanager'] = ''
tasksum['fluxscale'] = 'Bootstrap the flux density scale from standard calibrators'
taskcat['fluxscale'] = 'calibration'
taskvis['fluxscale'] = ''
tasksum['fringefit'] = 'Fringe fit delay and rates'
taskcat['fringefit'] = 'calibration'
taskvis['fringefit'] = ''
tasksum['ft'] = 'Insert a source model  a visibility set:'
taskcat['ft'] = 'imaging, calibration'
taskvis['ft'] = ''
tasksum['gaincal'] = 'Determine temporal gains from calibrator observations'
taskcat['gaincal'] = 'calibration'
taskvis['gaincal'] = ''
tasksum['gencal'] = 'Specify Calibration Values of Various Types'
taskcat['gencal'] = 'calibration'
taskvis['gencal'] = ''
tasksum['hanningsmooth'] = 'Hanning smooth frequency channel data to remove Gibbs ringing'
taskcat['hanningsmooth'] = 'manipulation'
taskvis['hanningsmooth'] = ''
tasksum['imcollapse'] = 'Collapse image along one axis, aggregating pixel values along that axis.'
taskcat['imcollapse'] = 'analysis'
taskvis['imcollapse'] = ''
tasksum['imcontsub'] = 'Estimates and subtracts continuum emission from an image cube'
taskcat['imcontsub'] = 'analysis, imaging'
taskvis['imcontsub'] = ''
tasksum['imdev'] = 'Create an image that can represent the statistical deviations of the input image.'
taskcat['imdev'] = 'analysis'
taskvis['imdev'] = ''
tasksum['imfit'] = 'Fit one or more elliptical Gaussian components on an image region(s)'
taskcat['imfit'] = 'analysis'
taskvis['imfit'] = ''
tasksum['imhead'] = 'List, get and put image header parameters'
taskcat['imhead'] = 'analysis, information, manipulation'
taskvis['imhead'] = ''
tasksum['imhistory'] = 'Retrieve and modify image history'
taskcat['imhistory'] = 'analysis'
taskvis['imhistory'] = ''
tasksum['immath'] = 'Perform math operations on images'
taskcat['immath'] = 'analysis'
taskvis['immath'] = ''
tasksum['immoments'] = 'Compute moments from an image'
taskcat['immoments'] = 'analysis'
taskvis['immoments'] = ''
tasksum['impbcor'] = 'Construct a primary beam corrected image from an image and a primary beam pattern.'
taskcat['impbcor'] = 'analysis'
taskvis['impbcor'] = ''
tasksum['importatca'] = 'Import ATCA RPFITS file(s) to a measurement set'
taskcat['importatca'] = 'import/export'
taskvis['importatca'] = ''
tasksum['importasap'] = 'Convert ASAP Scantable data  into a CASA visibility file (MS)'
taskcat['importasap'] = 'single dish'
taskvis['importasap'] = ''
tasksum['importasdm'] = 'Convert an ALMA Science Data Model observation into a CASA visibility file (MS)'
taskcat['importasdm'] = 'import/export'
taskvis['importasdm'] = ''
tasksum['importevla'] = 'Convert an Science Data Model observation into a CASA Measurement Set'
taskcat['importevla'] = 'import/export'
taskvis['importevla'] = 'experimental'
tasksum['importfits'] = 'Convert an image FITS file into a CASA image'
taskcat['importfits'] = 'import/export'
taskvis['importfits'] = ''
tasksum['importfitsidi'] = 'Convert a FITS-IDI file to a CASA visibility data set'
taskcat['importfitsidi'] = 'import/export'
taskvis['importfitsidi'] = ''
tasksum['importgmrt'] = 'Convert a UVFITS file to a CASA visibility data set'
taskcat['importgmrt'] = 'import/export'
taskvis['importgmrt'] = 'experimental'
tasksum['importmiriad'] = 'Convert a Miriad visibility file into a CASA MeasurementSet'
taskcat['importmiriad'] = 'import/export'
taskvis['importmiriad'] = ''
tasksum['importnro'] = 'Convert NOSTAR data into a CASA visibility file (MS)'
taskcat['importnro'] = 'singledish'
taskvis['importnro'] = ''
tasksum['importuvfits'] = 'Convert a UVFITS file to a CASA visibility data set'
taskcat['importuvfits'] = 'import/export'
taskvis['importuvfits'] = ''
tasksum['importvla'] = 'Import VLA archive file(s) to a measurement set'
taskcat['importvla'] = 'import/export'
taskvis['importvla'] = ''
tasksum['imrebin'] = 'Rebin an image by the specified integer factors'
taskcat['imrebin'] = 'analysis'
taskvis['imrebin'] = ''
tasksum['imreframe'] = 'Change the frame in which the image reports its spectral values'
taskcat['imreframe'] = 'analysis, information'
taskvis['imreframe'] = ''
tasksum['imregrid'] = 'regrid an image onto a template image'
taskcat['imregrid'] = 'analysis'
taskvis['imregrid'] = ''
tasksum['imsmooth'] = 'Smooth an image or portion of an image'
taskcat['imsmooth'] = 'analysis'
taskvis['imsmooth'] = ''
tasksum['imstat'] = 'Displays statistical information from an image or image region'
taskcat['imstat'] = 'analysis, information'
taskvis['imstat'] = ''
tasksum['imsubimage'] = 'Create a (sub)image from a region of the image'
taskcat['imsubimage'] = 'analysis'
taskvis['imsubimage'] = ''
tasksum['imtrans'] = 'Reorder image axes'
taskcat['imtrans'] = 'analysis'
taskvis['imtrans'] = ''
tasksum['imval'] = 'Get the data value(s) and/or mask value in an image.'
taskcat['imval'] = 'analysis, information'
taskvis['imval'] = ''
tasksum['imview'] = 'View an image'
taskcat['imview'] = 'utility, visualization'
taskvis['imview'] = ''
tasksum['initweights'] = 'Initializes weight information in the MS'
taskcat['initweights'] = 'calibration'
taskvis['initweights'] = ''
tasksum['listcal'] = 'List antenna gain solutions'
taskcat['listcal'] = 'information, calibration'
taskvis['listcal'] = ''
tasksum['listhistory'] = 'List the processing history of a dataset:'
taskcat['listhistory'] = 'information'
taskvis['listhistory'] = ''
tasksum['listfits'] = 'List the HDU and typical data rows of a fits file:'
taskcat['listfits'] = 'information'
taskvis['listfits'] = ''
tasksum['listobs'] = 'List the summary of a data set in the logger or in a file'
taskcat['listobs'] = 'information'
taskvis['listobs'] = ''
tasksum['listpartition'] = 'List the summary of a multi-MS data set in the logger or in a file'
taskcat['listpartition'] = 'information'
taskvis['listpartition'] = ''
tasksum['listsdm'] = 'Lists observation information present in an SDM directory.'
taskcat['listsdm'] = 'information'
taskvis['listsdm'] = 'experimental'
tasksum['listvis'] = 'List measurement set visibilities.'
taskcat['listvis'] = 'information, analysis'
taskvis['listvis'] = ''
tasksum['makemask'] = 'Makes and manipulates image masks'
taskcat['makemask'] = 'information'
taskvis['makemask'] = 'experimental'
tasksum['mosaic'] = 'Create a multi-field deconvolved image with selected algorithm'
taskcat['mosaic'] = 'imaging'
taskvis['mosaic'] = 'deprecated'
tasksum['msview'] = 'View a visibility data set'
taskcat['msview'] = 'utility, visualization, editing'
taskvis['msview'] = ''
tasksum['mstransform'] = 'Split the MS, combine/separate/regrid spws and do channel and time averaging'
taskcat['mstransform'] = 'manipulation'
taskvis['mstransform'] = ''
tasksum['msuvbin'] = 'grid the visibility data onto a defined uniform grid (in the form of an ms); multiple MS\'s can be done onto the same grid'
taskcat['msuvbin'] = 'ms, averaging'
taskvis['msuvbin'] = ''
tasksum['oldhanningsmooth'] = 'Hanning smooth frequency channel data to remove Gibbs ringing'
taskcat['oldhanningsmooth'] = 'manipulation'
taskvis['oldhanningsmooth'] = ''
tasksum['oldplotants'] = 'Plot the antenna distribution in the local reference frame:'
taskcat['oldplotants'] = 'visualization, calibration'
taskvis['oldplotants'] = ''
tasksum['oldsplit'] = 'Create a visibility subset from an existing visibility set'
taskcat['oldsplit'] = 'manipulation'
taskvis['oldsplit'] = ''
tasksum['plotants'] = 'Plot the antenna distribution in the local reference frame:'
taskcat['plotants'] = 'visualization, calibration'
taskvis['plotants'] = ''
tasksum['plotbandpass'] = 'Makes detailed plots of Tsys and bandpass solutions.'
taskcat['plotbandpass'] = 'visualization, calibration'
taskvis['plotbandpass'] = ''
tasksum['plotcal'] = 'An all-purpose plotter for calibration results '
taskcat['plotcal'] = 'visualization, calibration'
taskvis['plotcal'] = ''
tasksum['plotms'] = 'A plotter/interactive flagger for visibility data.'
taskcat['plotms'] = 'visualization, information,editing, manipulation, utility'
taskvis['plotms'] = ''
tasksum['plotuv'] = 'Plot the baseline distribution'
taskcat['plotuv'] = 'visualization,information'
taskvis['plotuv'] = ''
tasksum['plotweather'] = 'Plot elements of the weather table; estimate opacity.'
taskcat['plotweather'] = 'visualization'
taskvis['plotweather'] = 'experimental'
tasksum['plotprofilemap'] = 'Makes profile map.'
taskcat['plotprofilemap'] = 'visualization'
taskvis['plotprofilemap'] = ''
tasksum['partition'] = 'Task to produce Multi-MSs using parallelism'
taskcat['partition'] = 'manipulation'
taskvis['partition'] = ''
tasksum['polcal'] = 'Determine instrumental polarization calibrations'
taskcat['polcal'] = 'calibration'
taskvis['polcal'] = ''
tasksum['predictcomp'] = 'Make a component list for a known calibrator'
taskcat['predictcomp'] = 'modeling, calibration'
taskvis['predictcomp'] = ''
tasksum['impv'] = 'Construct a position-velocity image by choosing two points in the direction plane.'
taskcat['impv'] = 'analysis'
taskvis['impv'] = ''
tasksum['rerefant'] = 'Re-apply refant to a caltable'
taskcat['rerefant'] = 'calibration'
taskvis['rerefant'] = ''
tasksum['rmfit'] = 'Calculate rotation measure.'
taskcat['rmfit'] = 'analysis'
taskvis['rmfit'] = ''
tasksum['rmtables'] = 'Remove tables cleanly, use this instead of rm -rf'
taskcat['rmtables'] = 'utility'
taskvis['rmtables'] = ''
tasksum['sdbaseline'] = 'Fit/subtract a spectral baseline '
taskcat['sdbaseline'] = 'single dish'
taskvis['sdbaseline'] = ''
tasksum['sdcal'] = ' MS SD calibration task'
taskcat['sdcal'] = 'single dish'
taskvis['sdcal'] = ''
tasksum['sdfit'] = 'Fit a spectral line'
taskcat['sdfit'] = 'single dish'
taskvis['sdfit'] = ''
tasksum['sdfixscan'] = 'Task for single-dish image processing'
taskcat['sdfixscan'] = 'single dish'
taskvis['sdfixscan'] = ''
tasksum['sdgaincal'] = ' MS SD gain calibration task'
taskcat['sdgaincal'] = 'single dish'
taskvis['sdgaincal'] = 'experimental'
tasksum['sdimaging'] = 'SD task: imaging for total power and spectral data'
taskcat['sdimaging'] = 'single dish'
taskvis['sdimaging'] = ''
tasksum['tsdimaging'] = 'SD task: imaging for total power and spectral data'
taskcat['tsdimaging'] = 'single dish'
taskvis['tsdimaging'] = 'experimental'
tasksum['sdsidebandsplit'] = '[EXPERIMENTAL] invoke sideband separation using FFT'
taskcat['sdsidebandsplit'] = 'single dish'
taskvis['sdsidebandsplit'] = 'experimental'
tasksum['sdsmooth'] = 'Smooth spectral data '
taskcat['sdsmooth'] = 'single dish'
taskvis['sdsmooth'] = ''
tasksum['setjy'] = 'Fills the model column with the visibilities of a calibrator'
taskcat['setjy'] = 'modeling, calibration'
taskvis['setjy'] = ''
tasksum['ssoflux'] = 'Fills the model column with the visibilities of a calibrator'
taskcat['ssoflux'] = 'modeling, calibration'
taskvis['ssoflux'] = 'hidden'
tasksum['simalma'] = 'Simulation task for ALMA '
taskcat['simalma'] = 'simulation'
taskvis['simalma'] = 'experimental'
tasksum['simobserve'] = 'visibility simulation task'
taskcat['simobserve'] = 'simulation'
taskvis['simobserve'] = ''
tasksum['simanalyze'] = 'image and analyze measurement sets created with simobserve'
taskcat['simanalyze'] = 'simulation'
taskvis['simanalyze'] = ''
tasksum['slsearch'] = 'Search a spectral line table.'
taskcat['slsearch'] = 'analysis'
taskvis['slsearch'] = ''
tasksum['smoothcal'] = 'Smooth calibration solution(s) derived from one or more sources:'
taskcat['smoothcal'] = 'calibration'
taskvis['smoothcal'] = ''
tasksum['specfit'] = 'Fit 1-dimensional gaussians and/or polynomial models to an image or image region'
taskcat['specfit'] = 'analysis'
taskvis['specfit'] = 'experimental'
tasksum['specflux'] = 'Report spectral profile and calculate spectral flux over a user specified region'
taskcat['specflux'] = 'analysis'
taskvis['specflux'] = ''
tasksum['specsmooth'] = 'Smooth an image region in one dimension'
taskcat['specsmooth'] = 'analysis'
taskvis['specsmooth'] = ''
tasksum['splattotable'] = 'Convert a downloaded Splatalogue spectral line list to a casa table.'
taskcat['splattotable'] = 'analysis'
taskvis['splattotable'] = ''
tasksum['split'] = 'Create a visibility subset from an existing visibility set'
taskcat['split'] = 'manipulation'
taskvis['split'] = ''
tasksum['spxfit'] = 'Fit a 1-dimensional model(s) to an image(s) or region for determination of spectral index.'
taskcat['spxfit'] = 'analysis'
taskvis['spxfit'] = 'experimental'
tasksum['statwt'] = ' Reweight visibilities according to their scatter (Experimental)'
taskcat['statwt'] = 'manipulation'
taskvis['statwt'] = 'experimental'
tasksum['statwt2'] = 'Compute and set weights based on variance of data.'
taskcat['statwt2'] = ''
taskvis['statwt2'] = ''
tasksum['tclean'] = 'Radio Interferometric Image Reconstruction'
taskcat['tclean'] = 'imaging'
taskvis['tclean'] = 'experimental'
tasksum['tclean2'] = 'Radio Interferometric Image Reconstruction'
taskcat['tclean2'] = 'imaging'
taskvis['tclean2'] = 'experimental'
tasksum['testconcat'] = 'Concatenate the subtables of several visibility data sets, not the MAIN bulk data.'
taskcat['testconcat'] = 'utility, manipulation'
taskvis['testconcat'] = ''
tasksum['uvcontsub'] = 'Continuum fitting and subtraction in the uv plane'
taskcat['uvcontsub'] = 'modeling, manipulation'
taskvis['uvcontsub'] = ''
tasksum['uvcontsub3'] = 'An experimental clone of uvcontsub'
taskcat['uvcontsub3'] = 'modeling, manipulation'
taskvis['uvcontsub3'] = 'experimental'
tasksum['uvmodelfit'] = 'Fit a single component source model to the uv data'
taskcat['uvmodelfit'] = 'modeling, calibration'
taskvis['uvmodelfit'] = ''
tasksum['uvsub'] = 'Subtract/add model from/to the corrected visibility data.'
taskcat['uvsub'] = 'modeling, calibration'
taskvis['uvsub'] = ''
tasksum['viewer'] = 'View an image or visibility data set'
taskcat['viewer'] = 'visualization'
taskvis['viewer'] = ''
tasksum['wvrgcal'] = 'Generate a gain table based on Water Vapour Radiometer data'
taskcat['wvrgcal'] = 'calibration'
taskvis['wvrgcal'] = ''
tasksum['virtualconcat'] = 'Concatenate several visibility data sets into a multi-MS'
taskcat['virtualconcat'] = 'utility, manipulation'
taskvis['virtualconcat'] = ''
tasksum['vishead'] = 'List, summary, get, and put metadata in a measurement set'
taskcat['vishead'] = 'information, manipulation'
taskvis['vishead'] = ''
tasksum['visstatold'] = 'Displays statistical information from a Measurement Set, or from a Multi-MS'
taskcat['visstatold'] = 'information'
taskvis['visstatold'] = ''
tasksum['visstat'] = 'Displays statistical information from a Measurement Set, or from a Multi-MS'
taskcat['visstat'] = 'information'
taskvis['visstat'] = ''
tasksum['visstat2'] = 'Displays statistical information from a Measurement Set, or from a Multi-MS'
taskcat['visstat2'] = 'information'
taskvis['visstat2'] = ''
tasksum['widebandpbcor'] = 'Wideband PB-correction on the output of the MS-MFS algorithm'
taskcat['widebandpbcor'] = 'imaging'
taskvis['widebandpbcor'] = 'experimental'
tasksum['widefield'] = 'Wide-field imaging and deconvolution with selected algorithm'
taskcat['widefield'] = 'imaging'
taskvis['widefield'] = 'deprecated'
allcat = {}
thecats =['import/export', 'information', 'editing', 'manipulation', 'calibration', 'modeling', 'imaging', 'analysis', 'visualization', 'simulation', 'single dish', 'utility']
for category in thecats :
   allcat[category] = []
   experimental = []
   deprecated = []
   for key in taskcat.keys() :
      if taskcat[key].count(category) > 0 :
         if taskvis[key].count('hidden') > 0 :
            continue
         else :
            if taskvis[key].count('experimental') > 0 :
               experimental.append('('+key+')')
            else :
               if taskvis[key].count('deprecated') > 0 :
                  deprecated.append('{'+key+'}')
               else :
                  allcat[category].append(key)
   if category == 'utility' :
      allcat[category].append('taskhelp')
      allcat[category].append('tasklist')
      allcat[category].append('toolhelp')
      allcat[category].append('startup')
      allcat[category].append('help par.parametername')
      allcat[category].append('help taskname')
   allcat[category].sort()
   experimental.sort()
   deprecated.sort()
   for key in experimental :
      allcat[category].append(key)
   for key in deprecated :
      allcat[category].append(key)

