#
# This file was generated using xslt from its XML file
#
# Copyright 2014, Associated Universities Inc., Washington DC
#
import sys
import os
#from casac import *
import casac
import string
import time
import inspect
import gc
import numpy
from casa_stack_manip import stack_frame_find
from odict import odict
from types import * 
from task_ssoflux import ssoflux
class ssoflux_cli_:
    __name__ = "ssoflux"
    rkey = None
    i_am_a_casapy_task = None
    # The existence of the i_am_a_casapy_task attribute allows help()
    # (and other) to treat casapy tasks as a special case.

    def __init__(self) :
       self.__bases__ = (ssoflux_cli_,)
       self.__doc__ = self.__call__.__doc__

       self.parameters={'vis':None, 'field':None, 'spw':None, 'modimage':None, 'fluxdensity':None, 'standard':None, }


    def result(self, key=None):
	    #### and add any that have completed...
	    return None


    def __call__(self, vis=None, field=None, spw=None, modimage=None, fluxdensity=None, standard=None, ):

        """Fills the model column with the visibilities of a calibrator

	Detailed Description: 

          *This is an experimental clone of setjy while flux calibration with
           Solar System objects is being tested.  It will eventually be merged
           back into setjy.*

       The task places the model visibility amp and phase associated
       with a specified clean components image into the model column
       of the data set.  The flux density (I,Q,U,V) for a point source
       calibrator can be entered explicitly.

       Models are available for 3C48, 3C138, and 3C286 between
       1.4 and 43 GHz.  3C147 is available above 13 GHz.  These models
       are scaled to the precise frequency of the data.  Only I models are
       presently available.

       The location of the models is system dependent:  At the AOC, the
       models are in the directory::/usr/lib/casapy/data/nrao/VLA/CalModels/
       3C286_L.im (egs)

       ssoflux need only be run on the calibrator sources with a known flux
       density and/or model.
	
	Arguments :
		vis:	Name of input visibility file
		   Default Value: 

		field:	Field name(s)
		   Default Value: 

		spw:	Spectral window identifier (list)
		   Default Value: 

		modimage:	File location for field model
		   Default Value: 

		fluxdensity:	Specified flux density [I,Q,U,V]; -1 will lookup values
		   Default Value: -1

		standard:	Flux density standard
		   Default Value: Perley-Taylor 99
		   Allowed Values:
				Perley-Butler 2010
				Perley-Taylor 99
				Baars
				Perley 90
				Perley-Taylor 95
				Butler-JPL-Horizons 2010

	Returns: void

	Example :

       *This is an experimental clone of setjy while flux calibration with
        Solar System objects is being tested.  It will eventually be merged
        back into setjy.*

       This task sets the model visibility amp and phase of a
       specified source (generally a calibrator).  The simplest way is
       to enter the flux density (I,Q,U,V) explicitly, but this is
       valid only for a point source.

       For an extended source, the clean model (image.model) can be
       specified and the model visibilities associated with this clean
       model is placed in the visibility model column.

       Models are available for 3C48, 3C138, 3C286 between
       1.4 and 43 GHz.  3C147 is available above 13 GHz.  These models
       are scaled to the precise frequency of the data.  Only I source 
       model can be inserted at a time.

       The location of the models are system dependent:  At the AOC and CV,
       the models are in the directory::/usr/lib/casapy/data/nrao/VLA/CalModels
       or /usr/lib64/casapy/data/nrao/VLA/CalModel.

       ssoflux need only be run on the calibrator sources with a known flux
       density and/or model.

       Keyword arguments:
       vis -- Name of input visibility file
               default: none.  example: vis='ngc5921.ms'
       field -- Select field using field id(s) or field name(s).
              default: ''=all fields, but run ssoflux one field at a time.
                 [run listobs to obtain the list id's or names of calibrators]
              If field is a non-negative integer, it is assumed to be a field
              index.  Otherwise, it is taken to be a field name.
              field='0~2'; field ids 0,1,2
              field='0,4,5~7'; field ids 0,4,5,6,7
              field='3C286,3C295'; field named 3C286 and 3C295
              field = '3,4C*'; field id 3, all names starting with 4C
       spw -- Select spectral window/channels
              default: ''=all spectral windows and channels
              spw='0~2,4'; spectral windows 0,1,2,4 (all channels)
              spw='<2';  spectral windows less than 2 (i.e. 0,1)
              spw='0:5~61'; spw 0, channels 5 to 61
              spw='0,10,3:3~45'; spw 0,10 all channels, spw 3, channels 3 to 45.
              spw='0~2:2~6'; spw 0,1,2 with channels 2 through 6 in each.
              spw='0:0~10;15~60'; spectral window 0 with channels 0-10,15-60
              spw='0:0~10,1:20~30,2:1;2;4'; spw 0, channels 0-10,
                       spw 1, channels 20-30, and spw 2, channels, 1,2 and 4

       Use one of the two methods below:  modimage or fluxdensity

       modimage -- Model image (I only) for setting the model visibilities.
              default: '' means use fluxdensity instead of modimage. 
              Each field must be done separately.  The image clean model
              will be scaled from the frequency in the model to that actually used,
              unless fluxdensity = 0 (or fluxdensity[0] = 0).
              Both the amplitude and phase are calculated.
              At the AOC or CV, the models are located in
              /usr/lib/casapy/data/nrao/VLA/CalModels/3C286_L.im (egs)
                   lib64

       fluxdensity -- Specified flux density [I,Q,U,V] in Jy
               default: -1, uses [1,0,0,0] flux density for all sources,
                  except for 3C286, 3C48 and 3C147, which use standard flux
                  densities.  It is recommended to use modimage for
                  these sources if they are resolved by the observation.
               Only one flux density can be specified at a time.  The phases are
                  set to zero.
               example   fluxdensity=-1  will insert 1.0 for all calibrators
                         except 3C286, 3C147 and 3C48.
               example   field = '1'; fluxdensity=[3.2,0,0,0] wil put in 
                         a flux density of I=3.2 for field='1'

               At present (June 2000), this is the only method to insert a
               polarized flux density model.
               example:  fluxdensity=[2.63,0.21,-0.33,0.02]
                         will put in I,Q,U,V flux densities of 2.63,0.21,-0.33,
                         and 0.02, respectively, in the model column.

       standard -- Flux density standard, used if fluxdensity<0
               default: 'Perley-Taylor 99'; example: standard='Baars'
               Options: 'Baars','Perley 90','Perley-Taylor 95',
                  'Perley-Taylor 99', 'Perley-Butler 2010',
                  and 'Butler-JPL-Horizons 2010'.
               All but the last one are for extragalactic calibrators,
               and the final one is for Solar System objects.
 
        """
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
	#casac = self.__globals__['casac']
	casalog = self.__globals__['casalog']
	casa = self.__globals__['casa']
	#casalog = casac.casac.logsink()
        self.__globals__['__last_task'] = 'ssoflux'
        self.__globals__['taskname'] = 'ssoflux'
        ###
        self.__globals__['update_params'](func=self.__globals__['taskname'],printtext=False,ipython_globals=self.__globals__)
        ###
        ###
        #Handle globals or user over-ride of arguments
        #
        if type(self.__call__.func_defaults) is NoneType:
            function_signature_defaults={}
	else:
	    function_signature_defaults=dict(zip(self.__call__.func_code.co_varnames[1:],self.__call__.func_defaults))
	useLocalDefaults = False

        for item in function_signature_defaults.iteritems():
                key,val = item
                keyVal = eval(key)
                if (keyVal == None):
                        #user hasn't set it - use global/default
                        pass
                else:
                        #user has set it - use over-ride
			if (key != 'self') :
			   useLocalDefaults = True

	myparams = {}
	if useLocalDefaults :
	   for item in function_signature_defaults.iteritems():
	       key,val = item
	       keyVal = eval(key)
	       exec('myparams[key] = keyVal')
	       self.parameters[key] = keyVal
	       if (keyVal == None):
	           exec('myparams[key] = '+ key + ' = self.itsdefault(key)')
		   keyVal = eval(key)
		   if(type(keyVal) == dict) :
                      if len(keyVal) > 0 :
		         exec('myparams[key] = ' + key + ' = keyVal[len(keyVal)-1][\'value\']')
		      else :
		         exec('myparams[key] = ' + key + ' = {}')
	 
        else :
            print ''

            myparams['vis'] = vis = self.parameters['vis']
            myparams['field'] = field = self.parameters['field']
            myparams['spw'] = spw = self.parameters['spw']
            myparams['modimage'] = modimage = self.parameters['modimage']
            myparams['fluxdensity'] = fluxdensity = self.parameters['fluxdensity']
            myparams['standard'] = standard = self.parameters['standard']


	result = None

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['vis'] = vis
        mytmp['field'] = field
        mytmp['spw'] = spw
        mytmp['modimage'] = modimage
        mytmp['fluxdensity'] = fluxdensity
        mytmp['standard'] = standard
	pathname='file://' + casa['dirs']['xml'] + '/'
	trec = casac.casac.utils().torecord(pathname+'ssoflux.xml')

        casalog.origin('ssoflux')
	try :
          #if not trec.has_key('ssoflux') or not casac.casac.utils().verify(mytmp, trec['ssoflux']) :
	    #return False

          casac.casac.utils().verify(mytmp, trec['ssoflux'], True)
          scriptstr=['']
          saveinputs = self.__globals__['saveinputs']
          if type(self.__call__.func_defaults) is NoneType:
              saveinputs=''
          else:
              saveinputs('ssoflux', 'ssoflux.last', myparams, self.__globals__,scriptstr=scriptstr)
          tname = 'ssoflux'
          spaces = ' '*(18-len(tname))
          casalog.post('\n##########################################'+
                       '\n##### Begin Task: ' + tname + spaces + ' #####')
          if type(self.__call__.func_defaults) is NoneType:
              casalog.post(scriptstr[0]+'\n', 'INFO')
          else :
              casalog.post(scriptstr[1][1:]+'\n', 'INFO')
          result = ssoflux(vis, field, spw, modimage, fluxdensity, standard)
          casalog.post('##### End Task: ' + tname + '  ' + spaces + ' #####'+
                       '\n##########################################')

	except Exception, instance:
          if(self.__globals__.has_key('__rethrow_casa_exceptions') and self.__globals__['__rethrow_casa_exceptions']) :
             raise
          else :
             #print '**** Error **** ',instance
	     tname = 'ssoflux'
             casalog.post('An error occurred running task '+tname+'.', 'ERROR')
             pass

        gc.collect()
        return result
#
#
#
    def paramgui(self, useGlobals=True, ipython_globals=None):
        """
        Opens a parameter GUI for this task.  If useGlobals is true, then any relevant global parameter settings are used.
        """
        import paramgui
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )

        if useGlobals:
	    if ipython_globals == None:
                myf=self.__globals__
            else:
                myf=ipython_globals

            paramgui.setGlobals(myf)
        else:
            paramgui.setGlobals({})

        paramgui.runTask('ssoflux', myf['_ip'])
        paramgui.setGlobals({})

#
#
#
    def defaults(self, param=None, ipython_globals=None, paramvalue=None, subparam=None):
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
        if ipython_globals == None:
            myf=self.__globals__
        else:
            myf=ipython_globals

        a = odict()
        a['vis']  = ''
        a['field']  = ''
        a['spw']  = ''
        a['modimage']  = ''
        a['fluxdensity']  = -1
        a['standard']  = 'Perley-Taylor 99'


### This function sets the default values but also will return the list of
### parameters or the default value of a given parameter
        if(param == None):
                myf['__set_default_parameters'](a)
        elif(param == 'paramkeys'):
                return a.keys()
        else:
            if(paramvalue==None and subparam==None):
               if(a.has_key(param)):
                  return a[param]
               else:
                  return self.itsdefault(param)
            else:
               retval=a[param]
               if(type(a[param])==dict):
                  for k in range(len(a[param])):
                     valornotval='value'
                     if(a[param][k].has_key('notvalue')):
                        valornotval='notvalue'
                     if((a[param][k][valornotval])==paramvalue):
                        retval=a[param][k].copy()
                        retval.pop(valornotval)
                        if(subparam != None):
                           if(retval.has_key(subparam)):
                              retval=retval[subparam]
                           else:
                              retval=self.itsdefault(subparam)
		     else:
                        retval=self.itsdefault(subparam)
               return retval


#
#
    def check_params(self, param=None, value=None, ipython_globals=None):
      if ipython_globals == None:
          myf=self.__globals__
      else:
          myf=ipython_globals
#      print 'param:', param, 'value:', value
      try :
         if str(type(value)) != "<type 'instance'>" :
            value0 = value
            value = myf['cu'].expandparam(param, value)
            matchtype = False
            if(type(value) == numpy.ndarray):
               if(type(value) == type(value0)):
                  myf[param] = value.tolist()
               else:
                  #print 'value:', value, 'value0:', value0
                  #print 'type(value):', type(value), 'type(value0):', type(value0)
                  myf[param] = value0
                  if type(value0) != list :
                     matchtype = True
            else :
               myf[param] = value
            value = myf['cu'].verifyparam({param:value})
            if matchtype:
               value = False
      except Exception, instance:
         #ignore the exception and just return it unchecked
         myf[param] = value
      return value
#
#
    def description(self, key='ssoflux', subkey=None):
        desc={'ssoflux': 'Fills the model column with the visibilities of a calibrator',
               'vis': 'Name of input visibility file',
               'field': 'Field name(s)',
               'spw': 'Spectral window identifier (list)',
               'modimage': 'File location for field model',
               'fluxdensity': 'Specified flux density [I,Q,U,V]; -1 will lookup values',
               'standard': 'Flux density standard',

              }

        if(desc.has_key(key)) :
           return desc[key]

    def itsdefault(self, paramname) :
        a = {}
        a['vis']  = ''
        a['field']  = ''
        a['spw']  = ''
        a['modimage']  = ''
        a['fluxdensity']  = -1
        a['standard']  = 'Perley-Taylor 99'

        #a = sys._getframe(len(inspect.stack())-1).f_globals

        if a.has_key(paramname) :
	      return a[paramname]
ssoflux_cli = ssoflux_cli_()
