#
# This file was generated using xslt from its XML file
#
# Copyright 2009, Associated Universities Inc., Washington DC
#
import sys
import os
from  casac import *
import string
from taskinit import casalog
from taskinit import xmlpath
#from taskmanager import tm
import task_ssoflux
def ssoflux(vis='', field='', spw='', modimage='', fluxdensity=-1, standard='Perley-Taylor 99'):

        """Fills the model column with the visibilities of a calibrator
       *This is an experimental clone of setjy while flux calibration with
        Solar System objects is being tested.  It will eventually be merged
        back into setjy.*

       This task sets the model visibility amp and phase of a
       specified source (generally a calibrator).  The simplest way is
       to enter the flux density (I,Q,U,V) explicitly, but this is
       valid only for a point source.

       For an extended source, the clean model (image.model) can be
       specified and the model visibilities associated with this clean
       model is placed in the visibility model column.

       Models are available for 3C48, 3C138, 3C286 between
       1.4 and 43 GHz.  3C147 is available above 13 GHz.  These models
       are scaled to the precise frequency of the data.  Only I source 
       model can be inserted at a time.

       The location of the models are system dependent:  At the AOC and CV,
       the models are in the directory::/usr/lib/casapy/data/nrao/VLA/CalModels
       or /usr/lib64/casapy/data/nrao/VLA/CalModel.

       ssoflux need only be run on the calibrator sources with a known flux
       density and/or model.

       Keyword arguments:
       vis -- Name of input visibility file
               default: none.  example: vis='ngc5921.ms'
       field -- Select field using field id(s) or field name(s).
              default: ''=all fields, but run ssoflux one field at a time.
                 [run listobs to obtain the list id's or names of calibrators]
              If field is a non-negative integer, it is assumed to be a field
              index.  Otherwise, it is taken to be a field name.
              field='0~2'; field ids 0,1,2
              field='0,4,5~7'; field ids 0,4,5,6,7
              field='3C286,3C295'; field named 3C286 and 3C295
              field = '3,4C*'; field id 3, all names starting with 4C
       spw -- Select spectral window/channels
              default: ''=all spectral windows and channels
              spw='0~2,4'; spectral windows 0,1,2,4 (all channels)
              spw='<2';  spectral windows less than 2 (i.e. 0,1)
              spw='0:5~61'; spw 0, channels 5 to 61
              spw='0,10,3:3~45'; spw 0,10 all channels, spw 3, channels 3 to 45.
              spw='0~2:2~6'; spw 0,1,2 with channels 2 through 6 in each.
              spw='0:0~10;15~60'; spectral window 0 with channels 0-10,15-60
              spw='0:0~10,1:20~30,2:1;2;4'; spw 0, channels 0-10,
                       spw 1, channels 20-30, and spw 2, channels, 1,2 and 4

       Use one of the two methods below:  modimage or fluxdensity

       modimage -- Model image (I only) for setting the model visibilities.
              default: '' means use fluxdensity instead of modimage. 
              Each field must be done separately.  The image clean model
              will be scaled from the frequency in the model to that actually used,
              unless fluxdensity = 0 (or fluxdensity[0] = 0).
              Both the amplitude and phase are calculated.
              At the AOC or CV, the models are located in
              /usr/lib/casapy/data/nrao/VLA/CalModels/3C286_L.im (egs)
                   lib64

       fluxdensity -- Specified flux density [I,Q,U,V] in Jy
               default: -1, uses [1,0,0,0] flux density for all sources,
                  except for 3C286, 3C48 and 3C147, which use standard flux
                  densities.  It is recommended to use modimage for
                  these sources if they are resolved by the observation.
               Only one flux density can be specified at a time.  The phases are
                  set to zero.
               example   fluxdensity=-1  will insert 1.0 for all calibrators
                         except 3C286, 3C147 and 3C48.
               example   field = '1'; fluxdensity=[3.2,0,0,0] wil put in 
                         a flux density of I=3.2 for field='1'

               At present (June 2000), this is the only method to insert a
               polarized flux density model.
               example:  fluxdensity=[2.63,0.21,-0.33,0.02]
                         will put in I,Q,U,V flux densities of 2.63,0.21,-0.33,
                         and 0.02, respectively, in the model column.

       standard -- Flux density standard, used if fluxdensity<0
               default: 'Perley-Taylor 99'; example: standard='Baars'
               Options: 'Baars','Perley 90','Perley-Taylor 95',
                  'Perley-Taylor 99', 'Perley-Butler 2010',
                  and 'Butler-JPL-Horizons 2010'.
               All but the last one are for extragalactic calibrators,
               and the final one is for Solar System objects.
 
        """

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['vis'] = vis
        mytmp['field'] = field
        mytmp['spw'] = spw
        mytmp['modimage'] = modimage
        mytmp['fluxdensity'] = fluxdensity
        mytmp['standard'] = standard
	pathname='file://' + xmlpath( ) + '/'
	trec = casac.utils().torecord(pathname+'ssoflux.xml')

        casalog.origin('ssoflux')
        if trec.has_key('ssoflux') and casac.utils().verify(mytmp, trec['ssoflux']) :
	    result = task_ssoflux.ssoflux(vis, field, spw, modimage, fluxdensity, standard)

	else :
	  result = False
        return result
