#
# This file was generated using xslt from its XML file
#
# Copyright 2009, Associated Universities Inc., Washington DC
#
import sys
import os
from  casac import *
import string
from taskinit import casalog
from taskinit import xmlpath
#from taskmanager import tm
import task_split
def split(vis='', outputvis='', keepmms=True, field='', spw='', scan='', antenna='', correlation='', timerange='', intent='', array='', uvrange='', observation='', feed='', datacolumn='corrected', keepflags=True, width=1, timebin='0s', combine=''):

        """Create a visibility subset from an existing visibility set


  Detailed Keyword arguments:
	
    vis -- Name of input Measurement set or Multi-MS.
        default: none; 
        example: vis='ngc5921.ms'
	
    outputvis -- Name of output Measurement set or Multi-MS (MMS).
        default: none; 
        example: outputvis='ngc5921_src.ms'
    
        IMPORTANT: if a .flagversions file with the name of the output MS exist, this task will
                   exit with an error. The user needs to rename or remove the existing flagbackup
                   or choose a different output name for the MS.

    keepmms -- Create a Multi-MS as the output if the input is a Multi-MS.
        default: True

        By default it will create a Multi-MS when the input is a Multi-MS.
        The output Multi-MS will have the same partition axis of the input MMS.
        See 'help partition' for more information on the MMS format.
        
        NOTE: It is not possible to do time average with combine='scan' 
              if the input MMS was partitioned with separationaxis='scan'
              or 'auto'. In this case, the task will abort with an error.
                

    --- Data Selection ---

    field -- Select field using field id(s) or field name(s).
             [run listobs to obtain the list iof d's or names]
        default: ''=all fields If field string is a non-negative
           integer, it is assumed to be a field index
           otherwise, it is assumed to be a field name
           field='0~2'; field ids 0,1,2
           field='0,4,5~7'; field ids 0,4,5,6,7
           field='3C286,3C295'; fields named 3C286 and 3C295
           field = '3,4C*'; field id 3, all names starting with 4C

    spw -- Select spectral window/channels
        default: ''=all spectral windows and channels
           spw='0~2,4'; spectral windows 0,1,2,4 (all channels)
           spw='<2';  spectral windows less than 2 (i.e. 0,1)
           spw='0:5~61'; spw 0, channels 5 to 61
           spw='0,10,3:3~45'; spw 0,10 all channels, spw 3 - chans 3 to 45.
           spw='0~2:2~6'; spw 0,1,2 with channels 2 through 6 in each.
           spw = '*:3~64'  channels 3 through 64 for all sp id's
                   spw = ' :3~64' will NOT work.

               NOTE: mstransform does not support multiple channel ranges per
                     spectral window (';').

    scan -- Scan number range
        default: '' = all

    antenna -- Select data based on antenna/baseline
        default: '' (all)
            Non-negative integers are assumed to be antenna indices, and
            anything else is taken as an antenna name.

        examples:
            antenna='5&6': baseline between antenna index 5 and index 6.
            antenna='VA05&VA06': baseline between VLA antenna 5 and 6.
            antenna='5&6;7&8': baselines 5-6 and 7-8
            antenna='5': all baselines with antenna 5
            antenna='5,6,10': all baselines including antennas 5, 6, or 10
            antenna='5,6,10&': all baselines with *only* antennas 5, 6, or
                                   10.  (cross-correlations only.  Use &&
                                   to include autocorrelations, and &&&
                                   to get only autocorrelations.)
            antenna='!ea03,ea12,ea17': all baselines except those that
                                       include EVLA antennas ea03, ea12, or
                                       ea17.

    correlation -- Correlation types or expression.
        default: '' (all correlations)
        example: correlation='XX,YY' 

    timerange -- Select data based on time range:
        default: '' (all); examples,
           timerange = 'YYYY/MM/DD/hh:mm:ss~YYYY/MM/DD/hh:mm:ss'
           Note: if YYYY/MM/DD is missing date, timerange defaults to the
           first day in the dataset
           timerange='09:14:0~09:54:0' picks 40 min on first day
           timerange='25:00:00~27:30:00' picks 1 hr to 3 hr 30min
           on next day
           timerange='09:44:00' data within one integration of time
           timerange='>10:24:00' data after this time

    array -- (Sub)array number range
        default: '' = all

    uvrange -- Select data within uvrange (default units meters)
        default: ''=all; example:
            uvrange='0~1000klambda'; uvrange from 0-1000 kilo-lambda
            uvrange='>4klambda';uvranges greater than 4 kilo-lambda
            uvrange='0~1000km'; uvrange in kilometers

    observation -- Select by observation ID(s)
        default: '' = all

    feed -- Selection based on the feed - NOT IMPLEMENTED YET
        default: '' = all


    datacolumn -- Which data column to use for processing (case-insensitive).
        default: 'corrected'; example: datacolumn='data'
        options: 'data', 'model', 'corrected', 'all','float_data', 'lag_data', 
                 'float_data,data', 'lag_data,data'.

            NOTE: 'all' = whichever of the above that are present. If the requested
                          column does not exist, the task will exit with an error.

    keepflags -- Keep completely flagged rows in the output or drop them. This has no
                 effect on partially flagged rows. All of the channels and correlations
                 of a row must be flagged for it to be droppable, and a row must be
                 well defined to be keepable. 
    
            IMPORTANT: Regardless of this parameter, flagged data is never included in
                       channel averaging. On the other hand, partially flagged rows will
                       always be included in time averaging. The average value of the
                       flagged data for averages containing ONLY flagged data in the relevant
                       output channel will be written to the output with the corresponding
                       flag set to True, while only unflagged data is used on averages where
                       there is some unflagged data with the flag set to False.
    
        default: True (keep completely flagged rows in the output)
    
    
--- Channel averaging parameter ---
	
    width -- Number of input channels to average to create an output
             channel. If a list is given, each bin will apply to one spw in
             the selection.
        default: 1 => no channel averaging.
        options: (int) or [int]
	
        example: chanbin=[2,3] => average 2 channels of 1st selected
		         spectral window and 3 in the second one.

	
--- Time averaging parameters ---
					
    timebin -- Bin width for time averaging. When timebin is greater than 0s,
               the task will average data in time. Flagged data will be included 
               in the average calculation, unless the parameter keepflags is set to False. 
               In this case only partially flagged rows will be used in the average.
        default: '0s'

    combine -- Let the timebin span across scan, state or both.
               State is equivalent to sub-scans. One scan may have several
               state ids. For ALMA MSs, the sub-scans are limited to about
               30s duration each. In these cases, the task will automatically
               add state to the combine parameter. To see the number of states
               in an MS, use the msmd tool. See help msmd.

        NOTE: It is not possible to do time average with combine='scan' 
              if the input MMS was partitioned with separationaxis='scan'
              or 'auto'. In this case, the task will abort with an error.
        
        default: '' (separate time bins by both of the above)
        options: 'scan', 'state', 'state,scan'

        examples: 
            combine = 'scan'; can be useful when the scan number
                       goes up with each integration as in many WSRT MSs.
            combine = ['scan', 'state']: disregard scan and state
                       numbers when time averaging.
            combine = 'state,scan'; same as above.
		




        """

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['vis'] = vis
        mytmp['outputvis'] = outputvis
        mytmp['keepmms'] = keepmms
        mytmp['field'] = field
        mytmp['spw'] = spw
        mytmp['scan'] = scan
        mytmp['antenna'] = antenna
        mytmp['correlation'] = correlation
        mytmp['timerange'] = timerange
        mytmp['intent'] = intent
        mytmp['array'] = array
        mytmp['uvrange'] = uvrange
        mytmp['observation'] = observation
        mytmp['feed'] = feed
        mytmp['datacolumn'] = datacolumn
        mytmp['keepflags'] = keepflags
        mytmp['width'] = width
        mytmp['timebin'] = timebin
        mytmp['combine'] = combine
	pathname='file://' + xmlpath( ) + '/'
	trec = casac.utils().torecord(pathname+'split.xml')

        casalog.origin('split')
        if trec.has_key('split') and casac.utils().verify(mytmp, trec['split']) :
	    result = task_split.split(vis, outputvis, keepmms, field, spw, scan, antenna, correlation, timerange, intent, array, uvrange, observation, feed, datacolumn, keepflags, width, timebin, combine)

	else :
	  result = False
        return result
