#
# This file was generated using xslt from its XML file
#
# Copyright 2009, Associated Universities Inc., Washington DC
#
import sys
import os
from  casac import *
import string
from taskinit import casalog
from taskinit import xmlpath
#from taskmanager import tm
import task_splattotable
def splattotable(filenames=[''], table=''):

        """Convert a downloaded Splatalogue spectral line list to a casa table.
PARAMETER SUMMARY
filenames   Files containing Splatalogue lists.
table       Output table name. Must be specfied

This task reads a spectral line list(s) downloaded from Splatalogue (www.splatalogue.net) and loads it into a CASA table which
can be queried via eg the slsearch task.
    
REQUIRMENTS OF THE DOWNLOADED FILES
    
The downloaded files must be in a specific format for this task to succeed. The columns are the
important things; one can filter the results as one desires using Splatalogue, but the particular columns must be present as described
below. The columns which must be present in the downloaded file in this exact order are: "Species", "NRAO Recommended", "Chemical Name",
"Freq in GHz", "Resolved QNs", "CDMS/JPL Intensity", "Sijmu2 (D2)",
"Log10 (Aij)", "EL (K)", "EU (K)", "Linelist". In order to get these columns in this order, one should
select exactly the following items on the Splatalogue search interface. Under "Specify Ranges" one should select "GHz" for the frequency unit.
Under "Line Strength Display" select exactly "CDMS/JPL Intensity",
"Sij mu2", and "Aij". Under "Energy Levels", one should select exactly "Elower (K)" and "Eupper (K)". Under "Miscellaneous", one should
select exactly "Display Ordered Frequency ONLY" and "Display NRAO Recommended Frequencies". One should then initiate the search and on
the resulting page, one should select the Tab Field Separator and then export the list. The resulting list should be in the proper
format for importing into CASA.
    
splattotable("mysplatlist.txt", "mynewsl.tbl", true)



        """
        if type(filenames)==str: filenames=[filenames]

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['filenames'] = filenames
        mytmp['table'] = table
	pathname='file://' + xmlpath( ) + '/'
	trec = casac.utils().torecord(pathname+'splattotable.xml')

        casalog.origin('splattotable')
        if trec.has_key('splattotable') and casac.utils().verify(mytmp, trec['splattotable']) :
	    result = task_splattotable.splattotable(filenames, table)

	else :
	  result = False
        return result
