#
# This file was generated using xslt from its XML file
#
# Copyright 2014, Associated Universities Inc., Washington DC
#
import sys
import os
#from casac import *
import casac
import string
import time
import inspect
import gc
import numpy
from casa_stack_manip import stack_frame_find
from odict import odict
from types import * 
from task_simanalyze import simanalyze
class simanalyze_cli_:
    __name__ = "simanalyze"
    rkey = None
    i_am_a_casapy_task = None
    # The existence of the i_am_a_casapy_task attribute allows help()
    # (and other) to treat casapy tasks as a special case.

    def __init__(self) :
       self.__bases__ = (simanalyze_cli_,)
       self.__doc__ = self.__call__.__doc__

       self.parameters={'project':None, 'image':None, 'imagename':None, 'skymodel':None, 'vis':None, 'modelimage':None, 'imsize':None, 'imdirection':None, 'cell':None, 'interactive':None, 'niter':None, 'threshold':None, 'weighting':None, 'mask':None, 'outertaper':None, 'pbcor':None, 'stokes':None, 'featherimage':None, 'analyze':None, 'showuv':None, 'showpsf':None, 'showmodel':None, 'showconvolved':None, 'showclean':None, 'showresidual':None, 'showdifference':None, 'showfidelity':None, 'graphics':None, 'verbose':None, 'overwrite':None, 'dryrun':None, 'logfile':None, }


    def result(self, key=None):
	    #### and add any that have completed...
	    return None


    def __call__(self, project=None, image=None, imagename=None, skymodel=None, vis=None, modelimage=None, imsize=None, imdirection=None, cell=None, interactive=None, niter=None, threshold=None, weighting=None, mask=None, outertaper=None, pbcor=None, stokes=None, featherimage=None, analyze=None, showuv=None, showpsf=None, showmodel=None, showconvolved=None, showclean=None, showresidual=None, showdifference=None, showfidelity=None, graphics=None, verbose=None, overwrite=None, dryrun=None, logfile=None, ):

        """image and analyze measurement sets created with simobserve

	Detailed Description: 

    This task is for imaging and analyzing measurement sets (MSs) simulated 
      with simobserve or simalma.   
  
	Arguments :
		project:	
	root prefix for input and output file names.  
	This must be the directory of results generated by running 
        simobserve or simalma. In particular $project/$project.skymodel 
        will be required in order to compare output and input images.	
      
		   Default Value: sim

		image:	(re)image $project.*.ms to $project.image
		   Default Value: True

		imagename:	simulation output image to analyze (default = first $project/*.image found)
		   Default Value: default

		skymodel:	skymodel image to analyze (the .skymodel image created by simobserve or simalma and used by one of those tasks to create an MS; if unspecified, will try to find one similar to your specified output image name)
		   Default Value: 

		vis:	Measurement Set(s) to image
		   Default Value: default

		modelimage:	lower resolution prior image to use in clean e.g. existing total power image
		   Default Value: 

		imsize:	output image size in pixels (x,y) or 0 to match model
		   Default Value: 00

		imdirection:	set output image direction, (otherwise center on the model)
		   Default Value: 

		cell:	cell size with units e.g. "10arcsec" or "" to equal model
		   Default Value: 

		interactive:	interactive clean?  (make sure to set niter>0 also)
		   Default Value: False

		niter:	maximum number of iterations (0 for dirty image)
		   Default Value: 0

		threshold:	flux level (+units) to stop cleaning
		   Default Value: 0.1mJy

		weighting:	weighting to apply to visibilities.  briggs will use robust=0.5
		   Default Value: natural
		   Allowed Values:
				natural
				uniform
				briggs

		mask:	Cleanbox(es), mask image(s), region(s), or a level
		   Default Value: 

		outertaper:	uv-taper on outer baselines in uv-plane
		   Default Value: 
	
      

		pbcor:	correct the output of synthesis images for primary beam response?
		   Default Value: True

		stokes:	Stokes params to image
		   Default Value: I
		   Allowed Values:
				I
				IV
				QU
				IQUV
				RR
				LL
				RRLL
				XX
				YY
				XXYY

		featherimage:	image (e.g. total power) to feather with new image
		   Default Value: 

		analyze:	(only first 6 selected outputs will be displayed)
		   Default Value: False

		showuv:	display uv coverage
		   Default Value: True

		showpsf:	display synthesized (dirty) beam (ignored in single dish simulation)
		   Default Value: True

		showmodel:	display sky model at original resolution
		   Default Value: True

		showconvolved:	display sky model convolved with output clean beam
		   Default Value: False

		showclean:	display the synthesized image
		   Default Value: True

		showresidual:	display the clean residual image (ignored in single dish simulation)
		   Default Value: False

		showdifference:	display difference between output cleaned image and input model sky image convolved with output clean beam
		   Default Value: True

		showfidelity:	display fidelity (see help)
		   Default Value: True

		graphics:	display graphics at each stage to [screen|file|both|none]
		   Default Value: both
		   Allowed Values:
				screen
				file
				both
				none
				

		verbose:	
		   Default Value: False

		overwrite:	overwrite files starting with $project
		   Default Value: True

		logfile:	
		   Default Value: 

	Returns: void

	Example :

      * "project" needs to be the directory of results generated by running 
        simobserve or simalma. In particular $project/$project.skymodel 
        will be required in order to compare output and input images.

    -------------------------------
    mode image=True:
      * One should input one or more simulated MSs using the "vis" parameter.  
        These can include a total power MS. 
        Simanalyze will grid any total power MS, 
        clean (invert and deconvolve) any interferometric MSs, 
        and feather the results. 

      * the "vis" parameter:
        - example: single MS: vis="mysim.alma.out03.ms"
        - example: multiple MSs: vis="mysim.alma.out03.ms,mysim.aca.tp.ms"
        - one can use "$project" and let the task automatically replace it with
          the project name, e.g., vis="$project.noisy.ms,$project.noisy.sd.ms".
          However, note that if you created measurement set(s) using simobserve,
          MS names will include the configuration, e.g. 
          "$project.alma_out20.noisy.ms"
        - setting "vis" to "default" will find and attempt to image
          all measurement sets (interferometric and single dish) in the 
          project directory

      * Sometimes it is preferable to grid the single dish MS using the 
        sdimaging task for more control.  In that case one can input 
        the resulting single dish imaging under "featherimage", only 
        put interferometric MSs in "vis", and simanalyze  will clean the 
        interferometric and feather with your "featherimage".

      * Sometimes it is preferable to use a low resolution (single dish or 
        synthesis) image as a prior model during clean deconvolution
        of a higher resolution interferometric MS.  That is accomplished 
        by putting the low-resolution image in "modelimage" and the MS
        to be deconvolved in "vis". NOTE: This is not the original skymodel
        that was used in simobserve or simalma.  It is recommended to 
        leave this blank unless the user is familiar with using a prior 
        in clean deconvolution. (see casaguides) NOTE 2: modelimage will 
        not be used if the MS to be imaged is total power.
       
      * uses Cotton-Schwab clean for single fields and Mosaic gridding
        for multiple fields (with Clark PSF calculation in minor cycles).

      * interactive clean or use of more parameters than the subset 
        visible here are available by simply running the clean task directly, 
        then using simanalyze in the mode image=False (see below).

      * if graphics are turned on, this step will display the clean image 
        and residual image

      * the "mask" parameter:
        Specification of cleanbox(es), mask image(s), primary beam
        coverage level, and/or region(s) to be used for cleaning.
        clean tends to perform better, and is less likely to diverge, if 
        the clean component placement is limited by a mask to where real 
        emission is expected to be.  e.g. pixel ranges mask=[110,110,150,145],
        filename of mask image mask='myimage.mask', or a file with mask 
        regions --  see help for the clean task for more information.

      * NOTE: simanalyze was designed to be used after one or more runs of
        simobserve, and as such it assumes it will be able to find a 
        sky model image called $project/$project.skymodel, .newmodel, or 
        .compskymodel in the $project/ subdirectory.  If the simulated 
        MS has been created by means other than simply calling simobserve, 
        the user may have to copy their sky model image into the $project
        subdirectory and call it "$project.skymodel"

    -------------------------------
    mode image=False:
      * Sometimes the user has created a synthesized image themselves, 
        most likely using the clean task, perhaps along with 
        sdimaging and feather, or a previous call to simanalyze with image=True 
      * The user should input that simulated image as "imagename".  
        It will have suffix .image if created by clean, simanalyze, or simalma
      * simanalyze will attempt to find an appropriate skymodel image - 
        this is the *.skymodel image created by simobserve or simalma, 
        the (optionally rescaled) original sky model, which was used 
        to create the measurement set.
        simanalyze will look in the project directory, but if there are 
        multuple skymodels present it may not find the right one, so the
        "skymodel" parameter allows explicit specification.

    -------------------------------
    mode analyze=True is used to create an image of the difference between 
        the input skymodel and the simulated output image (whether that output
        image is being generated in the same call to simanalyze, with 
        image=True, or has already been generated, and simanalyze is being 
        called with image=False).

    showuv -- display uv coverage
    showpsf -- display synthesized (dirty) beam (ignored in single dish simulation)
    showmodel -- display sky model at original resolution
    showconvolved -- display sky model convolved with output beam 
    showclean -- display the synthesized image
    showresidual -- display the clean residual image (ignored in single dish simulation)
    showdifference -- display difference between output cleaned image and 
         input model sky image convolved with output clean beam
    showfidelity -- display fidelity image
         fidelity = abs(input) / max[ abs(input-output), 0.7*rms(output) ]
    

    Note that the RMS is calculated in the lower quarter of the image.  
         This is likely not the best choice, so you are encouraged to 
         measure RMS yourself in an off-source region using the viewer.

    dryrun=True is an advanced technical mode only useful for interferometric 
         (not single dish) data. 

    -------------------------------
    Output produced: (not all will always exist, depending on input parameters)
    To support different runs with different arrays, the names have the
    configuration name from antennalist appended.
    -------------------------------
    project.[cfg].skymodel.flat.regrid.conv = input sky regridded to match 
         the output image, and convolved with the output clean beam

    project.[cfg].image = synthesized image
    project.[cfg].flux.pbcoverage = primary beam correction for mosaic image
    project.[cfg].residual = residual image after cleaning
    project.[cfg].clean.last = parameter file of what parameters were used in
          the clean task
    project.[cfg].psf = synthesized (dirty) beam calculated from weighted uv 
          distribution
    project.[cfg].image.png = diagnostic figure of clean image and residual
	    
    project.[cfg].fidelity = fidelity image
    project.[cfg].analysis.png = diagnostic figure of difference and fidelity
	    
    project.[cfg].simanalyze.last = saved input parameters for simanalyze task

    -------------------------------
    Please see http://casaguides.nrao.edu, and contact the CASA helpdesk 
    with questions.
  
        """
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
	#casac = self.__globals__['casac']
	casalog = self.__globals__['casalog']
	casa = self.__globals__['casa']
	#casalog = casac.casac.logsink()
        self.__globals__['__last_task'] = 'simanalyze'
        self.__globals__['taskname'] = 'simanalyze'
        ###
        self.__globals__['update_params'](func=self.__globals__['taskname'],printtext=False,ipython_globals=self.__globals__)
        ###
        ###
        #Handle globals or user over-ride of arguments
        #
        if type(self.__call__.func_defaults) is NoneType:
            function_signature_defaults={}
	else:
	    function_signature_defaults=dict(zip(self.__call__.func_code.co_varnames[1:],self.__call__.func_defaults))
	useLocalDefaults = False

        for item in function_signature_defaults.iteritems():
                key,val = item
                keyVal = eval(key)
                if (keyVal == None):
                        #user hasn't set it - use global/default
                        pass
                else:
                        #user has set it - use over-ride
			if (key != 'self') :
			   useLocalDefaults = True

	myparams = {}
	if useLocalDefaults :
	   for item in function_signature_defaults.iteritems():
	       key,val = item
	       keyVal = eval(key)
	       exec('myparams[key] = keyVal')
	       self.parameters[key] = keyVal
	       if (keyVal == None):
	           exec('myparams[key] = '+ key + ' = self.itsdefault(key)')
		   keyVal = eval(key)
		   if(type(keyVal) == dict) :
                      if len(keyVal) > 0 :
		         exec('myparams[key] = ' + key + ' = keyVal[len(keyVal)-1][\'value\']')
		      else :
		         exec('myparams[key] = ' + key + ' = {}')
	 
        else :
            print ''

            myparams['project'] = project = self.parameters['project']
            myparams['image'] = image = self.parameters['image']
            myparams['imagename'] = imagename = self.parameters['imagename']
            myparams['skymodel'] = skymodel = self.parameters['skymodel']
            myparams['vis'] = vis = self.parameters['vis']
            myparams['modelimage'] = modelimage = self.parameters['modelimage']
            myparams['imsize'] = imsize = self.parameters['imsize']
            myparams['imdirection'] = imdirection = self.parameters['imdirection']
            myparams['cell'] = cell = self.parameters['cell']
            myparams['interactive'] = interactive = self.parameters['interactive']
            myparams['niter'] = niter = self.parameters['niter']
            myparams['threshold'] = threshold = self.parameters['threshold']
            myparams['weighting'] = weighting = self.parameters['weighting']
            myparams['mask'] = mask = self.parameters['mask']
            myparams['outertaper'] = outertaper = self.parameters['outertaper']
            myparams['pbcor'] = pbcor = self.parameters['pbcor']
            myparams['stokes'] = stokes = self.parameters['stokes']
            myparams['featherimage'] = featherimage = self.parameters['featherimage']
            myparams['analyze'] = analyze = self.parameters['analyze']
            myparams['showuv'] = showuv = self.parameters['showuv']
            myparams['showpsf'] = showpsf = self.parameters['showpsf']
            myparams['showmodel'] = showmodel = self.parameters['showmodel']
            myparams['showconvolved'] = showconvolved = self.parameters['showconvolved']
            myparams['showclean'] = showclean = self.parameters['showclean']
            myparams['showresidual'] = showresidual = self.parameters['showresidual']
            myparams['showdifference'] = showdifference = self.parameters['showdifference']
            myparams['showfidelity'] = showfidelity = self.parameters['showfidelity']
            myparams['graphics'] = graphics = self.parameters['graphics']
            myparams['verbose'] = verbose = self.parameters['verbose']
            myparams['overwrite'] = overwrite = self.parameters['overwrite']
            myparams['dryrun'] = dryrun = self.parameters['dryrun']
            myparams['logfile'] = logfile = self.parameters['logfile']

        if type(imsize)==int: imsize=[imsize]
        if type(outertaper)==str: outertaper=[outertaper]

	result = None

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['project'] = project
        mytmp['image'] = image
        mytmp['imagename'] = imagename
        mytmp['skymodel'] = skymodel
        mytmp['vis'] = vis
        mytmp['modelimage'] = modelimage
        mytmp['imsize'] = imsize
        mytmp['imdirection'] = imdirection
        mytmp['cell'] = cell
        mytmp['interactive'] = interactive
        mytmp['niter'] = niter
        mytmp['threshold'] = threshold
        mytmp['weighting'] = weighting
        mytmp['mask'] = mask
        mytmp['outertaper'] = outertaper
        mytmp['pbcor'] = pbcor
        mytmp['stokes'] = stokes
        mytmp['featherimage'] = featherimage
        mytmp['analyze'] = analyze
        mytmp['showuv'] = showuv
        mytmp['showpsf'] = showpsf
        mytmp['showmodel'] = showmodel
        mytmp['showconvolved'] = showconvolved
        mytmp['showclean'] = showclean
        mytmp['showresidual'] = showresidual
        mytmp['showdifference'] = showdifference
        mytmp['showfidelity'] = showfidelity
        mytmp['graphics'] = graphics
        mytmp['verbose'] = verbose
        mytmp['overwrite'] = overwrite
        mytmp['dryrun'] = dryrun
        mytmp['logfile'] = logfile
	pathname='file://' + casa['dirs']['xml'] + '/'
	trec = casac.casac.utils().torecord(pathname+'simanalyze.xml')

        casalog.origin('simanalyze')
	try :
          #if not trec.has_key('simanalyze') or not casac.casac.utils().verify(mytmp, trec['simanalyze']) :
	    #return False

          casac.casac.utils().verify(mytmp, trec['simanalyze'], True)
          scriptstr=['']
          saveinputs = self.__globals__['saveinputs']
          if type(self.__call__.func_defaults) is NoneType:
              saveinputs=''
          else:
              saveinputs('simanalyze', 'simanalyze.last', myparams, self.__globals__,scriptstr=scriptstr)
          tname = 'simanalyze'
          spaces = ' '*(18-len(tname))
          casalog.post('\n##########################################'+
                       '\n##### Begin Task: ' + tname + spaces + ' #####')
          if type(self.__call__.func_defaults) is NoneType:
              casalog.post(scriptstr[0]+'\n', 'INFO')
          else :
              casalog.post(scriptstr[1][1:]+'\n', 'INFO')
          result = simanalyze(project, image, imagename, skymodel, vis, modelimage, imsize, imdirection, cell, interactive, niter, threshold, weighting, mask, outertaper, pbcor, stokes, featherimage, analyze, showuv, showpsf, showmodel, showconvolved, showclean, showresidual, showdifference, showfidelity, graphics, verbose, overwrite, dryrun, logfile)
          casalog.post('##### End Task: ' + tname + '  ' + spaces + ' #####'+
                       '\n##########################################')

	except Exception, instance:
          if(self.__globals__.has_key('__rethrow_casa_exceptions') and self.__globals__['__rethrow_casa_exceptions']) :
             raise
          else :
             #print '**** Error **** ',instance
	     tname = 'simanalyze'
             casalog.post('An error occurred running task '+tname+'.', 'ERROR')
             pass

        gc.collect()
        return result
#
#
#
    def paramgui(self, useGlobals=True, ipython_globals=None):
        """
        Opens a parameter GUI for this task.  If useGlobals is true, then any relevant global parameter settings are used.
        """
        import paramgui
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )

        if useGlobals:
	    if ipython_globals == None:
                myf=self.__globals__
            else:
                myf=ipython_globals

            paramgui.setGlobals(myf)
        else:
            paramgui.setGlobals({})

        paramgui.runTask('simanalyze', myf['_ip'])
        paramgui.setGlobals({})

#
#
#
    def defaults(self, param=None, ipython_globals=None, paramvalue=None, subparam=None):
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
        if ipython_globals == None:
            myf=self.__globals__
        else:
            myf=ipython_globals

        a = odict()
        a['project']  = 'sim'
        a['image']  = True
        a['analyze']  = False
        a['graphics']  = 'both'
        a['verbose']  = False
        a['overwrite']  = True
        a['dryrun']  = False
        a['logfile']  = ''

        a['image'] = {
                    0:odict([{'value':True}, {'vis':'default'}, {'modelimage':''}, {'imsize':0}, {'imdirection':''}, {'cell':''}, {'interactive':False}, {'niter':0}, {'threshold':'0.1mJy'}, {'weighting':'natural'}, {'mask':[]}, {'outertaper':[]}, {'pbcor':True}, {'stokes':'I'}, {'featherimage':''}]), 
                    1:odict([{'value':False}, {'imagename':'default'}, {'skymodel':''}])}
        a['analyze'] = {
                    0:{'value':False}, 
                    1:odict([{'value':True}, {'showuv':True}, {'showpsf':True}, {'showmodel':True}, {'showconvolved':False}, {'showclean':True}, {'showresidual':False}, {'showdifference':True}, {'showfidelity':True}])}

### This function sets the default values but also will return the list of
### parameters or the default value of a given parameter
        if(param == None):
                myf['__set_default_parameters'](a)
        elif(param == 'paramkeys'):
                return a.keys()
        else:
            if(paramvalue==None and subparam==None):
               if(a.has_key(param)):
                  return a[param]
               else:
                  return self.itsdefault(param)
            else:
               retval=a[param]
               if(type(a[param])==dict):
                  for k in range(len(a[param])):
                     valornotval='value'
                     if(a[param][k].has_key('notvalue')):
                        valornotval='notvalue'
                     if((a[param][k][valornotval])==paramvalue):
                        retval=a[param][k].copy()
                        retval.pop(valornotval)
                        if(subparam != None):
                           if(retval.has_key(subparam)):
                              retval=retval[subparam]
                           else:
                              retval=self.itsdefault(subparam)
		     else:
                        retval=self.itsdefault(subparam)
               return retval


#
#
    def check_params(self, param=None, value=None, ipython_globals=None):
      if ipython_globals == None:
          myf=self.__globals__
      else:
          myf=ipython_globals
#      print 'param:', param, 'value:', value
      try :
         if str(type(value)) != "<type 'instance'>" :
            value0 = value
            value = myf['cu'].expandparam(param, value)
            matchtype = False
            if(type(value) == numpy.ndarray):
               if(type(value) == type(value0)):
                  myf[param] = value.tolist()
               else:
                  #print 'value:', value, 'value0:', value0
                  #print 'type(value):', type(value), 'type(value0):', type(value0)
                  myf[param] = value0
                  if type(value0) != list :
                     matchtype = True
            else :
               myf[param] = value
            value = myf['cu'].verifyparam({param:value})
            if matchtype:
               value = False
      except Exception, instance:
         #ignore the exception and just return it unchecked
         myf[param] = value
      return value
#
#
    def description(self, key='simanalyze', subkey=None):
        desc={'simanalyze': 'image and analyze measurement sets created with simobserve',
               'project': 'root prefix for output file names',
               'image': '(re)image $project.*.ms to $project.image',
               'imagename': 'simulation output image to analyze (default = first $project/*.image found)',
               'skymodel': 'skymodel image to analyze (the .skymodel image created by simobserve or simalma and used by one of those tasks to create an MS; if unspecified, will try to find one similar to your specified output image name)',
               'vis': 'Measurement Set(s) to image',
               'modelimage': 'lower resolution prior image to use in clean e.g. existing total power image',
               'imsize': 'output image size in pixels (x,y) or 0 to match model',
               'imdirection': 'set output image direction, (otherwise center on the model)',
               'cell': 'cell size with units e.g. "10arcsec" or "" to equal model',
               'interactive': 'interactive clean?  (make sure to set niter>0 also)',
               'niter': 'maximum number of iterations (0 for dirty image)',
               'threshold': 'flux level (+units) to stop cleaning',
               'weighting': 'weighting to apply to visibilities.  briggs will use robust=0.5',
               'mask': 'Cleanbox(es), mask image(s), region(s), or a level',
               'outertaper': 'uv-taper on outer baselines in uv-plane',
               'pbcor': 'correct the output of synthesis images for primary beam response?',
               'stokes': 'Stokes params to image',
               'featherimage': 'image (e.g. total power) to feather with new image',
               'analyze': '(only first 6 selected outputs will be displayed)',
               'showuv': 'display uv coverage',
               'showpsf': 'display synthesized (dirty) beam (ignored in single dish simulation)',
               'showmodel': 'display sky model at original resolution',
               'showconvolved': 'display sky model convolved with output clean beam',
               'showclean': 'display the synthesized image',
               'showresidual': 'display the clean residual image (ignored in single dish simulation)',
               'showdifference': 'display difference between output cleaned image and input model sky image convolved with output clean beam',
               'showfidelity': 'display fidelity (see help)',
               'graphics': 'display graphics at each stage to [screen|file|both|none]',
               'verbose': '',
               'overwrite': 'overwrite files starting with $project',
               'dryrun': 'only print information [experimental; only for interfermetric data]',
               'logfile': '',

              }

#
# Set subfields defaults if needed
#

        if(desc.has_key(key)) :
           return desc[key]

    def itsdefault(self, paramname) :
        a = {}
        a['project']  = 'sim'
        a['image']  = True
        a['imagename']  = 'default'
        a['skymodel']  = ''
        a['vis']  = 'default'
        a['modelimage']  = ''
        a['imsize']  = [0, 0]
        a['imdirection']  = ''
        a['cell']  = ''
        a['interactive']  = False
        a['niter']  = 0
        a['threshold']  = '0.1mJy'
        a['weighting']  = 'natural'
        a['mask']  = []
        a['outertaper']  = ['']
        a['pbcor']  = True
        a['stokes']  = 'I'
        a['featherimage']  = ''
        a['analyze']  = False
        a['showuv']  = True
        a['showpsf']  = True
        a['showmodel']  = True
        a['showconvolved']  = False
        a['showclean']  = True
        a['showresidual']  = False
        a['showdifference']  = True
        a['showfidelity']  = True
        a['graphics']  = 'both'
        a['verbose']  = False
        a['overwrite']  = True
        a['dryrun']  = False
        a['logfile']  = ''

        #a = sys._getframe(len(inspect.stack())-1).f_globals

        if self.parameters['image']  == True:
            a['vis'] = 'default'
            a['modelimage'] = ''
            a['imsize'] = 0
            a['imdirection'] = ''
            a['cell'] = ''
            a['interactive'] = False
            a['niter'] = 0
            a['threshold'] = '0.1mJy'
            a['weighting'] = 'natural'
            a['mask'] = []
            a['outertaper'] = []
            a['pbcor'] = True
            a['stokes'] = 'I'
            a['featherimage'] = ''

        if self.parameters['image']  == False:
            a['imagename'] = 'default'
            a['skymodel'] = ''

        if self.parameters['analyze']  == True:
            a['showuv'] = True
            a['showpsf'] = True
            a['showmodel'] = True
            a['showconvolved'] = False
            a['showclean'] = True
            a['showresidual'] = False
            a['showdifference'] = True
            a['showfidelity'] = True

        if a.has_key(paramname) :
	      return a[paramname]
simanalyze_cli = simanalyze_cli_()
