#
# This file was generated using xslt from its XML file
#
# Copyright 2009, Associated Universities Inc., Washington DC
#
import sys
import os
from  casac import *
import string
from taskinit import casalog
from taskinit import xmlpath
#from taskmanager import tm
import task_simanalyze
def simanalyze(project='sim', image=True, imagename='default', skymodel='', vis='default', modelimage='', imsize=[0, 0], imdirection='', cell='', interactive=False, niter=0, threshold='0.1mJy', weighting='natural', mask=[], outertaper=[''], pbcor=True, stokes='I', featherimage='', analyze=False, showuv=True, showpsf=True, showmodel=True, showconvolved=False, showclean=True, showresidual=False, showdifference=True, showfidelity=True, graphics='both', verbose=False, overwrite=True, dryrun=False, logfile=''):

        """image and analyze measurement sets created with simobserve
      * "project" needs to be the directory of results generated by running 
        simobserve or simalma. In particular $project/$project.skymodel 
        will be required in order to compare output and input images.

    -------------------------------
    mode image=True:
      * One should input one or more simulated MSs using the "vis" parameter.  
        These can include a total power MS. 
        Simanalyze will grid any total power MS, 
        clean (invert and deconvolve) any interferometric MSs, 
        and feather the results. 

      * the "vis" parameter:
        - example: single MS: vis="mysim.alma.out03.ms"
        - example: multiple MSs: vis="mysim.alma.out03.ms,mysim.aca.tp.ms"
        - one can use "$project" and let the task automatically replace it with
          the project name, e.g., vis="$project.noisy.ms,$project.noisy.sd.ms".
          However, note that if you created measurement set(s) using simobserve,
          MS names will include the configuration, e.g. 
          "$project.alma_out20.noisy.ms"
        - setting "vis" to "default" will find and attempt to image
          all measurement sets (interferometric and single dish) in the 
          project directory

      * Sometimes it is preferable to grid the single dish MS using the 
        sdimaging task for more control.  In that case one can input 
        the resulting single dish imaging under "featherimage", only 
        put interferometric MSs in "vis", and simanalyze  will clean the 
        interferometric and feather with your "featherimage".

      * Sometimes it is preferable to use a low resolution (single dish or 
        synthesis) image as a prior model during clean deconvolution
        of a higher resolution interferometric MS.  That is accomplished 
        by putting the low-resolution image in "modelimage" and the MS
        to be deconvolved in "vis". NOTE: This is not the original skymodel
        that was used in simobserve or simalma.  It is recommended to 
        leave this blank unless the user is familiar with using a prior 
        in clean deconvolution. (see casaguides) NOTE 2: modelimage will 
        not be used if the MS to be imaged is total power.
       
      * uses Cotton-Schwab clean for single fields and Mosaic gridding
        for multiple fields (with Clark PSF calculation in minor cycles).

      * interactive clean or use of more parameters than the subset 
        visible here are available by simply running the clean task directly, 
        then using simanalyze in the mode image=False (see below).

      * if graphics are turned on, this step will display the clean image 
        and residual image

      * the "mask" parameter:
        Specification of cleanbox(es), mask image(s), primary beam
        coverage level, and/or region(s) to be used for cleaning.
        clean tends to perform better, and is less likely to diverge, if 
        the clean component placement is limited by a mask to where real 
        emission is expected to be.  e.g. pixel ranges mask=[110,110,150,145],
        filename of mask image mask='myimage.mask', or a file with mask 
        regions --  see help for the clean task for more information.

      * NOTE: simanalyze was designed to be used after one or more runs of
        simobserve, and as such it assumes it will be able to find a 
        sky model image called $project/$project.skymodel, .newmodel, or 
        .compskymodel in the $project/ subdirectory.  If the simulated 
        MS has been created by means other than simply calling simobserve, 
        the user may have to copy their sky model image into the $project
        subdirectory and call it "$project.skymodel"

    -------------------------------
    mode image=False:
      * Sometimes the user has created a synthesized image themselves, 
        most likely using the clean task, perhaps along with 
        sdimaging and feather, or a previous call to simanalyze with image=True 
      * The user should input that simulated image as "imagename".  
        It will have suffix .image if created by clean, simanalyze, or simalma
      * simanalyze will attempt to find an appropriate skymodel image - 
        this is the *.skymodel image created by simobserve or simalma, 
        the (optionally rescaled) original sky model, which was used 
        to create the measurement set.
        simanalyze will look in the project directory, but if there are 
        multuple skymodels present it may not find the right one, so the
        "skymodel" parameter allows explicit specification.

    -------------------------------
    mode analyze=True is used to create an image of the difference between 
        the input skymodel and the simulated output image (whether that output
        image is being generated in the same call to simanalyze, with 
        image=True, or has already been generated, and simanalyze is being 
        called with image=False).

    showuv -- display uv coverage
    showpsf -- display synthesized (dirty) beam (ignored in single dish simulation)
    showmodel -- display sky model at original resolution
    showconvolved -- display sky model convolved with output beam 
    showclean -- display the synthesized image
    showresidual -- display the clean residual image (ignored in single dish simulation)
    showdifference -- display difference between output cleaned image and 
         input model sky image convolved with output clean beam
    showfidelity -- display fidelity image
         fidelity = abs(input) / max[ abs(input-output), 0.7*rms(output) ]
    

    Note that the RMS is calculated in the lower quarter of the image.  
         This is likely not the best choice, so you are encouraged to 
         measure RMS yourself in an off-source region using the viewer.

    dryrun=True is an advanced technical mode only useful for interferometric 
         (not single dish) data. 

    -------------------------------
    Output produced: (not all will always exist, depending on input parameters)
    To support different runs with different arrays, the names have the
    configuration name from antennalist appended.
    -------------------------------
    project.[cfg].skymodel.flat.regrid.conv = input sky regridded to match 
         the output image, and convolved with the output clean beam

    project.[cfg].image = synthesized image
    project.[cfg].flux.pbcoverage = primary beam correction for mosaic image
    project.[cfg].residual = residual image after cleaning
    project.[cfg].clean.last = parameter file of what parameters were used in
          the clean task
    project.[cfg].psf = synthesized (dirty) beam calculated from weighted uv 
          distribution
    project.[cfg].image.png = diagnostic figure of clean image and residual
	    
    project.[cfg].fidelity = fidelity image
    project.[cfg].analysis.png = diagnostic figure of difference and fidelity
	    
    project.[cfg].simanalyze.last = saved input parameters for simanalyze task

    -------------------------------
    Please see http://casaguides.nrao.edu, and contact the CASA helpdesk 
    with questions.
  
        """
        if type(imsize)==int: imsize=[imsize]
        if type(outertaper)==str: outertaper=[outertaper]

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['project'] = project
        mytmp['image'] = image
        mytmp['imagename'] = imagename
        mytmp['skymodel'] = skymodel
        mytmp['vis'] = vis
        mytmp['modelimage'] = modelimage
        mytmp['imsize'] = imsize
        mytmp['imdirection'] = imdirection
        mytmp['cell'] = cell
        mytmp['interactive'] = interactive
        mytmp['niter'] = niter
        mytmp['threshold'] = threshold
        mytmp['weighting'] = weighting
        mytmp['mask'] = mask
        mytmp['outertaper'] = outertaper
        mytmp['pbcor'] = pbcor
        mytmp['stokes'] = stokes
        mytmp['featherimage'] = featherimage
        mytmp['analyze'] = analyze
        mytmp['showuv'] = showuv
        mytmp['showpsf'] = showpsf
        mytmp['showmodel'] = showmodel
        mytmp['showconvolved'] = showconvolved
        mytmp['showclean'] = showclean
        mytmp['showresidual'] = showresidual
        mytmp['showdifference'] = showdifference
        mytmp['showfidelity'] = showfidelity
        mytmp['graphics'] = graphics
        mytmp['verbose'] = verbose
        mytmp['overwrite'] = overwrite
        mytmp['dryrun'] = dryrun
        mytmp['logfile'] = logfile
	pathname='file://' + xmlpath( ) + '/'
	trec = casac.utils().torecord(pathname+'simanalyze.xml')

        casalog.origin('simanalyze')
        if trec.has_key('simanalyze') and casac.utils().verify(mytmp, trec['simanalyze']) :
	    result = task_simanalyze.simanalyze(project, image, imagename, skymodel, vis, modelimage, imsize, imdirection, cell, interactive, niter, threshold, weighting, mask, outertaper, pbcor, stokes, featherimage, analyze, showuv, showpsf, showmodel, showconvolved, showclean, showresidual, showdifference, showfidelity, graphics, verbose, overwrite, dryrun, logfile)

	else :
	  result = False
        return result
