#
# This file was generated using xslt from its XML file
#
# Copyright 2009, Associated Universities Inc., Washington DC
#
import sys
import os
from  casac import *
import string
from taskinit import casalog
from taskinit import xmlpath
#from taskmanager import tm
import task_setjy
def setjy(vis='', field='', spw='', selectdata=False, timerange='', scan='', intent='', observation='', scalebychan=True, standard='Perley-Butler 2013', model='', modimage='', listmodels=False, fluxdensity=-1, spix=0.0, reffreq='1GHz', polindex=[], polangle=[], rotmeas=0.0, fluxdict=[], useephemdir=False, interpolation='nearest', usescratch=False, ismms=False):

        """Fills the model column with the visibilities of a calibrator
    The task sets the model visibility amp and phase of a specified source
    (generally a calibrator).  The simplest way is to enter the flux density
    (I,Q,U,V) explicitly, but this is valid only for a point source.

    For an extended source, the clean model (image.model) can be
    specified and the model visibilities associated with this clean
    model is placed in the visibility model column.

    Models are available for 3C48, 3C138, 3C286 between 1.4 and 43 GHz.
    3C147 is available above 4 GHz.  These models are scaled to the precise
    frequency of the data.  Only I models are presently available.

    The location of the models is system dependent: At the AOC and CV, the
    models are in the directory::/usr/lib/casapy/data/nrao/VLA/CalModels or
    /usr/lib64/casapy/data/nrao/VLA/CalModels (depending on whether 32 or 64
    bit CASA was installed on the machine being used).  In general (using
    Python), the stock models should be in
    casa['dirs']['data'] + '/nrao/VLA/CalModels'
    setjy also looks for models in the current directory before trying
    casa['dirs']['data'] + '/nrao/VLA/CalModels'.

    setjy need only be run on the calibrator sources with a known flux
    density and/or model.

    
    Solar System Objects are supported via the 'Butler-JPL-Horizons 2012' 
    standard. This uses new brightness temperature models and a new flux
    calculation code that replace the 'Butler-JPL-Horizons 2010' standard.
    The older 'Butler-JPL-Horizons 2010' standard is still available
    for comparison. Users may want to use predictcomp task to see the differences. 
    Currently they are modeled as uniform temperature disks based
    on their ephemerides at the time of observation (note that this may
    oversimplify objects, in particular asteroids).  The object name is
    obtained from the 'field' parameter. Recognized objects are listed
    below, under 'standard'.

    
   
    With standard='manual', flux densities and spectral index can be manually
    specified. As in the previous CASA versions, if fluxdensity[0] (Stokes I) 
    is < 0, the default standard will be used to calculate flux density as 
    a function of frequency. 

    The calculated flux densities are reported in the logger but also will be
    returned as a dictionary if you run as,
    fluxds = setjy(vis='ngc5921.ms', ...).
    The dictionary have the structure, 
         {field name, {spw Id: {'fluxd': [I,Q,U,V] (flux densities in Jy)}}}
    and the description is also in fluxds['format']. 

    Keyword arguments:
    vis -- Name of input visibility file
            default: none.  example: vis='ngc5921.ms'
    field -- Select field using field id(s) or field name(s).
           default: ''=all fields, but run setjy one field at a time.
              [run listobs to obtain the list id's or names of calibrators]
           If field is a non-negative integer, it is assumed to be a field
           index.  Otherwise, it is taken to be a field name (case sensitive
           - it must match the name as listed by listobs).
           field='0~2'; field ids 0,1,2
           field='0,4,5~7'; field ids 0,4,5,6,7
           field='3C286,3C295'; field named 3C286 and 3C295
           field = '3,4C*'; field id 3, all names starting with 4C
    spw -- Spectral window selection string.
           default: '' = all spectral windows
           Note that setjy only selects by spectral window, and ignores
           channel selections.  Fine-grained control could be achieved using
           (and possibly constructing) a cube for modimage.

    selectdata -- Other parameters for selecting part(s) of the MS
                  to operate on.
                  (Currently all time-oriented and most likely only of
                   interest when using a Solar System object as a calibrator.)
                  default: False

  >>> selectdata=True expandable parameters
               See help par.selectdata for more on these.
               Note: for usescratch=False, timerange, scan, and observation 
               are ignored (i.e. time-specific virtual model is not possible.).
 
               timerange  -- Select data based on time range (when usescratch=T):
                   default: '' (all); examples,
                   timerange = 'YYYY/MM/DD/hh:mm:ss~YYYY/MM/DD/hh:mm:ss'
                   Note: if YYYY/MM/DD is missing date defaults to first 
			 day in data set
                   timerange='09:14:0~09:54:0' picks 40 min on first day
                   timerange='25:00:00~27:30:00' picks 1 hr to 3 hr 
			     30min on NEXT day
                   timerange='09:44:00' pick data within one integration 
		             of time
                   timerange='>10:24:00' data after this time
                   For multiple MS input, a list of timerange strings can be
                   used:
                   timerange=['09:14:0~09:54:0','>10:24:00']
                   timerange='09:14:0~09:54:0''; apply the same timerange for
                                                 all input MSes
               scan -- Scan number range (when usescratch=T).
                   default: '' (all)
                   example: scan='1~5'
                   For multiple MS input, a list of scan strings can be used:
                   scan=['0~100','10~200']
                   scan='0~100; scan ids 0-100 for all input MSes
                   Check 'go listobs' to insure the scan numbers are in order.
               observation -- Observation ID range (when usescratch=T).
                   default: '' (all)
                   example: observation='1~5'
               intent -- observation intent.
                   default: '' (all)
                   example: using wildcard characters, 
                            intent="*CALIBRATE_AMPLI*"
                            will match field(s) contains CALIBRATE_AMPLI in a list of intents
                   WARNING: If a source with a specific field id has scans that can be distinguishable
                            with intent selection, one should set usescatch=True. Otherwise, any existing
                            model of the source may be cleared and overwritten even if the part of the scans
                            not selected by intent.
    

    scalebychan -- This determines whether the fluxdensity set in the model is
            calculated on a per channel basis. If False then it only one
            fluxdensity value is calculated per spw.  (Either way, all channels
            in spw are modified.)  It is effectively True if fluxdensity[0] >
            0.0. 
            default: True


    standard -- Flux density standard, used if fluxdensity[0] < 0.0
            default: 'Perley-Butler 2013'; example: standard='Baars'
            Options: 'Baars',
                     'Perley 90',
                     'Perley-Taylor 95',
                     'Perley-Taylor 99', 
                     'Perley-Butler 2010', 
                     'Perley-Butler 2013',
                     'Scaife-Heald 2012',
                     'Stevens-Reynolds 2016',
                     'Butler-JPL-Horizons 2010', 
                     'Butler-JPL-Horizons 2012', 
                     'manual'
                     'fluxscale' 
                     
            All but the last four are for extragalactic calibrators.
            The two 'Butler-JPL' standards are for Solar System objects.  
            Note that Scaife-Heald 2012 is for the low frequencies (mostly
            valid for the frequency range, 30-300MHz). 

            Extragalactic calibrators:
            Following source names and their common aliases are recognized.
            The last column shows which standards support for each source.
            Note that the task does not do exact matching of the name 
            (also case insensitive) and it recognizes as long as the field name  
            contains the string listed below (e.g. 'PKS 1934-638' works).  
            For 3C Name, a space or an underscore between 3C and the number
             (e.g. '3C 286' and '3C_286') also works. If the matching by 
            the field name fails, the task tries to match by its position to
            the known calibrator list stored in the data directory
            (~/data/nrao/VLA/standards/fluxscalibrator.data). 
            -------------------------------------------------------------
            3C Name B1950 Name J2000 Name Alt. J2000 Name  standards*
            3C48    0134+329   0137+331   J0137+3309       1,2,3,4,5,6,7
            3C123   0433+295   0437+296   J0437+2940       2 
            3C138   0518+165   0521+166   J0521+1638       1,2,3,4,5,6
            3C147   0538+498   0542+498   J0542+4951       1,2,3,4,5,6,7
            3C196   0809+483   0813+482   J0813+4813       1,2,7 
            3C286   1328+307   1331+305   J1331+3030       1,2,3,4,5,6,7
            3C295   1409+524   1411+522   J1411+5212       1,2,3,4,5,6,7
              -     1934-638      -       J1939-6342       1,3,4,5,6,8
            3C380   1828+487   1829+487   J1829+4845       7
            ------------------------------------------------------------- 
            * supported in: 1 - Perley-Butler 2010, 2 - Perley-Butler 2013 (ref. Perley and 
            Butler 2013, ApJS 204, 19), 3 - Perley-Taylor 99, 4 - Perley-Taylor 95, 
            5 - Perley 90, 6 - Baars, 7 - Scaife-Heald 2012, 8 - Stevens-Reynolds 2016 

            Solar system objects:
            The 'Butler-JPL-Horizons 2012' standard is recommended over 
            'Butler-JPL-Horizons 2010' as the former uses updated models.
            Recognized Solar System objects (for 'Butler-JPL-Horizons 2012') are: 
             
               
	       Planets: Venus, Mars, Jupiter, Uranus, Neptune
	       
	       Moons: Jupiter: Io, Europa, Ganymede, Callisto
                   Saturn:  Titan 

               Asteroids: Ceres, Lutetia, Pallas**, Vesta**, Juno**

            ******************************************************************************************
            * New asteroid models for Ceres, Pallas, and Vesta were put into CASA 4.7.               * 
            * A model is also available for Lutetia but we do not advise using this source for ALMA  *
            * absolute flux calibration. These new models are used (automatically chosen)            * 
            * for data taken after 2015 January 1 0h UT. The models are time variable and based on   *
            * thermophysical modeling by Th. Mueller (private communication).                        *
            * These are tabulated for 30, 80, 115, 150, 200, 230, 260, 300, 330, 360, 425, 650,      *
            * 800, 950, and 1000 GHz; cubic frequency interpolation is employed to derive the flux   *
            * density at other frequencies. There is no line emission included in these models.      *
            * The available model files can be listed with the command,                              * 
            *    setjy(standard='Butler-JPL-Horizons 2012', listmodels=T).                           *
            ******************************************************************************************
              
            * Venus: model for ~300MHz to 350GHz, no atmospheric lines (CO,H2O,HDO, etc)
            * Mars: tabulated as a function of time and frequency (30 - 1000GHz) based on 
               Rudy et al (1988), no atmospheric lines (CO, H20, H2O2, HDO, etc)
            * Jupiter: model for 30-1020GHz, does not include synchrotron emission
            * Uranus: model for 60-1800GHz, contains no rings or synchrotron.
            * Neptune: model for 2-2000GHz, the broad CO absorption line
               is included, but contains no rings or synchrotron. 
            * Titan: model for 53.3-1024.1GHz, include many spectral lines

            **  not recommended when the old model is used (i.e. for the data prior to 2015.01.01) 
                (The temperature is not yet adjusted for
                varying distance from the Sun.  The model data can be scaled
                after running setjy, but it is an involved process.)

	       The 'field' parameter must match the case of the field name(s)
	       in vis (as shown by listobs).

            Flux density calculation with Solar System objects depends on
            ephemerides. The setjy task looks for the data in  
            
            os.getenv('CASAPATH').split()[0] + '/data/ephemerides/JPL-Horizons'.

            If no ephemeris for the right object at the right time is
            present, the calculation will fail.  Ask the helpdesk to make an
            ephemeris.  The very adventurous and well versed in python can
            try it using CASA's recipes.ephemerides package:
	         import recipes.ephemerides as eph
		 help eph

            CASA comes with ephemerides for several more objects, but they
            are intended for use with me.framecomet(), and are not (yet)
            suitable flux density calibrators.  It is up to the observer to
            pick a good flux density calibrator (bright, spherical and
            featureless, on a circular orbit, in the right part of the sky,
            and not too resolved).  Even some of the objects listed above
            may prove to require more sophisticated flux density models than
            are currently implemented in CASA.  For many objects running
	    casalog.filter('INFO1') before running setjy will send more
	    information to the logger.  The cookbook also has an appendix
	    with descriptions of the models used by setjy (both
	    extragalactic and Solar System).

       >>> standard="Perley-Butler 2010" or "Perley-Butler 2013 expandable parameter
            model -- Model image (I only) for setting the model visibilities.
                 *****************************************************************
                 * Previously, this parameter is called 'modimage', now modimage *
                 * is deprecated. The setjy still accepts modimage but will be   *
                 * removed in future releases. Please use the parameter, 'model' *
                 * instead.                                                      *  
                 *****************************************************************
		 The model can be a cube, and its channels do not have to exactly
		 match those of vis.  It is recommended to use modimage for
		 sources that are resolved by the observation, but the
		 Butler-JPL-Horizons standard supplies a basic model of what
		 several Solar System objects look like.  default: '': do not use
		 a model image.
	  
	         Each field must be done separately when using a model image.  
                 

		 Both the amplitude and phase are calculated.  At the AOC or CV,
		 the models are located in casa['dirs']['data']
		 + '/nrao/VLA/CalModels/', e.g.
		 /usr/lib/casapy/data/nrao/VLA/CalModels/3C286_L.im
		      lib64

		 If model does not start with '/', setjy will look for a match
		 in '.', './CalModels', and any CalModels directories within
		 the casa['dirs']['data'] tree (excluding certain branches).

		 Note that model should be deconvolved, i.e. a set of clean
		 components instead of an image that has been convolved with a
		 clean beam.

            listmodels -- If True, do nothing but list candidates for model
                (for extragalactic calibrators) that are present on the system.  
		It looks for *.im* *.mod* in . including its sub-directories but skipping
		any directory name start with ".",   
		CalModels, and CalModels directories in the casa['dirs']['data'] tree.  
		It does not check whether they are appropriate for the MS!
		If standard='Butler-JPL-Horizons 2012', Tb models (frequency-depended
		brightness temperature models) for Solar System objects used in the 
		standard.  For standard='Butler-JPL-Horizons 2010', the recognized
		Solar System objects are listed. 

       >>> standard="Perley-Butler 2013" expandable parameter
            interpolation -- method for interpolation ('nearest', 'linear', 'cubic',
                or 'spline') in time for the time variable sources (3C48,3C138,3C147).
                This parameter is ignored for other non-variable sources in the standard.
                default:'nearest' 

       >>> standard="Butler-JPL-Horizons 2012" expandable parameter

            useephemdir -- If True: use the direction from the ephemeris table for 
                the solar system object. 
                default: False -use the direction information in the MS(i.e. Field table) 

       >>> standard="manual" expandable parameters
	    fluxdensity -- Specified flux density [I,Q,U,V] in Jy
		default: -1, uses [1,0,0,0] flux density for unrecognized sources,
		and standard flux densities for ones recognized by the default 
                standard (Perley-Butler 2010).  
		setjy will try to use the standard if fluxdensity is not
		positive.

		Only one flux density can be specified at a time.  The phases are
		set to zero.
		example   fluxdensity=-1  will use the default standard for recognized
		          calibrators (like 3C286, 3C147 and 3C48) and insert 1.0 
                          for selected fields with unrecognized sources.
		example   field = '1'; fluxdensity=[3.2,0,0,0] will put in 
			  a flux density of I=3.2 for field='1'

	        At present (June 2000), this is the only method to insert a
		polarized flux density model.
		example:  fluxdensity=[2.63,0.21,-0.33,0.02]
		          will put in I,Q,U,V flux densities of 2.63,0.21,-0.33,
			  and 0.02, respectively, in the model column.

	    spix -- Spectral index for I flux density (a float or a list of float values):
		       where S = fluxdensity * (freq/reffreq)**(spix[0]+spix[1]*log(freq/reffreq)+..)
		Default: [] =>0.0 (no effect)
		Only used if fluxdensity is being used.
		N.B.: If fluxdensity is positive, and spix is nonzero, then reffreq
		      must be set too!  (See below)

		It is applied in the same way to all polarizations, and does
		not account for Faraday rotation or depolarization.

                Example: [-0.7, -0.15] for alpha and a curvature term

	    reffreq -- The reference frequency for spix, given with a unit with
                an optional frequency frame (if the frame is not given, LSRK 
                is assumed). 
                There should be no space between the value and the unit 
                (e.g. '100.0GHz' or 'TOPO 100.0GHz' are correct but with 
                '100.0 GHz' you will see a warning message that it will be
                defaulted to LSRK). 
		Default: '1GHz'; this is only here to prevent division by 0!
		N.B.: If the flux density is being scaled by spectral index,
		then reffreq must be set to whatever reference frequency is
		correct for the given fluxdensity and spix.  It cannot be
		determined from vis.  On the other hand, if spix is 0, then any
		positive frequency can be used (and ignored).

		Examples: '86.0GHz', 'TOPO 86.0GHz', '4.65e9Hz'

            polindex -- Coefficients of the frequency-dependent linear polarization index (polarization fraction) 
                        expressed as,
                        pol. index = sqrt(Q^2+U^2)/I = c0 + c1*((freq-reffreq)/reffreq) + c2*((freq-reffreq)/reffreq)^2 + ..
                        When Q and U flux densities are given fluxdensity, c0 is determined from
                        these flux densities and the entry for c0 in polindex is ignored. Or Q and U flux densities in
                        fluxdensity can be set to 0.0 and then polindex[0] and polangle[0] are used to determine Q and U 
                        at reffreq.
                Default: []
                Example: [0.2, -0.01] (= [c0,c1]) 

            polangle -- Coefficients of the frequency-dependent linear polarization angle (in radians) expressed as,
                        pol. angle = 0.5*arctan(U/Q) = d0 + d1*((freq-reffreq)/reffreq) + d2*((freq-reffreq)/reffreq)^2 + ..
                        When Q and U flux densities are given in fluxdensity, d0 is determined from
                        these flux densities and the entry for d0 in polangle is ignored. Or Q and U flux densities in
                        fluxdensity can be set to 0.0 and then polindex[0] and polangle[0] are used to determine Q and U
                        at reffreq. Here polangle parameters are assumed to represent the intrinsic polarization angle.
                Default: []
                Example: [0.57, 0.2] (=[d0,d1])

            rotmeas -- rotation measure (in rad/m^2). 

            *** Note on the use of polindex, polangle and rotmeas ***
            When the frequnecy-dependent polindex and polangle are used, be sure to include all the coefficients of 
            both polindex and polangle to describe frequency depencency.  Otherwise frequency-dependent Q and U flux densities 
            are not calculated correctly.  If rotmeas is given, the calculated Q and U flux densities are then corrected for 
            the Faraday rotation.

       >>> standard="fluxscale" expandable parameters
	    fluxdict -- Output dictionary from fluxscale
                Using the flexibly results, the flux density, spectral index,
                and reference frequency are extracted and set to fluxdensity,
                spix, and reffreq parameters, respectively.
                The field and spw selections can be used to specify subset of 
                the fluxdict to be used to set the model. If they are left as 
                default (field="", spw="") all fields and/or spws in 
                the fluxdict (but those spws with fluxd=-1 will be skipped) are
                used.  
		default: {}


        usescratch  -- If False: 'virtual' model is created. The model information is saved 
        either in the SOURCE_MODEL column in the SOURCE table (if one exists) or in the keyword 
        of the main table in the MS and model visibilities are evaluated on the fly when calculating 
        calibration or plotting in plotms.
        If True: the model visibility will be evaluated and saved on disk in the MODEL_DATA 
        column.  This will increase your ms in size by a factor of 1.5 (w.r.t. the case where 
        you only have the DATA and the CORRECTED_DATA column).  Use True if you need to interact 
        with the MODEL_DATA in python, say. Also, use True if you need finer than field and spw 
        selections using scans/time (and when use with intent selection, please see WARNING section in the
        intent parameter description).

        *By running usescratch=T, it will remove the existing virtual model from previous runs.
        usescratch=F will not remove the existing MODEL_DATA but in subsequent process
        the virtual model with matching field and spw combination will be used if it exists
        regardless of the presence of the MODEL_DATA column.

         
        default: False        


    Returned dictionary: 
        When the setjy task is executed as setjy(vis='', ..), the flux densities used to set
        the model are returned as a Python dictionary with the format,
        {field Id: {spw Id: {fluxd: [I,Q,U,V] in Jy}, 'fieldName':field name }}, where
        field Id and spw Id are in string type. 
            

        """
        if type(polindex)==float: polindex=[polindex]
        if type(polangle)==float: polangle=[polangle]

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['vis'] = vis
        mytmp['field'] = field
        mytmp['spw'] = spw
        mytmp['selectdata'] = selectdata
        mytmp['timerange'] = timerange
        mytmp['scan'] = scan
        mytmp['intent'] = intent
        mytmp['observation'] = observation
        mytmp['scalebychan'] = scalebychan
        mytmp['standard'] = standard
        mytmp['model'] = model
        mytmp['modimage'] = modimage
        mytmp['listmodels'] = listmodels
        mytmp['fluxdensity'] = fluxdensity
        mytmp['spix'] = spix
        mytmp['reffreq'] = reffreq
        mytmp['polindex'] = polindex
        mytmp['polangle'] = polangle
        mytmp['rotmeas'] = rotmeas
        mytmp['fluxdict'] = fluxdict
        mytmp['useephemdir'] = useephemdir
        mytmp['interpolation'] = interpolation
        mytmp['usescratch'] = usescratch
        mytmp['ismms'] = ismms
	pathname='file://' + xmlpath( ) + '/'
	trec = casac.utils().torecord(pathname+'setjy.xml')

        casalog.origin('setjy')
        if trec.has_key('setjy') and casac.utils().verify(mytmp, trec['setjy']) :
	    result = task_setjy.setjy(vis, field, spw, selectdata, timerange, scan, intent, observation, scalebychan, standard, model, modimage, listmodels, fluxdensity, spix, reffreq, polindex, polangle, rotmeas, fluxdict, useephemdir, interpolation, usescratch, ismms)

	else :
	  result = False
        return result
