#
# This file was generated using xslt from its XML file
#
# Copyright 2014, Associated Universities Inc., Washington DC
#
import sys
import os
#from casac import *
import casac
import string
import time
import inspect
import gc
import numpy
from casa_stack_manip import stack_frame_find
from odict import odict
from types import * 
from task_plotuv import plotuv
class plotuv_cli_:
    __name__ = "plotuv"
    rkey = None
    i_am_a_casapy_task = None
    # The existence of the i_am_a_casapy_task attribute allows help()
    # (and other) to treat casapy tasks as a special case.

    def __init__(self) :
       self.__bases__ = (plotuv_cli_,)
       self.__doc__ = self.__call__.__doc__

       self.parameters={'vis':None, 'field':None, 'antenna':None, 'spw':None, 'observation':None, 'array':None, 'maxnpts':None, 'colors':None, 'symb':None, 'ncycles':None, 'figfile':None, }


    def result(self, key=None):
	    #### and add any that have completed...
	    return None


    def __call__(self, vis=None, field=None, antenna=None, spw=None, observation=None, array=None, maxnpts=None, colors=None, symb=None, ncycles=None, figfile=None, ):

        """Plot the baseline distribution

	Detailed Description: 

      Plots the selected baselines of vis one field at a time, in kilowavelengths.
    
	Arguments :
		vis:	Name of input visibility file (MS)
		   Default Value: 

		field:	Select field using ID(s) or name(s)
		   Default Value: 

		antenna:	Select data based on antenna/baseline
		   Default Value: 

		spw:	Select spectral window/channels
		   Default Value: 

		observation:	Select by observation ID(s)
		   Default Value: 

		array:	Select (sub)array(s) by array ID number
		   Default Value: 

		maxnpts:	Maximum number of points per plot.
		   Default Value: 100000

		colors:	a list of matplotlib color codes
		   Default Value: 
	  r
	  y
	  g
	  b
	

		symb:	A matplotlib plot symbol code
		   Default Value: ,

		ncycles:	How many times to cycle through colors per plot.
		   Default Value: 1

		figfile:	Save the plotted figure(s) using this name
		   Default Value: 

	Returns: bool

	Example :

    Plots the uv coverage of vis in klambda.  ncycles of colors will be
    allocated to representative wavelengths.

    Keyword arguments:
      vis -- Name of input visibility file
             default: none; example: vis='ngc5921.ms'

      --- Data Selection (see help par.selectdata for more detailed
          information)

       field -- Select field using field id(s) or field name(s).
                 [run listobs to obtain the list IDs or names]
              default: ''=all fields.  If field is a non-negative
              integer, it is assumed to be a field index.
              Otherwise, it is assumed to be a field name
              field='0~2'; field ids 0,1,2
              field='0,4,5~7'; field ids 0,4,5,6,7
              field='3C286,3C295'; fields named 3C286 and 3C295
              field = '3,4C*'; field id 3, all names starting with 4C
        antenna -- Select data based on antenna/baseline
                default: '' (all)
                Non-negative integers are assumed to be antenna indices, and
                anything else is taken as an antenna name.

                Examples:
                antenna='5&6': baseline between antenna index 5 and index 6.
                antenna='VA05&VA06': baseline between VLA antenna 5 and 6.
                antenna='5&6;7&8': baselines 5-6 and 7-8
                antenna='5': all baselines with antenna 5
                antenna='5,6,10': all baselines including antennas 5, 6, or 10
                antenna='5,6,10&': all baselines with *only* antennas 5, 6, or
                                       10.  (cross-correlations only.  Use &&
                                       to include autocorrelations, and &&&
                                       to get only autocorrelations.)
                antenna='!ea03,ea12,ea17': all baselines except those that
                                           include EVLA antennas ea03, ea12, or
                                           ea17.
       spw -- Select spectral windows.  Channel selection is ignored for now.
              default: ''=all spectral windows
              spw='0~2,4'; spectral windows 0,1,2,4
              spw='<2';  spectral windows less than 2 (i.e. 0,1)
              spw='0'; spw 0
              spw='0,10,3'; spws 0, 10, and 3
       observation -- Select by observation ID(s). default: '' = all
       array -- (Sub)array number range. default: ''=all

      maxnpts -- Save memory and/or screen space by plotting a maximum of maxnpts
                 (or all of them if maxnpts < 1).  There is a very sharp
                 slowdown if the plotter starts swapping.
                 default: 100000
      colors -- a list of matplotlib color codes, used in order of decreasing
                visibility wavelength.
                default: ['r', 'y', 'g', 'b']  (red, yellow, green, blue)
      symb -- One of matplotlib's codes for plot symbols: .:,o^v<>s+xDd234hH|_
              default: ',':  The smallest points I could find.
      ncycles -- The number of times colors will be cycled through per plot.
                 default: 1
      figfile -- If not '', save the plots using names based on figfile.
                 Example: if figfile is 'test.png', and field is '1,2,4', the plots
		          will be saved to test_fld1.png, test_fld2.png,
			  and test_fld4.png.
                 default: '' (Do not save)
    
        """
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
	#casac = self.__globals__['casac']
	casalog = self.__globals__['casalog']
	casa = self.__globals__['casa']
	#casalog = casac.casac.logsink()
        self.__globals__['__last_task'] = 'plotuv'
        self.__globals__['taskname'] = 'plotuv'
        ###
        self.__globals__['update_params'](func=self.__globals__['taskname'],printtext=False,ipython_globals=self.__globals__)
        ###
        ###
        #Handle globals or user over-ride of arguments
        #
        if type(self.__call__.func_defaults) is NoneType:
            function_signature_defaults={}
	else:
	    function_signature_defaults=dict(zip(self.__call__.func_code.co_varnames[1:],self.__call__.func_defaults))
	useLocalDefaults = False

        for item in function_signature_defaults.iteritems():
                key,val = item
                keyVal = eval(key)
                if (keyVal == None):
                        #user hasn't set it - use global/default
                        pass
                else:
                        #user has set it - use over-ride
			if (key != 'self') :
			   useLocalDefaults = True

	myparams = {}
	if useLocalDefaults :
	   for item in function_signature_defaults.iteritems():
	       key,val = item
	       keyVal = eval(key)
	       exec('myparams[key] = keyVal')
	       self.parameters[key] = keyVal
	       if (keyVal == None):
	           exec('myparams[key] = '+ key + ' = self.itsdefault(key)')
		   keyVal = eval(key)
		   if(type(keyVal) == dict) :
                      if len(keyVal) > 0 :
		         exec('myparams[key] = ' + key + ' = keyVal[len(keyVal)-1][\'value\']')
		      else :
		         exec('myparams[key] = ' + key + ' = {}')
	 
        else :
            print ''

            myparams['vis'] = vis = self.parameters['vis']
            myparams['field'] = field = self.parameters['field']
            myparams['antenna'] = antenna = self.parameters['antenna']
            myparams['spw'] = spw = self.parameters['spw']
            myparams['observation'] = observation = self.parameters['observation']
            myparams['array'] = array = self.parameters['array']
            myparams['maxnpts'] = maxnpts = self.parameters['maxnpts']
            myparams['colors'] = colors = self.parameters['colors']
            myparams['symb'] = symb = self.parameters['symb']
            myparams['ncycles'] = ncycles = self.parameters['ncycles']
            myparams['figfile'] = figfile = self.parameters['figfile']

        if type(colors)==str: colors=[colors]

	result = None

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['vis'] = vis
        mytmp['field'] = field
        mytmp['antenna'] = antenna
        mytmp['spw'] = spw
        mytmp['observation'] = observation
        mytmp['array'] = array
        mytmp['maxnpts'] = maxnpts
        mytmp['colors'] = colors
        mytmp['symb'] = symb
        mytmp['ncycles'] = ncycles
        mytmp['figfile'] = figfile
	pathname='file://' + casa['dirs']['xml'] + '/'
	trec = casac.casac.utils().torecord(pathname+'plotuv.xml')

        casalog.origin('plotuv')
	try :
          #if not trec.has_key('plotuv') or not casac.casac.utils().verify(mytmp, trec['plotuv']) :
	    #return False

          casac.casac.utils().verify(mytmp, trec['plotuv'], True)
          scriptstr=['']
          saveinputs = self.__globals__['saveinputs']
          if type(self.__call__.func_defaults) is NoneType:
              saveinputs=''
          else:
              saveinputs('plotuv', 'plotuv.last', myparams, self.__globals__,scriptstr=scriptstr)
          tname = 'plotuv'
          spaces = ' '*(18-len(tname))
          casalog.post('\n##########################################'+
                       '\n##### Begin Task: ' + tname + spaces + ' #####')
          if type(self.__call__.func_defaults) is NoneType:
              casalog.post(scriptstr[0]+'\n', 'INFO')
          else :
              casalog.post(scriptstr[1][1:]+'\n', 'INFO')
          result = plotuv(vis, field, antenna, spw, observation, array, maxnpts, colors, symb, ncycles, figfile)
          casalog.post('##### End Task: ' + tname + '  ' + spaces + ' #####'+
                       '\n##########################################')

	except Exception, instance:
          if(self.__globals__.has_key('__rethrow_casa_exceptions') and self.__globals__['__rethrow_casa_exceptions']) :
             raise
          else :
             #print '**** Error **** ',instance
	     tname = 'plotuv'
             casalog.post('An error occurred running task '+tname+'.', 'ERROR')
             pass

        gc.collect()
        return result
#
#
#
    def paramgui(self, useGlobals=True, ipython_globals=None):
        """
        Opens a parameter GUI for this task.  If useGlobals is true, then any relevant global parameter settings are used.
        """
        import paramgui
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )

        if useGlobals:
	    if ipython_globals == None:
                myf=self.__globals__
            else:
                myf=ipython_globals

            paramgui.setGlobals(myf)
        else:
            paramgui.setGlobals({})

        paramgui.runTask('plotuv', myf['_ip'])
        paramgui.setGlobals({})

#
#
#
    def defaults(self, param=None, ipython_globals=None, paramvalue=None, subparam=None):
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
        if ipython_globals == None:
            myf=self.__globals__
        else:
            myf=ipython_globals

        a = odict()
        a['vis']  = ''
        a['field']  = ''
        a['antenna']  = ''
        a['spw']  = ''
        a['observation']  = ''
        a['array']  = ''
        a['maxnpts']  = 100000
        a['colors']  = ['r', 'y', 'g', 'b']
        a['symb']  = ','
        a['ncycles']  = 1
        a['figfile']  = ''


### This function sets the default values but also will return the list of
### parameters or the default value of a given parameter
        if(param == None):
                myf['__set_default_parameters'](a)
        elif(param == 'paramkeys'):
                return a.keys()
        else:
            if(paramvalue==None and subparam==None):
               if(a.has_key(param)):
                  return a[param]
               else:
                  return self.itsdefault(param)
            else:
               retval=a[param]
               if(type(a[param])==dict):
                  for k in range(len(a[param])):
                     valornotval='value'
                     if(a[param][k].has_key('notvalue')):
                        valornotval='notvalue'
                     if((a[param][k][valornotval])==paramvalue):
                        retval=a[param][k].copy()
                        retval.pop(valornotval)
                        if(subparam != None):
                           if(retval.has_key(subparam)):
                              retval=retval[subparam]
                           else:
                              retval=self.itsdefault(subparam)
		     else:
                        retval=self.itsdefault(subparam)
               return retval


#
#
    def check_params(self, param=None, value=None, ipython_globals=None):
      if ipython_globals == None:
          myf=self.__globals__
      else:
          myf=ipython_globals
#      print 'param:', param, 'value:', value
      try :
         if str(type(value)) != "<type 'instance'>" :
            value0 = value
            value = myf['cu'].expandparam(param, value)
            matchtype = False
            if(type(value) == numpy.ndarray):
               if(type(value) == type(value0)):
                  myf[param] = value.tolist()
               else:
                  #print 'value:', value, 'value0:', value0
                  #print 'type(value):', type(value), 'type(value0):', type(value0)
                  myf[param] = value0
                  if type(value0) != list :
                     matchtype = True
            else :
               myf[param] = value
            value = myf['cu'].verifyparam({param:value})
            if matchtype:
               value = False
      except Exception, instance:
         #ignore the exception and just return it unchecked
         myf[param] = value
      return value
#
#
    def description(self, key='plotuv', subkey=None):
        desc={'plotuv': 'Plot the baseline distribution',
               'vis': 'Name of input visibility file (MS)',
               'field': 'Select field using ID(s) or name(s)',
               'antenna': 'Select data based on antenna/baseline',
               'spw': 'Select spectral window/channels',
               'observation': 'Select by observation ID(s)',
               'array': 'Select (sub)array(s) by array ID number',
               'maxnpts': 'Maximum number of points per plot.',
               'colors': 'a list of matplotlib color codes',
               'symb': 'A matplotlib plot symbol code',
               'ncycles': 'How many times to cycle through colors per plot.',
               'figfile': 'Save the plotted figure(s) using this name',

              }

        if(desc.has_key(key)) :
           return desc[key]

    def itsdefault(self, paramname) :
        a = {}
        a['vis']  = ''
        a['field']  = ''
        a['antenna']  = ''
        a['spw']  = ''
        a['observation']  = ''
        a['array']  = ''
        a['maxnpts']  = 100000
        a['colors']  = ['r', 'y', 'g', 'b']
        a['symb']  = ','
        a['ncycles']  = 1
        a['figfile']  = ''

        #a = sys._getframe(len(inspect.stack())-1).f_globals

        if a.has_key(paramname) :
	      return a[paramname]
plotuv_cli = plotuv_cli_()
