#
# This file was generated using xslt from its XML file
#
# Copyright 2009, Associated Universities Inc., Washington DC
#
import sys
import os
from  casac import *
import string
from taskinit import casalog
from taskinit import xmlpath
#from taskmanager import tm
import task_plotuv
def plotuv(vis='', field='', antenna='', spw='', observation='', array='', maxnpts=100000, colors=['r', 'y', 'g', 'b'], symb=',', ncycles=1, figfile=''):

        """Plot the baseline distribution
    Plots the uv coverage of vis in klambda.  ncycles of colors will be
    allocated to representative wavelengths.

    Keyword arguments:
      vis -- Name of input visibility file
             default: none; example: vis='ngc5921.ms'

      --- Data Selection (see help par.selectdata for more detailed
          information)

       field -- Select field using field id(s) or field name(s).
                 [run listobs to obtain the list IDs or names]
              default: ''=all fields.  If field is a non-negative
              integer, it is assumed to be a field index.
              Otherwise, it is assumed to be a field name
              field='0~2'; field ids 0,1,2
              field='0,4,5~7'; field ids 0,4,5,6,7
              field='3C286,3C295'; fields named 3C286 and 3C295
              field = '3,4C*'; field id 3, all names starting with 4C
        antenna -- Select data based on antenna/baseline
                default: '' (all)
                Non-negative integers are assumed to be antenna indices, and
                anything else is taken as an antenna name.

                Examples:
                antenna='5&6': baseline between antenna index 5 and index 6.
                antenna='VA05&VA06': baseline between VLA antenna 5 and 6.
                antenna='5&6;7&8': baselines 5-6 and 7-8
                antenna='5': all baselines with antenna 5
                antenna='5,6,10': all baselines including antennas 5, 6, or 10
                antenna='5,6,10&': all baselines with *only* antennas 5, 6, or
                                       10.  (cross-correlations only.  Use &&
                                       to include autocorrelations, and &&&
                                       to get only autocorrelations.)
                antenna='!ea03,ea12,ea17': all baselines except those that
                                           include EVLA antennas ea03, ea12, or
                                           ea17.
       spw -- Select spectral windows.  Channel selection is ignored for now.
              default: ''=all spectral windows
              spw='0~2,4'; spectral windows 0,1,2,4
              spw='<2';  spectral windows less than 2 (i.e. 0,1)
              spw='0'; spw 0
              spw='0,10,3'; spws 0, 10, and 3
       observation -- Select by observation ID(s). default: '' = all
       array -- (Sub)array number range. default: ''=all

      maxnpts -- Save memory and/or screen space by plotting a maximum of maxnpts
                 (or all of them if maxnpts < 1).  There is a very sharp
                 slowdown if the plotter starts swapping.
                 default: 100000
      colors -- a list of matplotlib color codes, used in order of decreasing
                visibility wavelength.
                default: ['r', 'y', 'g', 'b']  (red, yellow, green, blue)
      symb -- One of matplotlib's codes for plot symbols: .:,o^v<>s+xDd234hH|_
              default: ',':  The smallest points I could find.
      ncycles -- The number of times colors will be cycled through per plot.
                 default: 1
      figfile -- If not '', save the plots using names based on figfile.
                 Example: if figfile is 'test.png', and field is '1,2,4', the plots
		          will be saved to test_fld1.png, test_fld2.png,
			  and test_fld4.png.
                 default: '' (Do not save)
    
        """
        if type(colors)==str: colors=[colors]

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['vis'] = vis
        mytmp['field'] = field
        mytmp['antenna'] = antenna
        mytmp['spw'] = spw
        mytmp['observation'] = observation
        mytmp['array'] = array
        mytmp['maxnpts'] = maxnpts
        mytmp['colors'] = colors
        mytmp['symb'] = symb
        mytmp['ncycles'] = ncycles
        mytmp['figfile'] = figfile
	pathname='file://' + xmlpath( ) + '/'
	trec = casac.utils().torecord(pathname+'plotuv.xml')

        casalog.origin('plotuv')
        if trec.has_key('plotuv') and casac.utils().verify(mytmp, trec['plotuv']) :
	    result = task_plotuv.plotuv(vis, field, antenna, spw, observation, array, maxnpts, colors, symb, ncycles, figfile)

	else :
	  result = False
        return result
