#
# This file was generated using xslt from its XML file
#
# Copyright 2009, Associated Universities Inc., Washington DC
#
import sys
import os
from  casac import *
import string
from taskinit import casalog
from taskinit import xmlpath
#from taskmanager import tm
import task_oldsplit
def oldsplit(vis='', outputvis='', datacolumn='corrected', field='', spw='', width=1, antenna='', timebin='0s', timerange='', scan='', intent='', array='', uvrange='', correlation='', observation='', combine='', keepflags=True, keepmms=False):

        """Create a visibility subset from an existing visibility set

        Keyword arguments:
        vis -- Name of input visibility file
                default: none; example: vis='ngc5921.ms'
        outputvis -- Name of output visibility file
                default: none; example: outputvis='ngc5921_src.ms'

        datacolumn -- Which data column to split out
                default='corrected'; example: datacolumn='data'
                Options: 'data', 'model', 'corrected', 'all',
                'float_data', 'lag_data', 'float_data,data', and
                'lag_data,data'.
                N.B.: 'all' = whichever of the above that are present.
                Otherwise the selected column will go to DATA (or
                FLOAT_DATA) in the output.
                Splitting with the default datacolumn='corrected'
                before clean is normally required for self-calibration!

        --- Data Selection (see help par.selectdata for more detailed
            information)

        field -- Select field using field id(s) or field name(s).
                  [run listobs to obtain the list id's or names]
               default: ''=all fields If field string is a non-negative
               integer, it is assumed to be a field index
               otherwise, it is assumed to be a field name
               field='0~2'; field ids 0,1,2
               field='0,4,5~7'; field ids 0,4,5,6,7
               field='3C286,3C295'; fields named 3C286 and 3C295
               field = '3,4C*'; field id 3, all names starting with 4C
        spw -- Select spectral window/channels
               default: ''=all spectral windows and channels
               spw='0~2,4'; spectral windows 0,1,2,4 (all channels)
               spw='<2';  spectral windows less than 2 (i.e. 0,1)
               spw='0:5~61'; spw 0, channels 5 to 61
               spw='0,10,3:3~45'; spw 0,10 all channels, spw 3 - chans 3 to 45.
               spw='0~2:2~6'; spw 0,1,2 with channels 2 through 6 in each.
               spw = '*:3~64'  channels 3 through 64 for all sp id's
                       spw = ' :3~64' will NOT work.
               Oldsplit does not support multiple channel ranges per spectral
               window (';') because it is not clear whether to keep the ranges
               in the original spectral window or make a new spectral window
               for each additional range.
	width -- Defines the number of channel to average to form the one
	         output channel.
		 default: '1' => no channel averaging
		 example: width=[2,3] => average 2 channels of 1st
		          spectral window selected and 3 in the second one.
        antenna -- Select data based on antenna/baseline
               default: '' (all)
                Non-negative integers are assumed to be antenna indices, and
                anything else is taken as an antenna name.

                Examples:
                antenna='5&6': baseline between antenna index 5 and index 6.
                antenna='VA05&VA06': baseline between VLA antenna 5 and 6.
                antenna='5&6;7&8': baselines 5-6 and 7-8
                antenna='5': all baselines with antenna 5
                antenna='5,6,10': all baselines including antennas 5, 6, or 10
                antenna='5,6,10&': all baselines with *only* antennas 5, 6, or
                                       10.  (cross-correlations only.  Use &&
                                       to include autocorrelations, and &&&
                                       to get only autocorrelations.)
                antenna='!ea03,ea12,ea17': all baselines except those that
                                           include EVLA antennas ea03, ea12, or
                                           ea17.
        timebin -- Interval width for time averaging.
                   default: '0s' or '-1s' (no averaging)
                   example: timebin='30s'
                            '10' means '10s'
        timerange -- Select data based on time range:
               default = '' (all); examples,
               timerange = 'YYYY/MM/DD/hh:mm:ss~YYYY/MM/DD/hh:mm:ss'
               Note: if YYYY/MM/DD is missing date, timerange defaults to the
               first day in the dataset
               timerange='09:14:0~09:54:0' picks 40 min on first day
               timerange='25:00:00~27:30:00' picks 1 hr to 3 hr 30min
               on next day
               timerange='09:44:00' data within one integration of time
               timerange='>10:24:00' data after this time
        array -- (Sub)array number range
            default: ''=all
	uvrange -- Select data within uvrange (default units meters)
            default: ''=all; example:
            uvrange='0~1000klambda'; uvrange from 0-1000 kilo-lambda
            uvrange='>4klambda';uvranges greater than 4 kilo-lambda
            uvrange='0~1000km'; uvrange in kilometers
	scan -- Scan number range
            default: ''=all
        intent -- Select by scan intent (state).  Case sensitive.
            default: '' = all
            Examples:
            intent = 'CALIBRATE_ATMOSPHERE_REFERENCE'
            intent = 'calibrate_atmosphere_reference'.upper() # same as above
            # Select states that include one or both of CALIBRATE_WVR.REFERENCE
            # or OBSERVE_TARGET_ON_SOURCE.
            intent = 'CALIBRATE_WVR.REFERENCE, OBSERVE_TARGET_ON_SOURCE'
        correlation -- Select correlations, e.g. 'rr, ll' or ['XY', 'YX'].
                       default '' (all).
        observation -- Select by observation ID(s).
                       default: '' = all
        combine -- Let time bins span changes in scan and/or state.
                   default = '' (separate time bins by both of the above)
                   combine = 'scan': Can be useful when the scan number
                                     goes up with each integration,
                                     as in many WSRT MSes.
                   combine = ['scan', 'state']: disregard scan and state
                                                numbers when time averaging.
                   combine = 'state,scan': Same as above.
        keepflags -- If practical, keep completely flagged rows instead of
                     dropping them.  This has absolutely no effect on averaging
                     calculations, or partially flagged rows.  All of the
                     channels and correlations of a row must be flagged for it
                     to be droppable, and a row must be well defined to be
                     keepable.  The latter condition means that this option has
                     no effect on time averaging - in that case fully flagged
                     rows are automatically omitted.  Regardless of this
                     parameter, flagged data is never included in averaging
                     calculations.

                     The only time keepflags matters is if 
                     1. the input MS has some completely flagged rows
                     and
                     2. time averaging is not being done.

                     Then, if keepflags is False, the completely flagged rows
                     will be omitted from the output MS.  Otherwise, they will
                     be included (subject to the selection parameters).

        keepmms -- If true and the input is a multi-MS, make the output one, too.
	           Otherwise, the output will be a normal MS without partitioning. 
		   (experimental)
                   Default: False


        """

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['vis'] = vis
        mytmp['outputvis'] = outputvis
        mytmp['datacolumn'] = datacolumn
        mytmp['field'] = field
        mytmp['spw'] = spw
        mytmp['width'] = width
        mytmp['antenna'] = antenna
        mytmp['timebin'] = timebin
        mytmp['timerange'] = timerange
        mytmp['scan'] = scan
        mytmp['intent'] = intent
        mytmp['array'] = array
        mytmp['uvrange'] = uvrange
        mytmp['correlation'] = correlation
        mytmp['observation'] = observation
        mytmp['combine'] = combine
        mytmp['keepflags'] = keepflags
        mytmp['keepmms'] = keepmms
	pathname='file://' + xmlpath( ) + '/'
	trec = casac.utils().torecord(pathname+'oldsplit.xml')

        casalog.origin('oldsplit')
        if trec.has_key('oldsplit') and casac.utils().verify(mytmp, trec['oldsplit']) :
	    result = task_oldsplit.oldsplit(vis, outputvis, datacolumn, field, spw, width, antenna, timebin, timerange, scan, intent, array, uvrange, correlation, observation, combine, keepflags, keepmms)

	else :
	  result = False
        return result
