#
# This file was generated using xslt from its XML file
#
# Copyright 2008, Associated Universities Inc., Washington DC
#
import sys
import os
from casac import *
import string
import time
from casa_stack_manip import stack_frame_find
import gc
import numpy
from odict import odict
from task_mosaic import mosaic
from taskinit import casalog
from taskinit import xmlpath
class mosaic_pg_:
    __name__ = "mosaic"

    def __init__(self) :
       self.__bases__ = (mosaic_pg_,)
       self.__doc__ = self.__call__.__doc__


    def __call__(self, vis=None,imagename=None,mode=None,alg=None,imsize=None,cell=None,phasecenter=None,stokes=None,niter=None,gain=None,threshold=None,mask=None,cleanbox=None,nchan=None,start=None,width=None,field=None,spw=None,timerange=None,restfreq=None,sdimage=None,modelimage=None,weighting=None,mosweight=None,rmode=None,robust=None,ftmachine=None,cyclefactor=None,cyclespeedup=None,scaletype=None,minpb=None,sigma=None,targetflux=None,constrainflux=None,prior=None,negcomponent=None,scales=None,npercycle=None,npixels=None,noise=None,):

        myf=stack_frame_find( )
        myf['__last_task'] = 'mosaic'
        myf['taskname'] = 'mosaic'
        ###
        myf['update_params'](func=myf['taskname'],printtext=False)
        ###
        ###
        #Handle globals or user over-ride of arguments
        #
	function_signature_defaults=dict(zip(self.__call__.func_code.co_varnames,self.__call__.func_defaults))
	useLocalDefaults = False

        for item in function_signature_defaults.iteritems():
                key,val = item
                keyVal = eval(key)
                if (keyVal == None):
                        #user hasn't set it - use global/default
                        pass
                else:
                        #user has set it - use over-ride
			if (key != 'self') :
			   useLocalDefaults = True
                        #myf[key]=keyVal

	myparams = {}
	if useLocalDefaults :
	   for item in function_signature_defaults.iteritems():
	       key,val = item
	       keyVal = eval(key)
	       exec('myparams[key] = keyVal')
	       if (keyVal == None):
	           exec('myparams[key] = '+ key + ' = self.itsdefault(key)')
		   keyVal = eval(key)
		   if(type(keyVal) == dict) :
                      if len(keyVal) > 0 :
		         exec('myparams[key] = ' + key + ' = keyVal[len(keyVal)-1][\'value\']')
		      else :
		         exec('myparams[key] = ' + key + ' = {}')

	else :
            uselessvariable = None 
            myparams['vis'] = vis = myf['vis']
            myparams['imagename'] = imagename = myf['imagename']
            myparams['mode'] = mode = myf['mode']
            myparams['alg'] = alg = myf['alg']
            myparams['imsize'] = imsize = myf['imsize']
            myparams['cell'] = cell = myf['cell']
            myparams['phasecenter'] = phasecenter = myf['phasecenter']
            myparams['stokes'] = stokes = myf['stokes']
            myparams['niter'] = niter = myf['niter']
            myparams['gain'] = gain = myf['gain']
            myparams['threshold'] = threshold = myf['threshold']
            myparams['mask'] = mask = myf['mask']
            myparams['cleanbox'] = cleanbox = myf['cleanbox']
            myparams['nchan'] = nchan = myf['nchan']
            myparams['start'] = start = myf['start']
            myparams['width'] = width = myf['width']
            myparams['field'] = field = myf['field']
            myparams['spw'] = spw = myf['spw']
            myparams['timerange'] = timerange = myf['timerange']
            myparams['restfreq'] = restfreq = myf['restfreq']
            myparams['sdimage'] = sdimage = myf['sdimage']
            myparams['modelimage'] = modelimage = myf['modelimage']
            myparams['weighting'] = weighting = myf['weighting']
            myparams['mosweight'] = mosweight = myf['mosweight']
            myparams['rmode'] = rmode = myf['rmode']
            myparams['robust'] = robust = myf['robust']
            myparams['ftmachine'] = ftmachine = myf['ftmachine']
            myparams['cyclefactor'] = cyclefactor = myf['cyclefactor']
            myparams['cyclespeedup'] = cyclespeedup = myf['cyclespeedup']
            myparams['scaletype'] = scaletype = myf['scaletype']
            myparams['minpb'] = minpb = myf['minpb']
            myparams['sigma'] = sigma = myf['sigma']
            myparams['targetflux'] = targetflux = myf['targetflux']
            myparams['constrainflux'] = constrainflux = myf['constrainflux']
            myparams['prior'] = prior = myf['prior']
            myparams['negcomponent'] = negcomponent = myf['negcomponent']
            myparams['scales'] = scales = myf['scales']
            myparams['npercycle'] = npercycle = myf['npercycle']
            myparams['npixels'] = npixels = myf['npixels']
            myparams['noise'] = noise = myf['noise']

        if type(imsize)==int: imsize=[imsize]
        if type(cell)==float: cell=[cell]
        if type(mask)==str: mask=[mask]
        if type(prior)==str: prior=[prior]
        if type(scales)==int: scales=[scales]

	result = None

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['vis'] = vis
        mytmp['imagename'] = imagename
        mytmp['mode'] = mode
        mytmp['alg'] = alg
        mytmp['imsize'] = imsize
        if type(cell) == str :
           mytmp['cell'] = casac.quanta().quantity(cell)
        else :
           mytmp['cell'] = cell
        mytmp['phasecenter'] = phasecenter
        mytmp['stokes'] = stokes
        mytmp['niter'] = niter
        mytmp['gain'] = gain
        mytmp['threshold'] = threshold
        mytmp['mask'] = mask
        mytmp['cleanbox'] = cleanbox
        mytmp['nchan'] = nchan
        mytmp['start'] = start
        mytmp['width'] = width
        mytmp['field'] = field
        mytmp['spw'] = spw
        mytmp['timerange'] = timerange
        mytmp['restfreq'] = restfreq
        mytmp['sdimage'] = sdimage
        mytmp['modelimage'] = modelimage
        mytmp['weighting'] = weighting
        mytmp['mosweight'] = mosweight
        mytmp['rmode'] = rmode
        mytmp['robust'] = robust
        mytmp['ftmachine'] = ftmachine
        mytmp['cyclefactor'] = cyclefactor
        mytmp['cyclespeedup'] = cyclespeedup
        mytmp['scaletype'] = scaletype
        mytmp['minpb'] = minpb
        if type(sigma) == str :
           mytmp['sigma'] = casac.quanta().quantity(sigma)
        else :
           mytmp['sigma'] = sigma
        if type(targetflux) == str :
           mytmp['targetflux'] = casac.quanta().quantity(targetflux)
        else :
           mytmp['targetflux'] = targetflux
        mytmp['constrainflux'] = constrainflux
        mytmp['prior'] = prior
        mytmp['negcomponent'] = negcomponent
        mytmp['scales'] = scales
        mytmp['npercycle'] = npercycle
        mytmp['npixels'] = npixels
        if type(noise) == str :
           mytmp['noise'] = casac.quanta().quantity(noise)
        else :
           mytmp['noise'] = noise
	pathname='file://' + xmlpath( ) + '/'
	trec = casac.utils().torecord(pathname+'mosaic.xml')

        casalog.origin('mosaic')
        if not trec.has_key('mosaic') or not casac.utils().verify(mytmp, trec['mosaic']) :
	    return False


	try :
          casalog.post('')
          casalog.post('##########################################')
          casalog.post('##### Begin Task: mosaic           #####')
          casalog.post('')
          result = mosaic(vis, imagename, mode, alg, imsize, cell, phasecenter, stokes, niter, gain, threshold, mask, cleanbox, nchan, start, width, field, spw, timerange, restfreq, sdimage, modelimage, weighting, mosweight, rmode, robust, ftmachine, cyclefactor, cyclespeedup, scaletype, minpb, sigma, targetflux, constrainflux, prior, negcomponent, scales, npercycle, npixels, noise)
          casalog.post('')
          casalog.post('##### End Task: mosaic           #####')
          casalog.post('##########################################')


# saveinputs for individule engine has no use
# saveinputs should alos be removed from casa_in_py.py
#
#
#          saveinputs = myf['saveinputs']
#          saveinputs('mosaic', 'mosaic.last', myparams)
#
#
	except Exception, instance:
	  if(myf.has_key('__rethrow_casa_exceptions') and myf['__rethrow_casa_exceptions']) :
	     raise
	  else:
	     tname = 'mosaic'
	     casalog.post('An error occurred running task %s: %s' % (tname,instance), 'ERROR')
	     pass

        gc.collect()
        return result
#
#
##
#    def paramgui(self, useGlobals=True):
#        """
#        Opens a parameter GUI for this task.  If useGlobals is true, then any relevant global parameter settings are used.
#        """
#        import paramgui
#
#        myf = stack_frame_find( )
#
#        if useGlobals:
#            paramgui.setGlobals(myf)
#        else:
#            paramgui.setGlobals({})
#
#        paramgui.runTask('mosaic', myf['_ip'])
#        paramgui.setGlobals({})
#
#
#
#
    def defaults(self, param=None):
        myf=stack_frame_find( )
        a = odict()
        a['vis']  = ''
        a['imagename']  = ''
        a['mode']  = 'mfs'
        a['alg']  = 'clark'
        a['imsize']  = [256, 256]
        a['cell']  = ['1.0arcsec', '1.0arcsec']
        a['phasecenter']  = ''
        a['stokes']  = 'I'
        a['niter']  = 500
        a['gain']  = 0.1
        a['threshold']  = 0.0
        a['mask']  = ['']
        a['cleanbox']  = []
        a['field']  = ''
        a['spw']  = ''
        a['timerange']  = ''
        a['restfreq']  = ''
        a['sdimage']  = ''
        a['modelimage']  = ''
        a['weighting']  = 'natural'
        a['mosweight']  = False
        a['ftmachine']  = 'mosaic'
        a['cyclefactor']  = 1.5
        a['cyclespeedup']  = -1
        a['scaletype']  = 'SAULT'
        a['minpb']  = 0.1

        a['mode'] = {
                    0:{'value':'mfs'}, 
                    1:odict([{'value':'channel'}, {'nchan':1}, {'start':0}, {'width':1}]), 
                    2:odict([{'value':'velocity'}, {'nchan':1}, {'start':'0.0km/s'}, {'width':'1km/s'}]), 
                    3:odict([{'value':'frequency'}, {'nchan':1}, {'start':'1.4GHz'}, {'width':'10kHz'}])}
        a['alg'] = {
                    0:{'value':'clark'}, 
                    1:{'value':'hogbom'}, 
                    2:odict([{'value':'multiscale'}, {'scales':[0, 3, 10]}, {'negcomponent':2}]), 
                    3:odict([{'value':'entropy'}, {'sigma':0.01}, {'targetflux':1.0}, {'constrainflux':False}, {'prior':['']}]), 
                    4:{'value':'emptiness'}}
        a['weighting'] = {
                    0:{'value':'natural'}, 
                    1:{'value':'uniform'}, 
                    2:odict([{'value':'briggs'}, {'rmode':'none'}, {'robust':0.0}, {'noise':0.0}, {'npixels':0}]), 
                    3:odict([{'value':'superuniform'}, {'npixels':0}])}
        a['cleanbox'] = {
                    0:{'value':[]}, 
                    1:odict([{'value':'interactive'}, {'npercycle':100}])}

### This function sets the default values but also will return the list of
### parameters or the default value of a given parameter
        if(param == None):
                myf['__set_default_parameters'](a)
        elif(param == 'paramkeys'):
                return a.keys()
        else:
	        if(a.has_key(param)):
		   #if(type(a[param]) == dict) :
		   #   return a[param][len(a[param])-1]['value']
	   	   #else :
		      return a[param]


#
#
    def check_params(self, param=None, value=None):
      myf=stack_frame_find( )

#      print 'param:', param, 'value:', value
      try :
         if str(type(value)) != "<type 'instance'>" :
            value0 = value
            value = myf['cu'].expandparam(param, value)
            matchtype = False
            if(type(value) == numpy.ndarray):
               if(type(value) == type(value0)):
                  myf[param] = value.tolist()
               else:
                  #print 'value:', value, 'value0:', value0
                  #print 'type(value):', type(value), 'type(value0):', type(value0)
                  myf[param] = value0
                  if type(value0) != list :
                     matchtype = True
            else :
               myf[param] = value
            value = myf['cu'].verifyparam({param:value})
            if matchtype:
               value = False
      except Exception, instance:
         #ignore the exception and just return it unchecked
         myf[param] = value
      return value

#
#
    def itsdefault(self, paramname) :
        a = {}
        a['vis']  = ''
        a['imagename']  = ''
        a['mode']  = 'mfs'
        a['alg']  = 'clark'
        a['imsize']  = [256, 256]
        a['cell']  = ['1.0arcsec', '1.0arcsec']
        a['phasecenter']  = ''
        a['stokes']  = 'I'
        a['niter']  = 500
        a['gain']  = 0.1
        a['threshold']  = 0.0
        a['mask']  = ['']
        a['cleanbox']  = []
        a['nchan']  = 1
        a['start']  = 0
        a['width']  = 1
        a['field']  = ''
        a['spw']  = ''
        a['timerange']  = ''
        a['restfreq']  = ''
        a['sdimage']  = ''
        a['modelimage']  = ''
        a['weighting']  = 'natural'
        a['mosweight']  = False
        a['rmode']  = 'norm'
        a['robust']  = 0.0
        a['ftmachine']  = 'mosaic'
        a['cyclefactor']  = 1.5
        a['cyclespeedup']  = -1
        a['scaletype']  = 'SAULT'
        a['minpb']  = 0.1
        a['sigma']  = '0.001Jy'
        a['targetflux']  = '1.0Jy'
        a['constrainflux']  = False
        a['prior']  = ['']
        a['negcomponent']  = 2
        a['scales']  = [0, 3, 10]
        a['npercycle']  = 100
        a['npixels']  = 0
        a['noise']  = '0.0Jy'

        if a.has_key(paramname) :
	      return a[paramname]
mosaic_pg = mosaic_pg_()
