#
# This file was generated using xslt from its XML file
#
# Copyright 2014, Associated Universities Inc., Washington DC
#
import sys
import os
#from casac import *
import casac
import string
import time
import inspect
import gc
import numpy
from casa_stack_manip import stack_frame_find
from odict import odict
from types import * 
from task_mosaic import mosaic
class mosaic_cli_:
    __name__ = "mosaic"
    rkey = None
    i_am_a_casapy_task = None
    # The existence of the i_am_a_casapy_task attribute allows help()
    # (and other) to treat casapy tasks as a special case.

    def __init__(self) :
       self.__bases__ = (mosaic_cli_,)
       self.__doc__ = self.__call__.__doc__

       self.parameters={'vis':None, 'imagename':None, 'mode':None, 'alg':None, 'imsize':None, 'cell':None, 'phasecenter':None, 'stokes':None, 'niter':None, 'gain':None, 'threshold':None, 'mask':None, 'cleanbox':None, 'nchan':None, 'start':None, 'width':None, 'field':None, 'spw':None, 'timerange':None, 'restfreq':None, 'sdimage':None, 'modelimage':None, 'weighting':None, 'mosweight':None, 'rmode':None, 'robust':None, 'ftmachine':None, 'cyclefactor':None, 'cyclespeedup':None, 'scaletype':None, 'minpb':None, 'sigma':None, 'targetflux':None, 'constrainflux':None, 'prior':None, 'negcomponent':None, 'scales':None, 'npercycle':None, 'npixels':None, 'noise':None, }


    def result(self, key=None):
	    #### and add any that have completed...
	    return None


    def __call__(self, vis=None, imagename=None, mode=None, alg=None, imsize=None, cell=None, phasecenter=None, stokes=None, niter=None, gain=None, threshold=None, mask=None, cleanbox=None, nchan=None, start=None, width=None, field=None, spw=None, timerange=None, restfreq=None, sdimage=None, modelimage=None, weighting=None, mosweight=None, rmode=None, robust=None, ftmachine=None, cyclefactor=None, cyclespeedup=None, scaletype=None, minpb=None, sigma=None, targetflux=None, constrainflux=None, prior=None, negcomponent=None, scales=None, npercycle=None, npixels=None, noise=None, ):

        """Create a multi-field deconvolved image with selected algorithm

	Detailed Description: 
Form images from visibilities. Handles continuum and spectral line cubes.
	Arguments :
		vis:	name of input visibility file
		   Default Value: 

		imagename:	Pre-name of output images
		   Default Value: 

		mode:	Type of selection (mfs, channel, velocity, frequency)
		   Default Value: mfs
		   Allowed Values:
				mfs
				channel
				velocity
				frequency

		alg:	Algorithm to use (clark, hogbom, multiscale) 
		   Default Value: clark
		   Allowed Values:
				clark
				hogbom
				multiscale
				entropy

		imsize:	Image size in pixels (nx,ny), symmetric for single value
		   Default Value: 
    256256
	    

		cell:	The image cell size in arcseconds [x,y]. 
		   Default Value: 1.01.0

		phasecenter:	Field Identififier or direction of the image phase center
		   Default Value: 

		stokes:	Stokes params to image (I,IV,QU,IQUV,RR,LL,XX,YY,RRLL,XXYY)
		   Default Value: I
		   Allowed Values:
				I
				IV
				QU
				IQUV
				RR
				LL
				RRLL
				XX
				YY
				XXYY

		niter:	Maximum number of iterations
		   Default Value: 500

		gain:	Loop gain for cleaning
		   Default Value: 0.1

		threshold:	Flux level to stop cleaning (unit mJy assumed)
		   Default Value: 0.0

		mask:	Set of mask images used in cleaning
		   Default Value: 

		cleanbox:	clean box regions or file name or \'interactive\'
		   Default Value: 

		nchan:	Number of channels in output image
		   Default Value: 1

		start:	Start channel
		   Default Value: 0

		width:	Channel width (value > 1 indicates channel averaging)
		   Default Value: 1

		field:	Field Name
		   Default Value: 

		spw:	Spectral windows:channels: \'\' is all 
		   Default Value: 

		timerange:	Range of time to select from data
		   Default Value: 

		restfreq:	rest frequency to use in image
		   Default Value: 

		sdimage:	Input single dish image to use for model
		   Default Value: 

		modelimage:	Name of output(/input) model image
		   Default Value: 

		weighting:	Weighting to apply to visibilities
		   Default Value: natural
		   Allowed Values:
				natural
				uniform
				briggs
				radial
				superuniform

		mosweight:	Individually weight the fields of the mosaic
		   Default Value: False

		rmode:	Robustness mode (for Briggs weightting)
		   Default Value: norm
		   Allowed Values:
				none
				norm
				abs

		robust:	Briggs robustness parameter
		   Default Value: 0.0
		   Allowed Values:
				-2.0
				2.0

		ftmachine:	Gridding method for the image
		   Default Value: mosaic
		   Allowed Values:
				ft
				sd
				both
				mosaic

		cyclefactor:	Threshold for minor/major cycles (see pdoc)
		   Default Value: 1.5

		cyclespeedup:	Cycle threshold doubles in this number of iterations
		   Default Value: -1

		scaletype:	Controls scaling of pixels in the image plane
		   Default Value: SAULT
		   Allowed Values:
				PBCOR
				SAULT

		minpb:	Minimum PB level to use
		   Default Value: 0.1

		sigma:	Target image sigma
		   Default Value: 0.001

		targetflux:	Target flux for final image
		   Default Value: 1.0

		constrainflux:	Constrain image to match target flux 
		   Default Value: False

		prior:	Name of MEM prior images
		   Default Value: 

		negcomponent:	Stop the component search when the largest scale has found this number of negative components
		   Default Value: 2

		scales:	resolutions in pixel units
		   Default Value: 
	    0310
    

		npercycle:	Number of iterations before interactive masking prompt
		   Default Value: 100

		npixels:	number of pixels to determine cell size for superuniform or briggs weighting
		   Default Value: 0

		noise:	noise parameter for briggs weighting when rmode=\'abs\'
		   Default Value: 0.0

	Returns: void

	Example :



    Two types of point-source deconvolution, as well as multi-scale
    deconvolution, are available.  A continuum image (mfs) is produced
    by gridding together all spectral data.   Individual channels or
    groups of channels can also be images and then placed in an output
    image cube.

    The cleaning regions can be specified by an input mask image, from a
    file containing rectangular regions, or interactively as the
    deconvolution progresses.

    The mosaic task only uses the "corrected" datacolumn which is made
    from the "data" data column using applycal with the appropriate
    calibration tables.  Many Stokes combinations are available.


    Keyword arguments:
    vis -- Name of input visibility file
            default: none; example: vis='ngc5921.ms'
    imagename -- Pre-name of output images:
            default: none; example: imagename='m2'
            output images are:
              m2.image; cleaned and restored image
              m2.flux;  relative sky sensitivity over field
              m2.model; image of clean components
              m2.residual; image of residuals
              m2.interactive.mask; image containing clean regions
    mode -- Frequency Specification:
	    NOTE: See examples below:
            default: 'mfs'
              mode = 'mfs' means produce one image from all specified data.
              mode = 'channel'; Use with nchan, start, width to specify
                      output image cube.  See examples below
              mode = 'velocity', means channels are specified in velocity.
	      mode = 'frequency', means channels are specified in frequency.
       >>> mode expandable parameters (for modes other than 'mfs')
            Start, width are given in units of channels, frequency or velocity
               as indicated by mode, but only channel is complete.
            nchan -- Number of channels (planes) in output image
              default: 1; example: nchan=3
            start -- Start input channel (relative-0)
              default=0; example: start=5
            width -- Output channel width (>1 indicates channel averaging)
              default=1; example: width=4
        examples:
            spw = '0,1'; mode = 'mfs'
               will produce one image made from all channels in spw 0 and 1
            spw='0:5~28^2'; mode = 'mfs' 
               will produce one image made with channels (5,7,9,...,25,27)
            spw = '0'; mode = 'channel': nchan=3; start=5; width=4
               will produce an image with 3 output planes
               plane 1 contains data from channels (5+6+7+8)
               plane 2 contains data from channels (9+10+11+12)
               plane 3 contains data from channels (13+14+15+16)
            spw = '0:0~63^3'; mode=chann; nchan=21; start = 0; width = 1
               will produce an image with 20 output planes
               Plane 1 contains data from channel 0
               Plane 2 contains date from channel 2
               Plane 21 contains data from channel 61
            spw = '0:0~40^2'; mode = 'channel'; nchan = 3; start = 5; width = 4
               will produce an image with three output planes
               plane 1 contains channels (5,7)
               plane 2 contains channels (13,15)
               plane 3 contains channels (21,23)
    alg -- Algorithm to use (expandable):
            default: 'clark': Options: 'clark','hogbom','multiscale','entropy'
            'hogbom' Cleans from the images only.  Only inner quarter
		     of image is cleaned
            'clark' Cleans from gridded us data.  Only inner quarter of
		    image is cleaned
            'multiscale' cleans with several resolutions using hobgom clean
                  Currently much slower than single resolution. For extended 
		  sources, try single resolution with interactive and
            'entropy' Maximum entropy algorithm is still experimental
		  and not recommended for general use
      >>> multiscale expandable parameter
            scales  -- in pixel numbers; the size of component to deconvolve
                  default = [0,3,10]
                   recommended sizes are 0 (point), 3 (points per clean beam), and
                    10 (about a factor of three lower resolution)
            negcomponent' -- Stop component search when the largest
	          scale has found this number of negative components; -1 means
	          continue component search even if the largest component is 
	          negative.
                  default: 2; example: negcomponent=-1
      >>> entropy (MEM) expandable parameters (experimental)
	    sigma -- Target image sigma
                  default: '0.001Jy'; example: sigma='0.1Jy'
            targetflux -- Target flux for final image
                  default: '1.0Jy'; example: targetflux='200Jy'
            constrainflux -- Constrain image to match target flux;
                  otherwise, targetflux is used to initialize model only.   
                       default: False; example: constrainflux=True
            prior -- Name of MEM prior images
                  default: ['']; example: prior='source_mem.image'
    imsize -- Image pixel size (x,y)
            default = [256,256]; example: imsize=[350,350]
            imsize = 500 is equivalent to [500,500]
    cell -- Cell size (x,y)
            default= none;
            example: cell=['0.5arcsec,'0.5arcsec'] or
            cell=['1arcmin', '1arcmin']
            cell = '1arcsec' is equivalent to ['1arcsec','1arcsec']
	    NOTE:cell = '2' makes default cell size of 2 radians! 
    phasecenter -- direction measure  or fieldid for the mosaic center
            default: 0 (imply field=0 as center); example: phasecenter=6
            or phasecenter='J2000 19h30m00 -40d00m00'
    stokes -- Stokes parameters to image
            default='I'; example: stokes='IQUV';
            Options: 'I','IV''QU','IQUV','RR','LL','XX','YY','RRLL','XXYY'
    niter -- Maximum number iterations, set to zero for no CLEANing
            default: 500; example: niter=500
    gain -- Loop gain for CLEANing
            default: 0.1; example: gain=0.5
    threshold -- Flux level at which to stop CLEANing (units=mJy)
            default: 0.0; example: threshold=0.0  
    mask -- Name of mask image used for CLEANing
            default '' means no mask;
              example: mask='orion.mask'.  
	    It is useful to use a mask from a previous interactive mosaic 
	    session for a new execution.  The mask image shape
            must be the same as the new mosaic.
    cleanbox -- Cleaning region:
            default: [] defaults to inner quarter of image
            Three specification types:
            (a) 'interactive' allows the user to build the cleaning
                 mask interactively using the viewer.  The viewer will 
                 appear every npercycle interation, but modify as needed
		 The final interactive maks is saved in the file
		 imagename_interactive.mask.
            (b) Explicit pixel ranges
                example: cleanbox=[110,110,150,145]
                clean region with blc=110,100; trc=150,145 (pixel values)
                Only one clean region can be given this way.
            (c) Filename with pixel values with ascii format:
                <fieldindex blc-x blc-y trc-x trc-y> on each line
                1  45  66  123 124
                2  23 100  300 340
      >>> 'interactive' expandable parameter 
            npercycle -- this is the number of iterations between each clean 
	    to update mask interactively. Set to about niter/5, can also
            be changed interactively.               
    field -- Select fields in mosaic.  Use field id(s) or field name(s).
               ['go listobs' to obtain the list id's or names]
           default: ''=all fields
           If field string is a non-negative integer, it is assumed to
               be a field index otherwise, it is assumed to be a field name
           field='0~2'; field ids 0,1,2
           field='0,4,5~7'; field ids 0,4,5,6,7
           field='3C286,3C295'; field named 3C286 and 3C295
           field = '3,4C*'; field id 3, all names starting with 4C
    spw -- Select spectral window/channels
	   NOTE: This selects the data passed as the INPUT to mode
           default: ''=all spectral windows and channels
             spw='0~2,4'; spectral windows 0,1,2,4 (all channels)
             spw='<2';  spectral windows less than 2 (i.e. 0,1)
             spw='0:5~61'; spw 0, channels 5 to 61
             spw='0,10,3:3~45'; spw 0,10 all channels, spw 3, channels 3 to 45.
             spw='0~2:2~6'; spw 0,1,2 with channels 2 through 6 in each.
             spw='0:0~10;15~60'; spectral window 0 with channels 0-10,15-60
             spw='0:0~10,1:20~30,2:1;2;3'; spw 0, channels 0-10,
                   spw 1, channels 20-30, and spw 2, channels, 1,2 and 3
    timerange  -- Time range:
            default = '' (all); examples,
            selectime = 'YYYY/MM/DD/hh:mm:ss~YYYY/MM/DD/hh:mm:ss'
            Note: if YYYY/MM/DD is missing date defaults to first day
	      in data set
            timerange='09:14:0~09:54:0' picks 40 min on first day
            timerange= '25:00:00~27:30:00' picks 1 hr to 3 hr 30min on next day
            timerange='09:44:00' data within one integration of time
            timerange='>10:24:00' data after this time
    restfreq -- Specify rest frequency to use for image
            default=''
	    Occasionally it is necessary to set this (for example some VLA
	    spectral line data).  For example for
            NH_3 (1,1) put restfreq='23.694496GHz'
    sdimage -- Input Single Dish image to use for model
            default='' (no image); example: sdimage='n4826_12mchan.im'
    modelimage -- Name of output(/input) model image
            default='' (none=imagename.model); modelimage='orion.model'
            Note: This specifies the output model if a single dish
            image is input or the output model name from the imaging
    weighting -- Weighting to apply to visibilities:
            default='natural'; example: weighting='uniform';
            Options: 'natural','uniform','briggs','radial', 'superuniform'
       >>> Weighting expandable parameters
            For weighting='briggs'
              rmode -- Robustness mode (see help mosaic)
                default='norm'; example='abs';
                Options: 'norm','abs','none'
              robust -- Brigg's robustness parameter
                default=0.0; example: robust=0.5;
                Options: -2.0 to 2.0; -2 (uniform)/+2 (natural)
              noise   -- noise parameter to use for rmode='abs' in
	        briggs weighting
                example noise='1.0mJy'
            For superuniform/briggs weighting
                npixels -- number of pixels to determine uv-cell size
	        for weight calculation
                example npixels=7
    mosweight -- Individually weight the fields of the mosaic
            default: False; example: mosweight=True
            This can be useful if some of your fields are more
            sensitive than others (i.e. due to time spent on-source);
            this parameter will give more weight to higher sensitivity
            fields in the overlap regions.
    ftmachine -- Gridding method for the image;
            Options: ft (standard interferometric gridding), sd
	    (standard single dish) both (ft and sd as appropriate),
	    mosaic (gridding use PB as convolution function)
            default: 'mosaic'; example: ftmachine='ft'
    cyclefactor -- Change the threshold at which the deconvolution cycle will
            stop, degrid and subtract from the visibilities. For poor PSFs,
            reconcile often (cyclefactor=4 or 5); For good PSFs, use
            cyclefactor 1.5 to 2.0.
            default: 1.5; example: cyclefactor=4
            cycle threshold = cyclefactor * max sidelobe * max residual
    cyclespeedup -- Cycle threshold doubles in this number of iterations
            default: -1; example: cyclespeedup=500
    scaletype -- Controls scaling of pixels in the image plane. 
            default='SAULT'; example: scaletype='PBCOR'
            Options: 'PBCOR','SAULT'
            'SAULT' scale makes an output image where the noise is constant
             across the whole mosaic. However, the image is NOT
             corrected for the PB pattern, and therefore is not "flux
             correct". Division of the SAULT image_name.image image
             by the image_name.flux image will produce a "flux correct image".
             The 'PBCOR' option uses the SAULT scaling scheme for
             deconvolution, but when interactively cleaning shows the
             primary beam corrected image; the final PBCOR image is "flux
             correct"
    minpb -- Minimum PB level to use
            default=0.1; example: minpb=0.01
    async --  Run asynchronously
            default = False; do not run asychronously
  
        """
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
	#casac = self.__globals__['casac']
	casalog = self.__globals__['casalog']
	casa = self.__globals__['casa']
	#casalog = casac.casac.logsink()
        self.__globals__['__last_task'] = 'mosaic'
        self.__globals__['taskname'] = 'mosaic'
        ###
        self.__globals__['update_params'](func=self.__globals__['taskname'],printtext=False,ipython_globals=self.__globals__)
        ###
        ###
        #Handle globals or user over-ride of arguments
        #
        if type(self.__call__.func_defaults) is NoneType:
            function_signature_defaults={}
	else:
	    function_signature_defaults=dict(zip(self.__call__.func_code.co_varnames[1:],self.__call__.func_defaults))
	useLocalDefaults = False

        for item in function_signature_defaults.iteritems():
                key,val = item
                keyVal = eval(key)
                if (keyVal == None):
                        #user hasn't set it - use global/default
                        pass
                else:
                        #user has set it - use over-ride
			if (key != 'self') :
			   useLocalDefaults = True

	myparams = {}
	if useLocalDefaults :
	   for item in function_signature_defaults.iteritems():
	       key,val = item
	       keyVal = eval(key)
	       exec('myparams[key] = keyVal')
	       self.parameters[key] = keyVal
	       if (keyVal == None):
	           exec('myparams[key] = '+ key + ' = self.itsdefault(key)')
		   keyVal = eval(key)
		   if(type(keyVal) == dict) :
                      if len(keyVal) > 0 :
		         exec('myparams[key] = ' + key + ' = keyVal[len(keyVal)-1][\'value\']')
		      else :
		         exec('myparams[key] = ' + key + ' = {}')
	 
        else :
            print ''

            myparams['vis'] = vis = self.parameters['vis']
            myparams['imagename'] = imagename = self.parameters['imagename']
            myparams['mode'] = mode = self.parameters['mode']
            myparams['alg'] = alg = self.parameters['alg']
            myparams['imsize'] = imsize = self.parameters['imsize']
            myparams['cell'] = cell = self.parameters['cell']
            myparams['phasecenter'] = phasecenter = self.parameters['phasecenter']
            myparams['stokes'] = stokes = self.parameters['stokes']
            myparams['niter'] = niter = self.parameters['niter']
            myparams['gain'] = gain = self.parameters['gain']
            myparams['threshold'] = threshold = self.parameters['threshold']
            myparams['mask'] = mask = self.parameters['mask']
            myparams['cleanbox'] = cleanbox = self.parameters['cleanbox']
            myparams['nchan'] = nchan = self.parameters['nchan']
            myparams['start'] = start = self.parameters['start']
            myparams['width'] = width = self.parameters['width']
            myparams['field'] = field = self.parameters['field']
            myparams['spw'] = spw = self.parameters['spw']
            myparams['timerange'] = timerange = self.parameters['timerange']
            myparams['restfreq'] = restfreq = self.parameters['restfreq']
            myparams['sdimage'] = sdimage = self.parameters['sdimage']
            myparams['modelimage'] = modelimage = self.parameters['modelimage']
            myparams['weighting'] = weighting = self.parameters['weighting']
            myparams['mosweight'] = mosweight = self.parameters['mosweight']
            myparams['rmode'] = rmode = self.parameters['rmode']
            myparams['robust'] = robust = self.parameters['robust']
            myparams['ftmachine'] = ftmachine = self.parameters['ftmachine']
            myparams['cyclefactor'] = cyclefactor = self.parameters['cyclefactor']
            myparams['cyclespeedup'] = cyclespeedup = self.parameters['cyclespeedup']
            myparams['scaletype'] = scaletype = self.parameters['scaletype']
            myparams['minpb'] = minpb = self.parameters['minpb']
            myparams['sigma'] = sigma = self.parameters['sigma']
            myparams['targetflux'] = targetflux = self.parameters['targetflux']
            myparams['constrainflux'] = constrainflux = self.parameters['constrainflux']
            myparams['prior'] = prior = self.parameters['prior']
            myparams['negcomponent'] = negcomponent = self.parameters['negcomponent']
            myparams['scales'] = scales = self.parameters['scales']
            myparams['npercycle'] = npercycle = self.parameters['npercycle']
            myparams['npixels'] = npixels = self.parameters['npixels']
            myparams['noise'] = noise = self.parameters['noise']

        if type(imsize)==int: imsize=[imsize]
        if type(cell)==float: cell=[cell]
        if type(mask)==str: mask=[mask]
        if type(prior)==str: prior=[prior]
        if type(scales)==int: scales=[scales]

	result = None

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['vis'] = vis
        mytmp['imagename'] = imagename
        mytmp['mode'] = mode
        mytmp['alg'] = alg
        mytmp['imsize'] = imsize
        if type(cell) == str :
           mytmp['cell'] = casac.casac.qa.quantity(cell)
        else :
           mytmp['cell'] = cell
        mytmp['phasecenter'] = phasecenter
        mytmp['stokes'] = stokes
        mytmp['niter'] = niter
        mytmp['gain'] = gain
        mytmp['threshold'] = threshold
        mytmp['mask'] = mask
        mytmp['cleanbox'] = cleanbox
        mytmp['nchan'] = nchan
        mytmp['start'] = start
        mytmp['width'] = width
        mytmp['field'] = field
        mytmp['spw'] = spw
        mytmp['timerange'] = timerange
        mytmp['restfreq'] = restfreq
        mytmp['sdimage'] = sdimage
        mytmp['modelimage'] = modelimage
        mytmp['weighting'] = weighting
        mytmp['mosweight'] = mosweight
        mytmp['rmode'] = rmode
        mytmp['robust'] = robust
        mytmp['ftmachine'] = ftmachine
        mytmp['cyclefactor'] = cyclefactor
        mytmp['cyclespeedup'] = cyclespeedup
        mytmp['scaletype'] = scaletype
        mytmp['minpb'] = minpb
        if type(sigma) == str :
           mytmp['sigma'] = casac.casac.qa.quantity(sigma)
        else :
           mytmp['sigma'] = sigma
        if type(targetflux) == str :
           mytmp['targetflux'] = casac.casac.qa.quantity(targetflux)
        else :
           mytmp['targetflux'] = targetflux
        mytmp['constrainflux'] = constrainflux
        mytmp['prior'] = prior
        mytmp['negcomponent'] = negcomponent
        mytmp['scales'] = scales
        mytmp['npercycle'] = npercycle
        mytmp['npixels'] = npixels
        if type(noise) == str :
           mytmp['noise'] = casac.casac.qa.quantity(noise)
        else :
           mytmp['noise'] = noise
	pathname='file://' + casa['dirs']['xml'] + '/'
	trec = casac.casac.utils().torecord(pathname+'mosaic.xml')

        casalog.origin('mosaic')
	try :
          #if not trec.has_key('mosaic') or not casac.casac.utils().verify(mytmp, trec['mosaic']) :
	    #return False

          casac.casac.utils().verify(mytmp, trec['mosaic'], True)
          scriptstr=['']
          saveinputs = self.__globals__['saveinputs']
          if type(self.__call__.func_defaults) is NoneType:
              saveinputs=''
          else:
              saveinputs('mosaic', 'mosaic.last', myparams, self.__globals__,scriptstr=scriptstr)
          tname = 'mosaic'
          spaces = ' '*(18-len(tname))
          casalog.post('\n##########################################'+
                       '\n##### Begin Task: ' + tname + spaces + ' #####')
          if type(self.__call__.func_defaults) is NoneType:
              casalog.post(scriptstr[0]+'\n', 'INFO')
          else :
              casalog.post(scriptstr[1][1:]+'\n', 'INFO')
          result = mosaic(vis, imagename, mode, alg, imsize, cell, phasecenter, stokes, niter, gain, threshold, mask, cleanbox, nchan, start, width, field, spw, timerange, restfreq, sdimage, modelimage, weighting, mosweight, rmode, robust, ftmachine, cyclefactor, cyclespeedup, scaletype, minpb, sigma, targetflux, constrainflux, prior, negcomponent, scales, npercycle, npixels, noise)
          casalog.post('##### End Task: ' + tname + '  ' + spaces + ' #####'+
                       '\n##########################################')

	except Exception, instance:
          if(self.__globals__.has_key('__rethrow_casa_exceptions') and self.__globals__['__rethrow_casa_exceptions']) :
             raise
          else :
             #print '**** Error **** ',instance
	     tname = 'mosaic'
             casalog.post('An error occurred running task '+tname+'.', 'ERROR')
             pass

        gc.collect()
        return result
#
#
#
    def paramgui(self, useGlobals=True, ipython_globals=None):
        """
        Opens a parameter GUI for this task.  If useGlobals is true, then any relevant global parameter settings are used.
        """
        import paramgui
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )

        if useGlobals:
	    if ipython_globals == None:
                myf=self.__globals__
            else:
                myf=ipython_globals

            paramgui.setGlobals(myf)
        else:
            paramgui.setGlobals({})

        paramgui.runTask('mosaic', myf['_ip'])
        paramgui.setGlobals({})

#
#
#
    def defaults(self, param=None, ipython_globals=None, paramvalue=None, subparam=None):
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
        if ipython_globals == None:
            myf=self.__globals__
        else:
            myf=ipython_globals

        a = odict()
        a['vis']  = ''
        a['imagename']  = ''
        a['mode']  = 'mfs'
        a['alg']  = 'clark'
        a['imsize']  = [256, 256]
        a['cell']  = ['1.0arcsec', '1.0arcsec']
        a['phasecenter']  = ''
        a['stokes']  = 'I'
        a['niter']  = 500
        a['gain']  = 0.1
        a['threshold']  = 0.0
        a['mask']  = ['']
        a['cleanbox']  = {}
        a['field']  = ''
        a['spw']  = ''
        a['timerange']  = ''
        a['restfreq']  = ''
        a['sdimage']  = ''
        a['modelimage']  = ''
        a['weighting']  = 'natural'
        a['mosweight']  = False
        a['ftmachine']  = 'mosaic'
        a['cyclefactor']  = 1.5
        a['cyclespeedup']  = -1
        a['scaletype']  = 'SAULT'
        a['minpb']  = 0.1

        a['mode'] = {
                    0:{'value':'mfs'}, 
                    1:odict([{'value':'channel'}, {'nchan':1}, {'start':0}, {'width':1}]), 
                    2:odict([{'value':'velocity'}, {'nchan':1}, {'start':'0.0km/s'}, {'width':'1km/s'}]), 
                    3:odict([{'value':'frequency'}, {'nchan':1}, {'start':'1.4GHz'}, {'width':'10kHz'}])}
        a['alg'] = {
                    0:{'value':'clark'}, 
                    1:{'value':'hogbom'}, 
                    2:odict([{'value':'multiscale'}, {'scales':[0, 3, 10]}, {'negcomponent':2}]), 
                    3:odict([{'value':'entropy'}, {'sigma':0.01}, {'targetflux':1.0}, {'constrainflux':False}, {'prior':['']}]), 
                    4:{'value':'emptiness'}}
        a['weighting'] = {
                    0:{'value':'natural'}, 
                    1:{'value':'uniform'}, 
                    2:odict([{'value':'briggs'}, {'rmode':'none'}, {'robust':0.0}, {'noise':0.0}, {'npixels':0}]), 
                    3:odict([{'value':'superuniform'}, {'npixels':0}])}
        a['cleanbox'] = {
                    0:{'value':[]}, 
                    1:odict([{'value':'interactive'}, {'npercycle':100}])}

### This function sets the default values but also will return the list of
### parameters or the default value of a given parameter
        if(param == None):
                myf['__set_default_parameters'](a)
        elif(param == 'paramkeys'):
                return a.keys()
        else:
            if(paramvalue==None and subparam==None):
               if(a.has_key(param)):
                  return a[param]
               else:
                  return self.itsdefault(param)
            else:
               retval=a[param]
               if(type(a[param])==dict):
                  for k in range(len(a[param])):
                     valornotval='value'
                     if(a[param][k].has_key('notvalue')):
                        valornotval='notvalue'
                     if((a[param][k][valornotval])==paramvalue):
                        retval=a[param][k].copy()
                        retval.pop(valornotval)
                        if(subparam != None):
                           if(retval.has_key(subparam)):
                              retval=retval[subparam]
                           else:
                              retval=self.itsdefault(subparam)
		     else:
                        retval=self.itsdefault(subparam)
               return retval


#
#
    def check_params(self, param=None, value=None, ipython_globals=None):
      if ipython_globals == None:
          myf=self.__globals__
      else:
          myf=ipython_globals
#      print 'param:', param, 'value:', value
      try :
         if str(type(value)) != "<type 'instance'>" :
            value0 = value
            value = myf['cu'].expandparam(param, value)
            matchtype = False
            if(type(value) == numpy.ndarray):
               if(type(value) == type(value0)):
                  myf[param] = value.tolist()
               else:
                  #print 'value:', value, 'value0:', value0
                  #print 'type(value):', type(value), 'type(value0):', type(value0)
                  myf[param] = value0
                  if type(value0) != list :
                     matchtype = True
            else :
               myf[param] = value
            value = myf['cu'].verifyparam({param:value})
            if matchtype:
               value = False
      except Exception, instance:
         #ignore the exception and just return it unchecked
         myf[param] = value
      return value
#
#
    def description(self, key='mosaic', subkey=None):
        desc={'mosaic': 'Create a multi-field deconvolved image with selected algorithm',
               'vis': 'name of input visibility file',
               'imagename': 'Pre-name of output images',
               'mode': 'Type of selection (mfs, channel, velocity, frequency)',
               'alg': 'Algorithm to use (clark, hogbom, multiscale) ',
               'imsize': 'Image size in pixels (nx,ny), symmetric for single value',
               'cell': 'The image cell size in arcseconds [x,y]. ',
               'phasecenter': 'Field Identififier or direction of the image phase center',
               'stokes': 'Stokes params to image (I,IV,QU,IQUV,RR,LL,XX,YY,RRLL,XXYY)',
               'niter': 'Maximum number of iterations',
               'gain': 'Loop gain for cleaning',
               'threshold': 'Flux level to stop cleaning (unit mJy assumed)',
               'mask': 'Set of mask images used in cleaning',
               'cleanbox': 'clean box regions or file name or \'interactive\'',
               'nchan': 'Number of channels in output image',
               'start': 'Start channel',
               'width': 'Channel width (value > 1 indicates channel averaging)',
               'field': 'Field Name',
               'spw': 'Spectral windows:channels: \'\' is all ',
               'timerange': 'Range of time to select from data',
               'restfreq': 'rest frequency to use in image',
               'sdimage': 'Input single dish image to use for model',
               'modelimage': 'Name of output(/input) model image',
               'weighting': 'Weighting to apply to visibilities',
               'mosweight': 'Individually weight the fields of the mosaic',
               'rmode': 'Robustness mode (for Briggs weightting)',
               'robust': 'Briggs robustness parameter',
               'ftmachine': 'Gridding method for the image',
               'cyclefactor': 'Threshold for minor/major cycles (see pdoc)',
               'cyclespeedup': 'Cycle threshold doubles in this number of iterations',
               'scaletype': 'Controls scaling of pixels in the image plane',
               'minpb': 'Minimum PB level to use',
               'sigma': 'Target image sigma',
               'targetflux': 'Target flux for final image',
               'constrainflux': 'Constrain image to match target flux ',
               'prior': 'Name of MEM prior images',
               'negcomponent': 'Stop the component search when the largest scale has found this number of negative components',
               'scales': 'resolutions in pixel units',
               'npercycle': 'Number of iterations before interactive masking prompt',
               'npixels': 'number of pixels to determine cell size for superuniform or briggs weighting',
               'noise': 'noise parameter for briggs weighting when rmode=\'abs\'',

              }

#
# Set subfields defaults if needed
#
        if(subkey == 'channel'):
          desc['start'] = 'first channel in image relative to data channels'
        if(subkey == 'velocity'):
          desc['start'] = 'Velocity of first image channel: e.g \'0.0km/s\''
        if(subkey == 'velocity'):
          desc['width'] = 'image channel width in velocity units: e.g \'-1.0km/s\''
        if(subkey == 'frequency'):
          desc['start'] = 'Frequency of first image channel: e.q. \'1.4GHz\''
        if(subkey == 'frequency'):
          desc['width'] = 'Image channel width in frequency units: e.g \'1.0kHz\''
        if(subkey == 'briggs'):
          desc['npixels'] = 'number of pixels to determine uv-cell size 0=> field of view'
        if(subkey == 'superuniform'):
          desc['npixels'] = 'number of pixels to determine uv-cell size 0=> +/-3pixels'

        if(desc.has_key(key)) :
           return desc[key]

    def itsdefault(self, paramname) :
        a = {}
        a['vis']  = ''
        a['imagename']  = ''
        a['mode']  = 'mfs'
        a['alg']  = 'clark'
        a['imsize']  = [256, 256]
        a['cell']  = ['1.0arcsec', '1.0arcsec']
        a['phasecenter']  = ''
        a['stokes']  = 'I'
        a['niter']  = 500
        a['gain']  = 0.1
        a['threshold']  = 0.0
        a['mask']  = ['']
        a['cleanbox']  = {}
        a['nchan']  = 1
        a['start']  = 0
        a['width']  = 1
        a['field']  = ''
        a['spw']  = ''
        a['timerange']  = ''
        a['restfreq']  = ''
        a['sdimage']  = ''
        a['modelimage']  = ''
        a['weighting']  = 'natural'
        a['mosweight']  = False
        a['rmode']  = 'norm'
        a['robust']  = 0.0
        a['ftmachine']  = 'mosaic'
        a['cyclefactor']  = 1.5
        a['cyclespeedup']  = -1
        a['scaletype']  = 'SAULT'
        a['minpb']  = 0.1
        a['sigma']  = '0.001Jy'
        a['targetflux']  = '1.0Jy'
        a['constrainflux']  = False
        a['prior']  = ['']
        a['negcomponent']  = 2
        a['scales']  = [0, 3, 10]
        a['npercycle']  = 100
        a['npixels']  = 0
        a['noise']  = '0.0Jy'

        #a = sys._getframe(len(inspect.stack())-1).f_globals

        if self.parameters['mode']  == 'channel':
            a['nchan'] = 1
            a['start'] = 0
            a['width'] = 1

        if self.parameters['mode']  == 'velocity':
            a['nchan'] = 1
            a['start'] = '0.0km/s'
            a['width'] = '1km/s'

        if self.parameters['mode']  == 'frequency':
            a['nchan'] = 1
            a['start'] = '1.4GHz'
            a['width'] = '10kHz'

        if self.parameters['alg']  == 'multiscale':
            a['scales'] = [0, 3, 10]
            a['negcomponent'] = 2

        if self.parameters['alg']  == 'entropy':
            a['sigma'] = 0.01
            a['targetflux'] = 1.0
            a['constrainflux'] = False
            a['prior'] = ['']

        if self.parameters['weighting']  == 'briggs':
            a['rmode'] = 'none'
            a['robust'] = 0.0
            a['noise'] = 0.0
            a['npixels'] = 0

        if self.parameters['weighting']  == 'superuniform':
            a['npixels'] = 0

        if self.parameters['cleanbox']  == 'interactive':
            a['npercycle'] = 100

        if a.has_key(paramname) :
	      return a[paramname]
mosaic_cli = mosaic_cli_()
