#
# This file was generated using xslt from its XML file
#
# Copyright 2009, Associated Universities Inc., Washington DC
#
import sys
import os
from  casac import *
import string
from taskinit import casalog
from taskinit import xmlpath
#from taskmanager import tm
import task_mosaic
def mosaic(vis='', imagename='', mode='mfs', alg='clark', imsize=[256, 256], cell=['1.0arcsec', '1.0arcsec'], phasecenter='', stokes='I', niter=500, gain=0.1, threshold=0.0, mask=[''], cleanbox=[], nchan=1, start=0, width=1, field='', spw='', timerange='', restfreq='', sdimage='', modelimage='', weighting='natural', mosweight=False, rmode='norm', robust=0.0, ftmachine='mosaic', cyclefactor=1.5, cyclespeedup=-1, scaletype='SAULT', minpb=0.1, sigma='0.001Jy', targetflux='1.0Jy', constrainflux=False, prior=[''], negcomponent=2, scales=[0, 3, 10], npercycle=100, npixels=0, noise='0.0Jy'):

        """Create a multi-field deconvolved image with selected algorithm


    Two types of point-source deconvolution, as well as multi-scale
    deconvolution, are available.  A continuum image (mfs) is produced
    by gridding together all spectral data.   Individual channels or
    groups of channels can also be images and then placed in an output
    image cube.

    The cleaning regions can be specified by an input mask image, from a
    file containing rectangular regions, or interactively as the
    deconvolution progresses.

    The mosaic task only uses the "corrected" datacolumn which is made
    from the "data" data column using applycal with the appropriate
    calibration tables.  Many Stokes combinations are available.


    Keyword arguments:
    vis -- Name of input visibility file
            default: none; example: vis='ngc5921.ms'
    imagename -- Pre-name of output images:
            default: none; example: imagename='m2'
            output images are:
              m2.image; cleaned and restored image
              m2.flux;  relative sky sensitivity over field
              m2.model; image of clean components
              m2.residual; image of residuals
              m2.interactive.mask; image containing clean regions
    mode -- Frequency Specification:
	    NOTE: See examples below:
            default: 'mfs'
              mode = 'mfs' means produce one image from all specified data.
              mode = 'channel'; Use with nchan, start, width to specify
                      output image cube.  See examples below
              mode = 'velocity', means channels are specified in velocity.
	      mode = 'frequency', means channels are specified in frequency.
       >>> mode expandable parameters (for modes other than 'mfs')
            Start, width are given in units of channels, frequency or velocity
               as indicated by mode, but only channel is complete.
            nchan -- Number of channels (planes) in output image
              default: 1; example: nchan=3
            start -- Start input channel (relative-0)
              default=0; example: start=5
            width -- Output channel width (>1 indicates channel averaging)
              default=1; example: width=4
        examples:
            spw = '0,1'; mode = 'mfs'
               will produce one image made from all channels in spw 0 and 1
            spw='0:5~28^2'; mode = 'mfs' 
               will produce one image made with channels (5,7,9,...,25,27)
            spw = '0'; mode = 'channel': nchan=3; start=5; width=4
               will produce an image with 3 output planes
               plane 1 contains data from channels (5+6+7+8)
               plane 2 contains data from channels (9+10+11+12)
               plane 3 contains data from channels (13+14+15+16)
            spw = '0:0~63^3'; mode=chann; nchan=21; start = 0; width = 1
               will produce an image with 20 output planes
               Plane 1 contains data from channel 0
               Plane 2 contains date from channel 2
               Plane 21 contains data from channel 61
            spw = '0:0~40^2'; mode = 'channel'; nchan = 3; start = 5; width = 4
               will produce an image with three output planes
               plane 1 contains channels (5,7)
               plane 2 contains channels (13,15)
               plane 3 contains channels (21,23)
    alg -- Algorithm to use (expandable):
            default: 'clark': Options: 'clark','hogbom','multiscale','entropy'
            'hogbom' Cleans from the images only.  Only inner quarter
		     of image is cleaned
            'clark' Cleans from gridded us data.  Only inner quarter of
		    image is cleaned
            'multiscale' cleans with several resolutions using hobgom clean
                  Currently much slower than single resolution. For extended 
		  sources, try single resolution with interactive and
            'entropy' Maximum entropy algorithm is still experimental
		  and not recommended for general use
      >>> multiscale expandable parameter
            scales  -- in pixel numbers; the size of component to deconvolve
                  default = [0,3,10]
                   recommended sizes are 0 (point), 3 (points per clean beam), and
                    10 (about a factor of three lower resolution)
            negcomponent' -- Stop component search when the largest
	          scale has found this number of negative components; -1 means
	          continue component search even if the largest component is 
	          negative.
                  default: 2; example: negcomponent=-1
      >>> entropy (MEM) expandable parameters (experimental)
	    sigma -- Target image sigma
                  default: '0.001Jy'; example: sigma='0.1Jy'
            targetflux -- Target flux for final image
                  default: '1.0Jy'; example: targetflux='200Jy'
            constrainflux -- Constrain image to match target flux;
                  otherwise, targetflux is used to initialize model only.   
                       default: False; example: constrainflux=True
            prior -- Name of MEM prior images
                  default: ['']; example: prior='source_mem.image'
    imsize -- Image pixel size (x,y)
            default = [256,256]; example: imsize=[350,350]
            imsize = 500 is equivalent to [500,500]
    cell -- Cell size (x,y)
            default= none;
            example: cell=['0.5arcsec,'0.5arcsec'] or
            cell=['1arcmin', '1arcmin']
            cell = '1arcsec' is equivalent to ['1arcsec','1arcsec']
	    NOTE:cell = '2' makes default cell size of 2 radians! 
    phasecenter -- direction measure  or fieldid for the mosaic center
            default: 0 (imply field=0 as center); example: phasecenter=6
            or phasecenter='J2000 19h30m00 -40d00m00'
    stokes -- Stokes parameters to image
            default='I'; example: stokes='IQUV';
            Options: 'I','IV''QU','IQUV','RR','LL','XX','YY','RRLL','XXYY'
    niter -- Maximum number iterations, set to zero for no CLEANing
            default: 500; example: niter=500
    gain -- Loop gain for CLEANing
            default: 0.1; example: gain=0.5
    threshold -- Flux level at which to stop CLEANing (units=mJy)
            default: 0.0; example: threshold=0.0  
    mask -- Name of mask image used for CLEANing
            default '' means no mask;
              example: mask='orion.mask'.  
	    It is useful to use a mask from a previous interactive mosaic 
	    session for a new execution.  The mask image shape
            must be the same as the new mosaic.
    cleanbox -- Cleaning region:
            default: [] defaults to inner quarter of image
            Three specification types:
            (a) 'interactive' allows the user to build the cleaning
                 mask interactively using the viewer.  The viewer will 
                 appear every npercycle interation, but modify as needed
		 The final interactive maks is saved in the file
		 imagename_interactive.mask.
            (b) Explicit pixel ranges
                example: cleanbox=[110,110,150,145]
                clean region with blc=110,100; trc=150,145 (pixel values)
                Only one clean region can be given this way.
            (c) Filename with pixel values with ascii format:
                <fieldindex blc-x blc-y trc-x trc-y> on each line
                1  45  66  123 124
                2  23 100  300 340
      >>> 'interactive' expandable parameter 
            npercycle -- this is the number of iterations between each clean 
	    to update mask interactively. Set to about niter/5, can also
            be changed interactively.               
    field -- Select fields in mosaic.  Use field id(s) or field name(s).
               ['go listobs' to obtain the list id's or names]
           default: ''=all fields
           If field string is a non-negative integer, it is assumed to
               be a field index otherwise, it is assumed to be a field name
           field='0~2'; field ids 0,1,2
           field='0,4,5~7'; field ids 0,4,5,6,7
           field='3C286,3C295'; field named 3C286 and 3C295
           field = '3,4C*'; field id 3, all names starting with 4C
    spw -- Select spectral window/channels
	   NOTE: This selects the data passed as the INPUT to mode
           default: ''=all spectral windows and channels
             spw='0~2,4'; spectral windows 0,1,2,4 (all channels)
             spw='<2';  spectral windows less than 2 (i.e. 0,1)
             spw='0:5~61'; spw 0, channels 5 to 61
             spw='0,10,3:3~45'; spw 0,10 all channels, spw 3, channels 3 to 45.
             spw='0~2:2~6'; spw 0,1,2 with channels 2 through 6 in each.
             spw='0:0~10;15~60'; spectral window 0 with channels 0-10,15-60
             spw='0:0~10,1:20~30,2:1;2;3'; spw 0, channels 0-10,
                   spw 1, channels 20-30, and spw 2, channels, 1,2 and 3
    timerange  -- Time range:
            default = '' (all); examples,
            selectime = 'YYYY/MM/DD/hh:mm:ss~YYYY/MM/DD/hh:mm:ss'
            Note: if YYYY/MM/DD is missing date defaults to first day
	      in data set
            timerange='09:14:0~09:54:0' picks 40 min on first day
            timerange= '25:00:00~27:30:00' picks 1 hr to 3 hr 30min on next day
            timerange='09:44:00' data within one integration of time
            timerange='>10:24:00' data after this time
    restfreq -- Specify rest frequency to use for image
            default=''
	    Occasionally it is necessary to set this (for example some VLA
	    spectral line data).  For example for
            NH_3 (1,1) put restfreq='23.694496GHz'
    sdimage -- Input Single Dish image to use for model
            default='' (no image); example: sdimage='n4826_12mchan.im'
    modelimage -- Name of output(/input) model image
            default='' (none=imagename.model); modelimage='orion.model'
            Note: This specifies the output model if a single dish
            image is input or the output model name from the imaging
    weighting -- Weighting to apply to visibilities:
            default='natural'; example: weighting='uniform';
            Options: 'natural','uniform','briggs','radial', 'superuniform'
       >>> Weighting expandable parameters
            For weighting='briggs'
              rmode -- Robustness mode (see help mosaic)
                default='norm'; example='abs';
                Options: 'norm','abs','none'
              robust -- Brigg's robustness parameter
                default=0.0; example: robust=0.5;
                Options: -2.0 to 2.0; -2 (uniform)/+2 (natural)
              noise   -- noise parameter to use for rmode='abs' in
	        briggs weighting
                example noise='1.0mJy'
            For superuniform/briggs weighting
                npixels -- number of pixels to determine uv-cell size
	        for weight calculation
                example npixels=7
    mosweight -- Individually weight the fields of the mosaic
            default: False; example: mosweight=True
            This can be useful if some of your fields are more
            sensitive than others (i.e. due to time spent on-source);
            this parameter will give more weight to higher sensitivity
            fields in the overlap regions.
    ftmachine -- Gridding method for the image;
            Options: ft (standard interferometric gridding), sd
	    (standard single dish) both (ft and sd as appropriate),
	    mosaic (gridding use PB as convolution function)
            default: 'mosaic'; example: ftmachine='ft'
    cyclefactor -- Change the threshold at which the deconvolution cycle will
            stop, degrid and subtract from the visibilities. For poor PSFs,
            reconcile often (cyclefactor=4 or 5); For good PSFs, use
            cyclefactor 1.5 to 2.0.
            default: 1.5; example: cyclefactor=4
            cycle threshold = cyclefactor * max sidelobe * max residual
    cyclespeedup -- Cycle threshold doubles in this number of iterations
            default: -1; example: cyclespeedup=500
    scaletype -- Controls scaling of pixels in the image plane. 
            default='SAULT'; example: scaletype='PBCOR'
            Options: 'PBCOR','SAULT'
            'SAULT' scale makes an output image where the noise is constant
             across the whole mosaic. However, the image is NOT
             corrected for the PB pattern, and therefore is not "flux
             correct". Division of the SAULT image_name.image image
             by the image_name.flux image will produce a "flux correct image".
             The 'PBCOR' option uses the SAULT scaling scheme for
             deconvolution, but when interactively cleaning shows the
             primary beam corrected image; the final PBCOR image is "flux
             correct"
    minpb -- Minimum PB level to use
            default=0.1; example: minpb=0.01
    async --  Run asynchronously
            default = False; do not run asychronously
  
        """
        if type(imsize)==int: imsize=[imsize]
        if type(cell)==float: cell=[cell]
        if type(mask)==str: mask=[mask]
        if type(prior)==str: prior=[prior]
        if type(scales)==int: scales=[scales]

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['vis'] = vis
        mytmp['imagename'] = imagename
        mytmp['mode'] = mode
        mytmp['alg'] = alg
        mytmp['imsize'] = imsize
        if type(cell) == str :
           mytmp['cell'] = casac.quanta().quantity(cell)
        else :
           mytmp['cell'] = cell
        mytmp['phasecenter'] = phasecenter
        mytmp['stokes'] = stokes
        mytmp['niter'] = niter
        mytmp['gain'] = gain
        mytmp['threshold'] = threshold
        mytmp['mask'] = mask
        mytmp['cleanbox'] = cleanbox
        mytmp['nchan'] = nchan
        mytmp['start'] = start
        mytmp['width'] = width
        mytmp['field'] = field
        mytmp['spw'] = spw
        mytmp['timerange'] = timerange
        mytmp['restfreq'] = restfreq
        mytmp['sdimage'] = sdimage
        mytmp['modelimage'] = modelimage
        mytmp['weighting'] = weighting
        mytmp['mosweight'] = mosweight
        mytmp['rmode'] = rmode
        mytmp['robust'] = robust
        mytmp['ftmachine'] = ftmachine
        mytmp['cyclefactor'] = cyclefactor
        mytmp['cyclespeedup'] = cyclespeedup
        mytmp['scaletype'] = scaletype
        mytmp['minpb'] = minpb
        if type(sigma) == str :
           mytmp['sigma'] = casac.quanta().quantity(sigma)
        else :
           mytmp['sigma'] = sigma
        if type(targetflux) == str :
           mytmp['targetflux'] = casac.quanta().quantity(targetflux)
        else :
           mytmp['targetflux'] = targetflux
        mytmp['constrainflux'] = constrainflux
        mytmp['prior'] = prior
        mytmp['negcomponent'] = negcomponent
        mytmp['scales'] = scales
        mytmp['npercycle'] = npercycle
        mytmp['npixels'] = npixels
        if type(noise) == str :
           mytmp['noise'] = casac.quanta().quantity(noise)
        else :
           mytmp['noise'] = noise
	pathname='file://' + xmlpath( ) + '/'
	trec = casac.utils().torecord(pathname+'mosaic.xml')

        casalog.origin('mosaic')
        if trec.has_key('mosaic') and casac.utils().verify(mytmp, trec['mosaic']) :
	    result = task_mosaic.mosaic(vis, imagename, mode, alg, imsize, cell, phasecenter, stokes, niter, gain, threshold, mask, cleanbox, nchan, start, width, field, spw, timerange, restfreq, sdimage, modelimage, weighting, mosweight, rmode, robust, ftmachine, cyclefactor, cyclespeedup, scaletype, minpb, sigma, targetflux, constrainflux, prior, negcomponent, scales, npercycle, npixels, noise)

	else :
	  result = False
        return result
