#
# This file was generated using xslt from its XML file
#
# Copyright 2009, Associated Universities Inc., Washington DC
#
import sys
import os
from  casac import *
import string
from taskinit import casalog
from taskinit import xmlpath
#from taskmanager import tm
import task_imview
def imview(raster=[], contour=[], zoom=1, axes=[], out=''):

        """View an image
	The imview task provides access to a subset of all of the configuration
	options for loading and configuring the display of images in the casaviewer.
	This interface will evolve and eventually provide access to nearly all of 
        the image options available in the casaviewer.

	To simply create a casaviewer to set up interactively, you can use:

	    imview

	To open a particular image:

	    imview "ngc5921.clean.image"

        to open an image and overlay a contour:

	    imview "ngc5921.clean.image", "ngc5921.clean.image"

	or equivalently:

            imview( raster="ngc5921.clean.image", contour="ngc5921.clean.image" )

	to output an image:

            imview( raster="ngc5921.clean.image", out="ngc5921-01.png" )    
	    

	There are five optional parameters for imview -- raster, contour, zoom,
	axes, and out. Each of these parameters can take a few different forms and 
	are treated as python dictionaries:

	raster  -- (string) image file to open
	           (dict)   file (string)     => image file to open
	                    scaling (float)   => scaling power cycles
	                    range (float*2)   => data range
	                    colormap (string) => name of colormap
	                    colorwedge (bool) => show color wedge?
	contour -- (string) file to load as a contour
	           (dict)   file (string)     => file to load
	                    levels (float*N)  => relative levels
	                    base (numeric)    => zero in relative levels
	                    unit (numeric)    => one in the relative levels
	zoom    -- (int)    integral zoom level
	           (string) region file to load as the zoom region
	           (dict)   blc (numeric*2)   => bottom left corner
	                    trc (numeric*2)   => top right corner
	                    coord (string)    => pixel or world
	                    channel (int)     => chanel to display
	           (dict)   <region record>   => record loaded
	                                         e.g. rg.fromfiletorecord( )
	axes    -- (string*3) demension to display on the x, y, and z axes
	           (dict)     x               => dimension for x-axes
	                      y               => dimension for y-axes
	                      z               => dimension for z-axes
	out     -- (string) file with a supported extension
	                    [jpg, pdf, eps, ps, png, xbm, xpm, ppm]
	            (dict)    file (string)   => filename
	                      format (string) => valid ext (filename ext overrides)
	                      scale (numeric) => scale for non-eps, non-ps output
	                      dpi (numeric)   => dpi for eps or ps output
	                      orient (string) => portrait or landscape

        Examples: 

	1)  A subset (zoom) of a raster image. Note the notation of curly brackets:

	    imview(raster="ngc5921.clean.image", out="ngc5921-02.png",
	           zoom={'channel': 10, 'blc': [113,109], 'trc': [141,136]} )


	2) An overlay of a raster image, ngc5921.clean.image, with a
	contour map of the same image ngc5921.clean.image. Data ranges
	are selected, as well as the colormap and the scaling cycles
	of the raster image. Contours are autogenerated and The x-axis
	will be Declination. The image is written out to a file named 
        myout.png in the png format.

	imview(raster={'file': 'ngc5921.clean.image',
	               'range': [-0.01,0.03],
	               'colormap': 'Hot Metal 2',
	               'scaling': -1},
	       contour={'file': 'ngc5921.clean.image'},
	       axes={'x':'Declination'} ,
	       zoom={'channel': 7, 'blc': [75,75], 'trc': [175,175],
	             'coord': 'pixel'},
	       out='myout.png')

	3) As example (2) but with an integral zoom level and no output to a file

	imview(raster={'file': 'ngc5921.clean.image', 
	               'range': [-0.01,0.03], 
	               'colormap': 'Hot Metal 2'}, 
	       contour={'file': 'ngc5921.clean.image'}, 
	       axes={'x':'Declination'} , 
	       zoom=2)

	4) Now, the contour levels are explicitely given, a region file is used
	to define the zoom area

	imview(raster={'file': 'ngc5921.clean.image',
	               'range': [-0.01,0.03],
	               'colormap': 'Hot Metal 2'},
	       contour={'file': 'ngc5921.clean.image',
	                'levels': [-0.2, 0.2, 0.25, 0.3, 0.35, 0.4, 0.6, 0.8] },
	       zoom='myregion.rgn')

	specifying "zoom={'file': 'myregion.rgn', 'channel': 10}" would result
	in the same level of zoom and would display channel number 10 from
	the cube.


	
        """

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['raster'] = raster
        mytmp['contour'] = contour
        mytmp['zoom'] = zoom
        mytmp['axes'] = axes
        mytmp['out'] = out
	pathname='file://' + xmlpath( ) + '/'
	trec = casac.utils().torecord(pathname+'imview.xml')

        casalog.origin('imview')
        if trec.has_key('imview') and casac.utils().verify(mytmp, trec['imview']) :
	    result = task_imview.imview(raster, contour, zoom, axes, out)

	else :
	  result = False
        return result
