#
# This file was generated using xslt from its XML file
#
# Copyright 2009, Associated Universities Inc., Washington DC
#
import sys
import os
from  casac import *
import string
from taskinit import casalog
from taskinit import xmlpath
#from taskmanager import tm
import task_imregrid
def imregrid(imagename='', template='get', output='', asvelocity=True, axes=[-1], shape=[-1], interpolation='linear', decimate=10, replicate=False, overwrite=False):

        """regrid an image onto a template image
The imregrid task currently finds the nearest input pixel center and interpolates to the output pixel center.
No averaging is done in any direction!

Imregrid will regrid an input image onto a new coordinate system from a template image
or to a new directional reference frame. If a template image is used, then the input and
template images must have the same coordinate structure.

Keyword arguments:

imagename       Name of the source image that needs to be regridded. Must be specified.
                example: imagename='orion.image'
template        Dictionary, directional reference code, or imagename defining the new
                shape and coordinate system, or 'get' to return the template
                dictionary for imagename.  Recognized directional reference codes are:
                'J2000', 'B1950', 'B1950_VLA', 'GALACTIC', 'HADEC', 'AZEL',
                'AZELSW', 'AZELNE', 'ECLIPTIC', 'MECLIPTIC', 'TECLIPTIC',
                and 'SUPERGAL'.
                default: 'get'; example: template='orion_j2000.im' (for a template image),
                template='J2000' (to regrid the input image to J2000 coordinates).
shape           Shape of the output image. Only used if template is an image.
                If not specified (-1), the output image will be the same as the template image
                shape along the axes which are regridded and the same as the input image shpae
                along the axes which are not regridded. If specified and the axis ordering between
                the input image and the template are not the same, the values in the array correspond
                to the axis ordering of the input image; the output image will have the same axis
                ordering as the input image. Ignored if template is set equal to a
                reference code. If template is a dictionary, the output shape is
                retrieved from the dictionary so the shape input parameter is ignored.
output          Name for the regridded image.  Must be specified.
                example: imagename='orion_shifted.im'
asvelocity      If True, regrid spectral axis with respect to velocity, not frequency. If False,
                regrid with respect to frequency. default: True
axes            The pixel axes to regrid. Default value [-1] => all except Stokes. Ignored
                if template is set equal to a reference code (in which case only the directional
                axes are regridded). If specified, this should
                be provided as an array. example axes=[0,1] (only regrid the first two axes, which
                are normally the directional axes).
interpolation   The interpolation method.  One of 'nearest', 'linear', 'cubic'.
decimate        Decimation factor for coordinate grid computation
replicate       Replicate image rather than regrid?
overwrite">     Overwrite (unprompted) pre-existing output file?
async           Run task in a separate process (return CASA prompt)
                default: False; example: async=True
                
The new coordinate system is defined by the template parameter, which can be:

    * a recognized directional reference frame string. This will rotate the image and the coordinate system so that
      the new reference frame's axes are aligned to the cardinal directions (left-right, up-down).
      Rotation occurs about the center direction pixel. If this pixel is not the reference pixel,
      a temporary copy of the original image is created and the coordinate system is adjusted so
      the center direction pixel is the reference pixel. The coordinate system of the input image
      is not modified and the output image's reference direction pixel is the center pixel.
      Note that the conversion between one frame and another in general becomes less accurate
      as distance from the output image's reference pixel increases. Before the rotation occurs, the
      image is padded with masked pixels to ensure that all good pixels are used in the rotation (ie the
      corners of the image are not cropped after the rotation). After the image is rotated, any masked slices
      remaining along the edges of the image in the directional coordinate are cropped, so that there are
      no masked slices in the directional coordinate along the edges of the final image.
    * a {'csys': [valid coordinate system dictionary], 'shap': [int array describing the output shape]} dictionary.
      This is normally obtained by first running regrid with template='get'. In this case imregrid returns the
      necessary dictionary.
    * 'get', which does not regrid but returns the template dictionary
      for imagename, suitable for modification and reuse (see the point immediately above), or
    * the name of an image from which to get the coordinate system and shape.
      The input and template images must have the same
      coordinate structure.
      
Regridding of complex-valued images is supported. The real and imaginary parts are
regridded independently and the resulting regridded pixel values are combined to
form the regridded, complex-valued image.

The argument {\stfaf replicate} can be used to simply replicate pixels
rather than regridding them.  Normally ({\stfaf replicate=F}), for every
output pixel, its world coordinate is computed and the corresponding
input pixel found (then a little interpolation grid is generated).  If
you set {\stfaf replicate=T}, then what happens is that for every output
axis, a vector of regularly sampled input pixels is generated (based on
the ratio of the output and input axis shapes).  So this just means the
pixels get replicated (by whatever interpolation scheme you use) rather
than regridded in world coordinate space.  This process is much faster,
but its not a true world coordinate based regrid. 

As decribed above, when {\stfaf replicate} is False, a coordinate is
computed for each output pixel; this is an expensive operation.  The
argument {\stfaf decimate} allows you to decimate the computation of
that coordinate grid to a sparse grid, which is then filled in via fast
interpolation.  The default for {\stfaf decimate} is 10.  The number of
pixels per axis in the sparse grid is the number of output pixels for
that axis divided by the decimation factor.  A factor of 10 does pretty
well.  You may find that for very non-linear coordinate systems (e.g. 
very close to the pole) that you have to reduce the decimation factor.
You may also have to reduce the decimation factor if the number of pixels
in the output image along an axis to be regridded is less than about 50, or
the output image may be completely masked.

If one of the axes to be regridded is a spectral axis and asvelocity=T,
the axis will be regridded to match the velocity, not the frequency,
coordinate of the template coordinate system. Thus the output pixel
values will correspond only to the velocity, not the frequency, of the
output axis.

A variety of interpolation schemes are provided (only
the first three characters to be specified).  The cubic interpolation
is substantially slower than linear, and often the improvement is
modest.  By default linear interpolation is used.

If an image has per-plane beams and one attempts to regrid the spectral axis,
an exception is thrown.

RULES USED FOR GENERATING OUTPUT IMAGES IN SPECIFIC CASES

There are numerous rules governing the shape and coordinate system of the output
image depending on the input image, template image, and wheher default values of the
axes and shape parameters are used. They are enumerated below. 

NOTE: If you want to be certain of what type of output you will get, it is highly
recommended you specify both axes and shape to avoid any ambiguity.

1. Rules governing Stokes axes
    1.1. If the input image has no stokes axis, then the output image will have no stokes axis.
    1.2. If the input image has a stokes axis, but the template image/coordinate system does not,
         and if the default value of the shape parameter is used or if shape is specified and the
         specified value for the length stokes axis in equal to the length of the input image
         stokes axis, then all stokes in the input
         image will be present in the output image
    1.3. If the input image has a stokes axis, but the template image/coordinate system does not,
         and if the value of the shape parameter is specified but the length of the resulting stokes
         axis is not equal to the length of the input image's stokes axis, a failure will occur.
    1.4. If the input image has a stokes axis, if the template parameter is an image name, and if the
         template image has a degenerate stokes axis, if the axes parameter is not specified or is specified
         but does not contain the input stokes axis number, and if the shape parameter is not specified, then
         all stokes planes in the input image will be present in the output image.
    1.5. If the input image has a stokes axis, if the template parameter is an image name, and if the
         template image has a degenerate stokes axis, if the axes parameter is not specified or is specified
         but does not contain the input stokes axis number, if the shape parameter is specified, and if the
         specified length of the stokes axis is not equal to the length of the input stokes axis, then
         a failure will occur.
    1.6. If the input image has a stokes axis, if the template parameter is an image name, if the
         template image has a degenerate stokes axis, if the axes parameter is specified contains the
         input stokes axis number, then use the applicable rule of rules 1.7. and 1.8. for the template
         image having a nondegenerate stokes axis.
    1.7. If the input image has a stokes axis, if the template parameter is an image name, if the
         template image has a nondegenerate stokes axis, and if axes is not specified or if it is, it contains
         the input stokes axis number, then only the stokes parameters common to both the input image and
         the template image will be present in the output image. If the input image and the template image
         have no common stokes parameters, failure will occur. If shape is specified and the length of the
         specified stokes axis is not equal to the number of common stokes parameters in the input image and
         the template image, then failure will result.
    1.8. If the input image has a stokes axis, if the template parameter is an image name, if the
         template image has a nondegenerate stokes axis, and if axes is specified but does not contain the input
         image stokes axis number, then all stokes present in the input image will be present in the output image.
         If shape is also specified but the length of the specified stokes axis does not equal the length of
         the input stokes axis, then failure will result.

2. Rules governing spectral axes
    In all cases, if the shape parameter is specified, the spectral axis length must be consistent with what
    one would normally expect in the special cases, or a failure will result.
    2.1. If the input image does not have a spectral axis, then the output image will not have a spectral axis.
    2.2. If the input image has a degenerate spectral axis, if the template parameter is an image name, and if the
         template image has a spectral axis, if axes is not specified or if it is and does not
         contain the input image spectral axis number, then the spectral coordinate of the input image is copied
         to the output image and the output image will have a degenerate spectral axis.
    2.3. If the input image has a degenerate spectral axis, if the template parameter is an image name, and if the
         template image has a spectral axis, if axes is specified and it
         contains the input image spectral axis number, then the spectral coordinate of the template image is copied
         to the output image. If shape is not specified, the output image will have the same number of channels
         as the input image. If shape is specified, the output image will have the number of channels as specified
         in shape for the spectral axis. In these cases, the pixel and mask values for all spectral hyperplanes
         will be identical; the regridded single spectral plane is simply replicated n times, where n is the
         number of channels in the output image.
    2.4. If the input image has a spectral axis, if the template parameter is an image name, and if the
         template image does not have a spectral axis, if axes is not specified or if it is and does not
         contain the input image spectral axis number, then the spectral coordinate of the input image is copied
         to the output image and the output image will have the same number of channels as the input image.
    2.5. If the input image has a spectral axis, if the template parameter is an image name, if the
         template image does not have a spectral axis, if axes is specified it 
         contains the input image spectral axis number, then failure will result.
    2.6. If the input image has a spectral axis, if the template parameter is an image name, if the
         template image has a degenerate spectral axis, and if axes is unspecified or if it is but does not
         contain the spectral axis number of the input image, the spectral coordinate of the input image is
         copied to the output image and the output image will have the same number of channels as the input
         image.
    2.7. If the input image has a spectral axis, if the template parameter is an image name, if the
         template image has a nondegenerate spectral axis, and if axes is unspecified or if it is and
         contains the spectral axis number of the input image, regrid the spectral axis of the input to
         match the spectral axis of the template.
         
IMPORTANT NOTE ABOUT FLUX CONSERVATION
in general regridding is inaccurate for images that the angular resolution is poorly
sampled. A check is done for such cases and a warning message is emitted if a beam present.
However, no such check is done if there is no beam present. To add a restoring beam to
an image, use ia.setrestoringbeam().
         
Basic Examples

# Regrid an image to the "B1950" or "GALACTIC" coordinate systems

   imregrid(imagename="input.image", output="output.image", template="B1950")
   imregrid(imagename="input.image", output="output.image", template="GALACTIC")

Note that when regridding to another coordinate system in the manner above, if the
input image's direction coordinate is already in the frame specified by template,
a straight copy of the image is made. No regridding is actually done.

# Obtain a template dictionary from an image and then use it to regrid another image

   temp_dict = imregrid(imagename="target.image", template="get")
   imregrid(imagename="input.image", output="output.image", template=temp_dict)

In this example, the template="get" option is used in the first command in order to
characterize the desired shape and coordinate system used, and a new dictionary,
temp_dict, is generated accordingly. This is then used when performing the actual
regridding of input.image in the second command. 


More Advanced Examples

It is also possible to directly use a template image for regridding with imregrid.
For this to work reliably and predictably, the dimensionality (i.e. which
dimensions are present in an image) and the axis ordering of the input image must
be the same. The type and ordering of the axes of both the input and template
images can (and should) first be examined using the CASA imhead task. Any
necessary reordering of axes can be performed using the CASA imtrans task.

Unless the user explicitly specifies which dimensions to regrid using the axes
parameter (see the following example), imregrid will also attempt to regrid
degenerate axes (i.e. image axes of length one pixel). Stokes axes are never
regridded.

In the case where template is an image name and the default value of shape is specified,
the output image's shape will be the same as the template image's shape along the axes which
are regridded and the same as the input image's shape along the axes which are not regridded.
So for example, if the input image has a shape of [20, 30, 40] and the template image has a shape
of [10, 40, 70] and only axes=[0, 1], the output image will have a shape of [10, 40, 40]. If axes=[2],
the output image will have a shape of [20, 30, 70].

# Regrid input.image by directly using target.image as a template

   imregrid(imagename="input.image", output="output.image", template="target.image", shape=[500,500,40,1])

In this example, it is assumed that the axis order of the input image is of the
form (direction_x, direction_y, spectral, Stokes), where 'direction_x' and 'direction_y'
are the directional coordinates on the sky (in some reference frame),
'spectral' is a velocity/frequency axis, and 'Stokes' contains polarization
information.  In this example, input.image might typically be a data cube of
shape [100, 100, 40, 1]. Note that the default value of asvelocity (True) will be used so that
the spectral axis will be regridded to the same velocity system as that of the template image.


# Regrid only the first two axes of an image

Firstly, the user should inspect the type and ordering of the axes with imhead,
and then correct with imtrans if necessary.

   imregrid(imagename="input.image", output="output.image", template="target.image", axes=[0,1])

The above command will regrid only the first two axes (normally the directional axes)  of input.image and
leave all other axes unchanged. The output image will have the shape of the template image along the regridded
axes [0, 1] and the shape of the  input image along the other axes since the shape parameter was not
explicitly specified.


# Regrid the third axis, considering velocity rather than frequency units

   imregrid(imagename="input.image", output="output.image", template="target.image", axes=[2], asvelocity=True)

This example regrids the spectral axis (zero-based axis number 2)  with respect to velocity because the asvelocity parameter
has been set to True. This is useful when eg, regridding a cube containing one spectral line to match the velocity coordinate
of another cube containing a different spectral line.


# Regrid the third axis, considering velocity rather than frequency units but first set the rest frequency

   imhead("input.image", mode="put", hdkey="restfreq", hdvalue="110GHz")
   imregrid(imagename="input.image", output="output.image", template="target.image", axes=[2], asvelocity=True)

The first command in this example uses the imhead task to set the value of the
image rest frequency to a value of 110GHz in input.image. The following
imregrid command then performs a frequency units regridding only of the third
axis listed (zero-based axis) (2), taking account of the input.image rest frequency in the input file.



        """
        if type(axes)==int: axes=[axes]
        if type(shape)==int: shape=[shape]

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['imagename'] = imagename
        mytmp['template'] = template
        mytmp['output'] = output
        mytmp['asvelocity'] = asvelocity
        mytmp['axes'] = axes
        mytmp['shape'] = shape
        mytmp['interpolation'] = interpolation
        mytmp['decimate'] = decimate
        mytmp['replicate'] = replicate
        mytmp['overwrite'] = overwrite
	pathname='file://' + xmlpath( ) + '/'
	trec = casac.utils().torecord(pathname+'imregrid.xml')

        casalog.origin('imregrid')
        if trec.has_key('imregrid') and casac.utils().verify(mytmp, trec['imregrid']) :
	    result = task_imregrid.imregrid(imagename, template, output, asvelocity, axes, shape, interpolation, decimate, replicate, overwrite)

	else :
	  result = False
        return result
