#
# This file was generated using xslt from its XML file
#
# Copyright 2009, Associated Universities Inc., Washington DC
#
import sys
import os
from  casac import *
import string
from taskinit import casalog
from taskinit import xmlpath
#from taskmanager import tm
import task_importvla
def importvla(archivefiles=[''], vis='', bandname='', frequencytol='150000.0Hz', project='', starttime='', stoptime='', applytsys=True, autocorr=False, antnamescheme='new', keepblanks=False, evlabands=False):

        """Import VLA archive file(s) to a measurement set

      Imports an arbitrary number of VLA archive-format data sets into
      a casa measurement set.  If more than one band is present, they
      will be put in the same measurement set but in a separate spectral
      window.  The task will handle old style and new style VLA (after
      July 2007) archive data and apply the tsys to the data and to
      the weights.

      Keyword arguments:
      archivefiles -- Name of input VLA archive file(s)
              default: none.  Must be supplied
              example: archivefiles = 'AP314_A959519.xp1'
              example: archivefiles=['AP314_A950519.xp1','AP314_A950519.xp2']
      vis -- Name of output visibility file
              default: none.  Must be supplied.
              example: vis='NGC7538.ms'
              Will not over-write existing ms of same name.
              A backup flag-file version 'Original' will be made in
                vis.flagversions.  See help flagmanager
      bandname -- VLA Frequency band
              default: => '' = all bands
              example: bandname='K'
              Options: '4'=48-96 MHz,'P'=298-345 MHz,'L'=1.15-1.75 GHz,
              'C'=4.2-5.1 GHz,'X'=6.8-9.6 GHz,'U'=13.5-16.3 GHz,
              'K'=20.8-25.8 GHz,'Q'=38-51 GHz
      frequencytol -- Tolerance in frequency shift in making spectral windows
              default: => 150000 (Hz).  For Doppler shifted data, <10000 Hz may
              may produce too many unnecessary spectral windows.
              example: frequencytol = 1500000.0 (units = Hz)
      project -- Project name to import from archive files:
              default: '' => all projects in file
              example: project='AL519'
              project = 'al519' or AL519 will work.  Do not include
              leading zeros; project = 'AL0519' will not work.
      starttime -- Time after which data will be considered for importing
              default: '' => all:  Date must be included.
              syntax: starttime = '2003/1/31/05:05:23'
      stoptime --  Time before which data will be considered for importing
              default: '' => all:  Date must be included.
              syntax: stoptime = '2003/1/31/08:05:23'
      applytsys -- Apply data scaling and weight scaling by nominal
              sensitivity (~Tsys)
              default: True.  Strongly recommended
      autocorr --  import autocorrelations to ms
              default:  => False (no autocorrelations)
      antnamescheme -- 'old' or 'new' antenna names.
              default => 'new' gives antnenna names
                'VA04' or 'EA13 for VLA telescopse 04 and 13 (EVLA)
                'old' gives names '04' or '13'
      keepblanks -- Should sources with blank names be filled into the data base
              default => false.  Do not fill
              These scans are tipping scans (as of June 1, 2009) and should not
              be filled in the visibility data set.
      evlabands -- Use the EVLA's center frequency and bandwidths for frequencies
              specified via wavelength or band.
	      default => False.
      async --  Run asynchronously
              default = False; do not run asychronously
      
        """
        if type(archivefiles)==str: archivefiles=[archivefiles]

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['archivefiles'] = archivefiles
        mytmp['vis'] = vis
        mytmp['bandname'] = bandname
        if type(frequencytol) == str :
           mytmp['frequencytol'] = casac.quanta().quantity(frequencytol)
        else :
           mytmp['frequencytol'] = frequencytol
        mytmp['project'] = project
        mytmp['starttime'] = starttime
        mytmp['stoptime'] = stoptime
        mytmp['applytsys'] = applytsys
        mytmp['autocorr'] = autocorr
        mytmp['antnamescheme'] = antnamescheme
        mytmp['keepblanks'] = keepblanks
        mytmp['evlabands'] = evlabands
	pathname='file://' + xmlpath( ) + '/'
	trec = casac.utils().torecord(pathname+'importvla.xml')

        casalog.origin('importvla')
        if trec.has_key('importvla') and casac.utils().verify(mytmp, trec['importvla']) :
	    result = task_importvla.importvla(archivefiles, vis, bandname, frequencytol, project, starttime, stoptime, applytsys, autocorr, antnamescheme, keepblanks, evlabands)

	else :
	  result = False
        return result
