#
# This file was generated using xslt from its XML file
#
# Copyright 2009, Associated Universities Inc., Washington DC
#
import sys
import os
from  casac import *
import string
from taskinit import casalog
from taskinit import xmlpath
#from taskmanager import tm
import task_importfitsidi
def importfitsidi(fitsidifile=[''], vis='', constobsid=False, scanreindexgap_s=0., specframe='GEO'):

        """Convert a FITS-IDI file to a CASA visibility data set
	If several files are given, they will be concatenated into one MS.

        Keyword arguments:
        fitsidifile -- Name(s) of input FITS-IDI file(s)
                default: none; must be supplied 
		example='3C273XC1.IDI'
		example=['3C273XC1.IDI1','3C273XC1.IDI2'] 
        vis -- Name of output visibility file (MS)
                default: none; example: vis='3C273XC1.ms'
	constobsid -- If True a constant obs id == 0 is given to all input files 
	        default = False (new obs id for each input file)
	scanreindexgap_s --  if > 0., a new scan is started whenever the gap between two
                integrations is > the given value (seconds) or when a new field starts
                or when the ARRAY_ID changes.
                default = 0. (no reindexing)
        specframe -- this frame will be used to set the spectral reference frame
                for all spectral windows in the output MS
                default = GEO (geocentric), other options: TOPO, LSRK, BARY
                NOTE: if specframe is set to TOPO, the reference location will be taken from
                the Observatories table in the CASA data repository for the given name of
                the observatory. You can edit that table and add new rows.   


 
        """
        if type(fitsidifile)==str: fitsidifile=[fitsidifile]

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['fitsidifile'] = fitsidifile
        mytmp['vis'] = vis
        mytmp['constobsid'] = constobsid
        mytmp['scanreindexgap_s'] = scanreindexgap_s
        mytmp['specframe'] = specframe
	pathname='file://' + xmlpath( ) + '/'
	trec = casac.utils().torecord(pathname+'importfitsidi.xml')

        casalog.origin('importfitsidi')
        if trec.has_key('importfitsidi') and casac.utils().verify(mytmp, trec['importfitsidi']) :
	    result = task_importfitsidi.importfitsidi(fitsidifile, vis, constobsid, scanreindexgap_s, specframe)

	else :
	  result = False
        return result
