#
# This file was generated using xslt from its XML file
#
# Copyright 2014, Associated Universities Inc., Washington DC
#
import sys
import os
#from casac import *
import casac
import string
import time
import inspect
import gc
import numpy
from casa_stack_manip import stack_frame_find
from odict import odict
from types import * 
from task_importevla import importevla
class importevla_cli_:
    __name__ = "importevla"
    rkey = None
    i_am_a_casapy_task = None
    # The existence of the i_am_a_casapy_task attribute allows help()
    # (and other) to treat casapy tasks as a special case.

    def __init__(self) :
       self.__bases__ = (importevla_cli_,)
       self.__doc__ = self.__call__.__doc__

       self.parameters={'asdm':None, 'vis':None, 'ocorr_mode':None, 'compression':None, 'asis':None, 'scans':None, 'verbose':None, 'overwrite':None, 'online':None, 'tbuff':None, 'flagzero':None, 'flagpol':None, 'shadow':None, 'tolerance':None, 'addantenna':None, 'applyflags':None, 'savecmds':None, 'outfile':None, 'flagbackup':None, 'polyephem_tabtimestep':None, }


    def result(self, key=None):
	    #### and add any that have completed...
	    return None


    def __call__(self, asdm=None, vis=None, ocorr_mode=None, compression=None, asis=None, scans=None, verbose=None, overwrite=None, online=None, tbuff=None, flagzero=None, flagpol=None, shadow=None, tolerance=None, addantenna=None, applyflags=None, savecmds=None, outfile=None, flagbackup=None, polyephem_tabtimestep=None, ):

        """Convert an Science Data Model observation into a CASA Measurement Set
	Arguments :
		asdm:	Name of input asdm directory (on disk)
		   Default Value: 

		vis:	Root name of the ms to be created. Note the .ms is NOT added 
		   Default Value: 

		ocorr_mode:	Fill correlation mode AUTO_ONLY (ao), CROSS_ONLY (co) or CROSS_AND_AUTO (ca)
		   Default Value: co
		   Allowed Values:
				co
				ao
				ca

		compression:	Flag for turning on data compression
		   Default Value: False

		asis:	Create verbatim copies of these SDM tables in the MS.
		   Default Value: 

		scans:	List of scans to fill (default is all scans).
		   Default Value: 

		verbose:	Output lots of information while the filler is working
		   Default Value: False

		overwrite:	Over write an existing MS
		   Default Value: False

		online:	Create online flags
		   Default Value: True

		tbuff:	Time padding buffer (in seconds)
		   Default Value: 0.0

		flagzero:	Create flag commands for zero points
		   Default Value: True

		flagpol:	Create flag commands for cross-hand correlations
		   Default Value: True

		shadow:	Create flag commands for shadowed data
		   Default Value: True

		tolerance:	Amount of shadow allowed (in meters)
		   Default Value: 0.0

		addantenna:	File name or dictionary with additional antenna names, positions and diameters
		   Default Value: 

		applyflags:	Apply flag commands to MS
		   Default Value: False

		savecmds:	Save flag commands to an ASCII file
		   Default Value: False

		outfile:	Name of ASCII file to save flag commands
		   Default Value: 

		flagbackup:	Back up flag column before applying flags
		   Default Value: True

		polyephem_tabtimestep:	Timestep (days) for the tabulation of polynomial ephemerides. A value <= 0 disables tabulation.
		   Default Value: 0.001

	Returns: void

	Example :

Convert a Science Data Model (SDM) dataset into a CASA Measurement Set (MS).  
Will place online flags and specified clip/shadow flags into FLAG_CMD table 
and optionally apply to MS.

Warning: This version is under development and is geared to handling EVLA 
specific flag and system files, and is otherwise identical to importasdm.
				          
        HISTORY: Task created v1.0 S.T. Myers 2010-03-11 (3.0.1)
                 Last updated v9.0 S.M. Castro 2012-03-13 (3.4) code+doc

Keyword arguments:
asdm         -- Name of input SDM file (directory)
                default: none; 
                    Example: asdm='ExecBlock3'

vis          -- Root ms or scantable name, note a .ms is NOT appended to name
                default: none

ocorr_mode   -- output data for correlation mode AUTO_ONLY 
                (ao) or CROSS_ONLY (co) or CROSS_AND_AUTO (ca)
		default: co (for EVLA)

compression  -- produces comrpressed columns in the resulting measurement set.
                default: False

asis         -- creates verbatim copies of the ASDM tables in 
                the output measurement set. The value given to
		this option must be a list of table names separated
		by space characters; the wildcard character '*' is 
                allowed in table names.

scans        -- processes the scans requested in this parameter (default is
                all scans).  For simplest use provide a comma-separated list of 
		scan ranges, e.g. scans='1~3,5,10~20'.
                default: '' = all scans

                NOTE: A scan specification tecnically consists of an ExecBlock 
                index followed by the character ':' followed by a comma
                separated list of scan indexes or scan index ranges. The EVLA
                does not currently include more than one ExecBlock in a SDM
                so this specification prefix is not needed.

                By default all the scans are considered. 

overwrite    -- Over write an existing MS

verbose      -- produce log output as asdm2MS is being run

polyephem_tabtimestep -- Timestep (days) for the tabulation of polynomial ephemerides. 
               A value <= 0 disables tabulation.

EVLA-specific parameters:
-------------------------

online       -- create flagging commands for online flags. The commands will be saved to the FLAG_CMD 
                sub-table of the MS. Optionally, it can also be saved to an ASCII file when savecmds is set
                to True.
                default: True
 
            >>> online expandable parameters
                 tbuff -- (float) time padding buffer (in seconds)
                 default: 0.0

                 NOTE: this time is in seconds. You should currently
                 set the value of tbuff to be 1.5x the correlator
                 integration time if greater than 1 second.  For
                 example, if the SDM has integrations of 3 seconds,
                 set tbuff=4.5.  Likewise, set tbuff=15.0 for 10-sec
                 integrations.
                                  
 
flagzero     -- create flags to clip out visibilities with zero values. The command will be saved to the FLAG_CMD 
                sub-table of the MS. Optionally, it can also be saved to an ASCII file when savecmds is set
                to True.
                default: True
 
            >>> flagzero expandable parameter(s) 
                 flagpol -- (boolean) also zero-clip on cross-hands (default=False)
 
shadow       -- create flags for antennas that are shadowed. The command will be saved to the FLAG_CMD 
                sub-table of the MS. Optionally, it can also be saved to an ASCII file when savecmds is set
                to True.
                default: True
 
            >>> shadow expandable parameter
                 tolerance -- Amount of shadowing allowed in meters.
                   default: 0.0

                 addantenna -- It can be either a file name with additional antenna names, positions 
                               and diameters, or a Python dictionary with the same information. 
                               You can use the flaghelper functions to create the dictionary from a file.  
                   default: ''
                   
                   To create a dictionary inside casapy.
                   > import flaghelper as fh
                   > antdic = fh.readAntennaList(antfile)
                   
                   Where antfile is a text file in disk that contains information such as:
                    name=VLA01
                    diameter=25.0
                    position=[-1601144.96146691, -5041998.01971858, 3554864.76811967]
                    name=VLA02
                    diameter=25.0
                    position=[-1601105.7664601889, -5042022.3917835914, 3554847.245159178]
                   
 
applyflags   -- apply the online and specified flags to the MS
                default: False


savecmds   -- Save the flag commands to an ASCII file given by the parameter outfile. It will save the
              flag commands from online, flagzero and/or shadow if they are set to True. 
                default: False
                    
            >>> savecmds expandable parameter
                outfile      -- Filename where to save the flag commands.
                default: ' ' --> by default it will save on a filename composed from the MS name.
                    Example: vis='evla.ms', the outfile will be 'evla_cmd.txt'. 
                    
                    NOTE: The file is open to save in append mode.


flagbackup   -- Backup original flags in >ms<.flagversions 
                default: True

       Examples:


        1)  Produces MS CLowTest_000.ms with autocorrelations.
            You will find the online, zero, and shadow flags in the FLAG_CMD table
            for later application.  Does not apply any flags.
                
             importevla(asdm='CLowTest_000',ocorr_mode='ca')
                

        2)  Produces MS CLowTest_000.ms without autocorrelations.  
               
             importevla(asdm='CLowTest_000')
                

        3)  Will apply online flags and uses a more conservative 2sec buffer
                before the start and after the end timeranges.
                
             importevla(asdm='CLowTest_000',online=True,tbuff=2.0,applyflags=True)
                

        4)  This will create the FLAG_CMD sub-table using online flags only,
            but will not apply them to the MS.

            importevla(asdm='CLowTest_000',online=True,flagzero=False,shadow=False)


        5)  This will write the online flags to the FLAG_CMD table. It will also save commands
            to clip zeros and to flag shadowed antennas to the table. The commands will be further 
            applied to the data and the APPLIED column of the FLAG_CMD will be updated to True.

            importevla(asdm='CLowTest_000',online=True,flagzero=True,shadow=True,applyflags=True)


        6)  Import only scans 1, 2, 3, 5, 7, 9, save the online, shadow and clip commands to an ASCII file and
            do not apply the flags. The commands will be saved to CLowTest_000_cmd.txt.

            importevla(asdm='CLowTest_000',scans='1~3,5,7,9',online=True,flagzero=True,shadow=True,
                                applyflags=False, savecmds=True)
                
                You can use either flagdata or flagcmd to apply the flags later with the following commands:
                
                Apply all the flags in the file using flagdata
                flagdata('CLowTest_000.ms', mode='list', inpfile='CLowTest_000_cmd.txt')

                Select by reason on the file
                flagdata('CLowTest_000.ms',mode='list', inpfile='CLowTest_000_cmd.txt', 
                           reason=['ANTENNA_NOT_POINTING','CORRELATOR_DATA_INVALID'])
                
                Apply all the flags in the file using flagcmd
                flagcmd('CLowTest_000.ms',inpmode='list',inpfile='CLTest_000_cmd.txt',action='apply')
                                

HISTORY: Task last updated v9.0 S.M. Castro 2012-03-8 (3.4.0)
         Docs last updated v9.0 S.M. Castro 2012-03-13 (3.4.0)

  
        """
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
	#casac = self.__globals__['casac']
	casalog = self.__globals__['casalog']
	casa = self.__globals__['casa']
	#casalog = casac.casac.logsink()
        self.__globals__['__last_task'] = 'importevla'
        self.__globals__['taskname'] = 'importevla'
        ###
        self.__globals__['update_params'](func=self.__globals__['taskname'],printtext=False,ipython_globals=self.__globals__)
        ###
        ###
        #Handle globals or user over-ride of arguments
        #
        if type(self.__call__.func_defaults) is NoneType:
            function_signature_defaults={}
	else:
	    function_signature_defaults=dict(zip(self.__call__.func_code.co_varnames[1:],self.__call__.func_defaults))
	useLocalDefaults = False

        for item in function_signature_defaults.iteritems():
                key,val = item
                keyVal = eval(key)
                if (keyVal == None):
                        #user hasn't set it - use global/default
                        pass
                else:
                        #user has set it - use over-ride
			if (key != 'self') :
			   useLocalDefaults = True

	myparams = {}
	if useLocalDefaults :
	   for item in function_signature_defaults.iteritems():
	       key,val = item
	       keyVal = eval(key)
	       exec('myparams[key] = keyVal')
	       self.parameters[key] = keyVal
	       if (keyVal == None):
	           exec('myparams[key] = '+ key + ' = self.itsdefault(key)')
		   keyVal = eval(key)
		   if(type(keyVal) == dict) :
                      if len(keyVal) > 0 :
		         exec('myparams[key] = ' + key + ' = keyVal[len(keyVal)-1][\'value\']')
		      else :
		         exec('myparams[key] = ' + key + ' = {}')
	 
        else :
            print ''

            myparams['asdm'] = asdm = self.parameters['asdm']
            myparams['vis'] = vis = self.parameters['vis']
            myparams['ocorr_mode'] = ocorr_mode = self.parameters['ocorr_mode']
            myparams['compression'] = compression = self.parameters['compression']
            myparams['asis'] = asis = self.parameters['asis']
            myparams['scans'] = scans = self.parameters['scans']
            myparams['verbose'] = verbose = self.parameters['verbose']
            myparams['overwrite'] = overwrite = self.parameters['overwrite']
            myparams['online'] = online = self.parameters['online']
            myparams['tbuff'] = tbuff = self.parameters['tbuff']
            myparams['flagzero'] = flagzero = self.parameters['flagzero']
            myparams['flagpol'] = flagpol = self.parameters['flagpol']
            myparams['shadow'] = shadow = self.parameters['shadow']
            myparams['tolerance'] = tolerance = self.parameters['tolerance']
            myparams['addantenna'] = addantenna = self.parameters['addantenna']
            myparams['applyflags'] = applyflags = self.parameters['applyflags']
            myparams['savecmds'] = savecmds = self.parameters['savecmds']
            myparams['outfile'] = outfile = self.parameters['outfile']
            myparams['flagbackup'] = flagbackup = self.parameters['flagbackup']
            myparams['polyephem_tabtimestep'] = polyephem_tabtimestep = self.parameters['polyephem_tabtimestep']


	result = None

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['asdm'] = asdm
        mytmp['vis'] = vis
        mytmp['ocorr_mode'] = ocorr_mode
        mytmp['compression'] = compression
        mytmp['asis'] = asis
        mytmp['scans'] = scans
        mytmp['verbose'] = verbose
        mytmp['overwrite'] = overwrite
        mytmp['online'] = online
        mytmp['tbuff'] = tbuff
        mytmp['flagzero'] = flagzero
        mytmp['flagpol'] = flagpol
        mytmp['shadow'] = shadow
        mytmp['tolerance'] = tolerance
        mytmp['addantenna'] = addantenna
        mytmp['applyflags'] = applyflags
        mytmp['savecmds'] = savecmds
        mytmp['outfile'] = outfile
        mytmp['flagbackup'] = flagbackup
        mytmp['polyephem_tabtimestep'] = polyephem_tabtimestep
	pathname='file://' + casa['dirs']['xml'] + '/'
	trec = casac.casac.utils().torecord(pathname+'importevla.xml')

        casalog.origin('importevla')
	try :
          #if not trec.has_key('importevla') or not casac.casac.utils().verify(mytmp, trec['importevla']) :
	    #return False

          casac.casac.utils().verify(mytmp, trec['importevla'], True)
          scriptstr=['']
          saveinputs = self.__globals__['saveinputs']
          if type(self.__call__.func_defaults) is NoneType:
              saveinputs=''
          else:
              saveinputs('importevla', 'importevla.last', myparams, self.__globals__,scriptstr=scriptstr)
          tname = 'importevla'
          spaces = ' '*(18-len(tname))
          casalog.post('\n##########################################'+
                       '\n##### Begin Task: ' + tname + spaces + ' #####')
          if type(self.__call__.func_defaults) is NoneType:
              casalog.post(scriptstr[0]+'\n', 'INFO')
          else :
              casalog.post(scriptstr[1][1:]+'\n', 'INFO')
          result = importevla(asdm, vis, ocorr_mode, compression, asis, scans, verbose, overwrite, online, tbuff, flagzero, flagpol, shadow, tolerance, addantenna, applyflags, savecmds, outfile, flagbackup, polyephem_tabtimestep)
          casalog.post('##### End Task: ' + tname + '  ' + spaces + ' #####'+
                       '\n##########################################')

	except Exception, instance:
          if(self.__globals__.has_key('__rethrow_casa_exceptions') and self.__globals__['__rethrow_casa_exceptions']) :
             raise
          else :
             #print '**** Error **** ',instance
	     tname = 'importevla'
             casalog.post('An error occurred running task '+tname+'.', 'ERROR')
             pass

        gc.collect()
        return result
#
#
#
    def paramgui(self, useGlobals=True, ipython_globals=None):
        """
        Opens a parameter GUI for this task.  If useGlobals is true, then any relevant global parameter settings are used.
        """
        import paramgui
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )

        if useGlobals:
	    if ipython_globals == None:
                myf=self.__globals__
            else:
                myf=ipython_globals

            paramgui.setGlobals(myf)
        else:
            paramgui.setGlobals({})

        paramgui.runTask('importevla', myf['_ip'])
        paramgui.setGlobals({})

#
#
#
    def defaults(self, param=None, ipython_globals=None, paramvalue=None, subparam=None):
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
        if ipython_globals == None:
            myf=self.__globals__
        else:
            myf=ipython_globals

        a = odict()
        a['asdm']  = ''
        a['vis']  = ''
        a['ocorr_mode']  = 'co'
        a['compression']  = False
        a['asis']  = ''
        a['scans']  = ''
        a['verbose']  = False
        a['overwrite']  = False
        a['online']  = True
        a['flagzero']  = True
        a['shadow']  = True
        a['applyflags']  = False
        a['savecmds']  = False
        a['flagbackup']  = True
        a['polyephem_tabtimestep']  = 0.001

        a['online'] = {
                    0:odict([{'value':True}, {'tbuff':0.0}]), 
                    1:{'value':False}}
        a['flagzero'] = {
                    0:odict([{'value':True}, {'flagpol':True}]), 
                    1:{'value':False}}
        a['shadow'] = {
                    0:odict([{'value':True}, {'tolerance':0.0}, {'addantenna':''}]), 
                    1:{'value':False}}
        a['savecmds'] = {
                    0:{'value':False}, 
                    1:odict([{'value':True}, {'outfile':''}])}

### This function sets the default values but also will return the list of
### parameters or the default value of a given parameter
        if(param == None):
                myf['__set_default_parameters'](a)
        elif(param == 'paramkeys'):
                return a.keys()
        else:
            if(paramvalue==None and subparam==None):
               if(a.has_key(param)):
                  return a[param]
               else:
                  return self.itsdefault(param)
            else:
               retval=a[param]
               if(type(a[param])==dict):
                  for k in range(len(a[param])):
                     valornotval='value'
                     if(a[param][k].has_key('notvalue')):
                        valornotval='notvalue'
                     if((a[param][k][valornotval])==paramvalue):
                        retval=a[param][k].copy()
                        retval.pop(valornotval)
                        if(subparam != None):
                           if(retval.has_key(subparam)):
                              retval=retval[subparam]
                           else:
                              retval=self.itsdefault(subparam)
		     else:
                        retval=self.itsdefault(subparam)
               return retval


#
#
    def check_params(self, param=None, value=None, ipython_globals=None):
      if ipython_globals == None:
          myf=self.__globals__
      else:
          myf=ipython_globals
#      print 'param:', param, 'value:', value
      try :
         if str(type(value)) != "<type 'instance'>" :
            value0 = value
            value = myf['cu'].expandparam(param, value)
            matchtype = False
            if(type(value) == numpy.ndarray):
               if(type(value) == type(value0)):
                  myf[param] = value.tolist()
               else:
                  #print 'value:', value, 'value0:', value0
                  #print 'type(value):', type(value), 'type(value0):', type(value0)
                  myf[param] = value0
                  if type(value0) != list :
                     matchtype = True
            else :
               myf[param] = value
            value = myf['cu'].verifyparam({param:value})
            if matchtype:
               value = False
      except Exception, instance:
         #ignore the exception and just return it unchecked
         myf[param] = value
      return value
#
#
    def description(self, key='importevla', subkey=None):
        desc={'importevla': 'Convert an Science Data Model observation into a CASA Measurement Set',
               'asdm': 'Name of input asdm directory (on disk)',
               'vis': 'Root name of the ms to be created. Note the .ms is NOT added ',
               'ocorr_mode': 'Fill correlation mode AUTO_ONLY (ao), CROSS_ONLY (co) or CROSS_AND_AUTO (ca)',
               'compression': 'Flag for turning on data compression',
               'asis': 'Create verbatim copies of these SDM tables in the MS.',
               'scans': 'List of scans to fill (default is all scans).',
               'verbose': 'Output lots of information while the filler is working',
               'overwrite': 'Over write an existing MS',
               'online': 'Create online flags',
               'tbuff': 'Time padding buffer (in seconds)',
               'flagzero': 'Create flag commands for zero points',
               'flagpol': 'Create flag commands for cross-hand correlations',
               'shadow': 'Create flag commands for shadowed data',
               'tolerance': 'Amount of shadow allowed (in meters)',
               'addantenna': 'File name or dictionary with additional antenna names, positions and diameters',
               'applyflags': 'Apply flag commands to MS',
               'savecmds': 'Save flag commands to an ASCII file',
               'outfile': 'Name of ASCII file to save flag commands',
               'flagbackup': 'Back up flag column before applying flags',
               'polyephem_tabtimestep': 'Timestep (days) for the tabulation of polynomial ephemerides. A value <= 0 disables tabulation.',

              }

#
# Set subfields defaults if needed
#

        if(desc.has_key(key)) :
           return desc[key]

    def itsdefault(self, paramname) :
        a = {}
        a['asdm']  = ''
        a['vis']  = ''
        a['ocorr_mode']  = 'co'
        a['compression']  = False
        a['asis']  = ''
        a['scans']  = ''
        a['verbose']  = False
        a['overwrite']  = False
        a['online']  = True
        a['tbuff']  = 0.0
        a['flagzero']  = True
        a['flagpol']  = True
        a['shadow']  = True
        a['tolerance']  = 0.0
        a['addantenna']  = ''
        a['applyflags']  = False
        a['savecmds']  = False
        a['outfile']  = ''
        a['flagbackup']  = True
        a['polyephem_tabtimestep']  = 0.001

        #a = sys._getframe(len(inspect.stack())-1).f_globals

        if self.parameters['online']  == True:
            a['tbuff'] = 0.0

        if self.parameters['flagzero']  == True:
            a['flagpol'] = True

        if self.parameters['shadow']  == True:
            a['tolerance'] = 0.0
            a['addantenna'] = ''

        if self.parameters['savecmds']  == True:
            a['outfile'] = ''

        if a.has_key(paramname) :
	      return a[paramname]
importevla_cli = importevla_cli_()
