#
# This file was generated using xslt from its XML file
#
# Copyright 2009, Associated Universities Inc., Washington DC
#
import sys
import os
from  casac import *
import string
from taskinit import casalog
from taskinit import xmlpath
#from taskmanager import tm
import task_importasdm
def importasdm(asdm='', vis='', createmms=False, separationaxis='auto', numsubms='auto', corr_mode='all', srt='all', time_sampling='all', ocorr_mode='ca', compression=False, lazy=False, asis='', wvr_corrected_data='no', scans='', ignore_time=False, process_syspower=True, process_caldevice=True, process_pointing=True, process_flags=True, tbuff=0.0, applyflags=False, savecmds=False, outfile='', flagbackup=True, verbose=False, overwrite=False, showversion=False, useversion='v3', bdfflags=False, with_pointing_correction=False, remove_ref_undef=False, convert_ephem2geo=True, polyephem_tabtimestep=0.):

        """Convert an ALMA Science Data Model observation into a CASA visibility file (MS)		          
Keyword arguments:
asdm -- Name of input ASDM file (directory)
        default: none; example: asdm='ExecBlock3'

vis       -- Root ms name. Note that a prefix (.ms) is NOT appended to this name.
             default: none

createmms -- Create a Multi-MS partitioned according to the given separation axis.
             For more detailed documentation on partition, Multi-MS and the MPI use in
             CASA, please see the help partition and help mstransform.
             default: False

        separationaxis -- Axis to do parallelization across. 
            default: 'auto'
            Options: 'scan', 'spw', 'baseline', 'auto'

            * The 'auto' option will partition per scan/spw to obtain optimal load balancing with the
             following criteria:
    
               1 - Maximize the scan/spw/field distribution across sub-MSs
               2 - Generate sub-MSs with similar size

            * The 'scan' or 'spw' axes will partition the MS into scan or spw. The individual sub-MSs may
            not be balanced with respect to the number of rows.

            * The 'baseline' axis is mostly useful for Single-Dish data. This axis will partition the MS
              based on the available baselines. If the user wants only auto-correlations, use the
              ocorr_mode='ao'. Note that if numsubms='auto', partition will try to create as many subMSs as 
              the number of available servers in the cluster. If the user wants to have one subMS for each baseline, 
              set the numsubms parameter to a number higher than the number of baselines to achieve this.        
       
        numsubms -- The number of sub-MSs to create in the Multi-Ms.
                default: 'auto'
                Options: any integer number (example: numsubms=4)

                The default 'auto' is to partition using the number of available servers given when launching CASA.
                If the task is unable to determine the number of running servers, or the user did not start CASA
                using mpicasa, numsubms will use 8 as the default.
      
                Example: Launch CASA with 5 engines, where 4 of them will be used to create the MMS. The first
                    engine is used as the MPIClient.
      
                mpicasa -n 5 casa --nogui --log2term
                CASA> importasdm('uid__A1', createmms=True)
      
corr_mode -- correlation mode to be considered on input. Could
	     be one or more of the following, ao, co, ac, or all
	     default: 'all'

srt       -- spectral resolution type. Could be one or more of
	     the following, fr, ca, bw, or all
	     default: 'all'

time_sampling -- specifies the time sampling, INTEGRATION and/or
                 SUBINTEGRAION. could be one or more of the following
                 i, si, or all.
		 default: 'all'

ocorr_mode    -- output data for correlation mode AUTO_ONLY 
                 (ao) or CROSS_ONLY (co) or CROSS_AND_AUTO (ca)
		 default: 'ca'
		 
compression  -- produces comrpressed columns in the resulting measurement set.
                default: False

lazy         -- Make the MS DATA column read the ASDM Binary data directly
                (faster import, smaller MS). Instead of writing a copy of the visibilities
                into a standard DATA column, lazy=True will make importasdm only write
                a lookup-table such that later access to the DATA column will read the
                ASDM binary visibility data directly. This requires that the ASDM not
                be removed from its location as long the the DATA column is needed.
                Use method ms.asdmref() to query and manipulate the reference to the ASDM.
                lazy=True will save ca. 50% disk space and accelerate the DATA column
                access by ca. 10%.
                lazy=True will only work when there is visibility data in the ASDM,
                not with pure radiometer data.
                default: False

asis         --  creates verbatim copies of the ASDM tables in 
                 the output measurement set. The value given to
		 this option must be a list of table names separated
		 by space characters; the wildcard character '*' is 
                 allowed in table names.
                default: none

wvr_corrected_data -- specifies wich values are considered in the 
                      ASDM binary data to fill the DATA column in 
                      the MAIN table of the MS. Expected values for 
                      this option are 'no' for the uncorrected data 
                      (this is the default), 'yes' for the corrected
                      data and 'both' for corrected and uncorrected 
                      data. In the latter case, two measurement sets
                      are created, one containing the uncorrected 
                      data and the other one, whose name is suffixed
                      by '-wvr-corrected', containing the corrected 
                      data.
                  default: 'no'

scans --	  processes only the scans specified in the option's value. This value is a semicolon 
                  separated list of scan specifications. A scan specification consists in an exec bock index 
                  followed by the character ':' followed by a comma separated list of scan indexes or scan 
                  index ranges. A scan index is relative to the exec block it belongs to. Scan indexes are 
                  1-based while exec blocks's are 0-based. '0:1' or '2:2~6' or '0:1,1:2~6,8;2:,3:24~30' '1,2' 
                  are valid values for the option. '3:' alone will be interpreted as 'all the scans of the 
                  exec block#3'. An scan index or a scan index range not preceded by an exec block index will
                  be interpreted as 'all the scans with such indexes in all the exec blocks'.  By default 
                  all the scans are considered.
                    default: none (all scans)

ignore_time -- All the rows of the tables Feed, History, Pointing, Source, SysCal, CalDevice, SysPower,
               and Weather are processed independently of the time range of the selected exec block / scan.
                    default: False

process_syspower -- The SysPower table is processed if and only if this parameter is set to True.
                    default: True

process_caldevice -- The CalDevice table is processed if and only if this parameter is set to True.
                    default: True

process_pointing -- The Pointing table is processed if and only if this parameter is set to True.
                    default: True

process_flags    -- Create online flags based on the Flag.xml, Antenna.xml and SpectralWindow.xml files
                    and copy them to the FLAG_CMD sub-table of the MS. The flags will NOT be applied unless 
                    the parameter applyflags is set to True. Optionally, the flags can also be saved to
                    an external ASCII file if savecmds is set to True.
                    default: True
                    
            >>> process_flags expandable parameter
                 tbuff   -- Time padding buffer (in seconds)
                    default: 0.0

                 NOTE: this time is in seconds. You should currently
                 set the value of tbuff to be 1.5x the correlator
                 integration time if greater than 1 second.  For
                 example, if the SDM has integrations of 3 seconds,
                 set tbuff=4.5.  Likewise, set tbuff=15.0 for 10-sec
                 integrations.

                 applyflags -- Apply the online flags to the MS.
                   default: False


                savecmds -- Save the flag commands to an ASCII file given by the parameter outfile. 
                  default: False
                    
                outfile -- Filename or list of filenames where to save the online flag commands.
                  default: ' ' --> by default it will save on a filename composed from the MS name(s).
                    Example: vis='uid_A02.ms', the outfile will be 'uid_A02_cmd.txt'. 
                             vis='uid_A02-wvr-corrected.ms', the outfile will be 'uid_A02-wvr-corrected_cmd.txt'.  
                    

flagbackup   -- Backup original flags in >ms<.flagversions 
                default: True
  
verbose     -- produce log output as asdm2MS is being run
                default: False
      
overwrite   -- overwrite an existing MS or MS(s), if the option wvr_corrected_data='both'
                default: False (do not overwrite)
      
                NOTE: the overwrite parameter affects all the output of the task. If any of the following
                      exist, it will not overwrite them. MS(s), .flagversions, online flag files. When set to
                      True, it will overwrite the MS, .flagversions and online flag file.      

showversion -- report the version of the asdm2MS being used.
                    default: False

useversion -- Selects the version of asdm2MS to be used (\'v3\' (default, should work for all data))
              default: v3

bdfflags -- Set the MS FLAG column according to the ASDM _binary_ flags
            default: false

with_pointing_correction -- add (ASDM::Pointing::encoder - ASDM::Pointing::pointingDirection) to the value 
                            to be written in MS::Pointing::direction 

remove_ref_undef -- if set to True then apply fixspwbackport on the resulting MSes.
	            default: False
           
convert_ephem2geo -- ALMA uses ephemerides with observer location equal to the ALMA site. 
                     For later processing of the radial velocity information in, e.g. cvel, 
                     a geocentric ephemeris is needed. 
                     Setting this option to True will perform the conversion of positions and 
                     velocities on all attached ephemerides in the imported MS. 
                     This will neither change the time-spacing nor the duration of the ephemeris. 
                     No interpolation in time is done.

polyephem_tabtimestep -- Timestep (days) for the tabulation of polynomial ephemerides. A value <= 0 disables tabulation.
                         Presently, VLA data can contain polynomial ephemerides. ALMA data uses tabulated values.
                   default: 0.           

  
        """

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['asdm'] = asdm
        mytmp['vis'] = vis
        mytmp['createmms'] = createmms
        mytmp['separationaxis'] = separationaxis
        mytmp['numsubms'] = numsubms
        mytmp['corr_mode'] = corr_mode
        mytmp['srt'] = srt
        mytmp['time_sampling'] = time_sampling
        mytmp['ocorr_mode'] = ocorr_mode
        mytmp['compression'] = compression
        mytmp['lazy'] = lazy
        mytmp['asis'] = asis
        mytmp['wvr_corrected_data'] = wvr_corrected_data
        mytmp['scans'] = scans
        mytmp['ignore_time'] = ignore_time
        mytmp['process_syspower'] = process_syspower
        mytmp['process_caldevice'] = process_caldevice
        mytmp['process_pointing'] = process_pointing
        mytmp['process_flags'] = process_flags
        mytmp['tbuff'] = tbuff
        mytmp['applyflags'] = applyflags
        mytmp['savecmds'] = savecmds
        mytmp['outfile'] = outfile
        mytmp['flagbackup'] = flagbackup
        mytmp['verbose'] = verbose
        mytmp['overwrite'] = overwrite
        mytmp['showversion'] = showversion
        mytmp['useversion'] = useversion
        mytmp['bdfflags'] = bdfflags
        mytmp['with_pointing_correction'] = with_pointing_correction
        mytmp['remove_ref_undef'] = remove_ref_undef
        mytmp['convert_ephem2geo'] = convert_ephem2geo
        mytmp['polyephem_tabtimestep'] = polyephem_tabtimestep
	pathname='file://' + xmlpath( ) + '/'
	trec = casac.utils().torecord(pathname+'importasdm.xml')

        casalog.origin('importasdm')
        if trec.has_key('importasdm') and casac.utils().verify(mytmp, trec['importasdm']) :
	    result = task_importasdm.importasdm(asdm, vis, createmms, separationaxis, numsubms, corr_mode, srt, time_sampling, ocorr_mode, compression, lazy, asis, wvr_corrected_data, scans, ignore_time, process_syspower, process_caldevice, process_pointing, process_flags, tbuff, applyflags, savecmds, outfile, flagbackup, verbose, overwrite, showversion, useversion, bdfflags, with_pointing_correction, remove_ref_undef, convert_ephem2geo, polyephem_tabtimestep)

	else :
	  result = False
        return result
