#
# This file was generated using xslt from its XML file
#
# Copyright 2009, Associated Universities Inc., Washington DC
#
import sys
import os
from  casac import *
import string
from taskinit import casalog
from taskinit import xmlpath
#from taskmanager import tm
import task_impbcor
def impbcor(imagename='', pbimage="", outfile='', overwrite=False, box='', region='', chans='', stokes='', mask='', mode='divide', cutoff=-1.0, stretch=False):

        """Construct a primary beam corrected image from an image and a primary beam pattern.
PARAMETER SUMMARY
imagename        Name of the input (CASA, FITS, MIRIAD) image
pbimage          Name of the image (CASA, FITS, MIRIAD) of the primary beam pattern or an array of pixel values.
outfile          Name of output CASA image. Must be specified.
overwrite        If output file is specified, controls if an already existing file by the
                 same name can be overwritten. If true, the user is not prompted, the file
                 if it exists is automatically overwritten.
box              Rectangular region to select in direction plane. Default
                 is to use the entire direction plane.
region           Region selection. Default is to use the full image.
chans            Channels to use. Default is to use all channels.
stokes           Stokes planes to use. Default is to use all Stokes planes.
mask             Mask to use. Default is none.
stretch          Stretch the input mask if necessary and possible. 
mode             Divide or multiply the image by the primary beam image. Minimal match supported. Default "divide"
cutoff           PB cutoff. If mode is "d", all values less than this will be masked. If "m", all values greater will be masked. Less than 0, no cutoff. Default no cutoff

DESCRIPTION
Correct an image for primary beam attenuation using an image of the primary beam pattern.
The primary beam pattern can be provided as an image, in which case 1. it must have the same
shape as the input image and its coordinate system must be the same, or 2. it must
be a 2-D image in which case its coordinate system must consist of a (2-D) direction
coordinate which is the same as the direction coordinate in the input image and
its direction plane must be the same shape as that of the input image. Alternatively,
pbimage can be an array of pixel values in which case the same dimensionality and
shape constraints apply.

One can choose between dividing the image by the primary beam pattern (mode="divide") or
multiplying the image by the primary beam pattern (mode="multiply"). One can also choose
to specify a cutoff limit for the primary beam pattern. For mode="divide", for all pixels
below this cutoff in the primary beam pattern, the output image will be masked. In the
case of mode="multiply", all pixels in the output will be masked corresponding to pixels
with values greater than the cutoff in the primary beam pattern. A negative value for
cutoff means that no cutoff will be applied, which is the default.

EXAMPLE 
impbcor(imagename="attunuated.im", pbimage="mypb.im", outname="pbcorred.im", mode="divide", cutoff=0.1)
    
        """

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['imagename'] = imagename
        mytmp['pbimage'] = pbimage
        mytmp['outfile'] = outfile
        mytmp['overwrite'] = overwrite
        mytmp['box'] = box
        mytmp['region'] = region
        mytmp['chans'] = chans
        mytmp['stokes'] = stokes
        mytmp['mask'] = mask
        mytmp['mode'] = mode
        mytmp['cutoff'] = cutoff
        mytmp['stretch'] = stretch
	pathname='file://' + xmlpath( ) + '/'
	trec = casac.utils().torecord(pathname+'impbcor.xml')

        casalog.origin('impbcor')
        if trec.has_key('impbcor') and casac.utils().verify(mytmp, trec['impbcor']) :
	    result = task_impbcor.impbcor(imagename, pbimage, outfile, overwrite, box, region, chans, stokes, mask, mode, cutoff, stretch)

	else :
	  result = False
        return result
