#
# This file was generated using xslt from its XML file
#
# Copyright 2009, Associated Universities Inc., Washington DC
#
import sys
import os
from  casac import *
import string
from taskinit import casalog
from taskinit import xmlpath
#from taskmanager import tm
import task_imcontsub
def imcontsub(imagename='', linefile='', contfile='', fitorder=0, region='', box='', chans='', stokes=''):

        """Estimates and subtracts continuum emission from an image cube

  For each (x, y) column in imagename (or a subset selected by region and/or
  box), this estimates the continuum by fitting a polynomial to one or more
  subsets of the channels.  The continuum estimate is saved in contfile, and
  subtracted from imagename (or its subset) to make a spectral line estimate,
  which is saved in linefile.

  
  

  Keyword arguments:
  imagename -- Input image cube
    Default: none; Example: imagename='ngc5921_task.im'
  linefile -- Name of output spectral line cube
    Default: none; Example: outline='ngc5921_line.im'
  contfile -- Name of output continuum cube
    Default: none; Example: contfile='ngc5921_cont.im'
  fitorder -- Polynomial order for the continuum estimation.
    Default: 0; Example fitorder=2
  region -- Region selection. Default is
            to use the full image.
  box --  Rectangular region to select in direction plane. 
          for details. Default is to use the entire direction plane.
  chans -- Channels to use for fitting. 
           Default is to use all channels.
           Example: chans='3~6;>40'
  stokes -- Stokes planes to use. Default is
            to use all Stokes planes.
  
Fit a second order polynomial (fitorder=2) to channels 3-8 and 54-60 
to an RA x Dec x Frequency x Stokes cube, selecting the Stokes I plane

ch = '3~8, 54~60'
imcontsub(imagename="myimage.im", linefile="mycontsub.im", fitorder=2, chans=ch, fitorder=2, stokes="I")


        """

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['imagename'] = imagename
        mytmp['linefile'] = linefile
        mytmp['contfile'] = contfile
        mytmp['fitorder'] = fitorder
        mytmp['region'] = region
        mytmp['box'] = box
        mytmp['chans'] = chans
        mytmp['stokes'] = stokes
	pathname='file://' + xmlpath( ) + '/'
	trec = casac.utils().torecord(pathname+'imcontsub.xml')

        casalog.origin('imcontsub')
        if trec.has_key('imcontsub') and casac.utils().verify(mytmp, trec['imcontsub']) :
	    result = task_imcontsub.imcontsub(imagename, linefile, contfile, fitorder, region, box, chans, stokes)

	else :
	  result = False
        return result
