#
# This file was generated using xslt from its XML file
#
# Copyright 2009, Associated Universities Inc., Washington DC
#
import sys
import os
from  casac import *
import string
from taskinit import casalog
from taskinit import xmlpath
#from taskmanager import tm
import task_imcollapse
def imcollapse(imagename='', function='', axes=[0], outfile='', box='', region='', chans='', stokes='', mask='', overwrite=False, stretch=False):

        """Collapse image along one axis, aggregating pixel values along that axis.
PARAMETER SUMMARY
imagename        Name of the input (CASA, FITS, MIRIAD) image
function         Function used to compute aggregation of pixel values along the collapsed
                 axis. Supported functions are flux, max, mean, median, min, rms, stdev,
                 sum, variance. Minimum match is supported for the function parameter (eg,
                 function="r" will compute the rms of the pixel values).
axis             Zero-based axis number(s) or minimal match strings to compress.
outfile          Name of output CASA image. Must be specified.
overwrite        Controls if an already existing file by the
                 same name can be overwritten. If true, the user is not prompted, the file
                 if it exists is automatically overwritten.
box              Rectangular region to select in direction plane. 
                 for details. Default is to use the entire direction plane.
region           Region selection. Default is to use
                 the full image.
chans            Channels to use. Default is to use
                 all channels.
stokes           Stokes planes to use. Default is to use
                 all Stokes planes.
mask             Mask to use. Default is none.
stretch          Stretch the input mask if necessary and possible. Only used if a mask is specified.
                 
This task collapses an image along a specified axis or set of axes of N pixels to a single pixel on each
specified axis. Both float valued and complex valued images are supported. It computes the specified
aggregate function for pixel values along the specified axes
and places those values in the single remaining plane of those axes in the output image. It returns
an image analysis tool containing the newly created collapsed image if wantreturn=True. Choices of
aggregate functions are: flux (see below for constraints), max, mean, median, min, rms, stdev, sum, variance. Minimal unique match is
supported for the function parameter (eg, function="r" will compute the rms of the pixel values, "med"
will compute the median).

If one specifies function='flux', the following constraints must be true:

1. The image must have a direction coordinate,
2. The image must have at least one beam,
3. The specified axes must be exactly the direction coordinate axes,
4. Only one of the non-directional axes may be non-degenerate,
5. The iamge brightness unit must be conformant with x*yJy/beam, where x is an optional unit (such as km/s for moments images)
   and y is an optional SI prefix.
        
Axes can be specified as a single integer or array of integers indicating the zero-based axes along
which to collapse the image. Axes may also be specified as a single or array of strings which minimally
and uniquely match (ignoring case) world axes names in the image (eg "dec" or ["ri, "d"] for
collapsing along the declination axis or along the right ascension and declination axes, respectively).
         
The reference pixel of the collapsed axis is set to 0 and its reference value is set to the mean
of the the first and last values of that axis in the specified region of the input image.

# myimage.im is a 512x512x128x4 (ra,dec,freq,stokes) image
imagename = "myimage.im"
# collapse a subimage of it along its spectral axis avoiding the 8 edge
# channels at each end of the band, computing the mean value of the pixels
# resulting image is 256x256x1x4 in size.
outfile="collapse_spec_mean.im"
function="mean"
axis=2
box="127,127,383,383"
chans="8~119"
imcollapse(imagename=imagename, outfile=outfile, function=function, axes=axis, box=box, chans=chans)


        """

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['imagename'] = imagename
        mytmp['function'] = function
        mytmp['axes'] = axes
        mytmp['outfile'] = outfile
        mytmp['box'] = box
        mytmp['region'] = region
        mytmp['chans'] = chans
        mytmp['stokes'] = stokes
        mytmp['mask'] = mask
        mytmp['overwrite'] = overwrite
        mytmp['stretch'] = stretch
	pathname='file://' + xmlpath( ) + '/'
	trec = casac.utils().torecord(pathname+'imcollapse.xml')

        casalog.origin('imcollapse')
        if trec.has_key('imcollapse') and casac.utils().verify(mytmp, trec['imcollapse']) :
	    result = task_imcollapse.imcollapse(imagename, function, axes, outfile, box, region, chans, stokes, mask, overwrite, stretch)

	else :
	  result = False
        return result
