#
# This file was generated using xslt from its XML file
#
# Copyright 2014, Associated Universities Inc., Washington DC
#
import sys
import os
#from casac import *
import casac
import string
import time
import inspect
import gc
import numpy
from casa_stack_manip import stack_frame_find
from odict import odict
from types import * 
from task_gencal import gencal
class gencal_cli_:
    __name__ = "gencal"
    rkey = None
    i_am_a_casapy_task = None
    # The existence of the i_am_a_casapy_task attribute allows help()
    # (and other) to treat casapy tasks as a special case.

    def __init__(self) :
       self.__bases__ = (gencal_cli_,)
       self.__doc__ = self.__call__.__doc__

       self.parameters={'vis':None, 'caltable':None, 'caltype':None, 'infile':None, 'spw':None, 'antenna':None, 'pol':None, 'parameter':None, 'uniform':None, }


    def result(self, key=None):
	    #### and add any that have completed...
	    return None


    def __call__(self, vis=None, caltable=None, caltype=None, infile=None, spw=None, antenna=None, pol=None, parameter=None, uniform=None, ):

        """Specify Calibration Values of Various Types

	Detailed Description: 


        Specify calibration externally.

	
	Arguments :
		vis:	Name of input visibility file
		   Default Value: 

		caltable:	The new/existing calibration table
		   Default Value: 

		caltype:	The calibration type: \'amp\',\'ph\',\'sbd\',\'mbd\',\'antpos\',\'antposvla\',\'tsys\',\'evlagain\',\'opac\',\'gc\',\'gceff\',\'eff\',\'tecim\'
		   Default Value: 
		   Allowed Values:
				amp
				ph
				sbd
				mbd
				antpos
				antposvla
				tsys
				evlagain
				swpow
				rq
				swp/rq
				opac
				gc
				gceff
				eff
				tecim

		infile:	Input ancilliary file
		   Default Value: 

		spw:	Calibration spw(s) selection
		   Default Value: 

		antenna:	Calibration antenna(s) selection
		   Default Value: 

		pol:	Calibration polarizations(s) selection
		   Default Value: 

		parameter:	The calibration values
		   Default Value: 

		uniform:	Assume uniform calibration values across the array
		   Default Value: True

	Returns: void

	Example :


     The gencal task provides a means of specifying antenna-based
     calibration values manually.  The values are put in designated
     tables and applied to the data using applycal.  Several
     specialized calibrations are also generated with gencal.

     Current antenna-based gencal options (caltype) are:
        'amp'= amplitude correction
        'ph' = phase correction
        'sbd'= single-band delay (phase-frequency slope for each spw)
        'mbd'= multi-band delay (phase-frequency slope over all spw)
        'antpos' = ITRF antenna position corrections
        'antposvla' = VLA-centric antenna position corrections 
        'tsys' = Tsys from the SYSCAL table (ALMA)
        'swpow' = EVLA switched-power gains (experimental)
        'evlagain' (='swpow') (this syntax will deprecate)
        'rq' = EVLA requantizer gains _only_
        'swp/rq' = EVLA switched-power gains divided by requantizer gain
        'opac' = Tropospheric opacity
        'gc' = Gain curve (zenith-angle-dependent gain) (VLA only)
        'eff' = Antenna efficiency (sqrt(K/Jy)) (VLA only)
        'gceff' = Gain curve and efficiency (VLA only)
        'tecim' = Time-dep TEC image specified in infile

     Generic calibration parameters should be specified in the 'parameter'
     argument as a list.  The length of the list must correspond
     to the net length of the specific polarizations, antennas, and
     spws specified in the selection arguments.  The specified
     parameters will be duplicated over all members of any unspecified
     selection axes.  E.g., if pol=antenna=spw='', it only makes
     sense to specify a single parameter value, and this will be
     duplicated for all pols, antennas, and spws.  If multiple
     parameter values are specified, at least one of the selection
     arguments must be non-trivial, and the number of specified
     parameters must be consistent with the explicit selection.
     E.g., if a non-trivial spw selection is specified, then the 
     parameter list should match the number of spws specified, and 
     these values will be duplicated for all polarizations and 
     antennas.   If more than one selection argument is non-trivially 
     specified, the number of parameters specified should match 
     the product of the number specified selection elements.  The 
     parameter values should be sorted by pol (fastest), antenna, and 
     spw (slowest).   Un-specified elements on non-trivially specified 
     axes will be filled with nominal values (i.e., it is not
     necessary to exhaustively specify all elements on any axis or 
     use nominal parameter values explicitly).  Please consult the 
     examples provided below for additional guidance.  There is
     currently no support for time-dependent parameter specfication.
     The specified parameters will be assumed constant in
     time (though their impact on the data may be time-dependent, 
     depending on the caltype).  Some caltype options do not require 
     parameter specifications; these are described in detail below.
     
     The same caltable can be specified for multiple runs of gencal, 
     in which case the specified parameters will be incorporated 
     cumulatively.  E.g., amplitude parameters (caltype='amp')
     multiply and phase-like parameters ('ph', 'sbd','mbd','antpos') 
     add.  'amp' and 'ph' parameters can be incorporated into the 
     same caltable (in separate runs), but each of the other types
     require their own unique caltable.   A mechanism for
     specifying manual corrections via a text file will be provided in
     the future.

     The caltables are applied to the data by using applycal.  Other
     calibration tables may also be present, if applicable.

     For antenna position corrections (caltype='antpos'), the antenna 
     position offsets are specified in the ITRF frame. For EVLA, automated 
     lookup of the antenna position corrections is enabled when antenna is 
     unspecified (antenna='') for this caltype. Note that this requires 
     internet connection to access the EVLA antenna position correction 
     site. 
     For VLA position corrections in the VLA-centric frame, use 
     caltype='antposvla', and gencal will rotate them to ITRF before 
     storing them in the output caltable.

     For Tsys (caltype='tsys', for ALMA) and EVLA switched power
     corrections (caltype='swpow'), the calibration parameters are
     derived from information contained in MS subtables.  In these
     cases, specification of spw, antenna, pol, and parameter will be
     ignored.
     If Tsys measurements are not uniformly sampled across the array
     (typically the case for VLBI) use uniform=False to avoid
     unnecessary flagging of data.

     EVLA switched power calibration is supported in three modes:  
     'swpow' (formerly 'evlagain', a syntax which will 
       deprecate) yields the formal EVLA switched power calibration 
       which describes voltage gain as sqrt(Pdif/Tcal) (used to 
       correct the visibility data) and Tsys as Psum*Tcal/Pdif/2 (used 
       to correct the weights).  'swpow' implicitly includes any 
       requantizer gain scale and adjustments.
     'rq' yields only the requantizer voltage gains (Tsys is set to
       1.0 to avoid weight adjustments).
     'swp/rq' yields the ordinary switched power voltage gains divided
       by the requantizer voltage gain (Tsys is calculate normally).
     The 'rq' and 'swp/rq' modes are are mainly intended for testing 
     and evaluating the EVLA switched power systems.
  
     For caltype='opac', specify the desired opacity(ies) in the parameter
     argument.  At this time, only constant (in time) opacities are
     supported via gencal.  

     For gaincurve and efficiency (caltype='gc', 'gceff', or 'eff'), 
     observatory-provided factors are determined per spw according
     to the observing frequencies.  The parameter argument is 
     ignored.  These caltypes are currently only supported
     for VLA processing.  (Appropriate factors for ALMA are TBD.)

     Keyword arguments:

     vis -- Name of input visibility file
             default: none.  example: vis='ngc5921.ms'
     caltable -- Name of input/output caltable.  If it does not
                  exist, it will be created.  Specifying an
                  existing table will result in the parameters
                  being applied cumulatively. Only a single
                  time-stamp for all calibrations are supported,
                  currently.  Do not use a caltable
                  created by gaincal, bandpass, etc.  
                  default: none.  example: caltable='test.G'
     caltype -- The calibration parameter type being specified.
                 Options include:
                 'amp' = gain (G) amplitude (1 real parameter per
                         pol, antenna, spw)
                 'ph'  = gain (G) phase (deg) (1 real parameter per
                         pol, antenna, spw)
                 'sbd' = single-band delays (nsec) (1 real parameter 
                         per pol, antenna, spw)
                 'mbd' = multi-band delay (nsec) (1 real parameter 
                         per pol, antenna, spw)
                 'antpos' = antenna position corrections (m) (3 real
                            ITRF offset parameters per antenna; spw, pol
                            selection will be ignored)
                            With antenna='', this triggers an automated lookup
                            of antenna positions for EVLA.
                 'antposvla' = antenna position corrections (m) specified
                               in the old VLA-centric coordinate system
                 'tsys' = Tsys from the SYSCAL table (ALMA)
                 'evlagain' = EVLA switched-power gains (experimental)
                 'opac' = Tropospheric opacity (1 real parameter 
                         per antenna, spw)
                 'gc' = Antenna zenith-angle dependent gain curve (auto-lookup)
                 'gceff' = Gain curve and efficiency (auto-lookup)
                 'eff' = Antenna efficiency (auto-lookup)
                 default: none.
                 example: caltype='ph'
     spw -- Spectral window selection for specified parameters. 
             default: spw='' (specified parameters apply to all spws)
             example: spw = '2,3,4'
     antenna -- Antenna selection for specified parameters. 
                 default: antenna='' (specified parameters apply to all antennas)
                 example: antenna='ea02, ea03' (specified parameter(s) to
                           apply to ea02 and ea03 only)
     pol -- Polarization selection for specified parameters.
             default: pol='' (specified parameters apply to all polarizations)
             example: pol='R' (specified parameters to apply to
                                 R only)
     parameter -- The calibration parameters, specified as a list, to 
                   store in the caltable for the spw, antenna, and pol 
                   selection.  The required length of the list is 
                   determined by the caltype and the spw, antenna, pol
                   selection.  One "set" of parameters (e.g., one value
                   for 'amp', 'ph', etc., three values for 'antpos')
                   specified the same value for all indicated spw, antenna,
                   and pol.
                   OR, 
                   When specifying a long list of calibration parameter values,
                   these should be ordered first (fastest) by pol (if pol!=''),
                   then by antenna (if antenna!=''), and finally (sloweset) by 
                   spw (if spw!='').  Unspecified selection axes must not be
                   enumerated in the parameter list
      
     Examples:

       gencal(vis='test.ms',caltable='test.G',caltype='amp',
              spw='',antenna='',pol='',
              parameter=[3])

         --> Antenna-based gain amplitude corrections for all spws, antennas, 
              and polarizations will be multiplied by 3.  When applied
              to visibility data, this correction will produce a
              corrected visibility than is (1/3*1/3) less than the 
              uncorrected visibility.

       gencal(vis='test.ms',caltable='test.G',caltype='ph',
              spw='',antenna='ea03,ea04',pol='',
              parameter=[45,120])

         --> Gain phase corrections for antennas ea03 and ea04
              will be adjusted (additive) by 45 and 120 
              degrees (respectively), for all spws and polarizations.
              When these phases are applied to visibility data, the
              visibility phases will decrease or increase by the
              specified amount where the selected antennas occur
              first or second (respectively) in each baseline.  E.g., 
              the phase of baseline ea03-ea04 will change by (-45+120)
              = + 75 degrees.  Baseline ea01-ea03's phase will change
              by +45 degrees; baseline ea04-ea05's phase will change
              by -120 degrees.  The same phase sign convention is
              used for delay and antenna position corrections.

       gencal(vis='test.ms',caltable='test.G',caltype='ph',
              spw='',antenna='ea05,ea06',pol='R',
              parameter=[63,-34])

         --> Gain phase corrections for antennas ea05 and ea06
              will be adjusted (additive) by 63 and -34 
              degrees (respectively), in R only, for all spws

       gencal(vis='test.ms',caltable='test.G',caltype='ph',
              spw='',antenna='ea09,ea10',pol='R,L',
              parameter=[14,-23,-130,145])

         --> Gain phase corrections in all spws will be adjusted for 
              antenna ea09 by 14 deg in R and -23 deg in L, and for
              antenna ea10 by -130 deg in R and 145 deg in L.

       gencal(vis='test.ms',caltable='test.G',caltype='ph',
              spw='2,3',antenna='ea09,ea10',pol='',
              parameter=[14,-23,-130,145])

         --> Gain phases corrections in both polarizations will be adjusted for 
              antenna ea09 by 14 deg in spw 2 and -23 deg in spw 3, and for
              antenna ea10 by -130 deg in spw 2 and 145 deg in spw 3.

       gencal(vis='test.ms',caltable='test.G',caltype='sbd',
              spw='2,3',antenna='ea09,ea10',pol='',
              parameter=[14,-23,-130,145])

         --> Delay corrections in both polarizations will be adjusted for 
              antenna ea09 by 14 nsec in spw 2 and -23 nsec in spw 3, and for
              antenna ea10 by -130 nsec in spw 2 and 145 nsec in spw
              3.  See the above example for caltype='ph' for details
              of the sign convention adopted when applying delay corrections.

       gencal(vis='test.ms',caltable='test.G',caltype='antpos',antenna='')
     
         --> *** Currently EVLA observations only ***
             Antenna position corrections will be retrieved automatically
             over internet to generate the caltable with antenna=''.

       gencal(vis='test.ms',caltable='test.G',caltype='antpos',
              antenna='ea09,ea10',
              parameter=[0.01,0.02,0.03, -0.03,-0.01,-0.02])

         --> Antenna position corrections in meters (in ITRF) for
              antenna ea09 (dBx=0.01, dBy=0.02, dBz=0.03) and for
              antenna ea10 (dBx=-0.03, dBy=-0.01, dBz=-0.02)
              See the above example for caltype='ph' for details
              of the sign convention adopted when applying antpos 
              corrections.

       gencal(vis='test.ms',caltable='test.G',caltype='antposvla',
              antenna='ea09,ea10',
              parameter=[0.01,0.02,0.03, -0.03,-0.01,-0.02])

         --> Antenna position corrections (in the traditional VLA-centric
              frame) will be introduced in meters for
              antenna ea09 (dBx=0.01, dBy=0.02, dBz=0.03) and for
              antenna ea10 (dBx=-0.03, dBy=-0.01, dBz=-0.02)
              These offsets will be rotated to the ITRF frame before
              storing them in the caltable.
              See the above example for caltype='ph' for details
              of the sign convention adopted when applying antpos 
              corrections.

 
        """
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
	#casac = self.__globals__['casac']
	casalog = self.__globals__['casalog']
	casa = self.__globals__['casa']
	#casalog = casac.casac.logsink()
        self.__globals__['__last_task'] = 'gencal'
        self.__globals__['taskname'] = 'gencal'
        ###
        self.__globals__['update_params'](func=self.__globals__['taskname'],printtext=False,ipython_globals=self.__globals__)
        ###
        ###
        #Handle globals or user over-ride of arguments
        #
        if type(self.__call__.func_defaults) is NoneType:
            function_signature_defaults={}
	else:
	    function_signature_defaults=dict(zip(self.__call__.func_code.co_varnames[1:],self.__call__.func_defaults))
	useLocalDefaults = False

        for item in function_signature_defaults.iteritems():
                key,val = item
                keyVal = eval(key)
                if (keyVal == None):
                        #user hasn't set it - use global/default
                        pass
                else:
                        #user has set it - use over-ride
			if (key != 'self') :
			   useLocalDefaults = True

	myparams = {}
	if useLocalDefaults :
	   for item in function_signature_defaults.iteritems():
	       key,val = item
	       keyVal = eval(key)
	       exec('myparams[key] = keyVal')
	       self.parameters[key] = keyVal
	       if (keyVal == None):
	           exec('myparams[key] = '+ key + ' = self.itsdefault(key)')
		   keyVal = eval(key)
		   if(type(keyVal) == dict) :
                      if len(keyVal) > 0 :
		         exec('myparams[key] = ' + key + ' = keyVal[len(keyVal)-1][\'value\']')
		      else :
		         exec('myparams[key] = ' + key + ' = {}')
	 
        else :
            print ''

            myparams['vis'] = vis = self.parameters['vis']
            myparams['caltable'] = caltable = self.parameters['caltable']
            myparams['caltype'] = caltype = self.parameters['caltype']
            myparams['infile'] = infile = self.parameters['infile']
            myparams['spw'] = spw = self.parameters['spw']
            myparams['antenna'] = antenna = self.parameters['antenna']
            myparams['pol'] = pol = self.parameters['pol']
            myparams['parameter'] = parameter = self.parameters['parameter']
            myparams['uniform'] = uniform = self.parameters['uniform']

        if type(parameter)==float: parameter=[parameter]

	result = None

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['vis'] = vis
        mytmp['caltable'] = caltable
        mytmp['caltype'] = caltype
        mytmp['infile'] = infile
        mytmp['spw'] = spw
        mytmp['antenna'] = antenna
        mytmp['pol'] = pol
        mytmp['parameter'] = parameter
        mytmp['uniform'] = uniform
	pathname='file://' + casa['dirs']['xml'] + '/'
	trec = casac.casac.utils().torecord(pathname+'gencal.xml')

        casalog.origin('gencal')
	try :
          #if not trec.has_key('gencal') or not casac.casac.utils().verify(mytmp, trec['gencal']) :
	    #return False

          casac.casac.utils().verify(mytmp, trec['gencal'], True)
          scriptstr=['']
          saveinputs = self.__globals__['saveinputs']
          if type(self.__call__.func_defaults) is NoneType:
              saveinputs=''
          else:
              saveinputs('gencal', 'gencal.last', myparams, self.__globals__,scriptstr=scriptstr)
          tname = 'gencal'
          spaces = ' '*(18-len(tname))
          casalog.post('\n##########################################'+
                       '\n##### Begin Task: ' + tname + spaces + ' #####')
          if type(self.__call__.func_defaults) is NoneType:
              casalog.post(scriptstr[0]+'\n', 'INFO')
          else :
              casalog.post(scriptstr[1][1:]+'\n', 'INFO')
          result = gencal(vis, caltable, caltype, infile, spw, antenna, pol, parameter, uniform)
          casalog.post('##### End Task: ' + tname + '  ' + spaces + ' #####'+
                       '\n##########################################')

	except Exception, instance:
          if(self.__globals__.has_key('__rethrow_casa_exceptions') and self.__globals__['__rethrow_casa_exceptions']) :
             raise
          else :
             #print '**** Error **** ',instance
	     tname = 'gencal'
             casalog.post('An error occurred running task '+tname+'.', 'ERROR')
             pass

        gc.collect()
        return result
#
#
#
    def paramgui(self, useGlobals=True, ipython_globals=None):
        """
        Opens a parameter GUI for this task.  If useGlobals is true, then any relevant global parameter settings are used.
        """
        import paramgui
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )

        if useGlobals:
	    if ipython_globals == None:
                myf=self.__globals__
            else:
                myf=ipython_globals

            paramgui.setGlobals(myf)
        else:
            paramgui.setGlobals({})

        paramgui.runTask('gencal', myf['_ip'])
        paramgui.setGlobals({})

#
#
#
    def defaults(self, param=None, ipython_globals=None, paramvalue=None, subparam=None):
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
        if ipython_globals == None:
            myf=self.__globals__
        else:
            myf=ipython_globals

        a = odict()
        a['vis']  = ''
        a['caltable']  = ''
        a['caltype']  = ''
        a['spw']  = ''
        a['antenna']  = ''
        a['pol']  = ''
        a['parameter']  = []

        a['caltype'] = {
                    0:odict([{'value':'tecim'}, {'infile':''}]), 
                    1:odict([{'value':'gc'}, {'infile':''}]), 
                    2:odict([{'value':'gceff'}, {'infile':''}]), 
                    3:odict([{'value':'tsys'}, {'uniform':True}])}

### This function sets the default values but also will return the list of
### parameters or the default value of a given parameter
        if(param == None):
                myf['__set_default_parameters'](a)
        elif(param == 'paramkeys'):
                return a.keys()
        else:
            if(paramvalue==None and subparam==None):
               if(a.has_key(param)):
                  return a[param]
               else:
                  return self.itsdefault(param)
            else:
               retval=a[param]
               if(type(a[param])==dict):
                  for k in range(len(a[param])):
                     valornotval='value'
                     if(a[param][k].has_key('notvalue')):
                        valornotval='notvalue'
                     if((a[param][k][valornotval])==paramvalue):
                        retval=a[param][k].copy()
                        retval.pop(valornotval)
                        if(subparam != None):
                           if(retval.has_key(subparam)):
                              retval=retval[subparam]
                           else:
                              retval=self.itsdefault(subparam)
		     else:
                        retval=self.itsdefault(subparam)
               return retval


#
#
    def check_params(self, param=None, value=None, ipython_globals=None):
      if ipython_globals == None:
          myf=self.__globals__
      else:
          myf=ipython_globals
#      print 'param:', param, 'value:', value
      try :
         if str(type(value)) != "<type 'instance'>" :
            value0 = value
            value = myf['cu'].expandparam(param, value)
            matchtype = False
            if(type(value) == numpy.ndarray):
               if(type(value) == type(value0)):
                  myf[param] = value.tolist()
               else:
                  #print 'value:', value, 'value0:', value0
                  #print 'type(value):', type(value), 'type(value0):', type(value0)
                  myf[param] = value0
                  if type(value0) != list :
                     matchtype = True
            else :
               myf[param] = value
            value = myf['cu'].verifyparam({param:value})
            if matchtype:
               value = False
      except Exception, instance:
         #ignore the exception and just return it unchecked
         myf[param] = value
      return value
#
#
    def description(self, key='gencal', subkey=None):
        desc={'gencal': 'Specify Calibration Values of Various Types',
               'vis': 'Name of input visibility file',
               'caltable': 'The new/existing calibration table',
               'caltype': 'The calibration type: \'amp\',\'ph\',\'sbd\',\'mbd\',\'antpos\',\'antposvla\',\'tsys\',\'evlagain\',\'opac\',\'gc\',\'gceff\',\'eff\',\'tecim\'',
               'infile': 'Input ancilliary file',
               'spw': 'Calibration spw(s) selection',
               'antenna': 'Calibration antenna(s) selection',
               'pol': 'Calibration polarizations(s) selection',
               'parameter': 'The calibration values',
               'uniform': 'Assume uniform calibration values across the array',

              }

#
# Set subfields defaults if needed
#

        if(desc.has_key(key)) :
           return desc[key]

    def itsdefault(self, paramname) :
        a = {}
        a['vis']  = ''
        a['caltable']  = ''
        a['caltype']  = ''
        a['infile']  = ''
        a['spw']  = ''
        a['antenna']  = ''
        a['pol']  = ''
        a['parameter']  = []
        a['uniform']  = True

        #a = sys._getframe(len(inspect.stack())-1).f_globals

        if self.parameters['caltype']  == 'tecim':
            a['infile'] = ''

        if self.parameters['caltype']  == 'gc':
            a['infile'] = ''

        if self.parameters['caltype']  == 'gceff':
            a['infile'] = ''

        if self.parameters['caltype']  == 'tsys':
            a['uniform'] = True

        if a.has_key(paramname) :
	      return a[paramname]
gencal_cli = gencal_cli_()
