#
# This file was generated using xslt from its XML file
#
# Copyright 2014, Associated Universities Inc., Washington DC
#
import sys
import os
#from casac import *
import casac
import string
import time
import inspect
import gc
import numpy
from casa_stack_manip import stack_frame_find
from odict import odict
from types import * 
from task_fluxscale import fluxscale
class fluxscale_cli_:
    __name__ = "fluxscale"
    rkey = None
    i_am_a_casapy_task = None
    # The existence of the i_am_a_casapy_task attribute allows help()
    # (and other) to treat casapy tasks as a special case.

    def __init__(self) :
       self.__bases__ = (fluxscale_cli_,)
       self.__doc__ = self.__call__.__doc__

       self.parameters={'vis':None, 'caltable':None, 'fluxtable':None, 'reference':None, 'transfer':None, 'listfile':None, 'append':None, 'refspwmap':None, 'gainthreshold':None, 'antenna':None, 'timerange':None, 'scan':None, 'incremental':None, 'fitorder':None, 'display':None, }


    def result(self, key=None):
	    #### and add any that have completed...
	    return None


    def __call__(self, vis=None, caltable=None, fluxtable=None, reference=None, transfer=None, listfile=None, append=None, refspwmap=None, gainthreshold=None, antenna=None, timerange=None, scan=None, incremental=None, fitorder=None, display=None, ):

        """Bootstrap the flux density scale from standard calibrators

	Detailed Description: 


       Bootstrap the flux density scale from standard calibrators:

       After running gaincal on standard flux density calibrators (with or
       without an image model), and other calibrators with unknown flux
       densities (assumed 1 Jy), fluxscale applies the constraint that
       net system gain was, in fact, independent of field, on average,
       and that field-dependent gains in the input caltable are solely
       a result of the unknown flux densities for the calibrators.
       Using time-averaged gain amplitudes, the ratio between 
       each ordinary calibrator and the flux density calibrator(s) is 
       formed for each antenna and polarization (that they have in
       common).  The average of this ratio over antennas and polarizations
       yields a correction factor that is applied to the ordinary 
       calibrators' gains. (See also more detailed discussion in Example section below.)

	
	Arguments :
		vis:	Name of input visibility file (MS)
		   Default Value: 

		caltable:	Name of input calibration table
		   Default Value: 

		fluxtable:	Name of output, flux-scaled calibration table
		   Default Value: 

		reference:	Reference field name(s) (transfer flux scale FROM)
		   Default Value: 

		transfer:	Transfer field name(s) (transfer flux scale TO), \'\' -> all
		   Default Value: 

		listfile:	Name of listfile that contains the fit information.  Default is '' (no file).
		   Default Value: 

		append:	Append solutions?
		   Default Value: False

		refspwmap:	Scale across spectral window boundaries.  See help fluxscale
		   Default Value: -1

		gainthreshold:	Threshold (% deviation from the median) on gain amplitudes to be used in the flux scale calculation
		   Default Value: -1.0

		antenna:	antennas to include/exclude
		   Default Value: 

		timerange:	sub selection by timerange
		   Default Value: 

		scan:	sub selection by scan
		   Default Value: 

		incremental:	incremental caltable
		   Default Value: False

		fitorder:	order of spectral fitting
		   Default Value: 1

		display:	display some statistics of flux scaling
		   Default Value: False

	Returns: void

	Example :


       After running gaincal on standard flux density calibrators (with or
       without an image model), and other calibrators with unknown flux
       densities (assumed 1 Jy), fluxscale applies the constraint that
       net system gain was, in fact, independent of field, on average,
       and that field-dependent gains in the input caltable are solely
       a result of the unknown flux densities for the calibrators.
       Using time-averaged gain amplitudes, the ratio between 
       each ordinary calibrator and the flux density calibrator(s) is 
       formed for each antenna and polarization (that they have in
       common).  For incremental=False(default), the median of 
       this ratio over antennas and polarizations yields a correction 
       factor that is applied to the ordinary calibrators' gains. For 
       incremental=True, only the correction factors are written out 
       to the output fluxtable.

       The square of the gain correction factor for each calibrator
       and spw is the presumed flux density of that calibrator, and is
       reported in the logger.  The errors reported with this value
       reflect the scatter in gain ratio over antennas and
       polarizations, divided by the square root of the number of 
       antennas and polarizations available.  If the flux densities 
       for multiple spws exist, fitted spectral index and (for nspw>2)
       curvature are also reported. The fit is done for 
       log(flux density) = a_o + a_1*(log(frequency)) + a_2*(log(frequency))**2 
       where log(frequency) is with respect to the mean of log(frequency). 
       This reference frequency is reported in the logger along with the 
       flux density at that frequency.  The fit results are also reported 
       in the returned Python dictionary (the solutions are in 'spidx' 
       in the following order: a_o [log(S) at the zero point], a_1 [spectral index], 
       and a_2 [curvature]. And their errors are in 'spidxerr').  
       The MODEL_DATA column is currently _not_ revised to reflect the flux 
       densities derived by fluxscale.  Use setjy to set the MODEL_DATA 
       column, if necessary.

       The constant gain constraint is usually a reasonable assumption
       for the electronic systems on typical antennas.  It is
       important that external time- and/or elevation-dependent
       effects are separately accounted for when solving for the gain
       solution supplied to fluxscale, e.g., gain curves, 
       opacity, etc.  The fluxscale results can also be degraded
       by poor pointing during the observation. The parameters, gainthreshold
       and antenna (and timerange/scan) can be used to control the data to be used
       in the flux derivation in such cases. The gainthreshold parameter sets the range of 
       the input gain to be used in terms of the percentage deviation from 
       their median values (per field, per spectral window). When the antenna
       parameter is specified, the sub-parameters timerange and scan are also
       available to fine tune the data selection for the flux derivation. 
       These parameters uses the general CASA data selection (msselection) syntax.
       And these are 'AND' operations except when the antenna selection is specified
       with a negation (e.g. antenna="!6"). In that case, timerange and scan applied
       to only those antennas appear in the antenna parameter. So, for example,
       timerange='>02:35:00' with antenna='!6,24', will include the data with time greater than
       02:35:00 for antenna ID 6 and 24 but for other antennas the timerange selection is not
       applied.
       

       Keyword arguments:
       vis -- Name of input visibility file
               default: none; example: vis='ngc5921.ms'
       caltable -- Name of input calibration table
               default: none; example: caltable='ngc5921.gcal'
               This cal table was obtained from task gaincal.
       fluxtable -- Name of output, flux-scaled calibration table
               default: none; example: fluxtable='ngc5921.gcal2'
               The gains in this table have been adjusted by the
               derived flux density each calibrator.  The MODEL_DATA
               column has NOT been updated for the flux density of the
               calibrator.  Use setjy to do this if it is a point source.
       reference -- Reference field name(s)
               The names of the fields with a known flux densities or
                  visibilities that have been placed in the MODEL column
                  by setjy or ft for a model not in the CASA system.
               The syntax is similar to field.  Hence field index or
                  names can be used.
               default: none; example: reference='1328+307'
       transfer -- Transfer field name(s)
               The names of the fields with unknown flux densities.
                  These should be point-like calibrator sources
               The syntax is similar to field.  Hence source index or
                 names can be used.
               default: '' = all sources in caltable that are not specified
                  as reference sources.  Do not include unknown target sources
               example: transfer='1445+099, 3C84'; transfer = '0,4'

               NOTE: All fields in reference and transfer must have solutions
               in the caltable.

       listfile -- Fit listfile name
               The list file contains the flux density, flux density error,
                 S/N, and number of solutions (all antennas and feeds) for each
                 spectral window.  NOTE: The nominal spectral window frequencies
                 will be included in the future.
               default: '' = no fit listfile will be created.

       append -- Append fluxscaled solutions to the fluxtable.
               default: False; (will overwrite if already existing)
               example: append=True
       refspwmap -- Vector of spectral windows enabling scaling across
               spectral windows
               default: [-1]==> none.
               Example with 4 spectral windows:
               if the reference fields were observed only in spw=1 & 3,
               and the transfer fields were observed in all 4 spws (0,1,2,3),
               specify refspwmap=[1,1,3,3].
               This will ensure that transfer fields observed in spws 0,1,2,3
               will be referenced to reference field solutions only in
               spw 1 or 3.
       gainthreshold -- Threshold in the input gain solutions to be used in % deviation 
               from median values.
               default: -1 (no threshold)
               example: gainthreshold=0.15 (only used the gain solutions within 15% 
               (inclusive) of the median gain value (per field and per spw). 
       antenna --- Antenna selection to be included in the fluxscale determination.
               General ms selection syntax is accepted such as antenna id (given as a string)
               and antenna name.
               default: '' (=All antennas will be used)
               example: antenna='!23' (exclude antenna id, 23) 
      
         * Following sub-parameters are available when the antenna parameter is specified
         timerange --- Select time range using the msselection syntax.
               If the negation (e.g. '!23') is used in the antenna selection, it will apply
               the time range selection only to the negated antenna(s). Otherwise, the selection
               is global (i.e. applied to all antenna and to both reference and transfer fields.)
               default: '' (all timerange)
               example: timerange=">0:58:00"
         scan --- Select scan(s) using the msselection syntax. As in the case of the timerange parameter
               the selection will be applied to only the negated antenna(s) if the antenna parameter
               is used with the negation ("!").  
               default: '' (all scans)
               example: '2~5' 

       incremental -- Create an incremental caltable containing only gain correction 
               factors ( flux density= 1/(gain correction factor)**2)
               default: False; (older behavior = create flux-scaled gain table)
               example: incremental=True (output a caltable containing flux scale factors.)
              
               NOTE: If you use the incremental option, note that BOTH this incremental 
               fluxscale table AND an amplitude vs. time table should be supplied in applycal.

       fitorder -- Polynomial order of the spectral fitting for valid flux densities 
               with multiple spws.  Currently only support 1 (spectral index only) or 
               2 (spectral index and curvature).  It falls back to a lower fitorder if 
               there are not enough solutions to fit with the requested fitorder.
               default: 1
       display -- Display statistics and/or spectral fitting results. Currently only a histogram
               of the correction factors to derive the final flux density for each spectral window
               will be plotted.
               default: False
               example: display=True

       Returned dictionary: 
                when it is run as fluxres = fluxscale(vis='my.ms',...), the determined flux
                densities and spectral index information  are returned as a Python dictionary with
                a format, {fieldIdstr: {spwIdstr: {'fluxd':array([I,Q,U,V]), 
                                                  'fluxdErr': corresponding errors,
                                                   'numSol': corresponding no. of solutions,
                                        'fieldName': field name,
                                        'fitFluxd': fitted flux density at the reference frequency,
                                        'fitFluxdErr': fitted flux density error,
                                        'fitRefFreq': reference frequency,
                                        'spidx': a_0, a_1, a_2
                                        'spidxerr': errors in a_0,a_1, a_2} 
                           'freq': (center) spw frequencies 
                           'spwID': list of spw IDs,
                           'spwName': list of spw names}, where fieldIdstr and spwIdstr
                are field Id and spw Id in string type, respectively.

       
 
        """
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
	#casac = self.__globals__['casac']
	casalog = self.__globals__['casalog']
	casa = self.__globals__['casa']
	#casalog = casac.casac.logsink()
        self.__globals__['__last_task'] = 'fluxscale'
        self.__globals__['taskname'] = 'fluxscale'
        ###
        self.__globals__['update_params'](func=self.__globals__['taskname'],printtext=False,ipython_globals=self.__globals__)
        ###
        ###
        #Handle globals or user over-ride of arguments
        #
        if type(self.__call__.func_defaults) is NoneType:
            function_signature_defaults={}
	else:
	    function_signature_defaults=dict(zip(self.__call__.func_code.co_varnames[1:],self.__call__.func_defaults))
	useLocalDefaults = False

        for item in function_signature_defaults.iteritems():
                key,val = item
                keyVal = eval(key)
                if (keyVal == None):
                        #user hasn't set it - use global/default
                        pass
                else:
                        #user has set it - use over-ride
			if (key != 'self') :
			   useLocalDefaults = True

	myparams = {}
	if useLocalDefaults :
	   for item in function_signature_defaults.iteritems():
	       key,val = item
	       keyVal = eval(key)
	       exec('myparams[key] = keyVal')
	       self.parameters[key] = keyVal
	       if (keyVal == None):
	           exec('myparams[key] = '+ key + ' = self.itsdefault(key)')
		   keyVal = eval(key)
		   if(type(keyVal) == dict) :
                      if len(keyVal) > 0 :
		         exec('myparams[key] = ' + key + ' = keyVal[len(keyVal)-1][\'value\']')
		      else :
		         exec('myparams[key] = ' + key + ' = {}')
	 
        else :
            print ''

            myparams['vis'] = vis = self.parameters['vis']
            myparams['caltable'] = caltable = self.parameters['caltable']
            myparams['fluxtable'] = fluxtable = self.parameters['fluxtable']
            myparams['reference'] = reference = self.parameters['reference']
            myparams['transfer'] = transfer = self.parameters['transfer']
            myparams['listfile'] = listfile = self.parameters['listfile']
            myparams['append'] = append = self.parameters['append']
            myparams['refspwmap'] = refspwmap = self.parameters['refspwmap']
            myparams['gainthreshold'] = gainthreshold = self.parameters['gainthreshold']
            myparams['antenna'] = antenna = self.parameters['antenna']
            myparams['timerange'] = timerange = self.parameters['timerange']
            myparams['scan'] = scan = self.parameters['scan']
            myparams['incremental'] = incremental = self.parameters['incremental']
            myparams['fitorder'] = fitorder = self.parameters['fitorder']
            myparams['display'] = display = self.parameters['display']

        if type(reference)==str: reference=[reference]
        if type(transfer)==str: transfer=[transfer]
        if type(refspwmap)==int: refspwmap=[refspwmap]

	result = None

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['vis'] = vis
        mytmp['caltable'] = caltable
        mytmp['fluxtable'] = fluxtable
        mytmp['reference'] = reference
        mytmp['transfer'] = transfer
        mytmp['listfile'] = listfile
        mytmp['append'] = append
        mytmp['refspwmap'] = refspwmap
        mytmp['gainthreshold'] = gainthreshold
        mytmp['antenna'] = antenna
        mytmp['timerange'] = timerange
        mytmp['scan'] = scan
        mytmp['incremental'] = incremental
        mytmp['fitorder'] = fitorder
        mytmp['display'] = display
	pathname='file://' + casa['dirs']['xml'] + '/'
	trec = casac.casac.utils().torecord(pathname+'fluxscale.xml')

        casalog.origin('fluxscale')
	try :
          #if not trec.has_key('fluxscale') or not casac.casac.utils().verify(mytmp, trec['fluxscale']) :
	    #return False

          casac.casac.utils().verify(mytmp, trec['fluxscale'], True)
          scriptstr=['']
          saveinputs = self.__globals__['saveinputs']
          if type(self.__call__.func_defaults) is NoneType:
              saveinputs=''
          else:
              saveinputs('fluxscale', 'fluxscale.last', myparams, self.__globals__,scriptstr=scriptstr)
          tname = 'fluxscale'
          spaces = ' '*(18-len(tname))
          casalog.post('\n##########################################'+
                       '\n##### Begin Task: ' + tname + spaces + ' #####')
          if type(self.__call__.func_defaults) is NoneType:
              casalog.post(scriptstr[0]+'\n', 'INFO')
          else :
              casalog.post(scriptstr[1][1:]+'\n', 'INFO')
          result = fluxscale(vis, caltable, fluxtable, reference, transfer, listfile, append, refspwmap, gainthreshold, antenna, timerange, scan, incremental, fitorder, display)
          casalog.post('##### End Task: ' + tname + '  ' + spaces + ' #####'+
                       '\n##########################################')

	except Exception, instance:
          if(self.__globals__.has_key('__rethrow_casa_exceptions') and self.__globals__['__rethrow_casa_exceptions']) :
             raise
          else :
             #print '**** Error **** ',instance
	     tname = 'fluxscale'
             casalog.post('An error occurred running task '+tname+'.', 'ERROR')
             pass

        gc.collect()
        return result
#
#
#
    def paramgui(self, useGlobals=True, ipython_globals=None):
        """
        Opens a parameter GUI for this task.  If useGlobals is true, then any relevant global parameter settings are used.
        """
        import paramgui
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )

        if useGlobals:
	    if ipython_globals == None:
                myf=self.__globals__
            else:
                myf=ipython_globals

            paramgui.setGlobals(myf)
        else:
            paramgui.setGlobals({})

        paramgui.runTask('fluxscale', myf['_ip'])
        paramgui.setGlobals({})

#
#
#
    def defaults(self, param=None, ipython_globals=None, paramvalue=None, subparam=None):
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
        if ipython_globals == None:
            myf=self.__globals__
        else:
            myf=ipython_globals

        a = odict()
        a['vis']  = ''
        a['caltable']  = ''
        a['fluxtable']  = ''
        a['reference']  = ['']
        a['transfer']  = ['']
        a['listfile']  = ''
        a['append']  = False
        a['refspwmap']  = [-1]
        a['gainthreshold']  = -1.0
        a['antenna']  = ''
        a['incremental']  = False
        a['fitorder']  = 1
        a['display']  = False

        a['antenna'] = {
                    0:odict([{'notvalue':''}, {'timerange':''}, {'scan':''}])}

### This function sets the default values but also will return the list of
### parameters or the default value of a given parameter
        if(param == None):
                myf['__set_default_parameters'](a)
        elif(param == 'paramkeys'):
                return a.keys()
        else:
            if(paramvalue==None and subparam==None):
               if(a.has_key(param)):
                  return a[param]
               else:
                  return self.itsdefault(param)
            else:
               retval=a[param]
               if(type(a[param])==dict):
                  for k in range(len(a[param])):
                     valornotval='value'
                     if(a[param][k].has_key('notvalue')):
                        valornotval='notvalue'
                     if((a[param][k][valornotval])==paramvalue):
                        retval=a[param][k].copy()
                        retval.pop(valornotval)
                        if(subparam != None):
                           if(retval.has_key(subparam)):
                              retval=retval[subparam]
                           else:
                              retval=self.itsdefault(subparam)
		     else:
                        retval=self.itsdefault(subparam)
               return retval


#
#
    def check_params(self, param=None, value=None, ipython_globals=None):
      if ipython_globals == None:
          myf=self.__globals__
      else:
          myf=ipython_globals
#      print 'param:', param, 'value:', value
      try :
         if str(type(value)) != "<type 'instance'>" :
            value0 = value
            value = myf['cu'].expandparam(param, value)
            matchtype = False
            if(type(value) == numpy.ndarray):
               if(type(value) == type(value0)):
                  myf[param] = value.tolist()
               else:
                  #print 'value:', value, 'value0:', value0
                  #print 'type(value):', type(value), 'type(value0):', type(value0)
                  myf[param] = value0
                  if type(value0) != list :
                     matchtype = True
            else :
               myf[param] = value
            value = myf['cu'].verifyparam({param:value})
            if matchtype:
               value = False
      except Exception, instance:
         #ignore the exception and just return it unchecked
         myf[param] = value
      return value
#
#
    def description(self, key='fluxscale', subkey=None):
        desc={'fluxscale': 'Bootstrap the flux density scale from standard calibrators',
               'vis': 'Name of input visibility file (MS)',
               'caltable': 'Name of input calibration table',
               'fluxtable': 'Name of output, flux-scaled calibration table',
               'reference': 'Reference field name(s) (transfer flux scale FROM)',
               'transfer': 'Transfer field name(s) (transfer flux scale TO), \'\' -> all',
               'listfile': 'Name of listfile that contains the fit information.  Default is '' (no file).',
               'append': 'Append solutions?',
               'refspwmap': 'Scale across spectral window boundaries.  See help fluxscale',
               'gainthreshold': 'Threshold (% deviation from the median) on gain amplitudes to be used in the flux scale calculation',
               'antenna': 'antennas to include/exclude',
               'timerange': 'sub selection by timerange',
               'scan': 'sub selection by scan',
               'incremental': 'incremental caltable',
               'fitorder': 'order of spectral fitting',
               'display': 'display some statistics of flux scaling',

              }

#
# Set subfields defaults if needed
#

        if(desc.has_key(key)) :
           return desc[key]

    def itsdefault(self, paramname) :
        a = {}
        a['vis']  = ''
        a['caltable']  = ''
        a['fluxtable']  = ''
        a['reference']  = ['']
        a['transfer']  = ['']
        a['listfile']  = ''
        a['append']  = False
        a['refspwmap']  = [-1]
        a['gainthreshold']  = -1.0
        a['antenna']  = ''
        a['timerange']  = ''
        a['scan']  = ''
        a['incremental']  = False
        a['fitorder']  = 1
        a['display']  = False

        #a = sys._getframe(len(inspect.stack())-1).f_globals

        if self.parameters['antenna']  != '':
            a['timerange'] = ''
            a['scan'] = ''

        if a.has_key(paramname) :
	      return a[paramname]
fluxscale_cli = fluxscale_cli_()
