#
# This file was generated using xslt from its XML file
#
# Copyright 2014, Associated Universities Inc., Washington DC
#
import sys
import os
#from casac import *
import casac
import string
import time
import inspect
import gc
import numpy
from casa_stack_manip import stack_frame_find
from odict import odict
from types import * 
from task_fixvis import fixvis
class fixvis_cli_:
    __name__ = "fixvis"
    rkey = None
    i_am_a_casapy_task = None
    # The existence of the i_am_a_casapy_task attribute allows help()
    # (and other) to treat casapy tasks as a special case.

    def __init__(self) :
       self.__bases__ = (fixvis_cli_,)
       self.__doc__ = self.__call__.__doc__

       self.parameters={'vis':None, 'outputvis':None, 'field':None, 'refcode':None, 'reuse':None, 'phasecenter':None, 'distances':None, 'datacolumn':None, }


    def result(self, key=None):
	    #### and add any that have completed...
	    return None


    def __call__(self, vis=None, outputvis=None, field=None, refcode=None, reuse=None, phasecenter=None, distances=None, datacolumn=None, ):

        """Recalculates (u, v, w) and/or changes Phase Center 

	Detailed Description: 

Recalculates (u, v, w) and/or changes Phase Center

	Arguments :
		vis:	Name of the input visibility set.
		   Default Value: 

		outputvis:	Name of the output visibility set.  (Can be the same as vis.)
		   Default Value: 

		field:	Fields to operate on.  '' = all.
		   Default Value: ""

		refcode:	reference frame to convert UVW coordinates to
		   Default Value: 

		reuse:	base UVW calculation on the old values?
		   Default Value: True

		phasecenter:	use this direction as phase center
		   Default Value: 

		distances:	(experimental) List of the distances (as quanta) of the fields selected by field.
		   Default Value: ""

		datacolumn:	when applying a phase center shift, modify visibilities only in this/these column(s)
		   Default Value: all


	Example :


If the phase center is changed, the corresponding modifications are applied to the 
visibility columns given by the parameter "datacolumn" which is by default set 
to "all" (DATA, CORRECTED, and MODEL).

    Input Parameters
    vis        -- Name of the input visibility set
    
    outputvis  -- Name of the output visibility set, default: same as vis

    field      -- field selection string

    refcode    -- Reference frame to convert to, default: the refcode of PHASE_DIR in the 
                  FIELD table
                  example: 'B1950'
    
    reuse      -- base recalculation on existing UVW coordinates? default=True
                  ignored if parameter 'phasecenter' is set

    phasecenter  --  if set to a valid direction: change the phase center for the given 
                     field to this value
	       example: 'J2000 9h25m00s -05d12m00s'
               If given without the equinox, e.g. '0h01m00s +00d12m00s', the parameter
               is interpreted as a pair of offsets in RA and DEC to the present 
               phasecenter. 
               NOTE: The RA offset can be given in units of time or angle. If given 
               as a time (i.e. as a single number with a time unit as in, e.g., 12s
               or in the XXhXXmXXs or XX:XX:XX.XXX formats), it is applied as is. 
               If given as an angle (e.g., 0.01deg), it is divided by the cos(DEC) 
               before it is applied.

    distances -- (experimental) List of the distances (as quanta) of the fields selected by field
                 to be used for refocussing.
                 If empty, the distances of all fields are assumed to be infinity.
                 If not a list but just a single value is given, this is applied to
                 all fields.
                 default: []
                 examples: ['2E6km', '3E6km']   '15au'

    datacolumn -- when applying a phase center shift, modify visibilities only in 
                  this/these column(s)
                  default: 'all' (DATA, CORRECTED, and MODEL)
                  example: 'DATA,CORRECTED' (will not modify MODEL)
	       
    Examples:

    fixvis('NGC3256.ms','NGC3256-fixed.ms')
          will recalculate the UVW coordinates for all fields based on the existing
          phase center information in the FIELD table.

    fixvis('Moon.ms','Moon-fixed.ms','Moon', '', 'J2000 9h25m00s 05d12m00s')
          will set the phase center for field 'Moon' to the given direction and recalculate
          the UVW coordinates.


        """
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
	#casac = self.__globals__['casac']
	casalog = self.__globals__['casalog']
	casa = self.__globals__['casa']
	#casalog = casac.casac.logsink()
        self.__globals__['__last_task'] = 'fixvis'
        self.__globals__['taskname'] = 'fixvis'
        ###
        self.__globals__['update_params'](func=self.__globals__['taskname'],printtext=False,ipython_globals=self.__globals__)
        ###
        ###
        #Handle globals or user over-ride of arguments
        #
        if type(self.__call__.func_defaults) is NoneType:
            function_signature_defaults={}
	else:
	    function_signature_defaults=dict(zip(self.__call__.func_code.co_varnames[1:],self.__call__.func_defaults))
	useLocalDefaults = False

        for item in function_signature_defaults.iteritems():
                key,val = item
                keyVal = eval(key)
                if (keyVal == None):
                        #user hasn't set it - use global/default
                        pass
                else:
                        #user has set it - use over-ride
			if (key != 'self') :
			   useLocalDefaults = True

	myparams = {}
	if useLocalDefaults :
	   for item in function_signature_defaults.iteritems():
	       key,val = item
	       keyVal = eval(key)
	       exec('myparams[key] = keyVal')
	       self.parameters[key] = keyVal
	       if (keyVal == None):
	           exec('myparams[key] = '+ key + ' = self.itsdefault(key)')
		   keyVal = eval(key)
		   if(type(keyVal) == dict) :
                      if len(keyVal) > 0 :
		         exec('myparams[key] = ' + key + ' = keyVal[len(keyVal)-1][\'value\']')
		      else :
		         exec('myparams[key] = ' + key + ' = {}')
	 
        else :
            print ''

            myparams['vis'] = vis = self.parameters['vis']
            myparams['outputvis'] = outputvis = self.parameters['outputvis']
            myparams['field'] = field = self.parameters['field']
            myparams['refcode'] = refcode = self.parameters['refcode']
            myparams['reuse'] = reuse = self.parameters['reuse']
            myparams['phasecenter'] = phasecenter = self.parameters['phasecenter']
            myparams['distances'] = distances = self.parameters['distances']
            myparams['datacolumn'] = datacolumn = self.parameters['datacolumn']


	result = None

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['vis'] = vis
        mytmp['outputvis'] = outputvis
        mytmp['field'] = field
        mytmp['refcode'] = refcode
        mytmp['reuse'] = reuse
        mytmp['phasecenter'] = phasecenter
        mytmp['distances'] = distances
        mytmp['datacolumn'] = datacolumn
	pathname='file://' + casa['dirs']['xml'] + '/'
	trec = casac.casac.utils().torecord(pathname+'fixvis.xml')

        casalog.origin('fixvis')
	try :
          #if not trec.has_key('fixvis') or not casac.casac.utils().verify(mytmp, trec['fixvis']) :
	    #return False

          casac.casac.utils().verify(mytmp, trec['fixvis'], True)
          scriptstr=['']
          saveinputs = self.__globals__['saveinputs']
          if type(self.__call__.func_defaults) is NoneType:
              saveinputs=''
          else:
              saveinputs('fixvis', 'fixvis.last', myparams, self.__globals__,scriptstr=scriptstr)
          tname = 'fixvis'
          spaces = ' '*(18-len(tname))
          casalog.post('\n##########################################'+
                       '\n##### Begin Task: ' + tname + spaces + ' #####')
          if type(self.__call__.func_defaults) is NoneType:
              casalog.post(scriptstr[0]+'\n', 'INFO')
          else :
              casalog.post(scriptstr[1][1:]+'\n', 'INFO')
          result = fixvis(vis, outputvis, field, refcode, reuse, phasecenter, distances, datacolumn)
          casalog.post('##### End Task: ' + tname + '  ' + spaces + ' #####'+
                       '\n##########################################')

	except Exception, instance:
          if(self.__globals__.has_key('__rethrow_casa_exceptions') and self.__globals__['__rethrow_casa_exceptions']) :
             raise
          else :
             #print '**** Error **** ',instance
	     tname = 'fixvis'
             casalog.post('An error occurred running task '+tname+'.', 'ERROR')
             pass

        gc.collect()
        return result
#
#
#
    def paramgui(self, useGlobals=True, ipython_globals=None):
        """
        Opens a parameter GUI for this task.  If useGlobals is true, then any relevant global parameter settings are used.
        """
        import paramgui
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )

        if useGlobals:
	    if ipython_globals == None:
                myf=self.__globals__
            else:
                myf=ipython_globals

            paramgui.setGlobals(myf)
        else:
            paramgui.setGlobals({})

        paramgui.runTask('fixvis', myf['_ip'])
        paramgui.setGlobals({})

#
#
#
    def defaults(self, param=None, ipython_globals=None, paramvalue=None, subparam=None):
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
        if ipython_globals == None:
            myf=self.__globals__
        else:
            myf=ipython_globals

        a = odict()
        a['vis']  = ''
        a['outputvis']  = ''
        a['field']  = ""
        a['refcode']  = ''
        a['reuse']  = True
        a['phasecenter']  = ''
        a['distances']  = ""
        a['datacolumn']  = 'all'


### This function sets the default values but also will return the list of
### parameters or the default value of a given parameter
        if(param == None):
                myf['__set_default_parameters'](a)
        elif(param == 'paramkeys'):
                return a.keys()
        else:
            if(paramvalue==None and subparam==None):
               if(a.has_key(param)):
                  return a[param]
               else:
                  return self.itsdefault(param)
            else:
               retval=a[param]
               if(type(a[param])==dict):
                  for k in range(len(a[param])):
                     valornotval='value'
                     if(a[param][k].has_key('notvalue')):
                        valornotval='notvalue'
                     if((a[param][k][valornotval])==paramvalue):
                        retval=a[param][k].copy()
                        retval.pop(valornotval)
                        if(subparam != None):
                           if(retval.has_key(subparam)):
                              retval=retval[subparam]
                           else:
                              retval=self.itsdefault(subparam)
		     else:
                        retval=self.itsdefault(subparam)
               return retval


#
#
    def check_params(self, param=None, value=None, ipython_globals=None):
      if ipython_globals == None:
          myf=self.__globals__
      else:
          myf=ipython_globals
#      print 'param:', param, 'value:', value
      try :
         if str(type(value)) != "<type 'instance'>" :
            value0 = value
            value = myf['cu'].expandparam(param, value)
            matchtype = False
            if(type(value) == numpy.ndarray):
               if(type(value) == type(value0)):
                  myf[param] = value.tolist()
               else:
                  #print 'value:', value, 'value0:', value0
                  #print 'type(value):', type(value), 'type(value0):', type(value0)
                  myf[param] = value0
                  if type(value0) != list :
                     matchtype = True
            else :
               myf[param] = value
            value = myf['cu'].verifyparam({param:value})
            if matchtype:
               value = False
      except Exception, instance:
         #ignore the exception and just return it unchecked
         myf[param] = value
      return value
#
#
    def description(self, key='fixvis', subkey=None):
        desc={'fixvis': 'Recalculates (u, v, w) and/or changes Phase Center ',
               'vis': 'Name of the input visibility set.',
               'outputvis': 'Name of the output visibility set.  (Can be the same as vis.)',
               'field': 'Fields to operate on.  '' = all.',
               'refcode': 'reference frame to convert UVW coordinates to',
               'reuse': 'base UVW calculation on the old values?',
               'phasecenter': 'use this direction as phase center',
               'distances': '(experimental) List of the distances (as quanta) of the fields selected by field.',
               'datacolumn': 'when applying a phase center shift, modify visibilities only in this/these column(s)',

              }

        if(desc.has_key(key)) :
           return desc[key]

    def itsdefault(self, paramname) :
        a = {}
        a['vis']  = ''
        a['outputvis']  = ''
        a['field']  = ""
        a['refcode']  = ''
        a['reuse']  = True
        a['phasecenter']  = ''
        a['distances']  = ""
        a['datacolumn']  = 'all'

        #a = sys._getframe(len(inspect.stack())-1).f_globals

        if a.has_key(paramname) :
	      return a[paramname]
fixvis_cli = fixvis_cli_()
