#
# This file was generated using xslt from its XML file
#
# Copyright 2009, Associated Universities Inc., Washington DC
#
import sys
import os
from  casac import *
import string
from taskinit import casalog
from taskinit import xmlpath
#from taskmanager import tm
import task_fixvis
def fixvis(vis='', outputvis='', field="", refcode='', reuse=True, phasecenter='', distances="", datacolumn='all'):

        """Recalculates (u, v, w) and/or changes Phase Center 

If the phase center is changed, the corresponding modifications are applied to the 
visibility columns given by the parameter "datacolumn" which is by default set 
to "all" (DATA, CORRECTED, and MODEL).

    Input Parameters
    vis        -- Name of the input visibility set
    
    outputvis  -- Name of the output visibility set, default: same as vis

    field      -- field selection string

    refcode    -- Reference frame to convert to, default: the refcode of PHASE_DIR in the 
                  FIELD table
                  example: 'B1950'
    
    reuse      -- base recalculation on existing UVW coordinates? default=True
                  ignored if parameter 'phasecenter' is set

    phasecenter  --  if set to a valid direction: change the phase center for the given 
                     field to this value
	       example: 'J2000 9h25m00s -05d12m00s'
               If given without the equinox, e.g. '0h01m00s +00d12m00s', the parameter
               is interpreted as a pair of offsets in RA and DEC to the present 
               phasecenter. 
               NOTE: The RA offset can be given in units of time or angle. If given 
               as a time (i.e. as a single number with a time unit as in, e.g., 12s
               or in the XXhXXmXXs or XX:XX:XX.XXX formats), it is applied as is. 
               If given as an angle (e.g., 0.01deg), it is divided by the cos(DEC) 
               before it is applied.

    distances -- (experimental) List of the distances (as quanta) of the fields selected by field
                 to be used for refocussing.
                 If empty, the distances of all fields are assumed to be infinity.
                 If not a list but just a single value is given, this is applied to
                 all fields.
                 default: []
                 examples: ['2E6km', '3E6km']   '15au'

    datacolumn -- when applying a phase center shift, modify visibilities only in 
                  this/these column(s)
                  default: 'all' (DATA, CORRECTED, and MODEL)
                  example: 'DATA,CORRECTED' (will not modify MODEL)
	       
    Examples:

    fixvis('NGC3256.ms','NGC3256-fixed.ms')
          will recalculate the UVW coordinates for all fields based on the existing
          phase center information in the FIELD table.

    fixvis('Moon.ms','Moon-fixed.ms','Moon', '', 'J2000 9h25m00s 05d12m00s')
          will set the phase center for field 'Moon' to the given direction and recalculate
          the UVW coordinates.


        """

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['vis'] = vis
        mytmp['outputvis'] = outputvis
        mytmp['field'] = field
        mytmp['refcode'] = refcode
        mytmp['reuse'] = reuse
        mytmp['phasecenter'] = phasecenter
        mytmp['distances'] = distances
        mytmp['datacolumn'] = datacolumn
	pathname='file://' + xmlpath( ) + '/'
	trec = casac.utils().torecord(pathname+'fixvis.xml')

        casalog.origin('fixvis')
        if trec.has_key('fixvis') and casac.utils().verify(mytmp, trec['fixvis']) :
	    result = task_fixvis.fixvis(vis, outputvis, field, refcode, reuse, phasecenter, distances, datacolumn)

	else :
	  result = False
        return result
