#
# This file was generated using xslt from its XML file
#
# Copyright 2014, Associated Universities Inc., Washington DC
#
import sys
import os
#from casac import *
import casac
import string
import time
import inspect
import gc
import numpy
from casa_stack_manip import stack_frame_find
from odict import odict
from types import * 
from task_fixplanets import fixplanets
class fixplanets_cli_:
    __name__ = "fixplanets"
    rkey = None
    i_am_a_casapy_task = None
    # The existence of the i_am_a_casapy_task attribute allows help()
    # (and other) to treat casapy tasks as a special case.

    def __init__(self) :
       self.__bases__ = (fixplanets_cli_,)
       self.__doc__ = self.__call__.__doc__

       self.parameters={'vis':None, 'field':None, 'fixuvw':None, 'direction':None, 'refant':None, 'reftime':None, }


    def result(self, key=None):
	    #### and add any that have completed...
	    return None


    def __call__(self, vis=None, field=None, fixuvw=None, direction=None, refant=None, reftime=None, ):

        """Changes FIELD and SOURCE table entries based on user-provided direction or POINTING table, optionally fixes the UVW coordinates

	Detailed Description: 

    This task's main purpose is to correct observations which were performed
    with correct pointing and correlation but for which incorrect direction
    information was entered in the FIELD and SOURCE table of the MS.
    If you actually want to change the phase center of the visibilties in an MS,
    you should use task fixvis.

    Input Parameters
    vis        -- Name of the input visibility set

    field      -- field selection string

    fixuvw     -- recalc uvw coordinates? (default: False)

    direction  -- if set, don't use pointing table but set direction to this value.
                  The direction can either be given explicitly or as the path
                  to a JPL Horizons ephemeris (for an example of the format,
                  see directory data/ephemerides/JPL-Horizons/).
                  Alternatively, the ephemeris table can also be provided as mime format file,
                  i.e. a saved email as obtained via the commands (for example):
                  import recipes.ephemerides.request as jplreq
                  jplreq.request_from_JPL(objnam='Mars',startdate='2012-01-01',enddate='2013-12-31',
                       date_incr='0.1 d', get_axis_orientation=False, get_axis_ang_orientation=True,
                       get_sub_long=True, use_apparent=False, get_sep=False,
                       return_address='YOUR_EMAIL_ADDESS', mailserver='YOUR_MAIL_SERVER_ADDRESS')
                  Note: some mail clients may not save the JPL mail properly.
                        Confirmed to work is Thunderbird.

                  default= '' (use pointing table)

                  example: 'J2000 19h30m00 -40d00m00'

    refant     -- if using pointing table information, use it from this antenna
                  default: 0 (antenna id 0)
                  examples: 'DV06' (antenna with name DV06)
                            3 (antenna id 3)
    reftime    -- if using pointing table information, use it from this timestamp
                  default: 'first'
                  examples: 'median' will use the median timestamp for the given field
		            using only the unflagged maintable rows
                            '2012/07/11/08:41:32' will use the given timestamp (must be
                            within the observaton time)

	Arguments :
		vis:	Name of the input visibility set.
		   Default Value: 

		field:	Fields to operate on.  Blank = all.
		   Default Value: ""

		fixuvw:	Recalculate Fourier-plane u,v,w coordinates
		   Default Value: False

		direction:	if set, do not use pointing table but set direction to this value
		   Default Value: 

		refant:	if using pointing table information, use it from this antenna
		   Default Value: 0

		reftime:	if using pointing table information, use it from this timestamp 
		   Default Value: first


	Example :


    Examples:

    fixplanets('uid___A002_X1c6e54_X223.ms', 'Titan', True)
          will look up the pointing direction from antenna 0 for field 'Titan' in
          the POINTING table based on the first timestamp in the main table rows for
          this field, enter this direction in the FIELD and SOURCE tables, and then
          recalculate the UVW coordinates for this field.

    fixplanets('uid___A002_X1c6e54_X223.ms', 'Titan', True, 'Titan_55438-56292dUTC.tab')
          will attach the ephemeris table 'Titan_55438-56292dUTC.tab' to field 'Titan'
          and then recalculate the UVW coordinates for this field.

    fixplanets('uid___A002_X1c6e54_X223.ms', 'Titan', False, 'J2000 12h30m15 -02d12m00')
          will set the directions for field 'Titan' in the FIELD and SOURCE table to the
          given direction and not recalculate the UVW coordinates.
          (This can be useful for several purposes, among them preparing a concatenation
          of datasets. Only fields with the same direction will be recognised as identical.
          fixplanets can then be run again after the concatenation using parameters as in
          the first example above.)


        """
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
	#casac = self.__globals__['casac']
	casalog = self.__globals__['casalog']
	casa = self.__globals__['casa']
	#casalog = casac.casac.logsink()
        self.__globals__['__last_task'] = 'fixplanets'
        self.__globals__['taskname'] = 'fixplanets'
        ###
        self.__globals__['update_params'](func=self.__globals__['taskname'],printtext=False,ipython_globals=self.__globals__)
        ###
        ###
        #Handle globals or user over-ride of arguments
        #
        if type(self.__call__.func_defaults) is NoneType:
            function_signature_defaults={}
	else:
	    function_signature_defaults=dict(zip(self.__call__.func_code.co_varnames[1:],self.__call__.func_defaults))
	useLocalDefaults = False

        for item in function_signature_defaults.iteritems():
                key,val = item
                keyVal = eval(key)
                if (keyVal == None):
                        #user hasn't set it - use global/default
                        pass
                else:
                        #user has set it - use over-ride
			if (key != 'self') :
			   useLocalDefaults = True

	myparams = {}
	if useLocalDefaults :
	   for item in function_signature_defaults.iteritems():
	       key,val = item
	       keyVal = eval(key)
	       exec('myparams[key] = keyVal')
	       self.parameters[key] = keyVal
	       if (keyVal == None):
	           exec('myparams[key] = '+ key + ' = self.itsdefault(key)')
		   keyVal = eval(key)
		   if(type(keyVal) == dict) :
                      if len(keyVal) > 0 :
		         exec('myparams[key] = ' + key + ' = keyVal[len(keyVal)-1][\'value\']')
		      else :
		         exec('myparams[key] = ' + key + ' = {}')
	 
        else :
            print ''

            myparams['vis'] = vis = self.parameters['vis']
            myparams['field'] = field = self.parameters['field']
            myparams['fixuvw'] = fixuvw = self.parameters['fixuvw']
            myparams['direction'] = direction = self.parameters['direction']
            myparams['refant'] = refant = self.parameters['refant']
            myparams['reftime'] = reftime = self.parameters['reftime']


	result = None

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['vis'] = vis
        mytmp['field'] = field
        mytmp['fixuvw'] = fixuvw
        mytmp['direction'] = direction
        mytmp['refant'] = refant
        mytmp['reftime'] = reftime
	pathname='file://' + casa['dirs']['xml'] + '/'
	trec = casac.casac.utils().torecord(pathname+'fixplanets.xml')

        casalog.origin('fixplanets')
	try :
          #if not trec.has_key('fixplanets') or not casac.casac.utils().verify(mytmp, trec['fixplanets']) :
	    #return False

          casac.casac.utils().verify(mytmp, trec['fixplanets'], True)
          scriptstr=['']
          saveinputs = self.__globals__['saveinputs']
          if type(self.__call__.func_defaults) is NoneType:
              saveinputs=''
          else:
              saveinputs('fixplanets', 'fixplanets.last', myparams, self.__globals__,scriptstr=scriptstr)
          tname = 'fixplanets'
          spaces = ' '*(18-len(tname))
          casalog.post('\n##########################################'+
                       '\n##### Begin Task: ' + tname + spaces + ' #####')
          if type(self.__call__.func_defaults) is NoneType:
              casalog.post(scriptstr[0]+'\n', 'INFO')
          else :
              casalog.post(scriptstr[1][1:]+'\n', 'INFO')
          result = fixplanets(vis, field, fixuvw, direction, refant, reftime)
          casalog.post('##### End Task: ' + tname + '  ' + spaces + ' #####'+
                       '\n##########################################')

	except Exception, instance:
          if(self.__globals__.has_key('__rethrow_casa_exceptions') and self.__globals__['__rethrow_casa_exceptions']) :
             raise
          else :
             #print '**** Error **** ',instance
	     tname = 'fixplanets'
             casalog.post('An error occurred running task '+tname+'.', 'ERROR')
             pass

        gc.collect()
        return result
#
#
#
    def paramgui(self, useGlobals=True, ipython_globals=None):
        """
        Opens a parameter GUI for this task.  If useGlobals is true, then any relevant global parameter settings are used.
        """
        import paramgui
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )

        if useGlobals:
	    if ipython_globals == None:
                myf=self.__globals__
            else:
                myf=ipython_globals

            paramgui.setGlobals(myf)
        else:
            paramgui.setGlobals({})

        paramgui.runTask('fixplanets', myf['_ip'])
        paramgui.setGlobals({})

#
#
#
    def defaults(self, param=None, ipython_globals=None, paramvalue=None, subparam=None):
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
        if ipython_globals == None:
            myf=self.__globals__
        else:
            myf=ipython_globals

        a = odict()
        a['vis']  = ''
        a['field']  = ""
        a['fixuvw']  = False
        a['direction']  = ''
        a['refant']  = 0
        a['reftime']  = 'first'


### This function sets the default values but also will return the list of
### parameters or the default value of a given parameter
        if(param == None):
                myf['__set_default_parameters'](a)
        elif(param == 'paramkeys'):
                return a.keys()
        else:
            if(paramvalue==None and subparam==None):
               if(a.has_key(param)):
                  return a[param]
               else:
                  return self.itsdefault(param)
            else:
               retval=a[param]
               if(type(a[param])==dict):
                  for k in range(len(a[param])):
                     valornotval='value'
                     if(a[param][k].has_key('notvalue')):
                        valornotval='notvalue'
                     if((a[param][k][valornotval])==paramvalue):
                        retval=a[param][k].copy()
                        retval.pop(valornotval)
                        if(subparam != None):
                           if(retval.has_key(subparam)):
                              retval=retval[subparam]
                           else:
                              retval=self.itsdefault(subparam)
		     else:
                        retval=self.itsdefault(subparam)
               return retval


#
#
    def check_params(self, param=None, value=None, ipython_globals=None):
      if ipython_globals == None:
          myf=self.__globals__
      else:
          myf=ipython_globals
#      print 'param:', param, 'value:', value
      try :
         if str(type(value)) != "<type 'instance'>" :
            value0 = value
            value = myf['cu'].expandparam(param, value)
            matchtype = False
            if(type(value) == numpy.ndarray):
               if(type(value) == type(value0)):
                  myf[param] = value.tolist()
               else:
                  #print 'value:', value, 'value0:', value0
                  #print 'type(value):', type(value), 'type(value0):', type(value0)
                  myf[param] = value0
                  if type(value0) != list :
                     matchtype = True
            else :
               myf[param] = value
            value = myf['cu'].verifyparam({param:value})
            if matchtype:
               value = False
      except Exception, instance:
         #ignore the exception and just return it unchecked
         myf[param] = value
      return value
#
#
    def description(self, key='fixplanets', subkey=None):
        desc={'fixplanets': 'Changes FIELD and SOURCE table entries based on user-provided direction or POINTING table, optionally fixes the UVW coordinates',
               'vis': 'Name of the input visibility set.',
               'field': 'Fields to operate on.  Blank = all.',
               'fixuvw': 'Recalculate Fourier-plane u,v,w coordinates',
               'direction': 'if set, do not use pointing table but set direction to this value',
               'refant': 'if using pointing table information, use it from this antenna',
               'reftime': 'if using pointing table information, use it from this timestamp ',

              }

        if(desc.has_key(key)) :
           return desc[key]

    def itsdefault(self, paramname) :
        a = {}
        a['vis']  = ''
        a['field']  = ""
        a['fixuvw']  = False
        a['direction']  = ''
        a['refant']  = 0
        a['reftime']  = 'first'

        #a = sys._getframe(len(inspect.stack())-1).f_globals

        if a.has_key(paramname) :
	      return a[paramname]
fixplanets_cli = fixplanets_cli_()
