#
# This file was generated using xslt from its XML file
#
# Copyright 2009, Associated Universities Inc., Washington DC
#
import sys
import os
from  casac import *
import string
from taskinit import casalog
from taskinit import xmlpath
#from taskmanager import tm
import task_fixplanets
def fixplanets(vis='', field="", fixuvw=False, direction='', refant=0, reftime='first'):

        """Changes FIELD and SOURCE table entries based on user-provided direction or POINTING table, optionally fixes the UVW coordinates

    Examples:

    fixplanets('uid___A002_X1c6e54_X223.ms', 'Titan', True)
          will look up the pointing direction from antenna 0 for field 'Titan' in
          the POINTING table based on the first timestamp in the main table rows for
          this field, enter this direction in the FIELD and SOURCE tables, and then
          recalculate the UVW coordinates for this field.

    fixplanets('uid___A002_X1c6e54_X223.ms', 'Titan', True, 'Titan_55438-56292dUTC.tab')
          will attach the ephemeris table 'Titan_55438-56292dUTC.tab' to field 'Titan'
          and then recalculate the UVW coordinates for this field.

    fixplanets('uid___A002_X1c6e54_X223.ms', 'Titan', False, 'J2000 12h30m15 -02d12m00')
          will set the directions for field 'Titan' in the FIELD and SOURCE table to the
          given direction and not recalculate the UVW coordinates.
          (This can be useful for several purposes, among them preparing a concatenation
          of datasets. Only fields with the same direction will be recognised as identical.
          fixplanets can then be run again after the concatenation using parameters as in
          the first example above.)


        """

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['vis'] = vis
        mytmp['field'] = field
        mytmp['fixuvw'] = fixuvw
        mytmp['direction'] = direction
        mytmp['refant'] = refant
        mytmp['reftime'] = reftime
	pathname='file://' + xmlpath( ) + '/'
	trec = casac.utils().torecord(pathname+'fixplanets.xml')

        casalog.origin('fixplanets')
        if trec.has_key('fixplanets') and casac.utils().verify(mytmp, trec['fixplanets']) :
	    result = task_fixplanets.fixplanets(vis, field, fixuvw, direction, refant, reftime)

	else :
	  result = False
        return result
