#
# This file was generated using xslt from its XML file
#
# Copyright 2009, Associated Universities Inc., Washington DC
#
import sys
import os
from  casac import *
import string
from taskinit import casalog
from taskinit import xmlpath
#from taskmanager import tm
import task_feather
def feather(imagename='', highres='', lowres='', sdfactor=1.0, effdishdiam=-1.0, lowpassfiltersd=False):

        """Combine two images using their Fourier transforms

	Feathering is a simple method for combining two images with different 
        spatial resolution.  The processing steps are:

	       1. Regrid the low-resolution image to a temporary copy matching the
	           resolution of the high-resolution image,
               2. Transform each image to the spatial-frequency plane (gridded).
               3. Scale the low-resolution image (uv-grid) by the ratio of the
                   volumes of the two 'clean beams' (high-res/low-res). 
               4. Add to this, the uv-grid of the high-resolution image, scaled by
                   (1-wt) where 'wt' is the Fourier transform of the 'clean beam'
                   defined in the low-resolution image.
               5. Transform back to the image plane.

	Both input images must have a well-defined beam shape for this task to work. 
	This could be a 'clean beam' for interferometric images, and a 'primary-beam' 
        for a single-dish image. 

        The two images must also have the same flux density normalization scale.

	Keyword arguments:
        imagename -- Name of output feathered image
                default: none; example: imagename='orion_combined.im'
        highres -- Name of high resolution (interferometer) image
                default: none; example: highres='orion_vla.im'
	     This image is often a clean image obtained from synthesis
		observations.
        lowres -- Name of low resolution (single dish) image
                default: none; example: lowres='orion_gbt.im'
	     This image is often a image from a single-dish observations
	        or a clean image obtained from lower resolution synthesis
		observations.
         sdfactor -- value by which to scale the Single Dish image. Default is 1.0
                         Basically modifying the flux scale of the SD image
	 effdishdiam -- New effective SingleDish diameter to use in m. Obviously one can only reduce the dish effective dish diameter in feathering. Default -1.0 means leave as is.
	 lowpassfiltersd -- If True the high spatial frequency in the SD image is rejected. 
                                   Any data outside the maximum uv distance that the SD 
                                   has illuminated  is filtered out.


        Comments:

        This task can be used as one method of combining single-dish and 
        interferometric images after they have been separately made.
        
        The clean task allows another method of combining single-dish and
        interferometric data. The single-dish image can be used as a starting 
        model for the interferometric image-reconstruction. If there is
        some overlap between the spatial-frequencies contained in the 
        single-dish image and the interferometer sampling function, then,
        such a starting model will help constrain the solutions on the 
        short-baselines of the interferometric data.
        


        """

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['imagename'] = imagename
        mytmp['highres'] = highres
        mytmp['lowres'] = lowres
        mytmp['sdfactor'] = sdfactor
        mytmp['effdishdiam'] = effdishdiam
        mytmp['lowpassfiltersd'] = lowpassfiltersd
	pathname='file://' + xmlpath( ) + '/'
	trec = casac.utils().torecord(pathname+'feather.xml')

        casalog.origin('feather')
        if trec.has_key('feather') and casac.utils().verify(mytmp, trec['feather']) :
	    result = task_feather.feather(imagename, highres, lowres, sdfactor, effdishdiam, lowpassfiltersd)

	else :
	  result = False
        return result
