#
# This file was generated using xslt from its XML file
#
# Copyright 2009, Associated Universities Inc., Washington DC
#
import sys
import os
from  casac import *
import string
from taskinit import casalog
from taskinit import xmlpath
#from taskmanager import tm
import task_exportuvfits
def exportuvfits(vis='', fitsfile='', datacolumn='corrected', field='', spw='', antenna='', timerange='', writesyscal=False, multisource=True, combinespw=True, writestation=True, padwithflags=False, overwrite=False):

        """Convert a CASA visibility data set to a UVFITS file:

        This task writes a UVFITS file, a general format data set used
        to transfer data between different software systems.  It is
        written in floating point format.  Different programs have different
        restrictions on what forms of UVFITS files they will use, especially
        whether they will accept multiple sources and/or spectral windows in
        the same file.  See the spw, multisource, and combinespw descriptions
        below.

        IMPORTANT NOTE: In general, some of the data averaging features of this task have never
        worked properly. In general, users should run mstransform to select and average data
        prior to running exportuvfits. The associated input parameters are being slowly
        deprecated and removed.

        Keyword arguments:
        vis -- Name of input visibility file
                default: none;  example: vis='ngc5921.ms'
        fitsfile -- Name of output UV FITS file
                default: none;  example='3C273XC1.fits'
        datacolumn -- Visibility file data column
                default: => 'corrected'; example: datacolumn='model'
                Options: 'data' (raw),'corrected','model','weight'
        field -- Select field using field id(s) or field name(s).
                  [run listobs to obtain the list id's or names]
               default: ''=all fields
               If field string is a non-negative integer, it is assumed a field index
               otherwise, it is assumed a field name
               field='0~2'; field ids 0,1,2
               field='0,4,5~7'; field ids 0,4,5,6,7
               field='3C286,3C295'; field named 3C286 adn 3C295
               field = '3,4C*'; field id 3, all names starting with 4C
        spw -- Select spectral window/channels 
                 type 'help par.selection' for more examples.
               spw='0~2,4'; spectral windows 0,1,2,4 (all channels)
               spw='<2';  spectral windows less than 2 (i.e. 0,1)
               spw='0:5~61'; spw 0, channels 5 to 61, INCLUSIVE
               spw='*:5~61'; all spw with channels 5 to 62
               spw='0,10,3:3~45'; spw 0,10 all channels, spw 3, channels 3 to 45.
               spw='0~2:2~6'; spw 0,1,2 with channels 2 through 6 in each.
               spw='0:0~10;15~60'; spectral window 0 with channels 0-10,15-60
                         NOTE ';' to separate channel selections
               spw='0:0~10^2,1:20~30^5'; spw 0, channels 0,2,4,6,8,10,
                     spw 1, channels 20,25,30
        antenna -- Select data based on antenna/baseline
               default: '' (all)
               If antenna string is a non-negative integer, it is assumed
	          an antenna index
                 otherwise, it is assumed as an antenna name
               antenna='5&6'; baseline between antenna index 5 and index 6.
               antenna='VA05&VA06'; baseline between VLA antenna 5 and 6.
               antenna='5&6;7&8'; baseline 5-6 and 7-8
               antenna='5'; all baselines with antenna index 5
               antenna='05'; all baselines with antenna name '05', vla antenna
               antenna='5,6,10'; all baselines with antennas 5, 6 and 10
        timerange  -- Select data based on time range:
               default = '' (all); examples,
               timerange = 'YYYY/MM/DD/hh:mm:ss~YYYY/MM/DD/hh:mm:ss'
               Note: if YYYY/MM/DD is missing dat defaults to first day in data set
               timerange='09:14:0~09:54:0' picks 40 min on first day
               timerange='25:00:00~27:30:00' picks 1 hr to 3 hr 30min on next day
               timerange='09:44:00' data within one integration of time
               timerange='>10:24:00' data after this time
        multisource -- Write in multi-source format
                default: => True;
                Set to False if a single source is selected. Note that diffmap does not work on
                multi-source uvfits files, so if planning on using diffmap on the resulting uvfits
                file, select a single source and set multisource = False. Otherwise use True. (If
                multiple sources are selected, a multi-source file will be written no matter what
                the setting of this parameter). 
        combinespw -- If True, export the spectral windows as IFs.
                      Otherwise multiple windows will use multiple FREQIDs.
                default: =>  True;
                   all spectral windows must have same shape.
                True is recommended for AIPS, and mandatory for difmap.
        padwithflags -- If True, and combinespw is True, fill in missing
                        data as needed to fit the IF structure.  This is
                        appropriate if the MS had a few frequency-dependent
                        flags applied, and was then time-averaged by split, or
                        when exporting for use by difmap.  If the spectral
                        windows were observed at different times,
                        padwithflags=True will add a large number of flags,
                        making the output file significantly longer.  It does
                        not yet support spectral windows with different widths.
        writestation -- Write station name instead of antenna name
                default: True;
        writesyscal -- Write GC and TY tables
                default: => False; Not yet available
        overwrite -- Overwrite specified output file if it exists?

        """

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['vis'] = vis
        mytmp['fitsfile'] = fitsfile
        mytmp['datacolumn'] = datacolumn
        mytmp['field'] = field
        mytmp['spw'] = spw
        mytmp['antenna'] = antenna
        mytmp['timerange'] = timerange
        mytmp['writesyscal'] = writesyscal
        mytmp['multisource'] = multisource
        mytmp['combinespw'] = combinespw
        mytmp['writestation'] = writestation
        mytmp['padwithflags'] = padwithflags
        mytmp['overwrite'] = overwrite
	pathname='file://' + xmlpath( ) + '/'
	trec = casac.utils().torecord(pathname+'exportuvfits.xml')

        casalog.origin('exportuvfits')
        if trec.has_key('exportuvfits') and casac.utils().verify(mytmp, trec['exportuvfits']) :
	    result = task_exportuvfits.exportuvfits(vis, fitsfile, datacolumn, field, spw, antenna, timerange, writesyscal, multisource, combinespw, writestation, padwithflags, overwrite)

	else :
	  result = False
        return result
