#
# This file was generated using xslt from its XML file
#
# Copyright 2009, Associated Universities Inc., Washington DC
#
import sys
import os
from  casac import *
import string
from taskinit import casalog
from taskinit import xmlpath
#from taskmanager import tm
import task_exportasdm
def exportasdm(vis='', asdm='', datacolumn='data', archiveid='S0', rangeid='X1', subscanduration='24h', sbduration='2700s', apcorrected=False, verbose=True, showversion=True, useversion='v3'):

        """Convert a CASA visibility file (MS) into an ALMA or EVLA Science Data Model

  exportasdm(vis='ngc4826.ms', asdm='uid___S021_X1418_X1', 
             datacolumn='corrected', archiveid='S021', rangeid='X1418', 
             verbose=False)
  will produce an ASDM named 'uid___S021_X1418_X1' using the 
  datacolumn 'corrected' in the MS 'ngc4826.ms' with minimal
  log output. 

  The sbduration parameter controls the number of execution blocks (EBs)
  into which exportasdm subdivides the visibilities from your input MS.
  If the total observation time in the MS is shorter than what is given 
  in sbduration, a single EB will be created.

  Note concerning ALMA data: exportasdm presently is not able to export 
  from MSs containing WVR data. If you attempt to export such an MS, you
  will receive an error message saying that you can only export data of
  processor type "CORRELATOR". It will also give you the list of SPWs
  which contain CORRELATOR data. You will then have to split out these
  SPWs using the task "split" and run exportasdm on the resulting MS. 

  Also EVLA data can be exported. Note here that exportasdm does not produce
  online flags and that a subsequent reimport of the data must be done with
  online=False. Also, importevla will only work on your ASDM if you have 
  exported it with apcorrected=False (the default).

   importevla('xosrosdm', vis = 'xosro.ms')
   exportasdm(vis='xosro.ms', asdm='xosrosdm', apcorrected=False)
   importevla(asdm='xosro2asdm', vis='xosro2-reimp.ms', online=False)

  
        """

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['vis'] = vis
        mytmp['asdm'] = asdm
        mytmp['datacolumn'] = datacolumn
        mytmp['archiveid'] = archiveid
        mytmp['rangeid'] = rangeid
        mytmp['subscanduration'] = subscanduration
        mytmp['sbduration'] = sbduration
        mytmp['apcorrected'] = apcorrected
        mytmp['verbose'] = verbose
        mytmp['showversion'] = showversion
        mytmp['useversion'] = useversion
	pathname='file://' + xmlpath( ) + '/'
	trec = casac.utils().torecord(pathname+'exportasdm.xml')

        casalog.origin('exportasdm')
        if trec.has_key('exportasdm') and casac.utils().verify(mytmp, trec['exportasdm']) :
	    result = task_exportasdm.exportasdm(vis, asdm, datacolumn, archiveid, rangeid, subscanduration, sbduration, apcorrected, verbose, showversion, useversion)

	else :
	  result = False
        return result
