#
# This file was generated using xslt from its XML file
#
# Copyright 2014, Associated Universities Inc., Washington DC
#
import sys
import os
#from casac import *
import casac
import string
import time
import inspect
import gc
import numpy
from casa_stack_manip import stack_frame_find
from odict import odict
from types import * 
from task_delmod import delmod
class delmod_cli_:
    __name__ = "delmod"
    rkey = None
    i_am_a_casapy_task = None
    # The existence of the i_am_a_casapy_task attribute allows help()
    # (and other) to treat casapy tasks as a special case.

    def __init__(self) :
       self.__bases__ = (delmod_cli_,)
       self.__doc__ = self.__call__.__doc__

       self.parameters={'vis':None, 'otf':None, 'field':None, 'scr':None, }


    def result(self, key=None):
	    #### and add any that have completed...
	    return None


    def __call__(self, vis=None, otf=None, field=None, scr=None, ):

        """Deletes model representations in the MS
	Arguments :
		vis:	Name of input visibility file (MS)
		   Default Value: 

		otf:	Delete the on-the-fly model data keywords
		   Default Value: True

		field:	Select field using field id(s) or field name(s)
		   Default Value: 

		scr:	Delete the MODEL_DATA scr col (if it exists)
		   Default Value: False

	Returns: void

	Example :


      This utility task is to be used to delete the model visibility
      data representations in the MS.  The 'otf' representation is
      the new (as of v3.4) 'scratch-less' model data, stored as
      keywords in the MS header containing model data formation
      instructions.  It is generated by the setjy, ft, and clean
      tasks (usescratch=F), and if present, overrides the 
      old-fashioned MODEL_DATA column (if present).  If a user
      wishes to use the MODEL_DATA column _after_ having operated
      with the 'otf' representation, this task can be used
      to delete the 'otf' represenatation to make the MODEL_DATA
      column visible.  (Create the MODEL_DATA column by using
      usescratch=T in setjy, ft, or clean; or by running the
      clearcal task with addmodel=T.)

      If otf=T, specific fields can be selected for deletion
      using standard field selection semantics.  If field='',
      all fields' models will be deleted.

      For convenience, this method also provides a means for
      deleting the MODEL_DATA column by setting scr=T.  Note
      that it is not possible to delete the MODEL_DATA column
      per field.

      If otf=F and scr=F, delmod will provide a listing
      of the header field records.


 
        """
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
	#casac = self.__globals__['casac']
	casalog = self.__globals__['casalog']
	casa = self.__globals__['casa']
	#casalog = casac.casac.logsink()
        self.__globals__['__last_task'] = 'delmod'
        self.__globals__['taskname'] = 'delmod'
        ###
        self.__globals__['update_params'](func=self.__globals__['taskname'],printtext=False,ipython_globals=self.__globals__)
        ###
        ###
        #Handle globals or user over-ride of arguments
        #
        if type(self.__call__.func_defaults) is NoneType:
            function_signature_defaults={}
	else:
	    function_signature_defaults=dict(zip(self.__call__.func_code.co_varnames[1:],self.__call__.func_defaults))
	useLocalDefaults = False

        for item in function_signature_defaults.iteritems():
                key,val = item
                keyVal = eval(key)
                if (keyVal == None):
                        #user hasn't set it - use global/default
                        pass
                else:
                        #user has set it - use over-ride
			if (key != 'self') :
			   useLocalDefaults = True

	myparams = {}
	if useLocalDefaults :
	   for item in function_signature_defaults.iteritems():
	       key,val = item
	       keyVal = eval(key)
	       exec('myparams[key] = keyVal')
	       self.parameters[key] = keyVal
	       if (keyVal == None):
	           exec('myparams[key] = '+ key + ' = self.itsdefault(key)')
		   keyVal = eval(key)
		   if(type(keyVal) == dict) :
                      if len(keyVal) > 0 :
		         exec('myparams[key] = ' + key + ' = keyVal[len(keyVal)-1][\'value\']')
		      else :
		         exec('myparams[key] = ' + key + ' = {}')
	 
        else :
            print ''

            myparams['vis'] = vis = self.parameters['vis']
            myparams['otf'] = otf = self.parameters['otf']
            myparams['field'] = field = self.parameters['field']
            myparams['scr'] = scr = self.parameters['scr']


	result = None

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['vis'] = vis
        mytmp['otf'] = otf
        mytmp['field'] = field
        mytmp['scr'] = scr
	pathname='file://' + casa['dirs']['xml'] + '/'
	trec = casac.casac.utils().torecord(pathname+'delmod.xml')

        casalog.origin('delmod')
	try :
          #if not trec.has_key('delmod') or not casac.casac.utils().verify(mytmp, trec['delmod']) :
	    #return False

          casac.casac.utils().verify(mytmp, trec['delmod'], True)
          scriptstr=['']
          saveinputs = self.__globals__['saveinputs']
          if type(self.__call__.func_defaults) is NoneType:
              saveinputs=''
          else:
              saveinputs('delmod', 'delmod.last', myparams, self.__globals__,scriptstr=scriptstr)
          tname = 'delmod'
          spaces = ' '*(18-len(tname))
          casalog.post('\n##########################################'+
                       '\n##### Begin Task: ' + tname + spaces + ' #####')
          if type(self.__call__.func_defaults) is NoneType:
              casalog.post(scriptstr[0]+'\n', 'INFO')
          else :
              casalog.post(scriptstr[1][1:]+'\n', 'INFO')
          result = delmod(vis, otf, field, scr)
          casalog.post('##### End Task: ' + tname + '  ' + spaces + ' #####'+
                       '\n##########################################')

	except Exception, instance:
          if(self.__globals__.has_key('__rethrow_casa_exceptions') and self.__globals__['__rethrow_casa_exceptions']) :
             raise
          else :
             #print '**** Error **** ',instance
	     tname = 'delmod'
             casalog.post('An error occurred running task '+tname+'.', 'ERROR')
             pass

        gc.collect()
        return result
#
#
#
    def paramgui(self, useGlobals=True, ipython_globals=None):
        """
        Opens a parameter GUI for this task.  If useGlobals is true, then any relevant global parameter settings are used.
        """
        import paramgui
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )

        if useGlobals:
	    if ipython_globals == None:
                myf=self.__globals__
            else:
                myf=ipython_globals

            paramgui.setGlobals(myf)
        else:
            paramgui.setGlobals({})

        paramgui.runTask('delmod', myf['_ip'])
        paramgui.setGlobals({})

#
#
#
    def defaults(self, param=None, ipython_globals=None, paramvalue=None, subparam=None):
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
        if ipython_globals == None:
            myf=self.__globals__
        else:
            myf=ipython_globals

        a = odict()
        a['vis']  = ''
        a['otf']  = True
        a['scr']  = False

        a['otf'] = {
                    0:odict([{'value':True}, {'field':''}]), 
                    1:{'value':False}}

### This function sets the default values but also will return the list of
### parameters or the default value of a given parameter
        if(param == None):
                myf['__set_default_parameters'](a)
        elif(param == 'paramkeys'):
                return a.keys()
        else:
            if(paramvalue==None and subparam==None):
               if(a.has_key(param)):
                  return a[param]
               else:
                  return self.itsdefault(param)
            else:
               retval=a[param]
               if(type(a[param])==dict):
                  for k in range(len(a[param])):
                     valornotval='value'
                     if(a[param][k].has_key('notvalue')):
                        valornotval='notvalue'
                     if((a[param][k][valornotval])==paramvalue):
                        retval=a[param][k].copy()
                        retval.pop(valornotval)
                        if(subparam != None):
                           if(retval.has_key(subparam)):
                              retval=retval[subparam]
                           else:
                              retval=self.itsdefault(subparam)
		     else:
                        retval=self.itsdefault(subparam)
               return retval


#
#
    def check_params(self, param=None, value=None, ipython_globals=None):
      if ipython_globals == None:
          myf=self.__globals__
      else:
          myf=ipython_globals
#      print 'param:', param, 'value:', value
      try :
         if str(type(value)) != "<type 'instance'>" :
            value0 = value
            value = myf['cu'].expandparam(param, value)
            matchtype = False
            if(type(value) == numpy.ndarray):
               if(type(value) == type(value0)):
                  myf[param] = value.tolist()
               else:
                  #print 'value:', value, 'value0:', value0
                  #print 'type(value):', type(value), 'type(value0):', type(value0)
                  myf[param] = value0
                  if type(value0) != list :
                     matchtype = True
            else :
               myf[param] = value
            value = myf['cu'].verifyparam({param:value})
            if matchtype:
               value = False
      except Exception, instance:
         #ignore the exception and just return it unchecked
         myf[param] = value
      return value
#
#
    def description(self, key='delmod', subkey=None):
        desc={'delmod': 'Deletes model representations in the MS',
               'vis': 'Name of input visibility file (MS)',
               'otf': 'Delete the on-the-fly model data keywords',
               'field': 'Select field using field id(s) or field name(s)',
               'scr': 'Delete the MODEL_DATA scr col (if it exists)',

              }

#
# Set subfields defaults if needed
#

        if(desc.has_key(key)) :
           return desc[key]

    def itsdefault(self, paramname) :
        a = {}
        a['vis']  = ''
        a['otf']  = True
        a['field']  = ''
        a['scr']  = False

        #a = sys._getframe(len(inspect.stack())-1).f_globals

        if self.parameters['otf']  == True:
            a['field'] = ''

        if a.has_key(paramname) :
	      return a[paramname]
delmod_cli = delmod_cli_()
