#
# This file was generated using xslt from its XML file
#
# Copyright 2009, Associated Universities Inc., Washington DC
#
import sys
import os
from  casac import *
import string
from taskinit import casalog
from taskinit import xmlpath
#from taskmanager import tm
import task_cvel2
def cvel2(vis='', outputvis='', keepmms=True, passall=False, field='', spw='', scan='', antenna='', correlation='', timerange='', intent='', array='', uvrange='', observation='', feed='', datacolumn='all', mode='channel', nchan=-1, start=0, width=1, interpolation='linear', phasecenter='', restfreq='', outframe='', veltype='radio', hanning=False):

        """Regrid an MS or MMS to a new spectral window, channel structure or frame

    Detailed description of keyword arguments:

--- Input/Output parameters ---
    
    vis -- Name of input visibility file
        default: ''; example: vis='ngc5921.ms'

    outputvis -- Name of output visibility file or Multi-MS
        default: ''; example: outputvis='ngc5921.mms'

    keepmms -- Create a Multi-MS as the output if the input is a Multi-MS.
        default: True

    By default it will create a Multi-MS when the input is a Multi-MS.
    The output Multi-MS will have the same partition axis of the input MMS.
    See 'help partition' for more information on the MMS format.
    
    NOTE: It is not possible to combine the spws if the input MMS was partitioned with 
          separationaxis='spw'. In this case, the task will abort with an error.
                   

--- Data selection parameters ---
    field -- Select field using field id(s) or field name(s).
             [run listobs to obtain the list iof d's or names]
        default: ''=all fields If field string is a non-negative
           integer, it is assumed to be a field index
           otherwise, it is assumed to be a field name
           field='0~2'; field ids 0,1,2
           field='0,4,5~7'; field ids 0,4,5,6,7
           field='3C286,3C295'; fields named 3C286 and 3C295
           field = '3,4C*'; field id 3, all names starting with 4C

    spw -- Select spectral window/channels
        default: ''=all spectral windows and channels
           spw='0~2,4'; spectral windows 0,1,2,4 (all channels)
           spw='<2';  spectral windows less than 2 (i.e. 0,1)
           spw='0:5~61'; spw 0, channels 5 to 61
           spw='0,10,3:3~45'; spw 0,10 all channels, spw 3 - chans 3 to 45.
           spw='0~2:2~6'; spw 0,1,2 with channels 2 through 6 in each.
           spw = '*:3~64'  channels 3 through 64 for all sp id's
                   spw = ' :3~64' will NOT work.

               NOTE: mstransform does not support multiple channel ranges per
                     spectral window (';').

    scan -- Scan number range
        default: ''=all

    antenna -- Select data based on antenna/baseline
        default: '' (all)
            Non-negative integers are assumed to be antenna indices, and
            anything else is taken as an antenna name.

        examples:
            antenna='5&6': baseline between antenna index 5 and index 6.
            antenna='VA05&VA06': baseline between VLA antenna 5 and 6.
            antenna='5&6;7&8': baselines 5-6 and 7-8
            antenna='5': all baselines with antenna 5
            antenna='5,6,10': all baselines including antennas 5, 6, or 10
            antenna='5,6,10&': all baselines with *only* antennas 5, 6, or
                                   10.  (cross-correlations only.  Use &&
                                   to include autocorrelations, and &&&
                                   to get only autocorrelations.)
            antenna='!ea03,ea12,ea17': all baselines except those that
                                       include EVLA antennas ea03, ea12, or
                                       ea17.

    correlation -- Correlation types or expression.
        default: '' (all correlations)
        example: correlation='XX,YY' 

    timerange -- Select data based on time range:
        default: '' (all); examples,
           timerange = 'YYYY/MM/DD/hh:mm:ss~YYYY/MM/DD/hh:mm:ss'
           Note: if YYYY/MM/DD is missing date, timerange defaults to the
           first day in the dataset
           timerange='09:14:0~09:54:0' picks 40 min on first day
           timerange='25:00:00~27:30:00' picks 1 hr to 3 hr 30min
           on next day
           timerange='09:44:00' data within one integration of time
           timerange='>10:24:00' data after this time

    array -- (Sub)array number range
        default: ''=all

    uvrange -- Select data within uvrange (default units meters)
        default: ''=all; example:
            uvrange='0~1000klambda'; uvrange from 0-1000 kilo-lambda
            uvrange='>4klambda';uvranges greater than 4 kilo-lambda
            uvrange='0~1000km'; uvrange in kilometers

    observation -- Select by observation ID(s)
        default: ''=all

    feed -- Selection based on the feed - NOT IMPLEMENTED YET
        default: ''=all

    datacolumn -- Which data column to use for processing (case-insensitive).
        default: 'all'; 
        options: 'data', 'model', 'corrected', 'all','float_data', 'lag_data', 
                 'float_data,data', 'lag_data,data'.
        example: datacolumn='data'

        NOTE: 'all' = whichever of the above that are present. If the requested
                      column does not exist, the task will exit with an error.
            
    mode -- Frequency Specification:
               NOTE: See examples below:
               default: 'channel'
                 mode = 'channel'; Use with nchan, start, width to specify
                         output spw. Produces equidistant grid based on first
                         selected channel. See examples below.
                 mode = 'velocity', means channels are specified in 
 		      velocity.
                 mode = 'frequency', means channels are specified in 
 		      frequency.
                 mode = 'channel_b', alternative 'channel' mode.
		         Does not force an equidistant grid. Faster.

  >>> mode expandable parameters 
               Start, width are given in units of channels, frequency 
 		  or velocity as indicated by mode 
               nchan -- Number of channels in output spw
                 default: -1 = all channels; example: nchan=3
               start -- Start or end input channel (zero-based) depending on the sign of the width parameter
                 default=0; example: start=5
               width -- Output channel width in units of the input
 		     channel width (sign indicates whether the start parameter is lower(+) or upper(-) end of the range)
                 default=1; example: width=4
               interpolation -- Interpolation method (linear, nearest, cubic, spline, fftshift)
                 default = 'linear'
           examples:
               spw = '0,1'; mode = 'channel'
                  will produce a single spw containing all channels in spw 
 		       0 and 1
               spw='0:5~28^2'; mode = 'channel'
                  will produce a single spw made with channels 
 		       (5,7,9,...,25,27)
               spw = '0'; mode = 'channel': nchan=3; start=5; width=4
                  will produce an spw with 3 output channels
                  new channel 1 contains data from channels (5+6+7+8)
                  new channel 2 contains data from channels (9+10+11+12)
                  new channel 3 contains data from channels (13+14+15+16)
               spw = '0:0~63^3'; mode='channel'; nchan=21; start = 0; 
 		   width = 1
                  will produce an spw with 21 channels
                  new channel 1 contains data from channel 0
                  new channel 2 contains data from channel 2
                  new channel 21 contains data from channel 61
               spw = '0:0~40^2'; mode = 'channel'; nchan = 3; start = 
 		   5; width = 4
                  will produce an spw with three output channels
                  new channel 1 contains channels (5,7)
                  new channel 2 contains channels (13,15)
                  new channel 3 contains channels (21,23)

    phasecenter -- Direction measure  or fieldid. To be used in mosaics to indicate
               the center direction to be used in the spectral coordinate transformation.
            default: '' (first selected field)
            options: FIELD_ID (int) or center coordinate measure (str).
            example: phasecenter=6 or phasecenter='J2000 19h30m00 -40d00m00'
            
    restfreq -- Specify rest frequency to use for output image
               default='' Occasionally it is necessary to set this (for
               example some VLA spectral line data).  For example for
               NH_3 (1,1) put restfreq='23.694496GHz'

    outframe -- output reference frame (not case-sensitive)
               possible values: LSRK, LSRD, BARY, GALACTO, LGROUP, CMB, GEO, TOPO, or SOURCE
               (SOURCE is meant for solar system work and corresponds to GEO + radial velocity
               correction for ephemeris objects).
               default='' (keep original reference frame) ; example: outframe='BARY'     

    veltype -- definition of velocity (in mode)
               default = 'radio'

    hanning -- if true, Hanning smooth frequency channel data to remove Gibbs ringing

==================================================================

The intent of cvel2 is to transform channel labels and the 
visibilities to a spectral reference frame which is appropriate
for the science analysis, e.g. from TOPO to LSRK to correct for 
Doppler shifts throughout the time of the observation. Naturally, 
this will change the shape of the spectral feature to some extent. 
According to the Nyquist theorem you should oversample a spectrum 
with twice the numbers of channels to retain the shape. Based on 
some tests, however, we recommend to observe with at least 
3-4 times the number of channels for each significant spectral 
feature (like 3-4 times the linewidth). This will minimize 
regridding artifacts in cvel2.

If cvel2 has already established the grid that is desired for the
imaging, clean should be run with exactly the same frequency/velocity 
parameters as used in cvel2 in order to avoid additional regridding in 
clean.

Hanning smoothing is optionally offered in cvel2, but tests have 
shown that already the regridding process itself, if it involved 
a transformation from TOPO to a non-terrestrial reference frame, 
implies some smoothing (due to channel interpolation) such that 
Hanning smoothing may not be necessary.

        """

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['vis'] = vis
        mytmp['outputvis'] = outputvis
        mytmp['keepmms'] = keepmms
        mytmp['passall'] = passall
        mytmp['field'] = field
        mytmp['spw'] = spw
        mytmp['scan'] = scan
        mytmp['antenna'] = antenna
        mytmp['correlation'] = correlation
        mytmp['timerange'] = timerange
        mytmp['intent'] = intent
        mytmp['array'] = array
        mytmp['uvrange'] = uvrange
        mytmp['observation'] = observation
        mytmp['feed'] = feed
        mytmp['datacolumn'] = datacolumn
        mytmp['mode'] = mode
        mytmp['nchan'] = nchan
        mytmp['start'] = start
        mytmp['width'] = width
        mytmp['interpolation'] = interpolation
        mytmp['phasecenter'] = phasecenter
        mytmp['restfreq'] = restfreq
        mytmp['outframe'] = outframe
        mytmp['veltype'] = veltype
        mytmp['hanning'] = hanning
	pathname='file://' + xmlpath( ) + '/'
	trec = casac.utils().torecord(pathname+'cvel2.xml')

        casalog.origin('cvel2')
        if trec.has_key('cvel2') and casac.utils().verify(mytmp, trec['cvel2']) :
	    result = task_cvel2.cvel2(vis, outputvis, keepmms, passall, field, spw, scan, antenna, correlation, timerange, intent, array, uvrange, observation, feed, datacolumn, mode, nchan, start, width, interpolation, phasecenter, restfreq, outframe, veltype, hanning)

	else :
	  result = False
        return result
