#
# This file was generated using xslt from its XML file
#
# Copyright 2014, Associated Universities Inc., Washington DC
#
import sys
import os
#from casac import *
import casac
import string
import time
import inspect
import gc
import numpy
from casa_stack_manip import stack_frame_find
from odict import odict
from types import * 
from task_csvclean import csvclean
class csvclean_cli_:
    __name__ = "csvclean"
    rkey = None
    i_am_a_casapy_task = None
    # The existence of the i_am_a_casapy_task attribute allows help()
    # (and other) to treat casapy tasks as a special case.

    def __init__(self) :
       self.__bases__ = (csvclean_cli_,)
       self.__doc__ = self.__call__.__doc__

       self.parameters={'vis':None, 'imagename':None, 'field':None, 'spw':None, 'advise':None, 'mode':None, 'nchan':None, 'width':None, 'imsize':None, 'cell':None, 'phasecenter':None, 'niter':None, 'weighting':None, 'restoringbeam':None, 'interactive':None, }


    def result(self, key=None):
	    #### and add any that have completed...
	    return None


    def __call__(self, vis=None, imagename=None, field=None, spw=None, advise=None, mode=None, nchan=None, width=None, imsize=None, cell=None, phasecenter=None, niter=None, weighting=None, restoringbeam=None, interactive=None, ):

        """This task does an invert of the visibilities and deconvolve in the image plane.

	Detailed Description: 
This task does an invert of the visibilities and deconvolve in the
			image plane. It does not do a uvdata subtraction (aka Cotton-Schwab
			major cycle) of model visibility as in clean. - For ALMA Commissioning
	
	Arguments :
		vis:	Name of input visibility file
		   Default Value: 

		imagename:	Name of image
		   Default Value: 

		field:	Select field using field id(s) or field name(s)
		   Default Value: 

		spw:	Select spectral window/channels
		   Default Value: 

		advise:	Boolean to determine if advice on image cell is requested
		   Default Value: False

		mode:	 define the mode to operate csvclean: option continuum, cube 
		   Default Value: continuum
		   Allowed Values:
				continuum
				cube

		nchan:	Number of channels (planes) in output image; -1 = all
		   Default Value: -1

		width:	width of output spectral channels
		   Default Value: 1

		imsize:	Image size in pixels (nx,ny), symmetric for single value
		   Default Value: 
	    256256
	  

		cell:	The image cell size in arcseconds [x,y]. 
		   Default Value: 1.01.0

		phasecenter:	Image center: direction or field index
		   Default Value: 

		niter:	Maximum number of iterations
		   Default Value: 500

		weighting:	Type of weighting
		   Default Value: natural
		   Allowed Values:
				natural
				uniform
				briggs
				briggsabs
				radial
				superuniform

		restoringbeam:	Output Gaussian restoring beam for CLEAN image
		   Default Value: 

		interactive:	Create a mask interactively or not.
		   Default Value: False


	Example :


        This task does not do a uvdata subtraction (aka Cotton-Schwab major cycle) 
        of model visibility as in clean. - For ALMA Commissioning

	Keyword arguments:
	vis -- Name of input visibility file
        	default: none; example: vis='ngc5921.ms' 
        	
	imagename -- Name of output CASA image. (only the prefix)
                   default: none; example: imagename='m2'
                   output images are:
                 m2.image; cleaned and restored image
                        With or without primary beam correction
                 m2dirty.image; dirty image
                 m2psf.image; point-spread function (dirty beam)
                 m2.model; image of clean components
                 m2.mask; image containing clean regions, when interative=True
		         
	field -- Select fields in mosaic.  Use field id(s) or field name(s).
                  ['go listobs' to obtain the list id's or names]
              default: ''= all fields
              If field string is a non-negative integer, it is assumed to
                  be a field index otherwise, it is assumed to be a 
		  field name
              field='0~2'; field ids 0,1,2
              field='0,4,5~7'; field ids 0,4,5,6,7
              field='3C286,3C295'; field named 3C286 and 3C295
              field = '3,4C*'; field id 3, all names starting with 4C
              
	spw -- Select spectral window/channels
           NOTE: This selects the data passed as the INPUT to mode
           default: ''= all spectral windows and channels
                spw='0~2,4'; spectral windows 0,1,2,4 (all channels)
                spw='0:5~61'; spw 0, channels 5 to 61
                spw='<2';   spectral windows less than 2 (i.e. 0,1)
                spw='0,10,3:3~45'; spw 0,10 all channels, spw 3, 
				   channels 3 to 45.
                spw='0~2:2~6'; spw 0,1,2 with channels 2 through 6 in each.
                spw='0:0~10;15~60'; spectral window 0 with channels 
				    0-10,15-60
                spw='0:0~10,1:20~30,2:1;2;3'; spw 0, channels 0-10,
                      spw 1, channels 20-30, and spw 2, channels, 1,2 and 3
        advise -- This determines whether advice for imsize and cell is 
                  requested. If set to True. It won't run clean but return
                  values for imszise and cell estimated for the longest 
                  baseline in the data
                      
	imsize -- Image pixel size (x,y).  DOES NOT HAVE TO BE A POWER OF 2
               default = [256,256]; example: imsize=[350,350]
               imsize = 500 is equivalent to [500,500].
               Avoid odd-numbered imsize.

	cell -- Cell size (x,y)
               default= '1.0arcsec';
               example: cell=['0.5arcsec,'0.5arcsec'] or
               cell=['1arcmin', '1arcmin']
               cell = '1arcsec' is equivalent to ['1arcsec','1arcsec']
               NOTE:cell = 2.0 => ['2arcsec', '2arcsec']

       phasecenter -- direction measure  or fieldid for the mosaic center
                default: '' => first field selected ; example: phasecenter=6
                or phasecenter='J2000 19h30m00 -40d00m00'

	mode -- this determines what kind of image to make 
                continuum or cube. In continuum all the selected data 
                channels are combined in a 1 channel image using 
                multifrequency synthesis.
                options are 'cube' and 'continuum'
                default: 'continuum'
  >>> mode='cube' expandable parameters
               nchan -- sets the number of channel in the output
               image. e.g nchan=10
                
               width -- image channel width in terms of the number of
                        channel of the first spw of the data selected
                        e.g width=2  
              
                

	niter -- Maximum number of iterations,
               if niter=0, then no CLEANing is done ("invert" only)
               default: 500; example: niter=5000

	weighting -- Weighting to apply to visibilities:
               default='natural'; example: weighting='uniform';
               Options: 'natural','uniform','briggs', 
                       'superuniform','briggsabs','radial'

	restoringbeam -- Output Gaussian restoring beam for CLEAN image
               [bmaj, bmin, bpa] elliptical Gaussian restoring beam.
               Default units are in arc-seconds for bmaj and bmin, and in degrees
               for bpa. Default: restoringbeam=[]; Use PSF calculated
               from dirty beam. 
               example: restoringbeam=['10arcsec'] or restorinbeam='10arcsec', circular Gaussian.
                        FWHM 10 arcseconds example:
                        restoringbeam=['10.0','5.0','45.0deg'] 10"x5" 
                        at 45 degrees
	
	interactive -- Create a mask interactively or not.
        		default=False; example: interactive=True
        		The viewer will open with the image displayed. Select the
        		region for the mask and double click in the middle of it.
	
 
        """
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
	#casac = self.__globals__['casac']
	casalog = self.__globals__['casalog']
	casa = self.__globals__['casa']
	#casalog = casac.casac.logsink()
        self.__globals__['__last_task'] = 'csvclean'
        self.__globals__['taskname'] = 'csvclean'
        ###
        self.__globals__['update_params'](func=self.__globals__['taskname'],printtext=False,ipython_globals=self.__globals__)
        ###
        ###
        #Handle globals or user over-ride of arguments
        #
        if type(self.__call__.func_defaults) is NoneType:
            function_signature_defaults={}
	else:
	    function_signature_defaults=dict(zip(self.__call__.func_code.co_varnames[1:],self.__call__.func_defaults))
	useLocalDefaults = False

        for item in function_signature_defaults.iteritems():
                key,val = item
                keyVal = eval(key)
                if (keyVal == None):
                        #user hasn't set it - use global/default
                        pass
                else:
                        #user has set it - use over-ride
			if (key != 'self') :
			   useLocalDefaults = True

	myparams = {}
	if useLocalDefaults :
	   for item in function_signature_defaults.iteritems():
	       key,val = item
	       keyVal = eval(key)
	       exec('myparams[key] = keyVal')
	       self.parameters[key] = keyVal
	       if (keyVal == None):
	           exec('myparams[key] = '+ key + ' = self.itsdefault(key)')
		   keyVal = eval(key)
		   if(type(keyVal) == dict) :
                      if len(keyVal) > 0 :
		         exec('myparams[key] = ' + key + ' = keyVal[len(keyVal)-1][\'value\']')
		      else :
		         exec('myparams[key] = ' + key + ' = {}')
	 
        else :
            print ''

            myparams['vis'] = vis = self.parameters['vis']
            myparams['imagename'] = imagename = self.parameters['imagename']
            myparams['field'] = field = self.parameters['field']
            myparams['spw'] = spw = self.parameters['spw']
            myparams['advise'] = advise = self.parameters['advise']
            myparams['mode'] = mode = self.parameters['mode']
            myparams['nchan'] = nchan = self.parameters['nchan']
            myparams['width'] = width = self.parameters['width']
            myparams['imsize'] = imsize = self.parameters['imsize']
            myparams['cell'] = cell = self.parameters['cell']
            myparams['phasecenter'] = phasecenter = self.parameters['phasecenter']
            myparams['niter'] = niter = self.parameters['niter']
            myparams['weighting'] = weighting = self.parameters['weighting']
            myparams['restoringbeam'] = restoringbeam = self.parameters['restoringbeam']
            myparams['interactive'] = interactive = self.parameters['interactive']

        if type(imsize)==int: imsize=[imsize]
        if type(cell)==float: cell=[cell]
        if type(restoringbeam)==str: restoringbeam=[restoringbeam]

	result = None

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['vis'] = vis
        mytmp['imagename'] = imagename
        mytmp['field'] = field
        mytmp['spw'] = spw
        mytmp['advise'] = advise
        mytmp['mode'] = mode
        mytmp['nchan'] = nchan
        mytmp['width'] = width
        mytmp['imsize'] = imsize
        if type(cell) == str :
           mytmp['cell'] = casac.casac.qa.quantity(cell)
        else :
           mytmp['cell'] = cell
        mytmp['phasecenter'] = phasecenter
        mytmp['niter'] = niter
        mytmp['weighting'] = weighting
        mytmp['restoringbeam'] = restoringbeam
        mytmp['interactive'] = interactive
	pathname='file://' + casa['dirs']['xml'] + '/'
	trec = casac.casac.utils().torecord(pathname+'csvclean.xml')

        casalog.origin('csvclean')
	try :
          #if not trec.has_key('csvclean') or not casac.casac.utils().verify(mytmp, trec['csvclean']) :
	    #return False

          casac.casac.utils().verify(mytmp, trec['csvclean'], True)
          scriptstr=['']
          saveinputs = self.__globals__['saveinputs']
          if type(self.__call__.func_defaults) is NoneType:
              saveinputs=''
          else:
              saveinputs('csvclean', 'csvclean.last', myparams, self.__globals__,scriptstr=scriptstr)
          tname = 'csvclean'
          spaces = ' '*(18-len(tname))
          casalog.post('\n##########################################'+
                       '\n##### Begin Task: ' + tname + spaces + ' #####')
          if type(self.__call__.func_defaults) is NoneType:
              casalog.post(scriptstr[0]+'\n', 'INFO')
          else :
              casalog.post(scriptstr[1][1:]+'\n', 'INFO')
          result = csvclean(vis, imagename, field, spw, advise, mode, nchan, width, imsize, cell, phasecenter, niter, weighting, restoringbeam, interactive)
          casalog.post('##### End Task: ' + tname + '  ' + spaces + ' #####'+
                       '\n##########################################')

	except Exception, instance:
          if(self.__globals__.has_key('__rethrow_casa_exceptions') and self.__globals__['__rethrow_casa_exceptions']) :
             raise
          else :
             #print '**** Error **** ',instance
	     tname = 'csvclean'
             casalog.post('An error occurred running task '+tname+'.', 'ERROR')
             pass

        gc.collect()
        return result
#
#
#
    def paramgui(self, useGlobals=True, ipython_globals=None):
        """
        Opens a parameter GUI for this task.  If useGlobals is true, then any relevant global parameter settings are used.
        """
        import paramgui
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )

        if useGlobals:
	    if ipython_globals == None:
                myf=self.__globals__
            else:
                myf=ipython_globals

            paramgui.setGlobals(myf)
        else:
            paramgui.setGlobals({})

        paramgui.runTask('csvclean', myf['_ip'])
        paramgui.setGlobals({})

#
#
#
    def defaults(self, param=None, ipython_globals=None, paramvalue=None, subparam=None):
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
        if ipython_globals == None:
            myf=self.__globals__
        else:
            myf=ipython_globals

        a = odict()
        a['vis']  = ''
        a['field']  = ''
        a['spw']  = ''
        a['advise']  = False
        a['mode']  = 'continuum'

        a['advise'] = {
                    0:odict([{'value':False}, {'imagename':''}, {'imsize':[256, 256]}, {'cell':[1.0, 1.0]}, {'phasecenter':''}, {'niter':500}, {'weighting':'natural'}, {'restoringbeam':[]}, {'interactive':False}]), 
                    1:{'value':True}}
        a['mode'] = {
                    0:{'value':'continuum'}, 
                    1:odict([{'value':'cube'}, {'nchan':-1}, {'width':1}])}

### This function sets the default values but also will return the list of
### parameters or the default value of a given parameter
        if(param == None):
                myf['__set_default_parameters'](a)
        elif(param == 'paramkeys'):
                return a.keys()
        else:
            if(paramvalue==None and subparam==None):
               if(a.has_key(param)):
                  return a[param]
               else:
                  return self.itsdefault(param)
            else:
               retval=a[param]
               if(type(a[param])==dict):
                  for k in range(len(a[param])):
                     valornotval='value'
                     if(a[param][k].has_key('notvalue')):
                        valornotval='notvalue'
                     if((a[param][k][valornotval])==paramvalue):
                        retval=a[param][k].copy()
                        retval.pop(valornotval)
                        if(subparam != None):
                           if(retval.has_key(subparam)):
                              retval=retval[subparam]
                           else:
                              retval=self.itsdefault(subparam)
		     else:
                        retval=self.itsdefault(subparam)
               return retval


#
#
    def check_params(self, param=None, value=None, ipython_globals=None):
      if ipython_globals == None:
          myf=self.__globals__
      else:
          myf=ipython_globals
#      print 'param:', param, 'value:', value
      try :
         if str(type(value)) != "<type 'instance'>" :
            value0 = value
            value = myf['cu'].expandparam(param, value)
            matchtype = False
            if(type(value) == numpy.ndarray):
               if(type(value) == type(value0)):
                  myf[param] = value.tolist()
               else:
                  #print 'value:', value, 'value0:', value0
                  #print 'type(value):', type(value), 'type(value0):', type(value0)
                  myf[param] = value0
                  if type(value0) != list :
                     matchtype = True
            else :
               myf[param] = value
            value = myf['cu'].verifyparam({param:value})
            if matchtype:
               value = False
      except Exception, instance:
         #ignore the exception and just return it unchecked
         myf[param] = value
      return value
#
#
    def description(self, key='csvclean', subkey=None):
        desc={'csvclean': 'This task does an invert of the visibilities and deconvolve in the image plane.',
               'vis': 'Name of input visibility file',
               'imagename': 'Name of image',
               'field': 'Select field using field id(s) or field name(s)',
               'spw': 'Select spectral window/channels',
               'advise': 'Boolean to determine if advice on image cell is requested',
               'mode': ' define the mode to operate csvclean: option continuum, cube ',
               'nchan': 'Number of channels (planes) in output image; -1 = all',
               'width': 'width of output spectral channels',
               'imsize': 'Image size in pixels (nx,ny), symmetric for single value',
               'cell': 'The image cell size in arcseconds [x,y]. ',
               'phasecenter': 'Image center: direction or field index',
               'niter': 'Maximum number of iterations',
               'weighting': 'Type of weighting',
               'restoringbeam': 'Output Gaussian restoring beam for CLEAN image',
               'interactive': 'Create a mask interactively or not.',

              }

#
# Set subfields defaults if needed
#

        if(desc.has_key(key)) :
           return desc[key]

    def itsdefault(self, paramname) :
        a = {}
        a['vis']  = ''
        a['imagename']  = ''
        a['field']  = ''
        a['spw']  = ''
        a['advise']  = False
        a['mode']  = 'continuum'
        a['nchan']  = -1
        a['width']  = 1
        a['imsize']  = [256, 256]
        a['cell']  = ['1.0arcsec', '1.0arcsec']
        a['phasecenter']  = ''
        a['niter']  = 500
        a['weighting']  = 'natural'
        a['restoringbeam']  = ['']
        a['interactive']  = False

        #a = sys._getframe(len(inspect.stack())-1).f_globals

        if self.parameters['advise']  == False:
            a['imagename'] = ''
            a['imsize'] = [256, 256]
            a['cell'] = [1.0, 1.0]
            a['phasecenter'] = ''
            a['niter'] = 500
            a['weighting'] = 'natural'
            a['restoringbeam'] = []
            a['interactive'] = False

        if self.parameters['mode']  == 'cube':
            a['nchan'] = -1
            a['width'] = 1

        if a.has_key(paramname) :
	      return a[paramname]
csvclean_cli = csvclean_cli_()
