#
# This file was generated using xslt from its XML file
#
# Copyright 2009, Associated Universities Inc., Washington DC
#
import sys
import os
from  casac import *
import string
from taskinit import casalog
from taskinit import xmlpath
#from taskmanager import tm
import task_csvclean
def csvclean(vis='', imagename='', field='', spw='', advise=False, mode='continuum', nchan=-1, width=1, imsize=[256, 256], cell=['1.0arcsec', '1.0arcsec'], phasecenter='', niter=500, weighting='natural', restoringbeam=[''], interactive=False):

        """This task does an invert of the visibilities and deconvolve in the image plane.

        This task does not do a uvdata subtraction (aka Cotton-Schwab major cycle) 
        of model visibility as in clean. - For ALMA Commissioning

	Keyword arguments:
	vis -- Name of input visibility file
        	default: none; example: vis='ngc5921.ms' 
        	
	imagename -- Name of output CASA image. (only the prefix)
                   default: none; example: imagename='m2'
                   output images are:
                 m2.image; cleaned and restored image
                        With or without primary beam correction
                 m2dirty.image; dirty image
                 m2psf.image; point-spread function (dirty beam)
                 m2.model; image of clean components
                 m2.mask; image containing clean regions, when interative=True
		         
	field -- Select fields in mosaic.  Use field id(s) or field name(s).
                  ['go listobs' to obtain the list id's or names]
              default: ''= all fields
              If field string is a non-negative integer, it is assumed to
                  be a field index otherwise, it is assumed to be a 
		  field name
              field='0~2'; field ids 0,1,2
              field='0,4,5~7'; field ids 0,4,5,6,7
              field='3C286,3C295'; field named 3C286 and 3C295
              field = '3,4C*'; field id 3, all names starting with 4C
              
	spw -- Select spectral window/channels
           NOTE: This selects the data passed as the INPUT to mode
           default: ''= all spectral windows and channels
                spw='0~2,4'; spectral windows 0,1,2,4 (all channels)
                spw='0:5~61'; spw 0, channels 5 to 61
                spw='<2';   spectral windows less than 2 (i.e. 0,1)
                spw='0,10,3:3~45'; spw 0,10 all channels, spw 3, 
				   channels 3 to 45.
                spw='0~2:2~6'; spw 0,1,2 with channels 2 through 6 in each.
                spw='0:0~10;15~60'; spectral window 0 with channels 
				    0-10,15-60
                spw='0:0~10,1:20~30,2:1;2;3'; spw 0, channels 0-10,
                      spw 1, channels 20-30, and spw 2, channels, 1,2 and 3
        advise -- This determines whether advice for imsize and cell is 
                  requested. If set to True. It won't run clean but return
                  values for imszise and cell estimated for the longest 
                  baseline in the data
                      
	imsize -- Image pixel size (x,y).  DOES NOT HAVE TO BE A POWER OF 2
               default = [256,256]; example: imsize=[350,350]
               imsize = 500 is equivalent to [500,500].
               Avoid odd-numbered imsize.

	cell -- Cell size (x,y)
               default= '1.0arcsec';
               example: cell=['0.5arcsec,'0.5arcsec'] or
               cell=['1arcmin', '1arcmin']
               cell = '1arcsec' is equivalent to ['1arcsec','1arcsec']
               NOTE:cell = 2.0 => ['2arcsec', '2arcsec']

       phasecenter -- direction measure  or fieldid for the mosaic center
                default: '' => first field selected ; example: phasecenter=6
                or phasecenter='J2000 19h30m00 -40d00m00'

	mode -- this determines what kind of image to make 
                continuum or cube. In continuum all the selected data 
                channels are combined in a 1 channel image using 
                multifrequency synthesis.
                options are 'cube' and 'continuum'
                default: 'continuum'
  >>> mode='cube' expandable parameters
               nchan -- sets the number of channel in the output
               image. e.g nchan=10
                
               width -- image channel width in terms of the number of
                        channel of the first spw of the data selected
                        e.g width=2  
              
                

	niter -- Maximum number of iterations,
               if niter=0, then no CLEANing is done ("invert" only)
               default: 500; example: niter=5000

	weighting -- Weighting to apply to visibilities:
               default='natural'; example: weighting='uniform';
               Options: 'natural','uniform','briggs', 
                       'superuniform','briggsabs','radial'

	restoringbeam -- Output Gaussian restoring beam for CLEAN image
               [bmaj, bmin, bpa] elliptical Gaussian restoring beam.
               Default units are in arc-seconds for bmaj and bmin, and in degrees
               for bpa. Default: restoringbeam=[]; Use PSF calculated
               from dirty beam. 
               example: restoringbeam=['10arcsec'] or restorinbeam='10arcsec', circular Gaussian.
                        FWHM 10 arcseconds example:
                        restoringbeam=['10.0','5.0','45.0deg'] 10"x5" 
                        at 45 degrees
	
	interactive -- Create a mask interactively or not.
        		default=False; example: interactive=True
        		The viewer will open with the image displayed. Select the
        		region for the mask and double click in the middle of it.
	
 
        """
        if type(imsize)==int: imsize=[imsize]
        if type(cell)==float: cell=[cell]
        if type(restoringbeam)==str: restoringbeam=[restoringbeam]

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['vis'] = vis
        mytmp['imagename'] = imagename
        mytmp['field'] = field
        mytmp['spw'] = spw
        mytmp['advise'] = advise
        mytmp['mode'] = mode
        mytmp['nchan'] = nchan
        mytmp['width'] = width
        mytmp['imsize'] = imsize
        if type(cell) == str :
           mytmp['cell'] = casac.quanta().quantity(cell)
        else :
           mytmp['cell'] = cell
        mytmp['phasecenter'] = phasecenter
        mytmp['niter'] = niter
        mytmp['weighting'] = weighting
        mytmp['restoringbeam'] = restoringbeam
        mytmp['interactive'] = interactive
	pathname='file://' + xmlpath( ) + '/'
	trec = casac.utils().torecord(pathname+'csvclean.xml')

        casalog.origin('csvclean')
        if trec.has_key('csvclean') and casac.utils().verify(mytmp, trec['csvclean']) :
	    result = task_csvclean.csvclean(vis, imagename, field, spw, advise, mode, nchan, width, imsize, cell, phasecenter, niter, weighting, restoringbeam, interactive)

	else :
	  result = False
        return result
