#
# This file was generated using xslt from its XML file
#
# Copyright 2009, Associated Universities Inc., Washington DC
#
import sys
import os
from  casac import *
import string
from taskinit import casalog
from taskinit import xmlpath
#from taskmanager import tm
import task_clearcal
def clearcal(vis='', field='', spw='', intent='', addmodel=False):

        """Re-initializes the calibration for a visibility data set

      Clearcal reinitializes the calibration columns in a measurement set.
      Specificially, it will set the MODEL_DATA column (if present) to
      unity in total intensity and zero in polarization, and it will
      set the  CORRECTED_DATA column to the original (observed) DATA 
      in the DATA column.  Use the field and spw parameters to select
      which data to initialize.  If the dataset does not yet have the scratch
      columns, they will be created (MODEL_DATA only if addmodel=True)
      and initilized for the whole dataset (field, spw, and intent 
      will be ignored in this case).  

      Keyword arguments:
      vis -- Name of input visibility file
              default: none; example: vis='ngc5921.ms'

      field -- Select field using field id(s) or field name(s).
                 [run listobs to obtain the list id's or names]
              default: ''=all fields
              If field string is a non-negative integer, it is assumed a field index
                otherwise, it is assumed a field name
              field='0~2'; field ids 0,1,2
              field='0,4,5~7'; field ids 0,4,5,6,7
              field='3C286,3C295'; field named 3C286 adn 3C295
              field = '3,4C*'; field id 3, all names starting with 4C
      spw -- Select spectral window
              default: ''=all spectral windows and channels
              spw='0~2,4'; spectral windows 0,1,2,4 (all channels)
              spw='<2';  spectral windows less than 2 (i.e. 0,1)
              spw='0:5~61'; spw 0, channels 5 to 61
              spw='0,10,3:3~45'; spw 0,10 all channels, spw 3, channels 3 to 45.
              spw='0~2:2:6'; spw 0,1,2 with channels 2 through 6 in each.
              NB: Multiple channel ranges per spw are not supported in clearcal.
      intent -- Select observing intent
                default: ''  (no selection by intent)
                intent='*BANDPASS*'  (selects data labelled with
                                      BANDPASS intent)
      addmodel -- add MODEL_DATA along with CORRECTED_DATA if True; 
                  otherwise it will add/reset only CORRECTED_DATA, model visibilities
                  will then be evaluated when needed.
                  default: False  (model will not be added)


 
        """

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['vis'] = vis
        mytmp['field'] = field
        mytmp['spw'] = spw
        mytmp['intent'] = intent
        mytmp['addmodel'] = addmodel
	pathname='file://' + xmlpath( ) + '/'
	trec = casac.utils().torecord(pathname+'clearcal.xml')

        casalog.origin('clearcal')
        if trec.has_key('clearcal') and casac.utils().verify(mytmp, trec['clearcal']) :
	    result = task_clearcal.clearcal(vis, field, spw, intent, addmodel)

	else :
	  result = False
        return result
