#
# This file was generated using xslt from its XML file
#
# Copyright 2009, Associated Universities Inc., Washington DC
#
import sys
import os
from  casac import *
import string
from taskinit import casalog
from taskinit import xmlpath
#from taskmanager import tm
import task_caltabconvert
def caltabconvert(caltabold='', vis='', ptype='complex', caltabnew=''):

        """Convert old-style caltables into new-style caltables.
    This task converts old-style (up to CASA 3.3.0) caltables into new-style 
    (CASA 3.4.0 and later) caltables. It is provided as a convenience and 
    is strictly temporary. The information transferred should be enough 
    for most calibration purposes. BPOLY and GSPLINE versions are not 
    supported. Only simple bugs will be fixed. If there are other issues, 
    it is suggested that a new-style caltable be created directly.

    Arguments:

    caltabold -- Name of the old-style caltable.
    default: none
    example: caltabold='gronk.g0'

    vis -- Name of the visibility file (MS) associated with the old-style
        caltable.
    default: none
    example: vis='blurp.ms'

    ptype -- Type of data in the new-format caltable.
    default: "complex"; allowed values: "complex" or "float"
    example: ptype="complex"

    NB: The old-style caltables do not have this information, so it is
    imperative that users get it correct.  "complex" refers to caltables that
    have complex gains (e.g., produced by gaincal, bpcal, etc.).  "float" refers
    to caltables that real numbers such as delays (e.g., produced by gencal).

    caltabnew -- Name of the new-style caltable.
    default: "" --> the suffix ".new" is appended to the name of the old-style
        caltable
    example: caltabold='gronk_new.g0'
  
        """

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['caltabold'] = caltabold
        mytmp['vis'] = vis
        mytmp['ptype'] = ptype
        mytmp['caltabnew'] = caltabnew
	pathname='file://' + xmlpath( ) + '/'
	trec = casac.utils().torecord(pathname+'caltabconvert.xml')

        casalog.origin('caltabconvert')
        if trec.has_key('caltabconvert') and casac.utils().verify(mytmp, trec['caltabconvert']) :
	    result = task_caltabconvert.caltabconvert(caltabold, vis, ptype, caltabnew)

	else :
	  result = False
        return result
