#
# This file was generated using xslt from its XML file
#
# Copyright 2009, Associated Universities Inc., Washington DC
#
import sys
import os
from  casac import *
import string
from taskinit import casalog
from taskinit import xmlpath
#from taskmanager import tm
import task_calstat
def calstat(caltable='', axis='amplitude', datacolumn='gain', useflags=True):

        """Displays statistical information on a calibration table
        This task returns statistical information about a column in a calibration table.

        The following values are computed: mean value, sum of values, sum of squared values,
        median, median absolute deviation, quartile, minimum, maximum,
        variance, standard deviation, root mean square.

        Keyword arguments:

        caltable -- Name of input calibration table
                  default: '', example: vis='ggtau.1mm.amp.gcal'

        axis -- Which data to analyze. The possible values are 'amp', 'amplitude', 'phase',
                'real', 'imag', 'imaginary'. Also, the name of any real valued MS column can be 
                given, e.g. TIME, POLY_COEFF_AMP, REF_ANT, ANTENNA1, FLAG, ...

                default: 'amplitude'
                axis='gain'

                The phase of a complex number is in radians in the range [-pi; pi[.


        datacolumn -- Which data column to use if axis is 'amp', 'amplitude',
                      'phase', 'real', 'imag' or 'imaginary'.
                default: 'gain'
                datacolumn='gain'

        useflags -- Take MS flags into account (not implemented, this parameter 
                    has no effect!)
                default: False
                useflag=False
                useflag=True
        If useflags=False, flagged values are included in the statistics.
        If useflags=True, any flagged values are not used in the statistics.

        """

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['caltable'] = caltable
        mytmp['axis'] = axis
        mytmp['datacolumn'] = datacolumn
        mytmp['useflags'] = useflags
	pathname='file://' + xmlpath( ) + '/'
	trec = casac.utils().torecord(pathname+'calstat.xml')

        casalog.origin('calstat')
        if trec.has_key('calstat') and casac.utils().verify(mytmp, trec['calstat']) :
	    result = task_calstat.calstat(caltable, axis, datacolumn, useflags)

	else :
	  result = False
        return result
