#
# This file was generated using xslt from its XML file
#
# Copyright 2009, Associated Universities Inc., Washington DC
#
import sys
import os
from  casac import *
import string
from taskinit import casalog
from taskinit import xmlpath
#from taskmanager import tm
import task_browsetable
def browsetable(tablename='', mightedit=False, sortlist='', taql='', skipcols=''):

        """Browse a table (MS, calibration table, image)
    This task brings up a browser that can open and display any CASA table.
    The tablename can be specified at startup, or any table can be loaded after
    the browser comes up.
            
    Parameters:
    tablename -- Name of table file on disk (vis, calibration table, image)
                 default: none; example: tablename='ngc5921.ms'
    mightedit -- If True disable the filtering options (below) and allow
                 editing the table.  Warning: the GUI appears to ignore
                 whether the table tool is opened read-only - just be
                 aware that you should not edit filtered tables unless
                 you know what you are doing.
    sortlist  -- List of columns to sort by.
                 default: [] (none)
    taql      -- TaQL query string for prefiltering the table.
                 default: "" (none); example: taql="ANTENNA2 < 6"
    skipcols  -- Columns to NOT display.
                 default: [] (none); example: skipcols='feed1, feed2'    
            
    
    Some comments on using browsetable (see cookbook also):
    
     Most often you will browse a measurement set.  Either specify the vis name
     as the tablename, or when the browser comes up,
    
            click on <file> (upper left), then click on <open table>
    
     If you want to look at sub-tables, use the tab table keywords along the
     left side to bring up a panel with the sub-tables listed (Fig 3.8), then
     choose (left-click) a table and View.
    
     Note that one useful feature is that you can Edit any table and its
     contents. Use the Edit tab (to the right of the file tab).  Be careful
     with this, and make a backup copy of the table before editing!
    
     Use the Close Tables and Exit option from the Files menu to quit the
     casabrowser.
    
     To get a plot of two table values, click on tools, then click on plot 2D.
     For example, to get a u-v plot, in the Plotter Option Gui,
          set Rows:  0   to  <Large Number>
          X Axis:  UVW      Slice  (set 0)
          Y Axis:  UVW      Slice  (set 1)
          click 'Clear and Plot' on right.
    
     For visibility plots
          X Axis:  TIME
          Y Axis:  DATA     Slice Amplitude
          click 'Clear and Plot' on right.
       
       

        """

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['tablename'] = tablename
        mytmp['mightedit'] = mightedit
        mytmp['sortlist'] = sortlist
        mytmp['taql'] = taql
        mytmp['skipcols'] = skipcols
	pathname='file://' + xmlpath( ) + '/'
	trec = casac.utils().torecord(pathname+'browsetable.xml')

        casalog.origin('browsetable')
        if trec.has_key('browsetable') and casac.utils().verify(mytmp, trec['browsetable']) :
	    result = task_browsetable.browsetable(tablename, mightedit, sortlist, taql, skipcols)

	else :
	  result = False
        return result
