#
# This file was generated using xslt from its XML file
#
# Copyright 2014, Associated Universities Inc., Washington DC
#
import sys
import os
#from casac import *
import casac
import string
import time
import inspect
import gc
import numpy
from casa_stack_manip import stack_frame_find
from odict import odict
from types import * 
from task_boxit import boxit
class boxit_cli_:
    __name__ = "boxit"
    rkey = None
    i_am_a_casapy_task = None
    # The existence of the i_am_a_casapy_task attribute allows help()
    # (and other) to treat casapy tasks as a special case.

    def __init__(self) :
       self.__bases__ = (boxit_cli_,)
       self.__doc__ = self.__call__.__doc__

       self.parameters={'imagename':None, 'regionfile':None, 'threshold':None, 'maskname':None, 'chanrange':None, 'polrange':None, 'minsize':None, 'diag':None, 'boxstretch':None, 'overwrite':None, }


    def result(self, key=None):
	    #### and add any that have completed...
	    return None


    def __call__(self, imagename=None, regionfile=None, threshold=None, maskname=None, chanrange=None, polrange=None, minsize=None, diag=None, boxstretch=None, overwrite=None, ):

        """Box regions in image above given threshold value.

	Detailed Description: 
Returns a list of boxes, one for each contiguous set of pixels
  above the threshold value.  If given "regionfile", outputs boxes in
  regionfile+'.rgn'
	Arguments :
		imagename:	Name of image to threshold
		   Default Value: 

		regionfile:	Output region file
		   Default Value: 

		threshold:	Threshold value.  Must include units.
		   Default Value: 0.0

		maskname:	Output mask name (optional).
		   Default Value: 

		chanrange:	Range of channel ids
		   Default Value: 

		polrange:	Range of polarization ids
		   Default Value: 

		minsize:	Minimum number of pixels for a boxable island
		   Default Value: 2

		diag:	Count diagonal connections?
		   Default Value: False

		boxstretch:	Increase box sizes by this many pixels beyond thresholded pixels.
		   Default Value: 1
		   Allowed Values:
				-1
				6

		overwrite:	Overwrite existing region file?
		   Default Value: False

	Returns: void

	Example :



       This tool finds all 2-dimensional (RA/dec) regions in the given
       4D (only!) image which are contiguous sets of pixels (islands) above the given ]
       threshold.  It creates a box for each island, a rectangular "cutout".
       The boxes are stored as regions in the output regionfile.  Works on
       multi-plane images, but only boxes 2-D regions in each plane.
       (Doesn't create cubes/3D boxes.)
       
       NOTE: THIS TASK WILL NOT WORK ON IMAGES THAT DO NOT HAVE 4 DIMENSIONS WHICH INCLUDE
       A DIRECTION COORDINATE, A SPECTRAL COORDINATE, AND A STOKES COORDINATE. If your image
       has, eg just a direction coordinate, you can add the required axes using ia.adddegaxes()
       and remove them post-run with imsubimage with dropdeg=T.
 
       imagename -- Name of input images:
               default: none; example: imagename='myimage.image'
       regionfile -- Name of output region file (adds extension .rgn).
               default: none; if not given uses imagename+'.rgn'
       threshold -- value (with units) to use for island threshold.
               default: 0.0.
       maskname -- Optional output mask name.
               default: '' (do not write mask image)
       chanrange -- Range of channel ids
               default: '' (find boxes for all channels)
               example: '5~7' (find boxes for channel 5,6,7
       polrange -- Range of polarization ids
               default: '' (find boxes for all polarizations)
               example: '0~1' (find boxes for polarization 0,1
       minsize -- minimum size of island to get a box (in number of pixels)
               default: 2
       diag -- count diagonal connections as same island or not
               default: False
       boxstretch -- number of pixels to increase outward size of each box; can
               range from -1 to 5.
               default: 1
       overwrite -- Overwrite existing region file and/or mask?
               default: False.  If False, gives warning if file exists.

  
        """
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
	#casac = self.__globals__['casac']
	casalog = self.__globals__['casalog']
	casa = self.__globals__['casa']
	#casalog = casac.casac.logsink()
        self.__globals__['__last_task'] = 'boxit'
        self.__globals__['taskname'] = 'boxit'
        ###
        self.__globals__['update_params'](func=self.__globals__['taskname'],printtext=False,ipython_globals=self.__globals__)
        ###
        ###
        #Handle globals or user over-ride of arguments
        #
        if type(self.__call__.func_defaults) is NoneType:
            function_signature_defaults={}
	else:
	    function_signature_defaults=dict(zip(self.__call__.func_code.co_varnames[1:],self.__call__.func_defaults))
	useLocalDefaults = False

        for item in function_signature_defaults.iteritems():
                key,val = item
                keyVal = eval(key)
                if (keyVal == None):
                        #user hasn't set it - use global/default
                        pass
                else:
                        #user has set it - use over-ride
			if (key != 'self') :
			   useLocalDefaults = True

	myparams = {}
	if useLocalDefaults :
	   for item in function_signature_defaults.iteritems():
	       key,val = item
	       keyVal = eval(key)
	       exec('myparams[key] = keyVal')
	       self.parameters[key] = keyVal
	       if (keyVal == None):
	           exec('myparams[key] = '+ key + ' = self.itsdefault(key)')
		   keyVal = eval(key)
		   if(type(keyVal) == dict) :
                      if len(keyVal) > 0 :
		         exec('myparams[key] = ' + key + ' = keyVal[len(keyVal)-1][\'value\']')
		      else :
		         exec('myparams[key] = ' + key + ' = {}')
	 
        else :
            print ''

            myparams['imagename'] = imagename = self.parameters['imagename']
            myparams['regionfile'] = regionfile = self.parameters['regionfile']
            myparams['threshold'] = threshold = self.parameters['threshold']
            myparams['maskname'] = maskname = self.parameters['maskname']
            myparams['chanrange'] = chanrange = self.parameters['chanrange']
            myparams['polrange'] = polrange = self.parameters['polrange']
            myparams['minsize'] = minsize = self.parameters['minsize']
            myparams['diag'] = diag = self.parameters['diag']
            myparams['boxstretch'] = boxstretch = self.parameters['boxstretch']
            myparams['overwrite'] = overwrite = self.parameters['overwrite']


	result = None

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['imagename'] = imagename
        mytmp['regionfile'] = regionfile
        if type(threshold) == str :
           mytmp['threshold'] = casac.casac.qa.quantity(threshold)
        else :
           mytmp['threshold'] = threshold
        mytmp['maskname'] = maskname
        mytmp['chanrange'] = chanrange
        mytmp['polrange'] = polrange
        mytmp['minsize'] = minsize
        mytmp['diag'] = diag
        mytmp['boxstretch'] = boxstretch
        mytmp['overwrite'] = overwrite
	pathname='file://' + casa['dirs']['xml'] + '/'
	trec = casac.casac.utils().torecord(pathname+'boxit.xml')

        casalog.origin('boxit')
	try :
          #if not trec.has_key('boxit') or not casac.casac.utils().verify(mytmp, trec['boxit']) :
	    #return False

          casac.casac.utils().verify(mytmp, trec['boxit'], True)
          scriptstr=['']
          saveinputs = self.__globals__['saveinputs']
          if type(self.__call__.func_defaults) is NoneType:
              saveinputs=''
          else:
              saveinputs('boxit', 'boxit.last', myparams, self.__globals__,scriptstr=scriptstr)
          tname = 'boxit'
          spaces = ' '*(18-len(tname))
          casalog.post('\n##########################################'+
                       '\n##### Begin Task: ' + tname + spaces + ' #####')
          if type(self.__call__.func_defaults) is NoneType:
              casalog.post(scriptstr[0]+'\n', 'INFO')
          else :
              casalog.post(scriptstr[1][1:]+'\n', 'INFO')
          result = boxit(imagename, regionfile, threshold, maskname, chanrange, polrange, minsize, diag, boxstretch, overwrite)
          casalog.post('##### End Task: ' + tname + '  ' + spaces + ' #####'+
                       '\n##########################################')

	except Exception, instance:
          if(self.__globals__.has_key('__rethrow_casa_exceptions') and self.__globals__['__rethrow_casa_exceptions']) :
             raise
          else :
             #print '**** Error **** ',instance
	     tname = 'boxit'
             casalog.post('An error occurred running task '+tname+'.', 'ERROR')
             pass

        gc.collect()
        return result
#
#
#
    def paramgui(self, useGlobals=True, ipython_globals=None):
        """
        Opens a parameter GUI for this task.  If useGlobals is true, then any relevant global parameter settings are used.
        """
        import paramgui
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )

        if useGlobals:
	    if ipython_globals == None:
                myf=self.__globals__
            else:
                myf=ipython_globals

            paramgui.setGlobals(myf)
        else:
            paramgui.setGlobals({})

        paramgui.runTask('boxit', myf['_ip'])
        paramgui.setGlobals({})

#
#
#
    def defaults(self, param=None, ipython_globals=None, paramvalue=None, subparam=None):
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
        if ipython_globals == None:
            myf=self.__globals__
        else:
            myf=ipython_globals

        a = odict()
        a['imagename']  = ''
        a['regionfile']  = ''
        a['threshold']  = '0.0mJy'
        a['maskname']  = ''
        a['chanrange']  = ''
        a['polrange']  = ''
        a['minsize']  = 2
        a['diag']  = False
        a['boxstretch']  = 1
        a['overwrite']  = False


### This function sets the default values but also will return the list of
### parameters or the default value of a given parameter
        if(param == None):
                myf['__set_default_parameters'](a)
        elif(param == 'paramkeys'):
                return a.keys()
        else:
            if(paramvalue==None and subparam==None):
               if(a.has_key(param)):
                  return a[param]
               else:
                  return self.itsdefault(param)
            else:
               retval=a[param]
               if(type(a[param])==dict):
                  for k in range(len(a[param])):
                     valornotval='value'
                     if(a[param][k].has_key('notvalue')):
                        valornotval='notvalue'
                     if((a[param][k][valornotval])==paramvalue):
                        retval=a[param][k].copy()
                        retval.pop(valornotval)
                        if(subparam != None):
                           if(retval.has_key(subparam)):
                              retval=retval[subparam]
                           else:
                              retval=self.itsdefault(subparam)
		     else:
                        retval=self.itsdefault(subparam)
               return retval


#
#
    def check_params(self, param=None, value=None, ipython_globals=None):
      if ipython_globals == None:
          myf=self.__globals__
      else:
          myf=ipython_globals
#      print 'param:', param, 'value:', value
      try :
         if str(type(value)) != "<type 'instance'>" :
            value0 = value
            value = myf['cu'].expandparam(param, value)
            matchtype = False
            if(type(value) == numpy.ndarray):
               if(type(value) == type(value0)):
                  myf[param] = value.tolist()
               else:
                  #print 'value:', value, 'value0:', value0
                  #print 'type(value):', type(value), 'type(value0):', type(value0)
                  myf[param] = value0
                  if type(value0) != list :
                     matchtype = True
            else :
               myf[param] = value
            value = myf['cu'].verifyparam({param:value})
            if matchtype:
               value = False
      except Exception, instance:
         #ignore the exception and just return it unchecked
         myf[param] = value
      return value
#
#
    def description(self, key='boxit', subkey=None):
        desc={'boxit': 'Box regions in image above given threshold value.',
               'imagename': 'Name of image to threshold',
               'regionfile': 'Output region file',
               'threshold': 'Threshold value.  Must include units.',
               'maskname': 'Output mask name (optional).',
               'chanrange': 'Range of channel ids',
               'polrange': 'Range of polarization ids',
               'minsize': 'Minimum number of pixels for a boxable island',
               'diag': 'Count diagonal connections?',
               'boxstretch': 'Increase box sizes by this many pixels beyond thresholded pixels.',
               'overwrite': 'Overwrite existing region file?',

              }

        if(desc.has_key(key)) :
           return desc[key]

    def itsdefault(self, paramname) :
        a = {}
        a['imagename']  = ''
        a['regionfile']  = ''
        a['threshold']  = '0.0mJy'
        a['maskname']  = ''
        a['chanrange']  = ''
        a['polrange']  = ''
        a['minsize']  = 2
        a['diag']  = False
        a['boxstretch']  = 1
        a['overwrite']  = False

        #a = sys._getframe(len(inspect.stack())-1).f_globals

        if a.has_key(paramname) :
	      return a[paramname]
boxit_cli = boxit_cli_()
