#
# This file was generated using xslt from its XML file
#
# Copyright 2009, Associated Universities Inc., Washington DC
#
import sys
import os
from  casac import *
import string
from taskinit import casalog
from taskinit import xmlpath
#from taskmanager import tm
import task_boxit
def boxit(imagename='', regionfile='', threshold='0.0mJy', maskname='', chanrange='', polrange='', minsize=2, diag=False, boxstretch=1, overwrite=False):

        """Box regions in image above given threshold value.


       This tool finds all 2-dimensional (RA/dec) regions in the given
       4D (only!) image which are contiguous sets of pixels (islands) above the given ]
       threshold.  It creates a box for each island, a rectangular "cutout".
       The boxes are stored as regions in the output regionfile.  Works on
       multi-plane images, but only boxes 2-D regions in each plane.
       (Doesn't create cubes/3D boxes.)
       
       NOTE: THIS TASK WILL NOT WORK ON IMAGES THAT DO NOT HAVE 4 DIMENSIONS WHICH INCLUDE
       A DIRECTION COORDINATE, A SPECTRAL COORDINATE, AND A STOKES COORDINATE. If your image
       has, eg just a direction coordinate, you can add the required axes using ia.adddegaxes()
       and remove them post-run with imsubimage with dropdeg=T.
 
       imagename -- Name of input images:
               default: none; example: imagename='myimage.image'
       regionfile -- Name of output region file (adds extension .rgn).
               default: none; if not given uses imagename+'.rgn'
       threshold -- value (with units) to use for island threshold.
               default: 0.0.
       maskname -- Optional output mask name.
               default: '' (do not write mask image)
       chanrange -- Range of channel ids
               default: '' (find boxes for all channels)
               example: '5~7' (find boxes for channel 5,6,7
       polrange -- Range of polarization ids
               default: '' (find boxes for all polarizations)
               example: '0~1' (find boxes for polarization 0,1
       minsize -- minimum size of island to get a box (in number of pixels)
               default: 2
       diag -- count diagonal connections as same island or not
               default: False
       boxstretch -- number of pixels to increase outward size of each box; can
               range from -1 to 5.
               default: 1
       overwrite -- Overwrite existing region file and/or mask?
               default: False.  If False, gives warning if file exists.

  
        """

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['imagename'] = imagename
        mytmp['regionfile'] = regionfile
        if type(threshold) == str :
           mytmp['threshold'] = casac.quanta().quantity(threshold)
        else :
           mytmp['threshold'] = threshold
        mytmp['maskname'] = maskname
        mytmp['chanrange'] = chanrange
        mytmp['polrange'] = polrange
        mytmp['minsize'] = minsize
        mytmp['diag'] = diag
        mytmp['boxstretch'] = boxstretch
        mytmp['overwrite'] = overwrite
	pathname='file://' + xmlpath( ) + '/'
	trec = casac.utils().torecord(pathname+'boxit.xml')

        casalog.origin('boxit')
        if trec.has_key('boxit') and casac.utils().verify(mytmp, trec['boxit']) :
	    result = task_boxit.boxit(imagename, regionfile, threshold, maskname, chanrange, polrange, minsize, diag, boxstretch, overwrite)

	else :
	  result = False
        return result
