#
# This file was generated using xslt from its XML file
#
# Copyright 2009, Associated Universities Inc., Washington DC
#
import sys
import os
from  casac import *
import string
from taskinit import casalog
from taskinit import xmlpath
#from taskmanager import tm
import task_bandpass
def bandpass(vis='', caltable='', field='', spw='', intent='', selectdata=True, timerange='', uvrange='', antenna='', scan='', observation='', msselect='', solint='inf', combine='scan', refant='', minblperant=4, minsnr=3.0, solnorm=False, bandtype='B', smodel=[], append=False, fillgaps=0, degamp=3, degphase=3, visnorm=False, maskcenter=0, maskedge=5, docallib=False, callib='', gaintable=[''], gainfield=[''], interp=[''], spwmap=[], parang=False):

        """Calculates a bandpass calibration solution

       Determines the amplitude and phase as a function of frequency for
       each spectral window containing more than one channel.  Strong sources
       (or many observations of moderately strong sources) are needed to obtain
       accurate bandpass functions.  The two solution choices are: Individual
       antenna/based channel solutions 'B'; and a polynomial fit over the channels
       'BPOLY'.  The 'B' solutions can determined at any specified time interval, and
       is recommended if each channel has good signal-to-noise.  Other, 'BPOLY' is
       recommended.

      Keyword arguments:
      vis -- Name of input visibility file
              default: none; example: vis='ngc5921.ms'
      caltable -- Name of output bandpass calibration table
              default: none; example: caltable='ngc5921.bcal'

      --- Data Selection (see help par.selectdata for more detailed information)

      field -- Select field using field id(s) or field name(s).
                 [run listobs to obtain the list id's or names]
              default: ''=all fields
              If field string is a non-negative integer, it is assumed a field index
                otherwise, it is assumed a field name
              field='0~2'; field ids 0,1,2
              field='0,4,5~7'; field ids 0,4,5,6,7
              field='3C286,3C295'; field named 3C286 adn 3C295
              field = '3,4C*'; field id 3, all names starting with 4C
      spw -- Select spectral window/channels
              default: ''=all spectral windows and channels
              spw='0~2,4'; spectral windows 0,1,2,4 (all channels)
              spw='<2';  spectral windows less than 2 (i.e. 0,1)
              spw='0:5~61'; spw 0, channels 5 to 61
              spw='0,10,3:3~45'; spw 0,10 all channels, spw 3, channels 3 to 45.
              spw='0~2:2:6'; spw 0,1,2 with channels 2 through 6 in each.
              spw='0:0~10;15~60'; spectral window 0 with channels 0-10,15-60
                        NOTE: ';' to separate channel selections
              spw='0:0~10,1:20~30,2:1;2;3'; spw 0, channels 0-10,
                       spw 1, channels 20-30, and spw 2, channels, 1,2 and 3
      intent -- Select observing intent
                default: ''  (no selection by intent)
                intent='*BANDPASS*'  (selects data labelled with
                                      BANDPASS intent)
      selectdata -- Other data selection parameters
              default: True
      timerange  -- Select data based on time range:
              default = '' (all); examples,
              timerange = 'YYYY/MM/DD/hh:mm:ss~YYYY/MM/DD/hh:mm:ss'
              Note: if YYYY/MM/DD is missing dat defaults to first day in data set
              timerange='09:14:0~09:54:0' picks 40 min on first day
              timerange= '25:00:00~27:30:00' picks 1 hr to 3 hr 30min on next day
              timerange='09:44:00' data within one integration of time
              timerange='>10:24:00' data after this time
      uvrange -- Select data within uvrange (default meters)
              default: '' (all); example:
              uvrange='0~1000klambda'; uvrange from 0-1000 kilo-lambda
              uvrange='>4klambda';uvranges greater than 4 kilo-lambda
      antenna -- Select data based on antenna/baseline
              default: '' (all)
              If antenna string is a non-negative integer, it is assumed an antenna index
                otherwise, it is assumed as an antenna name
              antenna='5&6'; baseline between antenna index 5 and index 6.
              antenna='VA05&VA06'; baseline between VLA antenna 5 and 6.
              antenna='5&6;7&8'; baseline 5-6 and 7-8
              antenna='5'; all baselines with antenna 5
              antenna='5,6,10'; all baselines with antennas 5, 6 and 10
       scan -- Select data based on scan number - New, under developement
               default: '' (all); example: scan='>3'
       observation -- Observation ID(s).
                      default: '' = all
                      example: '0~2,4'
       msselect -- Optional complex data selection (ignore for now)

       --- Solution parameters
       solint --  Solution interval in time (units optional), and (optionally)
                   in frequency.  Frequency pre-averaging can be
                   specified after a comma in units of channels or Hz.
                   If nothing is specified for frequency, no freq pre-averaging 
                   will be done.
       default: 'inf' (~infinite, up to boundaries controlled by combine,
                       with no pre-averaging in frequency)
              Options for time: 'inf' (~infinite), 'int' (per integration), any float
                       or integer value with or without units
              Options for freq: an integer with 'ch' suffix will enforce
                                pre-averaging by the specified number
                                of channels.
                                a numeric value suffixed with frequency
                                units (e.g., 'Hz','kHz','MHz') will enforce
                                pre-averaging by an integral number of 
                                channels amounting to no more than the
                                specified bandwidth
              examples: solint='1min'; solint='60s', solint=60 --> 1 minute
                        solint='0s'; solint=0; solint='int' --> per integration
                        solint='-1s'; solint='inf' --> ~infinite, up to boundaries
                        enforced by combine
                        solint='inf,8Mhz' --> ~infinite in time, with 
                                                  8MHz pre-average in freq
                        solint='int,32ch' --> per-integration in time,
                                                  with 32-channel pre-average
                                                  in freq
       combine -- Data axes to combine for solving
              default: 'scan' --> solutions will break at obs, field, and spw
                      boundaries but may extend over multiple scans
                      (per obs, field and spw) up to solint.
              Options: '','obs','scan','spw',field', or any comma-separated 
                       combination in a single string
              example: combine='scan,spw'  --> extend solutions over scan boundaries
                       (up to the solint), and combine spws for solving
       refant -- Reference antenna name(s); a prioritized list may be specified
               default: '' (no reference antenna)
                example: refant='13' (antenna with index 13)
                         refant='VA04' (VLA antenna #4)
                         refant='EA02,EA23,EA13' (EVLA antenna EA02, use
                                EA23 and EA13 as alternates if/when EA02
                                drops out)
               Use 'go listobs' for antenna listing
       minblperant -- Minimum number of baselines required per antenna for each solve
                    Antennas with fewer baaselines are excluded from solutions. Amplitude
                    solutions with fewer than 4 baselines, and phase solutions with fewer 
                    than 3 baselines are only trivially constrained, and are no better
                    than baseline-based solutions.
                    default: 4
                    example: minblperant=10  => Antennas participating on 10 or more 
                             baselines are included in the solve
       minsnr -- Reject solutions below this SNR (only applies for bandtype = B)
               default: 3.0
       solnorm -- Normalize bandpass amplitudes and phase for each
               spw, pol, ant, and timestamp
               default: False (no normalization)
       bandtype -- Type of bandpass solution (B or BPOLY)
               default: 'B'; example: bandtype='BPOLY'
               'B' does a channel by channel solution for each
                   specified spw.
               'BPOLY' is somewhat experimental. It will fit an
                   nth order polynomial for the amplitude and phase
                   as a function of frequency. Only one fit is made
                   for all specified spw, and edge channels should be
                   omitted.
                Use taskname=plotcal in order to compare the results from
                   B and BPOLY.
       fillgaps -- Fill flagged solution channels by interpolation
               default: 0 (don't interpolate)
               example: fillgaps=3 (interpolate gaps 3 channels wide and narrower)
       degamp -- Polynomial degree for BPOLY amplitude solution
               default: 3; example: degamp=2
       degphase -- Polynomial degree for BPOLY phase solution
               default: 3; example: degphase=2
       visnorm -- Normalize data prior to BPOLY solution
               default: False; example: visnorm=True
       maskcenter -- Number of channels to avoid in center of each band
               default: 0; example: maskcenter=5 (BPOLY only)
       maskedge -- Fraction of channels to avoid at each band edge (in %)
               default: 5; example: maskedge=3 (BPOLY only)
       append -- Append solutions to the (existing) table.  Appended solutions
                  must be derived from the same MS as the existing
                  caltable, and solution spws must have the same
                  meta-info (according to spw selection and solint)
                  or be non-overlapping.
               default: False; overwrite existing table or make new table

      --- Other calibrations to apply on the fly before determining bandpass solution

      docallib -- Control means of specifying the caltables:
               default: False ==> Use gaintable,gainfield,interp,spwmap,calwt
                        If True, specify a file containing cal library in callib
      callib -- If docallib=True, specify a file containing cal
                  library directives

      gaintable -- Gain calibration table(s) to apply 
               default: '' (none);
               examples: gaintable='ngc5921.gcal'
                         gaintable=['ngc5921.ampcal','ngc5921.phcal']
      gainfield -- Select a subset of calibrators from gaintable(s)
               default:'' ==> all sources in table;
               'nearest' ==> nearest (on sky) available field in table
               otherwise, same syntax as field
               example: gainfield='0~3'
                        gainfield=['0~3','4~6']
      interp -- Interpolation type (in time[,freq]) to use for each gaintable.
                When frequency interpolation is relevant (B, Df, Xf),
                separate time-dependent and freq-dependent interp
                types with a comma (freq _after_ the comma).                
                Specifications for frequency are ignored when the
                calibration table has no channel-dependence.
                Time-dependent interp options ending in 'PD' enable a
                "phase delay" correction per spw for non-channel-dependent
                calibration types.
                For multi-obsId datasets, 'perobs' can be appended to
                the time-dependent interpolation specification to
                enforce obsId boundaries when interpolating in time.
                default: '' --> 'linear,linear' for all gaintable(s)
                example: interp='nearest'   (in time, freq-dep will be
                                             linear, if relevant)
                         interp='linear,cubic'  (linear in time, cubic
                                                 in freq)
                         interp='linearperobs,spline' (linear in time
                                                       per obsId,
                                                       spline in freq)
                         interp=',spline'  (spline in freq; linear in
                                            time by default)
                         interp=['nearest,spline','linear']  (for multiple gaintables)
                Options: Time: 'nearest', 'linear'
                         Freq: 'nearest', 'linear', 'cubic', 'spline'
      spwmap -- Spectral windows combinations to form for gaintable(s)
                default: [] (apply solutions from each spw to that spw only)
                Example:  spwmap=[0,0,1,1] means apply the caltable solutions
                          from spw = 0 to the spw 0,1 and spw 1 to spw 2,3.
                          spwmap=[[0,0,1,1],[0,1,0,1]]
      parang -- If True, apply the parallactic angle correction (required
               for polarization calibration)
               default: False


        """
        if type(smodel)==float: smodel=[smodel]
        if type(gaintable)==str: gaintable=[gaintable]
        if type(gainfield)==str: gainfield=[gainfield]
        if type(interp)==str: interp=[interp]
        if type(spwmap)==int: spwmap=[spwmap]

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['vis'] = vis
        mytmp['caltable'] = caltable
        mytmp['field'] = field
        mytmp['spw'] = spw
        mytmp['intent'] = intent
        mytmp['selectdata'] = selectdata
        mytmp['timerange'] = timerange
        mytmp['uvrange'] = uvrange
        mytmp['antenna'] = antenna
        mytmp['scan'] = scan
        mytmp['observation'] = observation
        mytmp['msselect'] = msselect
        mytmp['solint'] = solint
        mytmp['combine'] = combine
        mytmp['refant'] = refant
        mytmp['minblperant'] = minblperant
        mytmp['minsnr'] = minsnr
        mytmp['solnorm'] = solnorm
        mytmp['bandtype'] = bandtype
        mytmp['smodel'] = smodel
        mytmp['append'] = append
        mytmp['fillgaps'] = fillgaps
        mytmp['degamp'] = degamp
        mytmp['degphase'] = degphase
        mytmp['visnorm'] = visnorm
        mytmp['maskcenter'] = maskcenter
        mytmp['maskedge'] = maskedge
        mytmp['docallib'] = docallib
        mytmp['callib'] = callib
        mytmp['gaintable'] = gaintable
        mytmp['gainfield'] = gainfield
        mytmp['interp'] = interp
        mytmp['spwmap'] = spwmap
        mytmp['parang'] = parang
	pathname='file://' + xmlpath( ) + '/'
	trec = casac.utils().torecord(pathname+'bandpass.xml')

        casalog.origin('bandpass')
        if trec.has_key('bandpass') and casac.utils().verify(mytmp, trec['bandpass']) :
	    result = task_bandpass.bandpass(vis, caltable, field, spw, intent, selectdata, timerange, uvrange, antenna, scan, observation, msselect, solint, combine, refant, minblperant, minsnr, solnorm, bandtype, smodel, append, fillgaps, degamp, degphase, visnorm, maskcenter, maskedge, docallib, callib, gaintable, gainfield, interp, spwmap, parang)

	else :
	  result = False
        return result
