#
# This file was generated using xslt from its XML file
#
# Copyright 2008, Associated Universities Inc., Washington DC
#
import sys
import os
from casac import *
import string
import time
from casa_stack_manip import stack_frame_find
import gc
import numpy
from odict import odict
from task_autoclean import autoclean
from taskinit import casalog
from taskinit import xmlpath
class autoclean_pg_:
    __name__ = "autoclean"

    def __init__(self) :
       self.__bases__ = (autoclean_pg_,)
       self.__doc__ = self.__call__.__doc__


    def __call__(self, vis=None,imagename=None,field=None,spw=None,selectdata=None,timerange=None,uvrange=None,antenna=None,scan=None,mode=None,nchan=None,start=None,width=None,interpolation=None,doconcat=None,psfmode=None,imagermode=None,cyclefactor=None,cyclespeedup=None,imsize=None,cell=None,phasecenter=None,restfreq=None,stokes=None,weighting=None,robust=None,noise=None,npixels=None,interactive=None,mask=None,modelimage=None,uvtaper=None,outertaper=None,innertaper=None,niter=None,npercycle=None,npercycle_speedup=None,gain=None,pbcor=None,minpb=None,clean_threshold=None,Nrms=None,eps_maxres=None,useabsresid=None,allow_maxres_inc=None,island_rms=None,diag=None,peak_rms=None,gain_threshold=None,Npeak=None,shape=None,boxstretch=None,irregsize=None,):

        myf=stack_frame_find( )
        myf['__last_task'] = 'autoclean'
        myf['taskname'] = 'autoclean'
        ###
        myf['update_params'](func=myf['taskname'],printtext=False)
        ###
        ###
        #Handle globals or user over-ride of arguments
        #
	function_signature_defaults=dict(zip(self.__call__.func_code.co_varnames,self.__call__.func_defaults))
	useLocalDefaults = False

        for item in function_signature_defaults.iteritems():
                key,val = item
                keyVal = eval(key)
                if (keyVal == None):
                        #user hasn't set it - use global/default
                        pass
                else:
                        #user has set it - use over-ride
			if (key != 'self') :
			   useLocalDefaults = True
                        #myf[key]=keyVal

	myparams = {}
	if useLocalDefaults :
	   for item in function_signature_defaults.iteritems():
	       key,val = item
	       keyVal = eval(key)
	       exec('myparams[key] = keyVal')
	       if (keyVal == None):
	           exec('myparams[key] = '+ key + ' = self.itsdefault(key)')
		   keyVal = eval(key)
		   if(type(keyVal) == dict) :
                      if len(keyVal) > 0 :
		         exec('myparams[key] = ' + key + ' = keyVal[len(keyVal)-1][\'value\']')
		      else :
		         exec('myparams[key] = ' + key + ' = {}')

	else :
            uselessvariable = None 
            myparams['vis'] = vis = myf['vis']
            myparams['imagename'] = imagename = myf['imagename']
            myparams['field'] = field = myf['field']
            myparams['spw'] = spw = myf['spw']
            myparams['selectdata'] = selectdata = myf['selectdata']
            myparams['timerange'] = timerange = myf['timerange']
            myparams['uvrange'] = uvrange = myf['uvrange']
            myparams['antenna'] = antenna = myf['antenna']
            myparams['scan'] = scan = myf['scan']
            myparams['mode'] = mode = myf['mode']
            myparams['nchan'] = nchan = myf['nchan']
            myparams['start'] = start = myf['start']
            myparams['width'] = width = myf['width']
            myparams['interpolation'] = interpolation = myf['interpolation']
            myparams['doconcat'] = doconcat = myf['doconcat']
            myparams['psfmode'] = psfmode = myf['psfmode']
            myparams['imagermode'] = imagermode = myf['imagermode']
            myparams['cyclefactor'] = cyclefactor = myf['cyclefactor']
            myparams['cyclespeedup'] = cyclespeedup = myf['cyclespeedup']
            myparams['imsize'] = imsize = myf['imsize']
            myparams['cell'] = cell = myf['cell']
            myparams['phasecenter'] = phasecenter = myf['phasecenter']
            myparams['restfreq'] = restfreq = myf['restfreq']
            myparams['stokes'] = stokes = myf['stokes']
            myparams['weighting'] = weighting = myf['weighting']
            myparams['robust'] = robust = myf['robust']
            myparams['noise'] = noise = myf['noise']
            myparams['npixels'] = npixels = myf['npixels']
            myparams['interactive'] = interactive = myf['interactive']
            myparams['mask'] = mask = myf['mask']
            myparams['modelimage'] = modelimage = myf['modelimage']
            myparams['uvtaper'] = uvtaper = myf['uvtaper']
            myparams['outertaper'] = outertaper = myf['outertaper']
            myparams['innertaper'] = innertaper = myf['innertaper']
            myparams['niter'] = niter = myf['niter']
            myparams['npercycle'] = npercycle = myf['npercycle']
            myparams['npercycle_speedup'] = npercycle_speedup = myf['npercycle_speedup']
            myparams['gain'] = gain = myf['gain']
            myparams['pbcor'] = pbcor = myf['pbcor']
            myparams['minpb'] = minpb = myf['minpb']
            myparams['clean_threshold'] = clean_threshold = myf['clean_threshold']
            myparams['Nrms'] = Nrms = myf['Nrms']
            myparams['eps_maxres'] = eps_maxres = myf['eps_maxres']
            myparams['useabsresid'] = useabsresid = myf['useabsresid']
            myparams['allow_maxres_inc'] = allow_maxres_inc = myf['allow_maxres_inc']
            myparams['island_rms'] = island_rms = myf['island_rms']
            myparams['diag'] = diag = myf['diag']
            myparams['peak_rms'] = peak_rms = myf['peak_rms']
            myparams['gain_threshold'] = gain_threshold = myf['gain_threshold']
            myparams['Npeak'] = Npeak = myf['Npeak']
            myparams['shape'] = shape = myf['shape']
            myparams['boxstretch'] = boxstretch = myf['boxstretch']
            myparams['irregsize'] = irregsize = myf['irregsize']

        if type(imsize)==int: imsize=[imsize]
        if type(cell)==float: cell=[cell]
        if type(outertaper)==str: outertaper=[outertaper]
        if type(innertaper)==str: innertaper=[innertaper]

	result = None

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['vis'] = vis
        mytmp['imagename'] = imagename
        mytmp['field'] = field
        mytmp['spw'] = spw
        mytmp['selectdata'] = selectdata
        mytmp['timerange'] = timerange
        mytmp['uvrange'] = uvrange
        mytmp['antenna'] = antenna
        mytmp['scan'] = scan
        mytmp['mode'] = mode
        mytmp['nchan'] = nchan
        mytmp['start'] = start
        mytmp['width'] = width
        mytmp['interpolation'] = interpolation
        mytmp['doconcat'] = doconcat
        mytmp['psfmode'] = psfmode
        mytmp['imagermode'] = imagermode
        mytmp['cyclefactor'] = cyclefactor
        mytmp['cyclespeedup'] = cyclespeedup
        mytmp['imsize'] = imsize
        if type(cell) == str :
           mytmp['cell'] = casac.quanta().quantity(cell)
        else :
           mytmp['cell'] = cell
        mytmp['phasecenter'] = phasecenter
        mytmp['restfreq'] = restfreq
        mytmp['stokes'] = stokes
        mytmp['weighting'] = weighting
        mytmp['robust'] = robust
        mytmp['noise'] = noise
        mytmp['npixels'] = npixels
        mytmp['interactive'] = interactive
        mytmp['mask'] = mask
        mytmp['modelimage'] = modelimage
        mytmp['uvtaper'] = uvtaper
        mytmp['outertaper'] = outertaper
        mytmp['innertaper'] = innertaper
        mytmp['niter'] = niter
        mytmp['npercycle'] = npercycle
        mytmp['npercycle_speedup'] = npercycle_speedup
        mytmp['gain'] = gain
        mytmp['pbcor'] = pbcor
        mytmp['minpb'] = minpb
        if type(clean_threshold) == str :
           mytmp['clean_threshold'] = casac.quanta().quantity(clean_threshold)
        else :
           mytmp['clean_threshold'] = clean_threshold
        mytmp['Nrms'] = Nrms
        mytmp['eps_maxres'] = eps_maxres
        mytmp['useabsresid'] = useabsresid
        mytmp['allow_maxres_inc'] = allow_maxres_inc
        mytmp['island_rms'] = island_rms
        mytmp['diag'] = diag
        mytmp['peak_rms'] = peak_rms
        mytmp['gain_threshold'] = gain_threshold
        mytmp['Npeak'] = Npeak
        mytmp['shape'] = shape
        mytmp['boxstretch'] = boxstretch
        mytmp['irregsize'] = irregsize
	pathname='file://' + xmlpath( ) + '/'
	trec = casac.utils().torecord(pathname+'autoclean.xml')

        casalog.origin('autoclean')
        if not trec.has_key('autoclean') or not casac.utils().verify(mytmp, trec['autoclean']) :
	    return False


	try :
          casalog.post('')
          casalog.post('##########################################')
          casalog.post('##### Begin Task: autoclean           #####')
          casalog.post('')
          result = autoclean(vis, imagename, field, spw, selectdata, timerange, uvrange, antenna, scan, mode, nchan, start, width, interpolation, doconcat, psfmode, imagermode, cyclefactor, cyclespeedup, imsize, cell, phasecenter, restfreq, stokes, weighting, robust, noise, npixels, interactive, mask, modelimage, uvtaper, outertaper, innertaper, niter, npercycle, npercycle_speedup, gain, pbcor, minpb, clean_threshold, Nrms, eps_maxres, useabsresid, allow_maxres_inc, island_rms, diag, peak_rms, gain_threshold, Npeak, shape, boxstretch, irregsize)
          casalog.post('')
          casalog.post('##### End Task: autoclean           #####')
          casalog.post('##########################################')


# saveinputs for individule engine has no use
# saveinputs should alos be removed from casa_in_py.py
#
#
#          saveinputs = myf['saveinputs']
#          saveinputs('autoclean', 'autoclean.last', myparams)
#
#
	except Exception, instance:
	  if(myf.has_key('__rethrow_casa_exceptions') and myf['__rethrow_casa_exceptions']) :
	     raise
	  else:
	     tname = 'autoclean'
	     casalog.post('An error occurred running task %s: %s' % (tname,instance), 'ERROR')
	     pass

        gc.collect()
        return result
#
#
##
#    def paramgui(self, useGlobals=True):
#        """
#        Opens a parameter GUI for this task.  If useGlobals is true, then any relevant global parameter settings are used.
#        """
#        import paramgui
#
#        myf = stack_frame_find( )
#
#        if useGlobals:
#            paramgui.setGlobals(myf)
#        else:
#            paramgui.setGlobals({})
#
#        paramgui.runTask('autoclean', myf['_ip'])
#        paramgui.setGlobals({})
#
#
#
#
    def defaults(self, param=None):
        myf=stack_frame_find( )
        a = odict()
        a['vis']  = ''
        a['imagename']  = ''
        a['field']  = ''
        a['spw']  = ''
        a['selectdata']  = True
        a['mode']  = 'mfs'
        a['psfmode']  = 'clark'
        a['imagermode']  = ''
        a['imsize']  = [256, 256]
        a['cell']  = ['1.0arcsec']
        a['phasecenter']  = ''
        a['restfreq']  = ''
        a['stokes']  = 'I'
        a['weighting']  = 'natural'
        a['interactive']  = False
        a['mask']  = []
        a['modelimage']  = ''
        a['uvtaper']  = False
        a['niter']  = 500
        a['npercycle']  = 100
        a['npercycle_speedup']  = 1.5
        a['gain']  = 0.1
        a['pbcor']  = False
        a['minpb']  = 0.1
        a['clean_threshold']  = '0.0mJy'
        a['Nrms']  = 6
        a['eps_maxres']  = 0.01
        a['useabsresid']  = False
        a['allow_maxres_inc']  = 3
        a['island_rms']  = 4
        a['diag']  = False
        a['peak_rms']  = 6
        a['gain_threshold']  = 0.1
        a['Npeak']  = 3
        a['shape']  = 1
        a['boxstretch']  = 1
        a['irregsize']  = 100

        a['selectdata'] = {
                    0:{'value':False}, 
                    1:odict([{'value':True}, {'timerange':''}, {'uvrange':''}, {'antenna':''}, {'scan':''}])}
        a['mode'] = {
                    0:odict([{'value':'mfs'}, {'nterms':1}, {'reffreq':''}]), 
                    1:odict([{'value':'channel'}, {'nchan':1}, {'start':0}, {'width':1}, {'interpolation':'linear'}, {'doconcat':True}]), 
                    2:odict([{'value':'velocity'}, {'nchan':1}, {'start':'0.0km/s'}, {'width':'1km/s'}, {'interpolation':'linear'}, {'doconcat':True}]), 
                    3:odict([{'value':'frequency'}, {'nchan':1}, {'start':'1.4GHz'}, {'width':'10kHz'}, {'interpolation':'linear'}, {'doconcat':True}])}
        a['weighting'] = {
                    0:{'value':'natural'}, 
                    1:{'value':'uniform'}, 
                    2:odict([{'value':'briggs'}, {'robust':0.0}, {'npixels':0}]), 
                    3:odict([{'value':'briggsabs'}, {'robust':0.0}, {'noise':'1.0Jy'}, {'npixels':0}]), 
                    4:odict([{'value':'superuniform'}, {'npixels':0}])}
        a['uvtaper'] = {
                    0:{'value':False}, 
                    1:odict([{'value':True}, {'outertaper':[]}, {'innertaper':[]}])}
        a['imagermode'] = {
                    0:{'value':''}, 
                    1:odict([{'value':'csclean'}, {'cyclefactor':1.5}, {'cyclespeedup':-1}])}

### This function sets the default values but also will return the list of
### parameters or the default value of a given parameter
        if(param == None):
                myf['__set_default_parameters'](a)
        elif(param == 'paramkeys'):
                return a.keys()
        else:
	        if(a.has_key(param)):
		   #if(type(a[param]) == dict) :
		   #   return a[param][len(a[param])-1]['value']
	   	   #else :
		      return a[param]


#
#
    def check_params(self, param=None, value=None):
      myf=stack_frame_find( )

#      print 'param:', param, 'value:', value
      try :
         if str(type(value)) != "<type 'instance'>" :
            value0 = value
            value = myf['cu'].expandparam(param, value)
            matchtype = False
            if(type(value) == numpy.ndarray):
               if(type(value) == type(value0)):
                  myf[param] = value.tolist()
               else:
                  #print 'value:', value, 'value0:', value0
                  #print 'type(value):', type(value), 'type(value0):', type(value0)
                  myf[param] = value0
                  if type(value0) != list :
                     matchtype = True
            else :
               myf[param] = value
            value = myf['cu'].verifyparam({param:value})
            if matchtype:
               value = False
      except Exception, instance:
         #ignore the exception and just return it unchecked
         myf[param] = value
      return value

#
#
    def itsdefault(self, paramname) :
        a = {}
        a['vis']  = ''
        a['imagename']  = ''
        a['field']  = ''
        a['spw']  = ''
        a['selectdata']  = True
        a['timerange']  = ''
        a['uvrange']  = ''
        a['antenna']  = ''
        a['scan']  = ''
        a['mode']  = 'mfs'
        a['nchan']  = 1
        a['start']  = 0
        a['width']  = 1
        a['interpolation']  = 'linear'
        a['doconcat']  = True
        a['psfmode']  = 'clark'
        a['imagermode']  = ''
        a['cyclefactor']  = 1.5
        a['cyclespeedup']  = -1
        a['imsize']  = [256, 256]
        a['cell']  = ['1.0arcsec']
        a['phasecenter']  = ''
        a['restfreq']  = ''
        a['stokes']  = 'I'
        a['weighting']  = 'natural'
        a['robust']  = 0.0
        a['noise']  = '1.0Jy'
        a['npixels']  = 0
        a['interactive']  = False
        a['mask']  = []
        a['modelimage']  = ''
        a['uvtaper']  = False
        a['outertaper']  = ['']
        a['innertaper']  = ['1.0']
        a['niter']  = 500
        a['npercycle']  = 100
        a['npercycle_speedup']  = 1.5
        a['gain']  = 0.1
        a['pbcor']  = False
        a['minpb']  = 0.1
        a['clean_threshold']  = '0.0mJy'
        a['Nrms']  = 6
        a['eps_maxres']  = 0.01
        a['useabsresid']  = False
        a['allow_maxres_inc']  = 3
        a['island_rms']  = 4
        a['diag']  = False
        a['peak_rms']  = 6
        a['gain_threshold']  = 0.1
        a['Npeak']  = 3
        a['shape']  = 1
        a['boxstretch']  = 1
        a['irregsize']  = 100

        if a.has_key(paramname) :
	      return a[paramname]
autoclean_pg = autoclean_pg_()
