#
# This file was generated using xslt from its XML file
#
# Copyright 2014, Associated Universities Inc., Washington DC
#
import sys
import os
#from casac import *
import casac
import string
import time
import inspect
import gc
import numpy
from casa_stack_manip import stack_frame_find
from odict import odict
from types import * 
from task_autoclean import autoclean
class autoclean_cli_:
    __name__ = "autoclean"
    rkey = None
    i_am_a_casapy_task = None
    # The existence of the i_am_a_casapy_task attribute allows help()
    # (and other) to treat casapy tasks as a special case.

    def __init__(self) :
       self.__bases__ = (autoclean_cli_,)
       self.__doc__ = self.__call__.__doc__

       self.parameters={'vis':None, 'imagename':None, 'field':None, 'spw':None, 'selectdata':None, 'timerange':None, 'uvrange':None, 'antenna':None, 'scan':None, 'mode':None, 'nchan':None, 'start':None, 'width':None, 'interpolation':None, 'doconcat':None, 'psfmode':None, 'imagermode':None, 'cyclefactor':None, 'cyclespeedup':None, 'imsize':None, 'cell':None, 'phasecenter':None, 'restfreq':None, 'stokes':None, 'weighting':None, 'robust':None, 'noise':None, 'npixels':None, 'interactive':None, 'mask':None, 'modelimage':None, 'uvtaper':None, 'outertaper':None, 'innertaper':None, 'niter':None, 'npercycle':None, 'npercycle_speedup':None, 'gain':None, 'pbcor':None, 'minpb':None, 'clean_threshold':None, 'Nrms':None, 'eps_maxres':None, 'useabsresid':None, 'allow_maxres_inc':None, 'island_rms':None, 'diag':None, 'peak_rms':None, 'gain_threshold':None, 'Npeak':None, 'shape':None, 'boxstretch':None, 'irregsize':None, }


    def result(self, key=None):
	    #### and add any that have completed...
	    return None


    def __call__(self, vis=None, imagename=None, field=None, spw=None, selectdata=None, timerange=None, uvrange=None, antenna=None, scan=None, mode=None, nchan=None, start=None, width=None, interpolation=None, doconcat=None, psfmode=None, imagermode=None, cyclefactor=None, cyclespeedup=None, imsize=None, cell=None, phasecenter=None, restfreq=None, stokes=None, weighting=None, robust=None, noise=None, npixels=None, interactive=None, mask=None, modelimage=None, uvtaper=None, outertaper=None, innertaper=None, niter=None, npercycle=None, npercycle_speedup=None, gain=None, pbcor=None, minpb=None, clean_threshold=None, Nrms=None, eps_maxres=None, useabsresid=None, allow_maxres_inc=None, island_rms=None, diag=None, peak_rms=None, gain_threshold=None, Npeak=None, shape=None, boxstretch=None, irregsize=None, ):

        """CLEAN an image with automatically-chosen clean regions.

	Detailed Description: 
Form images from visibilities. Handles continuum and spectral
  line cubes.  Automatically choose size/shape/position of clean regions.
	Arguments :
		vis:	Name of input visibility file
		   Default Value: 

		imagename:	Pre-name of output images
		   Default Value: 

		field:	Field Name or id
		   Default Value: 

		spw:	Spectral windows:channels e.g. \'0~3:3~100\', \'\' is all
		   Default Value: 

		selectdata:	Other data selection parameters
		   Default Value: True

		timerange:	Range of time to select from data
		   Default Value: 

		uvrange:	Select data within uvrange 
		   Default Value: 

		antenna:	Select data based on antenna/baseline
		   Default Value: 

		scan:	Scan number range
		   Default Value: 

		mode:	Spectral gridding type (mfs, channel, velocity, frequency)
		   Default Value: mfs
		   Allowed Values:
				mfs
				channel
				velocity
				frequency

		nchan:	Number of channels (planes) in output image
		   Default Value: 1

		start:	First channel in input to use
		   Default Value: 0

		width:	Number of input channels to average
		   Default Value: 1

		interpolation:	Spectral interpolation(nearest, linear, cubic)
		   Default Value: linear
		   Allowed Values:
				nearest
				linear
				cubic
				spline

		doconcat:	Concatenate multiple channels into single final image
		   Default Value: True

		psfmode:	Method of PSF calculation to use during minor cycles
		   Default Value: clark
		   Allowed Values:
				clark
				clarkstokes
				hogbom

		imagermode:	Options: \'csclean\' or \'mosaic\', \' \', uses psfmode
		   Default Value: 
		   Allowed Values:
				
				csclean
				mosaic

		cyclefactor:	change depth in between of csclean cycle
		   Default Value: 1.5

		cyclespeedup:	Cycle threshold doubles in this number of iteration
		   Default Value: -1

		imsize:	x and y image size in pixels. Single value: same for both
		   Default Value: 
    256256
    

		cell:	x and y cell size(s). Default unit arcsec.
		   Default Value: 1.0

		phasecenter:	Image center: direction or field index
		   Default Value: 

		restfreq:	Rest frequency to assign to image (see help)
		   Default Value: 

		stokes:	Stokes params to image (eg I,IV, QU,IQUV); Current autoclean implementation requires Stokes="I".
		   Default Value: I
		   Allowed Values:
				I

		weighting:	Weighting of uv (natural, uniform, briggs, ...)
		   Default Value: natural
		   Allowed Values:
				natural
				uniform
				briggs
				briggsabs
				radial
				superuniform

		robust:	Briggs robustness parameter
		   Default Value: 0.0
		   Allowed Values:
				-2.0
				2.0

		noise:	noise parameter for briggs abs mode weighting
		   Default Value: 1.0Jy

		npixels:	number of pixels for superuniform or briggs weighting
		   Default Value: 0

		interactive:	use interactive clean (with GUI viewer)
		   Default Value: False

		mask:	Initial cleanbox(es), mask image(s), and/or region(s)  used in cleaning
		   Default Value: 

		modelimage:	Name of model image(s) to initialize cleaning
		   Default Value: 

		uvtaper:	Apply additional uv tapering of visibilities
		   Default Value: False

		outertaper:	uv-taper on outer baselines in uv-plane
		   Default Value: 
	      
	    

		innertaper:	uv-taper in center of uv-plane (not implemented)
		   Default Value: 1.0

		niter:	Max number of total clean cycles per channel
		   Default Value: 500

		npercycle:	Clean iterations before adding new clean boxes
		   Default Value: 100

		npercycle_speedup:	Increase npercycle by this factor if no new regions found.
		   Default Value: 1.5

		gain:	Loop gain for cleaning
		   Default Value: 0.1

		pbcor:	Output primary beam-corrected image
		   Default Value: False

		minpb:	Minimum PB level to use
		   Default Value: 0.1

		clean_threshold:	Flux level to stop cleaning.  Must include units.
		   Default Value: 0.0

		Nrms:	Threshold to stop cleaning: current rms * Nrms
		   Default Value: 6

		eps_maxres:	Stop cleaning if max abs(residual) changes by less than this factor
		   Default Value: 0.01

		useabsresid:	If True, use absolute value of residual to test for clean convergence.
		   Default Value: False

		allow_maxres_inc:	Stop cleaning if max abs(residual) increases this many times (set to -1 to ignore)
		   Default Value: 3

		island_rms:	Threshold for islands when finding clean regions: current rms * island_rms
		   Default Value: 4

		diag:	Count diagonal connection as same island?
		   Default Value: False

		peak_rms:	Threshold to add new clean box: peak in island must be at least current rms * peak_rms
		   Default Value: 6

		gain_threshold:	Threshold to add new clean box: peak in island must be at least current max residual * gain_threshold
		   Default Value: 0.1

		Npeak:	Max number of new clean regions to add in each iteration.
		   Default Value: 3
		   Allowed Values:
				1

		shape:	Shape of clean regions: 0 for circles, 1 for boxes, 2 for both.
		   Default Value: 1
		   Allowed Values:
				0
				3

		boxstretch:	Increase clean region size by this many pixels beyond island size.
		   Default Value: 1
		   Allowed Values:
				-1
				6

		irregsize:	For regions this large (in pixels), use irregular clean region.
		   Default Value: 100
		   Allowed Values:
				0

	Returns: void

	Example :

       This is a wrapper for clean which includes automatic clean boxing.
       Current capabilities include:
 
        1)  Multi-frequency-continuum images or spectral channel imaging
        2)  Stokes I imaging only
        3)  Use starting mask
 
 
       vis -- Name of input visibility file
               default: none; example: vis='ngc5921.ms'
       imagename -- Pre-name of output images:
               default: none; example: imagename='m2'
               output images are:
                 m2.image; cleaned and restored image
                        With or without primary beam correction
                 m2.psf; point-spread function (dirty beam)
                 m2.flux;  relative sky sensitivity over field
		 m2.mask;  total clean regions
                 m2.model; image of clean components
                 m2.residual; image of residuals
       field -- Select fields in mosaic.  Use field id(s) or field name(s).
                  ['go listobs' to obtain the list id's or names]
              default: ''= all fields
              If field string is a non-negative integer, it is assumed to
                  be a field index otherwise, it is assumed to be a 
		  field name
              field='0~2'; field ids 0,1,2
              field='0,4,5~7'; field ids 0,4,5,6,7
              field='3C286,3C295'; field named 3C286 and 3C295
              field = '3,4C*'; field id 3, all names starting with 4C
       spw -- Select spectral window/channels
              NOTE: This selects the data passed as the INPUT to mode
              default: ''=all spectral windows and channels
                spw='0~2,4'; spectral windows 0,1,2,4 (all channels)
                spw='0:5~61'; spw 0, channels 5 to 61
                spw='<2';   spectral windows less than 2 (i.e. 0,1)
                spw='0,10,3:3~45'; spw 0,10 all channels, spw 3, 
				   channels 3 to 45.
                 spw='0~2:2~6'; spw 0,1,2 with channels 2 through 6 in each.
                 spw='0:0~10;15~60'; spectral window 0 with channels 
				    0-10,15-60
                 spw='0:0~10,1:20~30,2:1;2;3'; spw 0, channels 0-10,
                      spw 1, channels 20-30, and spw 2, channels, 1,2 and 3
       selectdata -- Other data selection parameters
               default: True

  >>> selectdata=True expandable parameters
               See help par.selectdata for more on these

               timerange  -- Select data based on time range:
                   default: '' (all); examples,
                   timerange = 'YYYY/MM/DD/hh:mm:ss~YYYY/MM/DD/hh:mm:ss'
                   Note: if YYYY/MM/DD is missing date defaults to first 
			 day in data set
                   timerange='09:14:0~09:54:0' picks 40 min on first day
                   timerange='25:00:00~27:30:00' picks 1 hr to 3 hr 
			     30min on NEXT day
                   timerange='09:44:00' pick data within one integration 
		             of time
                   timerange='>10:24:00' data after this time
               uvrange -- Select data within uvrange (default units meters)
                   default: '' (all); example:
                   uvrange='0~1000klambda'; uvrange from 0-1000 kilo-lambda
                   uvrange='>4klambda';uvranges greater than 4 kilo lambda
               antenna -- Select data based on antenna/baseline
                   default: '' (all)
                   If antenna string is a non-negative integer, it is 
 		   assumed to be an antenna index, otherwise, it is
 		   considered an antenna name.
                   antenna='5&6'; baseline between antenna index 5 and 
 				 index 6.
                   antenna='VA05&VA06'; baseline between VLA antenna 5 
 				       and 6.
                   antenna='5&6;7&8'; baselines 5-6 and 7-8
                   antenna='5'; all baselines with antenna index 5
                   antenna='05'; all baselines with antenna number 05 
 				(VLA old name)
                   antenna='5,6,9'; all baselines with antennas 5,6,9 
 				   index numbers
              scan -- Scan number range.
                  default: '' (all)
                  example: scan='1~5'
                  Check 'go listobs' to insure the scan numbers are in 
 			order.
       mode -- Frequency Specification:
               NOTE: Channels deselected with spw parameter will contain all
                     zeros. 
               See examples below.
               default: 'mfs'
                 mode = 'mfs' means produce one image from all 
 		      specified data.
                 mode = 'channel'; Use with nchan, start, width to specify
                         output image cube.  See examples below
                 mode = 'velocity', means channels are specified in 
 		      velocity.
                 mode = 'frequency', means channels are specified in 
 		      frequency.

  >>> mode expandable parameters (for modes other than 'mfs')
               Start, width are given in units of channels, frequency 
 		  or velocity as indicated by mode (note: only nearest neighbour 
                  interpolation is available at this time).
               nchan -- Number of channels (planes) in output image
                 default: 1; example: nchan=3
               start -- Start input channel (relative-0)
                 default=0; example: start=5
               width -- Output channel width in units of the input
 		     channel width (>1 indicates channel averaging)
                 default=1; example: width=4
               interpolation -- Interpolation type of spectral data when gridded on
                     the uv-plane
                 default = 'linear'
               doconcat -- Tells autoclean to concatenate multiple channel images into
                     single image at the end of its run.  (Autoclean makes an image
                     for each channel, and cleans/boxes them one at a time.)
                 default = 'True'
           examples:
               spw = '0,1'; mode = 'mfs'
                  will produce one image made from all channels in spw 
 		       0 and 1
               spw='0:5~28^2'; mode = 'mfs'
                  will produce one image made with channels 
 		       (5,7,9,...,25,27)
               spw = '0'; mode = 'channel': nchan=3; start=5; width=4
                  will produce an image with 3 output planes
                  plane 1 contains data from channels (5+6+7+8)
                  plane 2 contains data from channels (9+10+11+12)
                  plane 3 contains data from channels (13+14+15+16)
               spw = '0:0~63^3'; mode='channel'; nchan=21; start = 0; 
 		   width = 1
                  will produce an image with 20 output planes
                  Plane 1 contains data from channel 0
                  Plane 2 contains date from channel 2
                  Plane 21 contains data from channel 61
               spw = '0:0~40^2'; mode = 'channel'; nchan = 3; start = 
 		   5; width = 4
                  will produce an image with three output planes
                  plane 1 contains channels (5,7)
                  plane 2 contains channels (13,15)
                  plane 3 contains channels (21,23)

       psfmode -- method of PSF calculation to use during minor cycles:
               default: 'clark': Options: 'clark','clarkstokes', 'hogbom'
               'clark'  use smaller beam (faster, usually good enough);
                for stokes images clean components peaks are searched in the I^2+Q^2+U^2+V^2 domain 
               'clarkstokes' locate clean components independently in each stokes image
               'hogbom' full-width of image (slower, better for poor 
 	       uv-coverage)
               Note:  psfmode will be used to clean is imagermode = ''
       imagermode -- Advanced imaging e.g mosaic or Cotton-Schwab clean
               default: imagermode='': Options: '', 'csclean'
               default ''  => psfmode cleaning algorithm used

  >>> imagermode='csclean' expandable parameter(s): 
            Image using the Cotton-Schwab algorithm in between major cycles
 	    cyclefactor -- Change the threshold at which
 			  the deconvolution cycle will stop, degrid
 			  and subtract from the visibilities.  For
 			  poor PSFs, reconcile often (cyclefactor=4 or
 			  5); For good PSFs, use cyclefactor 1.5 to
 			  2.0. Note: threshold = cyclefactor * max
 			  sidelobe * max residual.
 			  default: 1.5; example: cyclefactor=4
 	    cyclespeedup -- Cycle threshold doubles in this
 			  number of iterations default: -1;
 			  example: cyclespeedup=3
                          try cyclespeedup = 50 to speed up cleaning 
             
       imsize -- Image pixel size (x,y).  DOES NOT HAVE TO BE A POWER OF 2
               default = [256,256]; example: imsize=[350,350]
               imsize = 500 is equivalent to [500,500]
               Avoid odd-numbered imsize.
       cell -- Cell size (x,y)
               default= '1.0arcsec';
               example: cell=['0.5arcsec,'0.5arcsec'] or
               cell=['1arcmin', '1arcmin']
               cell = '1arcsec' is equivalent to ['1arcsec','1arcsec']
               NOTE:cell = 2.0 => ['2arcsec', '2arcsec']
       phasecenter -- direction measure  or fieldid for the mosaic center
               default: '' => first field selected ; example: phasecenter=6
               or phasecenter='J2000 19h30m00 -40d00m00'
       restfreq -- Specify rest frequency to use for output image
               default='' Occasionally it is necessary to set this (for
               example some VLA spectral line data).  For example for
               NH_3 (1,1) put restfreq='23.694496GHz'
       stokes -- Stokes parameters to image
               default='I'; example: stokes='IQUV';
               Options: 'I','IV''QU','IQUV','RR','LL','XX','YY','RRLL','XXYY'

       weighting -- Weighting to apply to visibilities:
               default='natural'; example: weighting='uniform';
               Options: 'natural','uniform','briggs', 
 		       'superuniform','briggsabs','radial'

  >>> Weighting expandable parameters
               For weighting='briggs' and 'briggsabs'
                   robust -- Brigg's robustness parameter
                   default=0.0; example: robust=0.5;
                   Options: -2.0 to 2.0; -2 (uniform)/+2 (natural)
               For weighting='briggsabs'
                   noise   -- noise parameter to use for Briggs "abs" 
 		   weighting
                   example noise='1.0mJy'
               npixels -- uv-cell area used for weight calculation
                   example npixels=1
                   Default = 0
                   superuniform:  0 Means 3x3 cells for weighting
                     the cell weight is proportional to the weight of
                     the 3x3 cells centered on it.
                   superuniform = F means 1x1 cell for averaging weights.
                   briggs/briggsabs: 0 is similar to 1x1 cell weight.
                     1 may? be similar to 3X3 cells.
                   Only npixels 0 or 1 recommended
                   
       mask -- Initial specification of cleanbox(es), mask image(s), and/or
 	   region(s) to be used for CLEANing.  For channel data (image cubes),
           any initial mask will be applied to every channel. mask default: 
           [] (no masking); Possible specification types: (a) Explicit
 	   cleanbox pixel ranges example: mask=[110,110,150,145] clean
 	   region with blc=110,100; trc=150,145 (pixel values) (b)
 	   Filename with cleanbox pixel values with ascii format:
 	   example: mask='mycleanbox.txt' <fieldid blc-x blc-y
 	   trc-x trc-y> on each line 
 	   1 45 66 123 124 
 	   2 23 100 300 340
 	   (c) Filename for image mask example: mask='myimage.mask'
 	   (d) Filename for region specification (e.g. from viewer)
 	   example: mask='myregion.rgn' (e) Combinations of any of the
 	   above example: mask=[[110,110,150,145],'mycleanbox.txt',
 	   'myimage.mask','myregion.rgn']
           If include outlier fields, then mask need to be spefied in
           nested lists: e.g. mask=[[[110,110,150,145],'myimage.mask'],[],[20,20,40,40]]
           (A clean box with [110,110,150,145] and a image mask for main field, 
            no mask for 1st outlier field, 1 clean box for second outlier field.)
       modelimage -- Name of model image(s) to initialize cleaning. If
               multiple images, then these will be added together to
               form initial starting model NOTE: these are in addition
               to any initial model in the <imagename>.model image file
               default: '' (none); example: modelimage='orion.model'
               modelimage=['orion.model','sdorion.image'] Note: if the
               units in the image are Jy/beam as in a single-dish
               image, then it will be converted to Jy/pixel as in a
               model image, using the restoring beam in the image
               header
  >>> uvtaper=True expandable parameters
               outertaper -- uv-taper on outer baselines in uv-plane
                 [bmaj, bmin, bpa] taper Gaussian scale in uv or 
 		 angular units. NOTE: uv taper in (klambda) is roughly on-sky 
 	         FWHM(arcsec/200)
                 default: outertaper=[]; no outer taper applied
 		 example: outertaper=['5klambda']  circular taper 
 				FWHM=5 kilo-lambda
                         outertaper=['5klambda','3klambda','45.0deg']
                         outertaper=['10arcsec'] on-sky FWHM 10"
                         outertaper=['300.0'] default units are meters 
 			        in aperture plane
               innertaper -- uv-taper in center of uv-plane
                 [bmaj,bmin,bpa] Gaussian scale at which taper falls to 
 		 zero at uv=0
                 default: innertaper=[]; no inner taper applied
                 NOT YET IMPLEMENTED                
       niter -- Maximum number iterations over all clean iterations.
               default: 500;  example: niter=5000
       npercycle -- Number of clean minor cycles before making new clean region
 	   selection. 
           default: 100;  example: npercycle = 100
       npercycle_speedup: If no new clean regions found during an iteration of
 	   clean region selections, increase npercycle by this factor.
           (Npercycle returns to initial value if new clean regions are later
            found.)
           default: 1.5;  example: npercycle_speedup = 2
       gain -- Loop gain for CLEANing
               default: 0.1; example: gain=0.5
       pbcor -- Output primary beam-corrected image 
 	      default: pbcor=False; output un-corrected image 
 	      example: pbcor=True; output pb-corrected image (masked outside
               minpb) Note: if you set pbcor=False, you can later
               recover the pbcor image by dividing by the .flux image
               (e.g. using immath)
       minpb -- Minimum PB level to use default=0.1;
               The flux image is used to determine this
	       except for the case of mosaic with ft='mosaic'
	       where the flux.pbcoverage image is used.
               example:
               minpb=0.01 Note: this minpb is always in effect
               (regardless of pbcor=True/False) 
       clean_threshold -- Flux level at which to stop CLEANing
               default: '0.0mJy'; 
               example: threshold='2.3mJy'  (always include units)
                        threshold = '0.0023Jy'
                        threshold = '0.0023Jy/beam' (okay also)
       Nrms -- Stop cleaning when maximum residual is below this value times
 	   the current rms (outside the current clean regions).
           default: 6
           example: Nrms=4
       eps_maxres -- Convergence parameter to stop cleaning: stop if maximum
 	   residual has changed by less than a factor of eps_maxres.
           default: 0.01  (one per cent change)
           example: eps_maxres = 0.05
       allow_maxres_inc -- Parameter to stop cleaning: stop if maximum residual
 	   has increased between clean iterations this number of times.
           default: 3
           example: allow_maxres_inc = 2
       island_rms: threshold (this value times current rms) at which to box the
 	   residual image when searching for new clean regions
           default: 4
           example:  island_rms = 3
       diag: T/F switch to declare if pixels connected on the diagonal belong
 	   to the same island, when selecting pixels for clean boxing
           default: False
           example: diag = True
       peak_rms: threshold (this value times current rms) for peak pixel flux
 	   to qualify an island for clean boxing
           default: 6
           example: peak_rms = 5
       gain_threshold: threshold (this value times current maximum residual) of
 	   peak pixel in island to qualify island for clean boxing. 
           default: 0.1
           example: gain_threshold = 0.5
       Npeak: maximum number of new clean regions to add each iteration
           default: 3
           example: Npeak = 5
       shape: parameter to determine shape of clean regions. 
           0: all circles
           1: all boxes
           2: choose according to island shape (circles if island has similar
 	   dimension in x and y direction, box otherwise)
           default: 1  
           example: shape=2
       boxstretch: number of pixels to increase outward size of clean region,
 	   can range from -1 to 5. 
           default: 1
           example: boxstretch = 3
       irregsize: for islands this large (dimension in pixels) or larger, fill
 	   in mask with island's actual shape rather than using a box or
 	   circle.  Set to 0 to ignore this parameter.
           default: 100
           example: irregsize = 50

  
        """
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
	#casac = self.__globals__['casac']
	casalog = self.__globals__['casalog']
	casa = self.__globals__['casa']
	#casalog = casac.casac.logsink()
        self.__globals__['__last_task'] = 'autoclean'
        self.__globals__['taskname'] = 'autoclean'
        ###
        self.__globals__['update_params'](func=self.__globals__['taskname'],printtext=False,ipython_globals=self.__globals__)
        ###
        ###
        #Handle globals or user over-ride of arguments
        #
        if type(self.__call__.func_defaults) is NoneType:
            function_signature_defaults={}
	else:
	    function_signature_defaults=dict(zip(self.__call__.func_code.co_varnames[1:],self.__call__.func_defaults))
	useLocalDefaults = False

        for item in function_signature_defaults.iteritems():
                key,val = item
                keyVal = eval(key)
                if (keyVal == None):
                        #user hasn't set it - use global/default
                        pass
                else:
                        #user has set it - use over-ride
			if (key != 'self') :
			   useLocalDefaults = True

	myparams = {}
	if useLocalDefaults :
	   for item in function_signature_defaults.iteritems():
	       key,val = item
	       keyVal = eval(key)
	       exec('myparams[key] = keyVal')
	       self.parameters[key] = keyVal
	       if (keyVal == None):
	           exec('myparams[key] = '+ key + ' = self.itsdefault(key)')
		   keyVal = eval(key)
		   if(type(keyVal) == dict) :
                      if len(keyVal) > 0 :
		         exec('myparams[key] = ' + key + ' = keyVal[len(keyVal)-1][\'value\']')
		      else :
		         exec('myparams[key] = ' + key + ' = {}')
	 
        else :
            print ''

            myparams['vis'] = vis = self.parameters['vis']
            myparams['imagename'] = imagename = self.parameters['imagename']
            myparams['field'] = field = self.parameters['field']
            myparams['spw'] = spw = self.parameters['spw']
            myparams['selectdata'] = selectdata = self.parameters['selectdata']
            myparams['timerange'] = timerange = self.parameters['timerange']
            myparams['uvrange'] = uvrange = self.parameters['uvrange']
            myparams['antenna'] = antenna = self.parameters['antenna']
            myparams['scan'] = scan = self.parameters['scan']
            myparams['mode'] = mode = self.parameters['mode']
            myparams['nchan'] = nchan = self.parameters['nchan']
            myparams['start'] = start = self.parameters['start']
            myparams['width'] = width = self.parameters['width']
            myparams['interpolation'] = interpolation = self.parameters['interpolation']
            myparams['doconcat'] = doconcat = self.parameters['doconcat']
            myparams['psfmode'] = psfmode = self.parameters['psfmode']
            myparams['imagermode'] = imagermode = self.parameters['imagermode']
            myparams['cyclefactor'] = cyclefactor = self.parameters['cyclefactor']
            myparams['cyclespeedup'] = cyclespeedup = self.parameters['cyclespeedup']
            myparams['imsize'] = imsize = self.parameters['imsize']
            myparams['cell'] = cell = self.parameters['cell']
            myparams['phasecenter'] = phasecenter = self.parameters['phasecenter']
            myparams['restfreq'] = restfreq = self.parameters['restfreq']
            myparams['stokes'] = stokes = self.parameters['stokes']
            myparams['weighting'] = weighting = self.parameters['weighting']
            myparams['robust'] = robust = self.parameters['robust']
            myparams['noise'] = noise = self.parameters['noise']
            myparams['npixels'] = npixels = self.parameters['npixels']
            myparams['interactive'] = interactive = self.parameters['interactive']
            myparams['mask'] = mask = self.parameters['mask']
            myparams['modelimage'] = modelimage = self.parameters['modelimage']
            myparams['uvtaper'] = uvtaper = self.parameters['uvtaper']
            myparams['outertaper'] = outertaper = self.parameters['outertaper']
            myparams['innertaper'] = innertaper = self.parameters['innertaper']
            myparams['niter'] = niter = self.parameters['niter']
            myparams['npercycle'] = npercycle = self.parameters['npercycle']
            myparams['npercycle_speedup'] = npercycle_speedup = self.parameters['npercycle_speedup']
            myparams['gain'] = gain = self.parameters['gain']
            myparams['pbcor'] = pbcor = self.parameters['pbcor']
            myparams['minpb'] = minpb = self.parameters['minpb']
            myparams['clean_threshold'] = clean_threshold = self.parameters['clean_threshold']
            myparams['Nrms'] = Nrms = self.parameters['Nrms']
            myparams['eps_maxres'] = eps_maxres = self.parameters['eps_maxres']
            myparams['useabsresid'] = useabsresid = self.parameters['useabsresid']
            myparams['allow_maxres_inc'] = allow_maxres_inc = self.parameters['allow_maxres_inc']
            myparams['island_rms'] = island_rms = self.parameters['island_rms']
            myparams['diag'] = diag = self.parameters['diag']
            myparams['peak_rms'] = peak_rms = self.parameters['peak_rms']
            myparams['gain_threshold'] = gain_threshold = self.parameters['gain_threshold']
            myparams['Npeak'] = Npeak = self.parameters['Npeak']
            myparams['shape'] = shape = self.parameters['shape']
            myparams['boxstretch'] = boxstretch = self.parameters['boxstretch']
            myparams['irregsize'] = irregsize = self.parameters['irregsize']

        if type(imsize)==int: imsize=[imsize]
        if type(cell)==float: cell=[cell]
        if type(outertaper)==str: outertaper=[outertaper]
        if type(innertaper)==str: innertaper=[innertaper]

	result = None

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['vis'] = vis
        mytmp['imagename'] = imagename
        mytmp['field'] = field
        mytmp['spw'] = spw
        mytmp['selectdata'] = selectdata
        mytmp['timerange'] = timerange
        mytmp['uvrange'] = uvrange
        mytmp['antenna'] = antenna
        mytmp['scan'] = scan
        mytmp['mode'] = mode
        mytmp['nchan'] = nchan
        mytmp['start'] = start
        mytmp['width'] = width
        mytmp['interpolation'] = interpolation
        mytmp['doconcat'] = doconcat
        mytmp['psfmode'] = psfmode
        mytmp['imagermode'] = imagermode
        mytmp['cyclefactor'] = cyclefactor
        mytmp['cyclespeedup'] = cyclespeedup
        mytmp['imsize'] = imsize
        if type(cell) == str :
           mytmp['cell'] = casac.casac.qa.quantity(cell)
        else :
           mytmp['cell'] = cell
        mytmp['phasecenter'] = phasecenter
        mytmp['restfreq'] = restfreq
        mytmp['stokes'] = stokes
        mytmp['weighting'] = weighting
        mytmp['robust'] = robust
        mytmp['noise'] = noise
        mytmp['npixels'] = npixels
        mytmp['interactive'] = interactive
        mytmp['mask'] = mask
        mytmp['modelimage'] = modelimage
        mytmp['uvtaper'] = uvtaper
        mytmp['outertaper'] = outertaper
        mytmp['innertaper'] = innertaper
        mytmp['niter'] = niter
        mytmp['npercycle'] = npercycle
        mytmp['npercycle_speedup'] = npercycle_speedup
        mytmp['gain'] = gain
        mytmp['pbcor'] = pbcor
        mytmp['minpb'] = minpb
        if type(clean_threshold) == str :
           mytmp['clean_threshold'] = casac.casac.qa.quantity(clean_threshold)
        else :
           mytmp['clean_threshold'] = clean_threshold
        mytmp['Nrms'] = Nrms
        mytmp['eps_maxres'] = eps_maxres
        mytmp['useabsresid'] = useabsresid
        mytmp['allow_maxres_inc'] = allow_maxres_inc
        mytmp['island_rms'] = island_rms
        mytmp['diag'] = diag
        mytmp['peak_rms'] = peak_rms
        mytmp['gain_threshold'] = gain_threshold
        mytmp['Npeak'] = Npeak
        mytmp['shape'] = shape
        mytmp['boxstretch'] = boxstretch
        mytmp['irregsize'] = irregsize
	pathname='file://' + casa['dirs']['xml'] + '/'
	trec = casac.casac.utils().torecord(pathname+'autoclean.xml')

        casalog.origin('autoclean')
	try :
          #if not trec.has_key('autoclean') or not casac.casac.utils().verify(mytmp, trec['autoclean']) :
	    #return False

          casac.casac.utils().verify(mytmp, trec['autoclean'], True)
          scriptstr=['']
          saveinputs = self.__globals__['saveinputs']
          if type(self.__call__.func_defaults) is NoneType:
              saveinputs=''
          else:
              saveinputs('autoclean', 'autoclean.last', myparams, self.__globals__,scriptstr=scriptstr)
          tname = 'autoclean'
          spaces = ' '*(18-len(tname))
          casalog.post('\n##########################################'+
                       '\n##### Begin Task: ' + tname + spaces + ' #####')
          if type(self.__call__.func_defaults) is NoneType:
              casalog.post(scriptstr[0]+'\n', 'INFO')
          else :
              casalog.post(scriptstr[1][1:]+'\n', 'INFO')
          result = autoclean(vis, imagename, field, spw, selectdata, timerange, uvrange, antenna, scan, mode, nchan, start, width, interpolation, doconcat, psfmode, imagermode, cyclefactor, cyclespeedup, imsize, cell, phasecenter, restfreq, stokes, weighting, robust, noise, npixels, interactive, mask, modelimage, uvtaper, outertaper, innertaper, niter, npercycle, npercycle_speedup, gain, pbcor, minpb, clean_threshold, Nrms, eps_maxres, useabsresid, allow_maxres_inc, island_rms, diag, peak_rms, gain_threshold, Npeak, shape, boxstretch, irregsize)
          casalog.post('##### End Task: ' + tname + '  ' + spaces + ' #####'+
                       '\n##########################################')

	except Exception, instance:
          if(self.__globals__.has_key('__rethrow_casa_exceptions') and self.__globals__['__rethrow_casa_exceptions']) :
             raise
          else :
             #print '**** Error **** ',instance
	     tname = 'autoclean'
             casalog.post('An error occurred running task '+tname+'.', 'ERROR')
             pass

        gc.collect()
        return result
#
#
#
    def paramgui(self, useGlobals=True, ipython_globals=None):
        """
        Opens a parameter GUI for this task.  If useGlobals is true, then any relevant global parameter settings are used.
        """
        import paramgui
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )

        if useGlobals:
	    if ipython_globals == None:
                myf=self.__globals__
            else:
                myf=ipython_globals

            paramgui.setGlobals(myf)
        else:
            paramgui.setGlobals({})

        paramgui.runTask('autoclean', myf['_ip'])
        paramgui.setGlobals({})

#
#
#
    def defaults(self, param=None, ipython_globals=None, paramvalue=None, subparam=None):
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
        if ipython_globals == None:
            myf=self.__globals__
        else:
            myf=ipython_globals

        a = odict()
        a['vis']  = ''
        a['imagename']  = ''
        a['field']  = ''
        a['spw']  = ''
        a['selectdata']  = True
        a['mode']  = 'mfs'
        a['psfmode']  = 'clark'
        a['imagermode']  = ''
        a['imsize']  = [256, 256]
        a['cell']  = ['1.0arcsec']
        a['phasecenter']  = ''
        a['restfreq']  = ''
        a['stokes']  = 'I'
        a['weighting']  = 'natural'
        a['interactive']  = False
        a['mask']  = []
        a['modelimage']  = ''
        a['uvtaper']  = False
        a['niter']  = 500
        a['npercycle']  = 100
        a['npercycle_speedup']  = 1.5
        a['gain']  = 0.1
        a['pbcor']  = False
        a['minpb']  = 0.1
        a['clean_threshold']  = '0.0mJy'
        a['Nrms']  = 6
        a['eps_maxres']  = 0.01
        a['useabsresid']  = False
        a['allow_maxres_inc']  = 3
        a['island_rms']  = 4
        a['diag']  = False
        a['peak_rms']  = 6
        a['gain_threshold']  = 0.1
        a['Npeak']  = 3
        a['shape']  = 1
        a['boxstretch']  = 1
        a['irregsize']  = 100

        a['selectdata'] = {
                    0:{'value':False}, 
                    1:odict([{'value':True}, {'timerange':''}, {'uvrange':''}, {'antenna':''}, {'scan':''}])}
        a['mode'] = {
                    0:odict([{'value':'mfs'}, {'nterms':1}, {'reffreq':''}]), 
                    1:odict([{'value':'channel'}, {'nchan':1}, {'start':0}, {'width':1}, {'interpolation':'linear'}, {'doconcat':True}]), 
                    2:odict([{'value':'velocity'}, {'nchan':1}, {'start':'0.0km/s'}, {'width':'1km/s'}, {'interpolation':'linear'}, {'doconcat':True}]), 
                    3:odict([{'value':'frequency'}, {'nchan':1}, {'start':'1.4GHz'}, {'width':'10kHz'}, {'interpolation':'linear'}, {'doconcat':True}])}
        a['weighting'] = {
                    0:{'value':'natural'}, 
                    1:{'value':'uniform'}, 
                    2:odict([{'value':'briggs'}, {'robust':0.0}, {'npixels':0}]), 
                    3:odict([{'value':'briggsabs'}, {'robust':0.0}, {'noise':'1.0Jy'}, {'npixels':0}]), 
                    4:odict([{'value':'superuniform'}, {'npixels':0}])}
        a['uvtaper'] = {
                    0:{'value':False}, 
                    1:odict([{'value':True}, {'outertaper':[]}, {'innertaper':[]}])}
        a['imagermode'] = {
                    0:{'value':''}, 
                    1:odict([{'value':'csclean'}, {'cyclefactor':1.5}, {'cyclespeedup':-1}])}

### This function sets the default values but also will return the list of
### parameters or the default value of a given parameter
        if(param == None):
                myf['__set_default_parameters'](a)
        elif(param == 'paramkeys'):
                return a.keys()
        else:
            if(paramvalue==None and subparam==None):
               if(a.has_key(param)):
                  return a[param]
               else:
                  return self.itsdefault(param)
            else:
               retval=a[param]
               if(type(a[param])==dict):
                  for k in range(len(a[param])):
                     valornotval='value'
                     if(a[param][k].has_key('notvalue')):
                        valornotval='notvalue'
                     if((a[param][k][valornotval])==paramvalue):
                        retval=a[param][k].copy()
                        retval.pop(valornotval)
                        if(subparam != None):
                           if(retval.has_key(subparam)):
                              retval=retval[subparam]
                           else:
                              retval=self.itsdefault(subparam)
		     else:
                        retval=self.itsdefault(subparam)
               return retval


#
#
    def check_params(self, param=None, value=None, ipython_globals=None):
      if ipython_globals == None:
          myf=self.__globals__
      else:
          myf=ipython_globals
#      print 'param:', param, 'value:', value
      try :
         if str(type(value)) != "<type 'instance'>" :
            value0 = value
            value = myf['cu'].expandparam(param, value)
            matchtype = False
            if(type(value) == numpy.ndarray):
               if(type(value) == type(value0)):
                  myf[param] = value.tolist()
               else:
                  #print 'value:', value, 'value0:', value0
                  #print 'type(value):', type(value), 'type(value0):', type(value0)
                  myf[param] = value0
                  if type(value0) != list :
                     matchtype = True
            else :
               myf[param] = value
            value = myf['cu'].verifyparam({param:value})
            if matchtype:
               value = False
      except Exception, instance:
         #ignore the exception and just return it unchecked
         myf[param] = value
      return value
#
#
    def description(self, key='autoclean', subkey=None):
        desc={'autoclean': 'CLEAN an image with automatically-chosen clean regions.',
               'vis': 'Name of input visibility file',
               'imagename': 'Pre-name of output images',
               'field': 'Field Name or id',
               'spw': 'Spectral windows:channels e.g. \'0~3:3~100\', \'\' is all',
               'selectdata': 'Other data selection parameters',
               'timerange': 'Range of time to select from data',
               'uvrange': 'Select data within uvrange ',
               'antenna': 'Select data based on antenna/baseline',
               'scan': 'Scan number range',
               'mode': 'Spectral gridding type (mfs, channel, velocity, frequency)',
               'nchan': 'Number of channels (planes) in output image',
               'start': 'First channel in input to use',
               'width': 'Number of input channels to average',
               'interpolation': 'Spectral interpolation(nearest, linear, cubic)',
               'doconcat': 'Concatenate multiple channels into single final image',
               'psfmode': 'Method of PSF calculation to use during minor cycles',
               'imagermode': 'Options: \'csclean\' or \'mosaic\', \' \', uses psfmode',
               'cyclefactor': 'change depth in between of csclean cycle',
               'cyclespeedup': 'Cycle threshold doubles in this number of iteration',
               'imsize': 'x and y image size in pixels. Single value: same for both',
               'cell': 'x and y cell size(s). Default unit arcsec.',
               'phasecenter': 'Image center: direction or field index',
               'restfreq': 'Rest frequency to assign to image (see help)',
               'stokes': 'Stokes params to image (eg I,IV, QU,IQUV); Current autoclean implementation requires Stokes="I".',
               'weighting': 'Weighting of uv (natural, uniform, briggs, ...)',
               'robust': 'Briggs robustness parameter',
               'noise': 'noise parameter for briggs abs mode weighting',
               'npixels': 'number of pixels for superuniform or briggs weighting',
               'interactive': 'use interactive clean (with GUI viewer)',
               'mask': 'Initial cleanbox(es), mask image(s), and/or region(s)  used in cleaning',
               'modelimage': 'Name of model image(s) to initialize cleaning',
               'uvtaper': 'Apply additional uv tapering of visibilities',
               'outertaper': 'uv-taper on outer baselines in uv-plane',
               'innertaper': 'uv-taper in center of uv-plane (not implemented)',
               'niter': 'Max number of total clean cycles per channel',
               'npercycle': 'Clean iterations before adding new clean boxes',
               'npercycle_speedup': 'Increase npercycle by this factor if no new regions found.',
               'gain': 'Loop gain for cleaning',
               'pbcor': 'Output primary beam-corrected image',
               'minpb': 'Minimum PB level to use',
               'clean_threshold': 'Flux level to stop cleaning.  Must include units.',
               'Nrms': 'Threshold to stop cleaning: current rms * Nrms',
               'eps_maxres': 'Stop cleaning if max abs(residual) changes by less than this factor',
               'useabsresid': 'If True, use absolute value of residual to test for clean convergence.',
               'allow_maxres_inc': 'Stop cleaning if max abs(residual) increases this many times (set to -1 to ignore)',
               'island_rms': 'Threshold for islands when finding clean regions: current rms * island_rms',
               'diag': 'Count diagonal connection as same island?',
               'peak_rms': 'Threshold to add new clean box: peak in island must be at least current rms * peak_rms',
               'gain_threshold': 'Threshold to add new clean box: peak in island must be at least current max residual * gain_threshold',
               'Npeak': 'Max number of new clean regions to add in each iteration.',
               'shape': 'Shape of clean regions: 0 for circles, 1 for boxes, 2 for both.',
               'boxstretch': 'Increase clean region size by this many pixels beyond island size.',
               'irregsize': 'For regions this large (in pixels), use irregular clean region.',

              }

#
# Set subfields defaults if needed
#
        if(subkey == 'channel'):
          desc['start'] = 'First channel to use (0=first channel specified in spw)'
        if(subkey == 'velocity'):
          desc['start'] = 'Velocity of first image channel: e.g \'0.0km/s\''
        if(subkey == 'velocity'):
          desc['width'] = 'image channel width in velocity units: e.g \'1.0km/s\''
        if(subkey == 'frequency'):
          desc['start'] = 'Frequency of first image channel: e.q. \'1.4GHz\''
        if(subkey == 'frequency'):
          desc['width'] = 'Image channel width in frequency units: e.g \'1.0kHz\''
        if(subkey == 'briggs'):
          desc['npixels'] = 'number of pixels to determine uv-cell size 0=> field of view'
        if(subkey == 'briggsabs'):
          desc['npixels'] = 'number of pixels to determine uv-cell size 0=> field of view'
        if(subkey == 'superuniform'):
          desc['npixels'] = 'number of pixels to determine uv-cell size 0=> +/-3pixels'

        if(desc.has_key(key)) :
           return desc[key]

    def itsdefault(self, paramname) :
        a = {}
        a['vis']  = ''
        a['imagename']  = ''
        a['field']  = ''
        a['spw']  = ''
        a['selectdata']  = True
        a['timerange']  = ''
        a['uvrange']  = ''
        a['antenna']  = ''
        a['scan']  = ''
        a['mode']  = 'mfs'
        a['nchan']  = 1
        a['start']  = 0
        a['width']  = 1
        a['interpolation']  = 'linear'
        a['doconcat']  = True
        a['psfmode']  = 'clark'
        a['imagermode']  = ''
        a['cyclefactor']  = 1.5
        a['cyclespeedup']  = -1
        a['imsize']  = [256, 256]
        a['cell']  = ['1.0arcsec']
        a['phasecenter']  = ''
        a['restfreq']  = ''
        a['stokes']  = 'I'
        a['weighting']  = 'natural'
        a['robust']  = 0.0
        a['noise']  = '1.0Jy'
        a['npixels']  = 0
        a['interactive']  = False
        a['mask']  = []
        a['modelimage']  = ''
        a['uvtaper']  = False
        a['outertaper']  = ['']
        a['innertaper']  = ['1.0']
        a['niter']  = 500
        a['npercycle']  = 100
        a['npercycle_speedup']  = 1.5
        a['gain']  = 0.1
        a['pbcor']  = False
        a['minpb']  = 0.1
        a['clean_threshold']  = '0.0mJy'
        a['Nrms']  = 6
        a['eps_maxres']  = 0.01
        a['useabsresid']  = False
        a['allow_maxres_inc']  = 3
        a['island_rms']  = 4
        a['diag']  = False
        a['peak_rms']  = 6
        a['gain_threshold']  = 0.1
        a['Npeak']  = 3
        a['shape']  = 1
        a['boxstretch']  = 1
        a['irregsize']  = 100

        #a = sys._getframe(len(inspect.stack())-1).f_globals

        if self.parameters['selectdata']  == True:
            a['timerange'] = ''
            a['uvrange'] = ''
            a['antenna'] = ''
            a['scan'] = ''

        if self.parameters['mode']  == 'mfs':
            a['nterms'] = 1
            a['reffreq'] = ''

        if self.parameters['mode']  == 'channel':
            a['nchan'] = 1
            a['start'] = 0
            a['width'] = 1
            a['interpolation'] = 'linear'
            a['doconcat'] = True

        if self.parameters['mode']  == 'velocity':
            a['nchan'] = 1
            a['start'] = '0.0km/s'
            a['width'] = '1km/s'
            a['interpolation'] = 'linear'
            a['doconcat'] = True

        if self.parameters['mode']  == 'frequency':
            a['nchan'] = 1
            a['start'] = '1.4GHz'
            a['width'] = '10kHz'
            a['interpolation'] = 'linear'
            a['doconcat'] = True

        if self.parameters['weighting']  == 'briggs':
            a['robust'] = 0.0
            a['npixels'] = 0

        if self.parameters['weighting']  == 'briggsabs':
            a['robust'] = 0.0
            a['noise'] = '1.0Jy'
            a['npixels'] = 0

        if self.parameters['weighting']  == 'superuniform':
            a['npixels'] = 0

        if self.parameters['uvtaper']  == True:
            a['outertaper'] = []
            a['innertaper'] = []

        if self.parameters['imagermode']  == 'csclean':
            a['cyclefactor'] = 1.5
            a['cyclespeedup'] = -1

        if a.has_key(paramname) :
	      return a[paramname]
autoclean_cli = autoclean_cli_()
