#
# This file was generated using xslt from its XML file
#
# Copyright 2014, Associated Universities Inc., Washington DC
#
import sys
import os
#from casac import *
import casac
import string
import time
import inspect
import gc
import numpy
from casa_stack_manip import stack_frame_find
from odict import odict
from types import * 
from task_applycal import applycal
class applycal_cli_:
    __name__ = "applycal"
    rkey = None
    i_am_a_casapy_task = None
    # The existence of the i_am_a_casapy_task attribute allows help()
    # (and other) to treat casapy tasks as a special case.

    def __init__(self) :
       self.__bases__ = (applycal_cli_,)
       self.__doc__ = self.__call__.__doc__

       self.parameters={'vis':None, 'field':None, 'spw':None, 'intent':None, 'selectdata':None, 'timerange':None, 'uvrange':None, 'antenna':None, 'scan':None, 'observation':None, 'msselect':None, 'docallib':None, 'callib':None, 'gaintable':None, 'gainfield':None, 'interp':None, 'spwmap':None, 'calwt':None, 'parang':None, 'applymode':None, 'flagbackup':None, }


    def result(self, key=None):
	    #### and add any that have completed...
	    return None


    def __call__(self, vis=None, field=None, spw=None, intent=None, selectdata=None, timerange=None, uvrange=None, antenna=None, scan=None, observation=None, msselect=None, docallib=None, callib=None, gaintable=None, gainfield=None, interp=None, spwmap=None, calwt=None, parang=None, applymode=None, flagbackup=None, ):

        """Apply calibrations solutions(s) to data

	Detailed Description: 

Applycal reads the specified gain calibration tables, applies
them to the (raw) data column (with the specified selection),
and writes the calibrated results into the corrected column.
This is done in one step, so all available calibration must
be specified.  Applycal will overwrite existing corrected data.

Standard data selection is supported.  See help par.selectdata
for more information.

One or more calibration tables (both temporal, frequency, polarization
calibrations) can be specified in the gaintable parameter.  The
calibration values associated with a restricted list of fields
can also be selected for each table.

See task accum for instructions on forming calibration
incrementally.  See task split for saving corrected data in
another visibility file.


	Arguments :
		vis:	Name of input visibility file
		   Default Value: 

		field:	Select field using field id(s) or field name(s)
		   Default Value: 

		spw:	Select spectral window/channels
		   Default Value: 

		intent:	Select observing intent
		   Default Value: 

		selectdata:	Other data selection parameters
		   Default Value: True

		timerange:	Select data based on time range
		   Default Value: 

		uvrange:	Select data within uvrange (default units meters)
		   Default Value: 

		antenna:	Select data based on antenna/baseline
		   Default Value: 

		scan:	Scan number range
		   Default Value: 

		observation:	Select by observation ID(s)
		   Default Value: 

		msselect:	Optional complex data selection (ignore for now)
		   Default Value: 

		docallib:	Use callib or traditional cal apply parameters
		   Default Value: False

		callib:	Cal Library filename
		   Default Value: 

		gaintable:	Gain calibration table(s) to apply on the fly
		   Default Value: 

		gainfield:	Select a subset of calibrators from gaintable(s)
		   Default Value: 

		interp:	Interp type in time[,freq], per gaintable. default==linear,linear
		   Default Value: 

		spwmap:	Spectral windows combinations to form for gaintables(s)
		   Default Value: 

		calwt:	Calibrate data weights per gaintable.
		   Default Value: True

		parang:	Apply parallactic angle correction
		   Default Value: False

		applymode:	Calibration mode: ""="calflag","calflagstrict","trial","flagonly","flagonlystrict", or "calonly"
		   Default Value: 
		   Allowed Values:
				
				calflag
				calflagstrict
				trial
				flagonly
				flagonlystrict
				calonly

		flagbackup:	Automatically back up the state of flags before the run?
		   Default Value: True


	Example :



       Applycal reads the specified gain calibration tables or cal library, 
       applies them to the (raw) data column (with the specified selection),
       and writes the calibrated results into the corrected column.
       This is done in one step, so all available calibration tables must
       be specified.  

       Applycal will overwrite existing corrected data, and will flag data
       for which there is no calibration available.

       In the traditional interface (docallib=False), all calibration 
       tables (both temporal, frequency, polarization
       calibrations) are specified in the gaintable parameter.  The
       calibration values associated with a restricted list of fields
       can also be selected for each table in gainfield.

       As of CASA v4.2, docallib=True provides specification of an
       ensemble of calibration tables and directives via a cal
       library file.

       See task accum for instructions on forming calibration
       incrementally.  See task split for copying out any portion of the data
       and selected columns to a new visibility file.

       Keyword arguments:
       vis -- Name of input visibility file
               default: < none>; example: vis='ngc5921.ms'

      --- Data Selection: the data to which the calibration will be applied
        (see help par.selectdata for more detailed information)

      field -- Select field id(s) or field name(s) to apply calibration.
                 [run listobs to obtain the list id's or names]
               default: ''=all fields
               If field's string is an integer >=0, it is assumed to be an index
                 otherwise, it is assumed to be a field name
               field='0~2'; field ids 0,1,2
               field='0,4,5~7'; field ids 0,4,5,6,7
               field='3C286,3C295'; fields named 3C286 and 3C295
               field = '3,4C*'; field id 3, all names starting with 4C
      spw -- Select spectral window/channels 
               type 'help par.selection' for more examples.
             spw='0~2,4'; spectral windows 0,1,2,4 (all channels)
             spw='<2';  spectral windows less than 2 (i.e. 0,1)
             spw='0:5~61'; spw 0, channels 5 to 61, INCLUSIVE
             spw='*:5~61'; all spw with channels 5 to 62
             spw='0,10,3:3~45'; spw 0,10 all channels, spw 3, channels 3 to 45.
             spw='0~2:2~6'; spw 0,1,2 with channels 2 through 6 in each.
             spw='0:0~10;15~60'; spectral window 0 with channels 0-10,15-60
                       NOTE ';' to separate channel selections
             spw='0:0~10^2,1:20~30^5'; spw 0, channels 0,2,4,6,8,10,
                   spw 1, channels 20,25,30
       intent -- Select observing intent
                 default: ''  (no selection by intent)
                 intent='*BANDPASS*'  (selects data labelled with
                                       BANDPASS intent)
       selectdata -- Other data selection parameters
              default: True
       timerange  -- Select data based on time range:
              default = '' (all); examples,
              timerange = 'YYYY/MM/DD/hh:mm:ss~YYYY/MM/DD/hh:mm:ss'
              Note: if YYYY/MM/DD is missing, date defaults to first day in
                    data set
              timerange='09:14:0~09:54:0' picks 40 min on first day
              timerange= '25:00:00~27:30:00' picks 1 hr to 3 hr 30min on next day
              timerange='09:44:00' data within one integration of time
              timerange='>10:24:00' data after this time
       uvrange -- Select data within uvrange (default units meters)
              default: '' (all); example:
              uvrange='0~1000klambda'; uvrange from 0-1000 kilo-lambda
              uvrange='>4klambda';uvranges greater than 4 kilolambda
       antenna -- Select data based on antenna/baseline
              default: '' (all)
              If antenna's string is an integer >=0, it is taken to be an index
                otherwise, it is assumed to be an antenna name
              antenna='5&6'; baseline between antenna index 5 and index 6.
              antenna='VA05&VA06'; baseline between VLA antenna 5 and 6.
              antenna='5&6;7&8'; baseline 5-6 and 7-8
              antenna='5'; all baselines with antenna index 5
              antenna='05'; all baselines with antenna name 05--vla antenna 5.
              antenna='5,6,10'; all baselines with antennas 5,6 and 10
       scan -- Scan number range
       observation -- Select by observation ID(s).
                       default: '' = all
                       example: '0~3,6'
       msselect -- Optional complex data selection (ignore for now)

       --- Calibration files to apply
       docallib -- Control means of specifying the caltables:
               default: False ==> Use gaintable,gainfield,interp,spwmap,calwt
                        If True, specify a file containing cal library in callib
       callib -- If docallib=True, specify a file containing cal
                  library directives
       gaintable -- Gain calibration table(s) to apply 
               default: '' (none);
               examples: gaintable='ngc5921.gcal'
                   gaintable=['n5921.ampcal','n5921.phcal','n5921.bpass']
               All gain table types: 'G', GSPLINE, 'T', 'B', 'BPOLY', 'D's'
                   can be applied.
       gainfield -- Select a subset of calibrators from each gaintable
               default:'' ==> all sources in table;
               'nearest' ==> nearest (on sky) available field in table
               otherwise, same syntax as field
               example: gainfield='0~3'
                        gainfield=['0~3','4~6']  (for multiple gaintables)
       interp -- Interpolation type (in time[,freq]) to use for each gaintable.
                When frequency interpolation is relevant (bandpass solutions, 
                frequency-dependent polcal solutions, ALMA Tsys)
                separate time-dependent and freq-dependent interp
                types with a comma (freq _after_ the comma).                
                Specifications for frequency are ignored when the
                calibration table has no channel-dependence.
                Time-dependent interp options ending in 'PD' enable a
                "phase delay" correction per spw for non-channel-dependent
                calibration types.
                For multi-obsId datasets, 'perobs' can be appended to
                the time-dependent interpolation specification to
                enforce obsId boundaries when interpolating in time.
                Add 'flag' to the freq-dependent interpolation options
                to enforce channel-dependent flagging (rather than
                interpolation/extrapolation).
                default: '' --> 'linear,linear' for all gaintable(s)
                example: interp='nearest'   (in time, freq-dep will be
                                             linear, if relevant)
                         interp='linear,cubic'  (linear in time, cubic
                                                 in freq)
                         interp='linearperobs,splineflag' (linear in time
                                                          per obsId,
                                                          spline in
                                                          freq with
                                                          channelized
                                                          flagging)
                         interp=',spline'  (spline in freq; linear in
                                            time by default)
                         interp=['nearest,spline','linear']  (for multiple gaintables)
                Options: Time: 'nearest', 'linear', 'nearestPD', 'linearPD'
                         Freq: 'nearest', 'linear', 'cubic', 'spline',
                               'nearestflag', 'linearflag', 'cubicflag', 'splineflag',

       spwmap -- Spectral windows combinations to form for gaintable(s)
               default: [] (apply solutions from each spw to that spw only)
               Example:  spwmap=[0,0,1,1] means apply the caltable solutions
                         from spw = 0 to the spw 0,1 and spw 1 to spw 2,3.
                         spwmap=[[0,0,1,1],[0,1,0,1]]  (for multiple gaintables)
                         
          Complicated example:

            gaintable=['tab1','tab2','tab3']
            gainfield='3C286'
            interp=['linear','nearest']
            spwmap=[[],[0,0,2]]
            
            This means: apply 3 cal tables, selecting only solutions for 3C286
            from tab1 (but all fields from tab2 and tab3, indicated by
            no gainfield entry for these files).  Linear interpolation
            (in time) will be used for 'tab1' and 'tab3' (default); 'tab2' will
            use nearest.  For the 'tab2', the calibration spws map
            will be mapped to the data spws according to 0->0, 0->1, 2->2.
            (I.e., for data spw=0 and 2, the spw mapping is one to one,
            but data spw 1 will be calibrated by solutions from spw 0.)  
           
       parang -- If True, apply the parallactic angle correction.  FOR ANY
               POLARIZATION CALIBRATION AND IMAGING, parang = True
               default: False
       calwt -- Calibrate weights along with data for each gaintable
               default: True  (for all specified gaintables)
               examples: calwt=False (for all specified gaintables)
                         calwt=[True,False,True]  (specified per gaintable)
       applymode -- Calibration apply mode:
               ''='calflag' (default) calibrate data and apply flags from solutions
               'trial' report on flags from solutions, dataset entirely unchanged
               'flagonly' apply flags from solutions only, data not calibrated
               'calonly' calibrate data only, flags from solutions NOT
                    applied (use with extreme caution!)
               'calflagstrict' or 'flagonlystrict' same as above
                    except flag spws for which calibration is
                    unavailable in one or more tables (instead of 
                    allowing them to pass uncalibrated and
                    unflagged)

       flagbackup -- Back up the state of the flags before applying calibration
                     default: True
       async -- Run task in a separate process 
                default: False; example: async=True



        """
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
	#casac = self.__globals__['casac']
	casalog = self.__globals__['casalog']
	casa = self.__globals__['casa']
	#casalog = casac.casac.logsink()
        self.__globals__['__last_task'] = 'applycal'
        self.__globals__['taskname'] = 'applycal'
        ###
        self.__globals__['update_params'](func=self.__globals__['taskname'],printtext=False,ipython_globals=self.__globals__)
        ###
        ###
        #Handle globals or user over-ride of arguments
        #
        if type(self.__call__.func_defaults) is NoneType:
            function_signature_defaults={}
	else:
	    function_signature_defaults=dict(zip(self.__call__.func_code.co_varnames[1:],self.__call__.func_defaults))
	useLocalDefaults = False

        for item in function_signature_defaults.iteritems():
                key,val = item
                keyVal = eval(key)
                if (keyVal == None):
                        #user hasn't set it - use global/default
                        pass
                else:
                        #user has set it - use over-ride
			if (key != 'self') :
			   useLocalDefaults = True

	myparams = {}
	if useLocalDefaults :
	   for item in function_signature_defaults.iteritems():
	       key,val = item
	       keyVal = eval(key)
	       exec('myparams[key] = keyVal')
	       self.parameters[key] = keyVal
	       if (keyVal == None):
	           exec('myparams[key] = '+ key + ' = self.itsdefault(key)')
		   keyVal = eval(key)
		   if(type(keyVal) == dict) :
                      if len(keyVal) > 0 :
		         exec('myparams[key] = ' + key + ' = keyVal[len(keyVal)-1][\'value\']')
		      else :
		         exec('myparams[key] = ' + key + ' = {}')
	 
        else :
            print ''

            myparams['vis'] = vis = self.parameters['vis']
            myparams['field'] = field = self.parameters['field']
            myparams['spw'] = spw = self.parameters['spw']
            myparams['intent'] = intent = self.parameters['intent']
            myparams['selectdata'] = selectdata = self.parameters['selectdata']
            myparams['timerange'] = timerange = self.parameters['timerange']
            myparams['uvrange'] = uvrange = self.parameters['uvrange']
            myparams['antenna'] = antenna = self.parameters['antenna']
            myparams['scan'] = scan = self.parameters['scan']
            myparams['observation'] = observation = self.parameters['observation']
            myparams['msselect'] = msselect = self.parameters['msselect']
            myparams['docallib'] = docallib = self.parameters['docallib']
            myparams['callib'] = callib = self.parameters['callib']
            myparams['gaintable'] = gaintable = self.parameters['gaintable']
            myparams['gainfield'] = gainfield = self.parameters['gainfield']
            myparams['interp'] = interp = self.parameters['interp']
            myparams['spwmap'] = spwmap = self.parameters['spwmap']
            myparams['calwt'] = calwt = self.parameters['calwt']
            myparams['parang'] = parang = self.parameters['parang']
            myparams['applymode'] = applymode = self.parameters['applymode']
            myparams['flagbackup'] = flagbackup = self.parameters['flagbackup']

        if type(gaintable)==str: gaintable=[gaintable]
        if type(gainfield)==str: gainfield=[gainfield]
        if type(interp)==str: interp=[interp]
        if type(spwmap)==int: spwmap=[spwmap]
        if type(calwt)==bool: calwt=[calwt]

	result = None

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['vis'] = vis
        mytmp['field'] = field
        mytmp['spw'] = spw
        mytmp['intent'] = intent
        mytmp['selectdata'] = selectdata
        mytmp['timerange'] = timerange
        mytmp['uvrange'] = uvrange
        mytmp['antenna'] = antenna
        mytmp['scan'] = scan
        mytmp['observation'] = observation
        mytmp['msselect'] = msselect
        mytmp['docallib'] = docallib
        mytmp['callib'] = callib
        mytmp['gaintable'] = gaintable
        mytmp['gainfield'] = gainfield
        mytmp['interp'] = interp
        mytmp['spwmap'] = spwmap
        mytmp['calwt'] = calwt
        mytmp['parang'] = parang
        mytmp['applymode'] = applymode
        mytmp['flagbackup'] = flagbackup
	pathname='file://' + casa['dirs']['xml'] + '/'
	trec = casac.casac.utils().torecord(pathname+'applycal.xml')

        casalog.origin('applycal')
	try :
          #if not trec.has_key('applycal') or not casac.casac.utils().verify(mytmp, trec['applycal']) :
	    #return False

          casac.casac.utils().verify(mytmp, trec['applycal'], True)
          scriptstr=['']
          saveinputs = self.__globals__['saveinputs']
          if type(self.__call__.func_defaults) is NoneType:
              saveinputs=''
          else:
              saveinputs('applycal', 'applycal.last', myparams, self.__globals__,scriptstr=scriptstr)
          tname = 'applycal'
          spaces = ' '*(18-len(tname))
          casalog.post('\n##########################################'+
                       '\n##### Begin Task: ' + tname + spaces + ' #####')
          if type(self.__call__.func_defaults) is NoneType:
              casalog.post(scriptstr[0]+'\n', 'INFO')
          else :
              casalog.post(scriptstr[1][1:]+'\n', 'INFO')
          result = applycal(vis, field, spw, intent, selectdata, timerange, uvrange, antenna, scan, observation, msselect, docallib, callib, gaintable, gainfield, interp, spwmap, calwt, parang, applymode, flagbackup)
          casalog.post('##### End Task: ' + tname + '  ' + spaces + ' #####'+
                       '\n##########################################')

	except Exception, instance:
          if(self.__globals__.has_key('__rethrow_casa_exceptions') and self.__globals__['__rethrow_casa_exceptions']) :
             raise
          else :
             #print '**** Error **** ',instance
	     tname = 'applycal'
             casalog.post('An error occurred running task '+tname+'.', 'ERROR')
             pass

        gc.collect()
        return result
#
#
#
    def paramgui(self, useGlobals=True, ipython_globals=None):
        """
        Opens a parameter GUI for this task.  If useGlobals is true, then any relevant global parameter settings are used.
        """
        import paramgui
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )

        if useGlobals:
	    if ipython_globals == None:
                myf=self.__globals__
            else:
                myf=ipython_globals

            paramgui.setGlobals(myf)
        else:
            paramgui.setGlobals({})

        paramgui.runTask('applycal', myf['_ip'])
        paramgui.setGlobals({})

#
#
#
    def defaults(self, param=None, ipython_globals=None, paramvalue=None, subparam=None):
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
        if ipython_globals == None:
            myf=self.__globals__
        else:
            myf=ipython_globals

        a = odict()
        a['vis']  = ''
        a['field']  = ''
        a['spw']  = ''
        a['intent']  = ''
        a['selectdata']  = True
        a['docallib']  = False
        a['parang']  = False
        a['applymode']  = ''
        a['flagbackup']  = True

        a['selectdata'] = {
                    0:odict([{'value':True}, {'timerange':''}, {'uvrange':''}, {'antenna':''}, {'scan':''}, {'observation':''}, {'msselect':''}]), 
                    1:{'value':False}}
        a['docallib'] = {
                    0:odict([{'value':False}, {'gaintable':[]}, {'gainfield':[]}, {'interp':[]}, {'spwmap':[]}, {'calwt':[True]}]), 
                    1:odict([{'value':True}, {'callib':''}])}

### This function sets the default values but also will return the list of
### parameters or the default value of a given parameter
        if(param == None):
                myf['__set_default_parameters'](a)
        elif(param == 'paramkeys'):
                return a.keys()
        else:
            if(paramvalue==None and subparam==None):
               if(a.has_key(param)):
                  return a[param]
               else:
                  return self.itsdefault(param)
            else:
               retval=a[param]
               if(type(a[param])==dict):
                  for k in range(len(a[param])):
                     valornotval='value'
                     if(a[param][k].has_key('notvalue')):
                        valornotval='notvalue'
                     if((a[param][k][valornotval])==paramvalue):
                        retval=a[param][k].copy()
                        retval.pop(valornotval)
                        if(subparam != None):
                           if(retval.has_key(subparam)):
                              retval=retval[subparam]
                           else:
                              retval=self.itsdefault(subparam)
		     else:
                        retval=self.itsdefault(subparam)
               return retval


#
#
    def check_params(self, param=None, value=None, ipython_globals=None):
      if ipython_globals == None:
          myf=self.__globals__
      else:
          myf=ipython_globals
#      print 'param:', param, 'value:', value
      try :
         if str(type(value)) != "<type 'instance'>" :
            value0 = value
            value = myf['cu'].expandparam(param, value)
            matchtype = False
            if(type(value) == numpy.ndarray):
               if(type(value) == type(value0)):
                  myf[param] = value.tolist()
               else:
                  #print 'value:', value, 'value0:', value0
                  #print 'type(value):', type(value), 'type(value0):', type(value0)
                  myf[param] = value0
                  if type(value0) != list :
                     matchtype = True
            else :
               myf[param] = value
            value = myf['cu'].verifyparam({param:value})
            if matchtype:
               value = False
      except Exception, instance:
         #ignore the exception and just return it unchecked
         myf[param] = value
      return value
#
#
    def description(self, key='applycal', subkey=None):
        desc={'applycal': 'Apply calibrations solutions(s) to data',
               'vis': 'Name of input visibility file',
               'field': 'Select field using field id(s) or field name(s)',
               'spw': 'Select spectral window/channels',
               'intent': 'Select observing intent',
               'selectdata': 'Other data selection parameters',
               'timerange': 'Select data based on time range',
               'uvrange': 'Select data within uvrange (default units meters)',
               'antenna': 'Select data based on antenna/baseline',
               'scan': 'Scan number range',
               'observation': 'Select by observation ID(s)',
               'msselect': 'Optional complex data selection (ignore for now)',
               'docallib': 'Use callib or traditional cal apply parameters',
               'callib': 'Cal Library filename',
               'gaintable': 'Gain calibration table(s) to apply on the fly',
               'gainfield': 'Select a subset of calibrators from gaintable(s)',
               'interp': 'Interp type in time[,freq], per gaintable. default==linear,linear',
               'spwmap': 'Spectral windows combinations to form for gaintables(s)',
               'calwt': 'Calibrate data weights per gaintable.',
               'parang': 'Apply parallactic angle correction',
               'applymode': 'Calibration mode: ""="calflag","calflagstrict","trial","flagonly","flagonlystrict", or "calonly"',
               'flagbackup': 'Automatically back up the state of flags before the run?',

              }

#
# Set subfields defaults if needed
#

        if(desc.has_key(key)) :
           return desc[key]

    def itsdefault(self, paramname) :
        a = {}
        a['vis']  = ''
        a['field']  = ''
        a['spw']  = ''
        a['intent']  = ''
        a['selectdata']  = True
        a['timerange']  = ''
        a['uvrange']  = ''
        a['antenna']  = ''
        a['scan']  = ''
        a['observation']  = ''
        a['msselect']  = ''
        a['docallib']  = False
        a['callib']  = ''
        a['gaintable']  = ['']
        a['gainfield']  = ['']
        a['interp']  = ['']
        a['spwmap']  = []
        a['calwt']  = [True]
        a['parang']  = False
        a['applymode']  = ''
        a['flagbackup']  = True

        #a = sys._getframe(len(inspect.stack())-1).f_globals

        if self.parameters['selectdata']  == True:
            a['timerange'] = ''
            a['uvrange'] = ''
            a['antenna'] = ''
            a['scan'] = ''
            a['observation'] = ''
            a['msselect'] = ''

        if self.parameters['docallib']  == False:
            a['gaintable'] = []
            a['gainfield'] = []
            a['interp'] = []
            a['spwmap'] = []
            a['calwt'] = [True]

        if self.parameters['docallib']  == True:
            a['callib'] = ''

        if a.has_key(paramname) :
	      return a[paramname]
applycal_cli = applycal_cli_()
